/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.HexUtil;
import freenet.support.io.LineReader;
import freenet.support.io.TooLongException;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class LineReadingInputStream
extends FilterInputStream
implements LineReader {
    public LineReadingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public String readLine(int maxLength, int bufferSize, boolean utf) throws IOException {
        if (maxLength < 1) {
            return null;
        }
        if (maxLength <= bufferSize) {
            bufferSize = maxLength + 1;
        }
        if (!this.markSupported()) {
            return this.readLineWithoutMarking(maxLength, bufferSize, utf);
        }
        byte[] buf = new byte[Math.max(Math.min(128, maxLength), Math.min(1024, bufferSize))];
        int ctr = 0;
        this.mark(maxLength + 2);
        while (true) {
            assert (buf.length - ctr > 0);
            int x = this.read(buf, ctr, buf.length - ctr);
            if (x < 0) {
                if (ctr == 0) {
                    return null;
                }
                return new String(buf, 0, ctr, utf ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1);
            }
            if (x == 0) {
                throw new EOFException();
            }
            int end = ctr + x;
            while (ctr < end) {
                if (buf[ctr] == 10) {
                    String toReturn = "";
                    if (ctr != 0) {
                        boolean removeCR = buf[ctr - 1] == 13;
                        toReturn = new String(buf, 0, removeCR ? ctr - 1 : ctr, utf ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1);
                    }
                    this.reset();
                    this.skip(ctr + 1);
                    return toReturn;
                }
                if (ctr >= maxLength) {
                    throw new TooLongException("We reached maxLength=" + maxLength + " parsing\n " + HexUtil.bytesToHex(buf, 0, ctr) + "\n" + new String(buf, 0, ctr, utf ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1));
                }
                ++ctr;
            }
            if (buf.length >= maxLength || buf.length - ctr >= bufferSize) continue;
            byte[] newBuf = new byte[Math.min(buf.length * 2, maxLength)];
            System.arraycopy(buf, 0, newBuf, 0, ctr);
            buf = newBuf;
        }
    }

    protected String readLineWithoutMarking(int maxLength, int bufferSize, boolean utf) throws IOException {
        if (maxLength < bufferSize) {
            bufferSize = maxLength + 1;
        }
        byte[] buf = new byte[Math.max(Math.min(128, maxLength), Math.min(1024, bufferSize))];
        int ctr = 0;
        while (true) {
            int x;
            if ((x = this.read()) == -1) {
                if (ctr == 0) {
                    return null;
                }
                return new String(buf, 0, ctr, utf ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1);
            }
            if (x == 10) {
                if (ctr == 0) {
                    return "";
                }
                if (buf[ctr - 1] == 13) {
                    --ctr;
                }
                return new String(buf, 0, ctr, utf ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1);
            }
            if (ctr >= maxLength) {
                throw new TooLongException("We reached maxLength=" + maxLength + " parsing\n " + HexUtil.bytesToHex(buf, 0, ctr) + "\n" + new String(buf, 0, ctr, utf ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1));
            }
            if (ctr >= buf.length) {
                buf = Arrays.copyOf(buf, Math.min(buf.length * 2, maxLength));
            }
            buf[ctr++] = (byte)x;
        }
    }
}

