/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.support.Logger;
import freenet.support.WrapperKeepalive;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.io.Fallocate;
import freenet.support.io.FileUtil;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;

public class PooledFileRandomAccessBuffer
implements LockableRandomAccessBuffer,
Serializable {
    private static volatile boolean logMINOR;
    private static final long serialVersionUID = 1L;
    private static final FDTracker DEFAULT_FDTRACKER;
    private transient FDTracker fds;
    public final File file;
    private final boolean readOnly;
    private int lockLevel;
    private transient RandomAccessFile raf;
    private final long length;
    private boolean closed;
    private final long persistentTempID;
    private boolean secureDelete;
    private final boolean deleteOnFree;
    static final int MAGIC = 696014090;
    static final int VERSION = 1;

    public PooledFileRandomAccessBuffer(File file, boolean readOnly, long forceLength, Random seedRandom, long persistentTempID, boolean deleteOnFree) throws IOException {
        this(file, readOnly, forceLength, seedRandom, persistentTempID, deleteOnFree, DEFAULT_FDTRACKER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PooledFileRandomAccessBuffer(File file, boolean readOnly, long forceLength, Random seedRandom, long persistentTempID, boolean deleteOnFree, FDTracker fds) throws IOException {
        this.file = file;
        this.readOnly = readOnly;
        this.persistentTempID = persistentTempID;
        this.deleteOnFree = deleteOnFree;
        this.fds = fds;
        this.lockLevel = 0;
        LockableRandomAccessBuffer.RAFLock lock = this.lockOpen();
        try {
            long currentLength = this.raf.length();
            if (forceLength >= 0L && forceLength != currentLength) {
                if (readOnly) {
                    throw new IOException("Read only but wrong length");
                }
                try (WrapperKeepalive wrapperKeepalive = new WrapperKeepalive();){
                    wrapperKeepalive.start();
                    Fallocate.forChannel(this.raf.getChannel(), this.raf.getFD(), forceLength).fromOffset(currentLength).execute();
                }
                this.raf.setLength(forceLength);
                currentLength = forceLength;
            }
            this.length = currentLength;
            lock.unlock();
        }
        catch (IOException e) {
            PooledFileRandomAccessBuffer pooledFileRandomAccessBuffer = this;
            synchronized (pooledFileRandomAccessBuffer) {
                this.raf.close();
                this.raf = null;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledFileRandomAccessBuffer(File file, String mode, byte[] initialContents, int offset, int size, long persistentTempID, boolean deleteOnFree, boolean readOnly) throws IOException {
        this.file = file;
        this.readOnly = readOnly;
        this.length = size;
        this.persistentTempID = persistentTempID;
        this.deleteOnFree = deleteOnFree;
        this.fds = DEFAULT_FDTRACKER;
        this.lockLevel = 0;
        LockableRandomAccessBuffer.RAFLock lock = this.lockOpen(true);
        try {
            this.raf.write(initialContents, offset, size);
            lock.unlock();
        }
        catch (IOException e) {
            PooledFileRandomAccessBuffer pooledFileRandomAccessBuffer = this;
            synchronized (pooledFileRandomAccessBuffer) {
                this.raf.close();
                this.raf = null;
            }
            throw e;
        }
    }

    protected PooledFileRandomAccessBuffer() {
        this.file = null;
        this.readOnly = false;
        this.length = 0L;
        this.persistentTempID = -1L;
        this.deleteOnFree = false;
        this.fds = null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.fds = DEFAULT_FDTRACKER;
    }

    @Override
    public long size() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pread(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        if (fileOffset < 0L) {
            throw new IllegalArgumentException();
        }
        LockableRandomAccessBuffer.RAFLock lock = this.lockOpen();
        try {
            PooledFileRandomAccessBuffer pooledFileRandomAccessBuffer = this;
            synchronized (pooledFileRandomAccessBuffer) {
                this.raf.seek(fileOffset);
                this.raf.readFully(buf, bufOffset, length);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pwrite(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        if (fileOffset < 0L) {
            throw new IllegalArgumentException();
        }
        if (this.readOnly) {
            throw new IOException("Read only");
        }
        LockableRandomAccessBuffer.RAFLock lock = this.lockOpen();
        try {
            if (fileOffset + (long)length > this.length) {
                throw new IOException("Length limit exceeded");
            }
            PooledFileRandomAccessBuffer pooledFileRandomAccessBuffer = this;
            synchronized (pooledFileRandomAccessBuffer) {
                this.raf.seek(fileOffset);
                this.raf.write(buf, bufOffset, length);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (logMINOR) {
            Logger.minor(this, "Closing " + this, (Throwable)new Exception("debug"));
        }
        FDTracker fDTracker = this.fds;
        synchronized (fDTracker) {
            if (this.lockLevel != 0) {
                throw new IllegalStateException("Must unlock first!");
            }
            this.closed = true;
            this.fds.closables.remove(this);
            this.closeRAF();
        }
    }

    @Override
    public LockableRandomAccessBuffer.RAFLock lockOpen() throws IOException {
        return this.lockOpen(false);
    }

    private LockableRandomAccessBuffer.RAFLock lockOpen(boolean forceWrite) throws IOException {
        LockableRandomAccessBuffer.RAFLock lock = new LockableRandomAccessBuffer.RAFLock(){

            @Override
            protected void innerUnlock() {
                PooledFileRandomAccessBuffer.this.unlock();
            }
        };
        FDTracker fDTracker = this.fds;
        synchronized (fDTracker) {
            block5: while (true) {
                while (true) {
                    this.fds.closables.remove(this);
                    if (this.closed) {
                        throw new IOException("Already closed " + this);
                    }
                    if (this.raf != null) {
                        ++this.lockLevel;
                        return lock;
                    }
                    if (this.fds.totalOpenFDs < this.fds.maxOpenFDs) {
                        this.raf = new RandomAccessFile(this.file, this.readOnly && !forceWrite ? "r" : "rw");
                        ++this.lockLevel;
                        this.fds.totalOpenFDs++;
                        return lock;
                    }
                    PooledFileRandomAccessBuffer closable = this.pollFirstClosable();
                    if (closable != null) {
                        closable.closeRAF();
                        continue;
                    }
                    try {
                        this.fds.wait();
                        continue block5;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledFileRandomAccessBuffer pollFirstClosable() {
        FDTracker fDTracker = this.fds;
        synchronized (fDTracker) {
            Iterator it = this.fds.closables.iterator();
            if (it.hasNext()) {
                PooledFileRandomAccessBuffer first = (PooledFileRandomAccessBuffer)it.next();
                it.remove();
                return first;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeRAF() {
        FDTracker fDTracker = this.fds;
        synchronized (fDTracker) {
            if (this.lockLevel != 0) {
                throw new IllegalStateException();
            }
            if (this.raf == null) {
                return;
            }
            try {
                this.raf.close();
            }
            catch (IOException e) {
                Logger.error(this, "Error closing " + this + " : " + e, (Throwable)e);
            }
            this.raf = null;
            this.fds.totalOpenFDs--;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock() {
        FDTracker fDTracker = this.fds;
        synchronized (fDTracker) {
            --this.lockLevel;
            if (this.lockLevel > 0) {
                return;
            }
            this.fds.closables.add(this);
            this.fds.notify();
        }
    }

    public void setSecureDelete(boolean secureDelete) {
        this.secureDelete = secureDelete;
    }

    @Override
    public void free() {
        this.close();
        if (!this.deleteOnFree) {
            return;
        }
        if (this.secureDelete) {
            try {
                FileUtil.secureDelete(this.file);
            }
            catch (IOException e) {
                Logger.error(this, "Unable to delete " + this.file + " : " + e, (Throwable)e);
                System.err.println("Unable to delete temporary file " + this.file);
            }
        } else {
            this.file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isOpen() {
        FDTracker fDTracker = this.fds;
        synchronized (fDTracker) {
            return this.raf != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLocked() {
        FDTracker fDTracker = this.fds;
        synchronized (fDTracker) {
            return this.lockLevel != 0;
        }
    }

    @Override
    public void onResume(ClientContext context) throws ResumeFailedException {
        if (!this.file.exists()) {
            throw new ResumeFailedException("File does not exist: " + this.file);
        }
        if (this.length > this.file.length()) {
            throw new ResumeFailedException("Bad length");
        }
        if (this.persistentTempID != -1L) {
            context.persistentFileTracker.register(this.file);
        }
    }

    public String toString() {
        return super.toString() + ":" + this.file;
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(696014090);
        dos.writeInt(1);
        dos.writeUTF(this.file.toString());
        dos.writeBoolean(this.readOnly);
        dos.writeLong(this.length);
        dos.writeLong(this.persistentTempID);
        dos.writeBoolean(this.deleteOnFree);
        if (this.deleteOnFree) {
            dos.writeBoolean(this.secureDelete);
        }
    }

    PooledFileRandomAccessBuffer(DataInputStream dis, FilenameGenerator fg, PersistentFileTracker persistentFileTracker) throws StorageFormatException, IOException, ResumeFailedException {
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Bad version");
        }
        File f = new File(dis.readUTF());
        this.readOnly = dis.readBoolean();
        this.length = dis.readLong();
        this.persistentTempID = dis.readLong();
        this.deleteOnFree = dis.readBoolean();
        this.secureDelete = this.deleteOnFree ? dis.readBoolean() : false;
        this.fds = DEFAULT_FDTRACKER;
        if (this.length < 0L) {
            throw new StorageFormatException("Bad length");
        }
        if (this.persistentTempID != -1L) {
            if (!f.exists() && (f = fg.getFilename(this.persistentTempID)).exists()) {
                persistentFileTracker.register(f);
                this.file = f;
                return;
            }
            this.file = fg.maybeMove(f, this.persistentTempID);
            if (!f.exists()) {
                throw new ResumeFailedException("Persistent tempfile lost " + f);
            }
        } else {
            this.file = f;
            if (!f.exists()) {
                throw new ResumeFailedException("Lost file " + f);
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.deleteOnFree ? 1231 : 1237);
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (int)(this.persistentTempID ^ this.persistentTempID >>> 32);
        result = 31 * result + (this.readOnly ? 1231 : 1237);
        result = 31 * result + (this.secureDelete ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PooledFileRandomAccessBuffer other = (PooledFileRandomAccessBuffer)obj;
        if (this.deleteOnFree != other.deleteOnFree) {
            return false;
        }
        if (!this.file.equals(other.file)) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.persistentTempID != other.persistentTempID) {
            return false;
        }
        if (this.readOnly != other.readOnly) {
            return false;
        }
        return this.secureDelete == other.secureDelete;
    }

    static {
        Logger.registerClass(PooledFileRandomAccessBuffer.class);
        DEFAULT_FDTRACKER = new FDTracker(100);
    }

    static class FDTracker
    implements Serializable {
        private int maxOpenFDs;
        private int totalOpenFDs = 0;
        private final LinkedHashSet<PooledFileRandomAccessBuffer> closables = new LinkedHashSet();

        FDTracker(int maxOpenFDs) {
            this.maxOpenFDs = maxOpenFDs;
        }

        synchronized void setMaxFDs(int max) {
            if (max <= 0) {
                throw new IllegalArgumentException();
            }
            this.maxOpenFDs = max;
        }

        synchronized int getOpenFDs() {
            return this.totalOpenFDs;
        }

        synchronized int getClosableFDs() {
            return this.closables.size();
        }
    }
}

