/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.crypt.MasterSecret;
import freenet.support.api.Bucket;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.RAFInputStream;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RAFBucket
implements Bucket,
RandomAccessBucket {
    private final LockableRandomAccessBuffer underlying;
    final long size;
    static final int MAGIC = -1993707382;

    public RAFBucket(LockableRandomAccessBuffer underlying) throws IOException {
        this.underlying = underlying;
        this.size = underlying.size();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public OutputStream getOutputStreamUnbuffered() throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(this.getInputStreamUnbuffered());
    }

    @Override
    public InputStream getInputStreamUnbuffered() throws IOException {
        return new RAFInputStream(this.underlying, 0L, this.underlying.size());
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly() {
    }

    @Override
    public void free() {
        this.underlying.free();
    }

    @Override
    public RandomAccessBucket createShadow() {
        return null;
    }

    @Override
    public void onResume(ClientContext context) throws ResumeFailedException {
        this.underlying.onResume(context);
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(-1993707382);
        this.underlying.storeTo(dos);
    }

    RAFBucket(DataInputStream dis, FilenameGenerator fg, PersistentFileTracker persistentFileTracker, MasterSecret masterKey) throws IOException, StorageFormatException, ResumeFailedException {
        this.underlying = BucketTools.restoreRAFFrom(dis, fg, persistentFileTracker, masterKey);
        this.size = this.underlying.size();
    }

    @Override
    public LockableRandomAccessBuffer toRandomAccessBuffer() {
        return this.underlying;
    }
}

