/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.math;

import freenet.node.TimeSkewDetectorCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.math.RunningAverage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;

public final class TimeDecayingRunningAverage
implements RunningAverage,
Cloneable {
    private final AtomicReference<Data> data = new AtomicReference();
    private final TimeTracker timeTracker;
    private final LongSupplier monotonicTimeSourceNanos;
    private final long notInitializedSentinel;
    private final long createdTimeMillis;
    private final double halfLifeNanos;
    private final double min;
    private final double max;

    public TimeDecayingRunningAverage(double defaultValue, long halfLife, double min, double max, TimeSkewDetectorCallback callback) {
        this(defaultValue, halfLife, min, max, null, callback);
    }

    public TimeDecayingRunningAverage(double defaultValue, long halfLife, double min, double max, SimpleFieldSet fs, TimeSkewDetectorCallback callback) {
        this(defaultValue, halfLife, min, max, fs, callback, System::currentTimeMillis, System::nanoTime);
    }

    TimeDecayingRunningAverage(double defaultValue, long halfLife, double min, double max, SimpleFieldSet fs, TimeSkewDetectorCallback callback, LongSupplier wallClockTimeSourceMillis, LongSupplier monotonicTimeSourceNanos) {
        double d;
        this.halfLifeNanos = (double)Math.max(1L, halfLife) * 1000000.0;
        this.min = min;
        this.max = max;
        long createdTime = wallClockTimeSourceMillis.getAsLong();
        long reports = 0L;
        boolean started = false;
        double currentValue = defaultValue;
        if (fs != null && (started = fs.getBoolean("Started", false)) && !this.isInvalid(d = fs.getDouble("CurrentValue", currentValue))) {
            reports = Math.max(0L, fs.getLong("TotalReports", 0L));
            createdTime -= Math.max(0L, fs.getLong("Uptime", 0L));
            currentValue = d;
        }
        this.timeTracker = new TimeTracker(callback, wallClockTimeSourceMillis);
        this.monotonicTimeSourceNanos = monotonicTimeSourceNanos;
        this.notInitializedSentinel = monotonicTimeSourceNanos.getAsLong() - 1L;
        this.createdTimeMillis = createdTime;
        this.data.set(new Data(reports, this.notInitializedSentinel, started, currentValue));
    }

    public TimeDecayingRunningAverage(TimeDecayingRunningAverage other) {
        this.timeTracker = new TimeTracker(other.timeTracker);
        this.monotonicTimeSourceNanos = other.monotonicTimeSourceNanos;
        this.notInitializedSentinel = other.notInitializedSentinel;
        this.createdTimeMillis = other.createdTimeMillis;
        this.halfLifeNanos = other.halfLifeNanos;
        this.max = other.max;
        this.min = other.min;
        this.data.set(new Data(other.data.get()));
    }

    @Override
    public double currentValue() {
        return this.data.get().currentValue;
    }

    @Override
    public void report(double d) {
        this.data.updateAndGet(data -> ((Data)data).updated(d));
        this.timeTracker.report();
    }

    @Override
    public void report(long d) {
        this.report((double)d);
    }

    @Override
    public double valueIfReported(double r) {
        return this.data.get().updated(r).currentValue;
    }

    @Override
    public long countReports() {
        return this.data.get().reports;
    }

    public long lastReportTime() {
        return this.timeTracker.lastReportMillis;
    }

    public SimpleFieldSet exportFieldSet(boolean shortLived) {
        Data data = this.data.get();
        long now = this.timeTracker.wallClockTimeSourceMillis.getAsLong();
        SimpleFieldSet fs = new SimpleFieldSet(shortLived);
        fs.putSingle("Type", "TimeDecayingRunningAverage");
        fs.put("CurrentValue", data.currentValue);
        fs.put("Started", data.started);
        fs.put("TotalReports", data.reports);
        fs.put("Uptime", now - this.createdTimeMillis);
        return fs;
    }

    @Override
    public TimeDecayingRunningAverage clone() {
        return new TimeDecayingRunningAverage(this);
    }

    public String toString() {
        Data data = this.data.get();
        long now = this.timeTracker.wallClockTimeSourceMillis.getAsLong();
        return super.toString() + ": currentValue=" + data.currentValue + ", , halfLife=" + (long)(this.halfLifeNanos / 1000000.0) + "ms, lastReportTime=" + (now - this.lastReportTime()) + "ms ago, createdTime=" + (now - this.createdTimeMillis) + "ms ago, reports=" + data.reports + ", started=" + data.started + ", min=" + this.min + ", max=" + this.max;
    }

    private boolean isInvalid(double d) {
        return d < this.min || d > this.max || Double.isInfinite(d) || Double.isNaN(d);
    }

    private static class TimeTracker {
        private final TimeSkewDetectorCallback timeSkewDetectorCallback;
        private final LongSupplier wallClockTimeSourceMillis;
        private volatile long lastReportMillis = -1L;

        private TimeTracker(TimeSkewDetectorCallback timeSkewDetectorCallback, LongSupplier wallClockTimeSourceMillis) {
            this.timeSkewDetectorCallback = timeSkewDetectorCallback;
            this.wallClockTimeSourceMillis = wallClockTimeSourceMillis;
        }

        private TimeTracker(TimeTracker other) {
            this.timeSkewDetectorCallback = other.timeSkewDetectorCallback;
            this.wallClockTimeSourceMillis = other.wallClockTimeSourceMillis;
            this.lastReportMillis = other.lastReportMillis;
        }

        private void report() {
            long now;
            if (this.timeSkewDetectorCallback == null) {
                this.lastReportMillis = this.wallClockTimeSourceMillis.getAsLong();
                return;
            }
            long lastReportTime = this.lastReportMillis;
            this.lastReportMillis = now = this.wallClockTimeSourceMillis.getAsLong();
            if (now < lastReportTime) {
                Logger.error(this, "Clock went back in time: " + now + " was " + lastReportTime + " (back " + (lastReportTime - now) + "ms)");
                this.timeSkewDetectorCallback.setTimeSkewDetectedUserAlert();
            }
        }
    }

    private class Data {
        private final long reports;
        private final long lastUpdatedNanos;
        private final boolean started;
        private final double currentValue;

        private Data(long reports, long lastUpdatedNanos, boolean started, double currentValue) {
            this.reports = reports;
            this.lastUpdatedNanos = lastUpdatedNanos;
            this.started = started;
            this.currentValue = Math.max(TimeDecayingRunningAverage.this.min, Math.min(TimeDecayingRunningAverage.this.max, currentValue));
        }

        private Data(Data other) {
            this.reports = other.reports;
            this.lastUpdatedNanos = other.lastUpdatedNanos;
            this.started = other.started;
            this.currentValue = other.currentValue;
        }

        private Data updated(double d) {
            if (TimeDecayingRunningAverage.this.isInvalid(d)) {
                return this;
            }
            long now = TimeDecayingRunningAverage.this.monotonicTimeSourceNanos.getAsLong();
            if (!this.started) {
                return new Data(this.reports + 1L, now, true, d);
            }
            if (this.lastUpdatedNanos == TimeDecayingRunningAverage.this.notInitializedSentinel) {
                return new Data(this.reports + 1L, now, true, this.currentValue);
            }
            double timeSinceLastUpdated = now - this.lastUpdatedNanos;
            double changeFactor = Math.pow(0.5, timeSinceLastUpdated / TimeDecayingRunningAverage.this.halfLifeNanos);
            double newValue = this.currentValue * changeFactor + (1.0 - changeFactor) * d;
            return new Data(this.reports + 1L, now, true, newValue);
        }
    }
}

