/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ClientMetadata;
import freenet.client.InsertBlock;
import freenet.client.InsertContext;
import freenet.client.InsertException;
import freenet.client.Metadata;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.BinaryBlobFormatException;
import freenet.client.async.BinaryBlobInserter;
import freenet.client.async.ClientBaseCallback;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientPutCallback;
import freenet.client.async.ClientPutState;
import freenet.client.async.PersistentClientCallback;
import freenet.client.async.PutCompletionCallback;
import freenet.client.async.SingleFileInserter;
import freenet.client.events.SendingToNetworkEvent;
import freenet.client.events.SplitfileProgressEvent;
import freenet.crypt.ChecksumChecker;
import freenet.keys.BaseClientKey;
import freenet.keys.FreenetURI;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.ResumeFailedException;
import java.io.IOException;

public class ClientPutter
extends BaseClientPutter
implements PutCompletionCallback {
    private static final long serialVersionUID = 1L;
    final ClientPutCallback client;
    final RandomAccessBucket data;
    final FreenetURI targetURI;
    final ClientMetadata cm;
    final InsertContext ctx;
    final String targetFilename;
    private ClientPutState currentState;
    private boolean finished;
    private final boolean isMetadata;
    private boolean startedStarting;
    private final boolean binaryBlob;
    private FreenetURI uri;
    private final byte[] overrideSplitfileCrypto;
    private byte[] cryptoKey;
    private final long metadataThreshold;
    private boolean gotFinalMetadata;
    private static volatile boolean logMINOR;
    protected int minSuccessFetchBlocks;

    public ClientPutter(ClientPutCallback client, RandomAccessBucket data, FreenetURI targetURI, ClientMetadata cm, InsertContext ctx, short priorityClass, boolean isMetadata, String targetFilename, boolean binaryBlob, ClientContext context, byte[] overrideSplitfileCrypto, long metadataThreshold) {
        super(priorityClass, client);
        this.cm = cm;
        this.isMetadata = isMetadata;
        this.client = client;
        this.data = data;
        this.targetURI = targetURI;
        this.ctx = ctx;
        this.finished = false;
        this.cancelled = false;
        this.targetFilename = targetFilename;
        this.binaryBlob = binaryBlob;
        this.overrideSplitfileCrypto = overrideSplitfileCrypto;
        this.metadataThreshold = metadataThreshold;
    }

    public void start(ClientContext context) throws InsertException {
        this.start(false, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(boolean restart, ClientContext context) throws InsertException {
        block49: {
            InsertContext.CompatibilityMode mode;
            if (logMINOR) {
                Logger.minor(this, "Starting " + this + " for " + this.targetURI);
            }
            byte cryptoAlgorithm = (mode = this.ctx.getCompatibilityMode()) != InsertContext.CompatibilityMode.COMPAT_CURRENT && mode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1416.ordinal() ? (byte)2 : 3;
            try {
                this.targetURI.checkInsertURI();
                boolean randomiseSplitfileKeys = ClientPutter.randomiseSplitfileKeys(this.targetURI, this.ctx, this.persistent());
                if (this.data == null) {
                    throw new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, "No data to insert", null);
                }
                boolean cancel = false;
                ClientPutter clientPutter = this;
                synchronized (clientPutter) {
                    if (restart) {
                        this.clearCountersOnRestart();
                        if (this.currentState != null && !this.finished) {
                            if (logMINOR) {
                                Logger.minor(this, "Can't restart, not finished and currentState != null : " + this.currentState);
                            }
                            return false;
                        }
                        if (this.finished) {
                            this.startedStarting = false;
                        }
                        this.finished = false;
                    }
                    if (this.startedStarting) {
                        if (logMINOR) {
                            Logger.minor(this, "Can't " + (restart ? "restart" : "start") + " : startedStarting = true");
                        }
                        return false;
                    }
                    this.startedStarting = true;
                    if (this.currentState != null) {
                        if (logMINOR) {
                            Logger.minor(this, "Can't " + (restart ? "restart" : "start") + " : currentState != null : " + this.currentState);
                        }
                        return false;
                    }
                    cancel = this.cancelled;
                    this.cryptoKey = null;
                    if (this.overrideSplitfileCrypto != null) {
                        this.cryptoKey = this.overrideSplitfileCrypto;
                        if (this.cryptoKey.length != 32) {
                            throw new InsertException(InsertException.InsertExceptionMode.INVALID_URI, "overrideSplitfileCryptoKey must be of length 32", null);
                        }
                    } else if (randomiseSplitfileKeys) {
                        this.cryptoKey = new byte[32];
                        context.random.nextBytes(this.cryptoKey);
                    }
                    if (!cancel) {
                        if (!this.binaryBlob) {
                            ClientMetadata meta = this.cm;
                            if (meta != null) {
                                meta = this.persistent() ? meta.clone() : meta;
                            }
                            this.currentState = new SingleFileInserter(this, this, new InsertBlock(this.data, meta, this.targetURI), this.isMetadata, this.ctx, this.realTimeFlag, false, false, null, null, false, this.targetFilename, false, this.persistent(), 0L, 0L, null, cryptoAlgorithm, this.cryptoKey, this.metadataThreshold);
                        } else {
                            this.currentState = new BinaryBlobInserter(this.data, this, this.getClient(), false, this.priorityClass, this.ctx, context);
                        }
                    }
                }
                if (cancel) {
                    this.onFailure(new InsertException(InsertException.InsertExceptionMode.CANCELLED), null, context);
                    return false;
                }
                clientPutter = this;
                synchronized (clientPutter) {
                    cancel = this.cancelled;
                }
                if (cancel) {
                    this.onFailure(new InsertException(InsertException.InsertExceptionMode.CANCELLED), null, context);
                    return false;
                }
                if (logMINOR) {
                    Logger.minor(this, "Starting insert: " + this.currentState);
                }
                if (this.currentState instanceof SingleFileInserter) {
                    ((SingleFileInserter)this.currentState).start(context);
                } else {
                    this.currentState.schedule(context);
                }
                clientPutter = this;
                synchronized (clientPutter) {
                    cancel = this.cancelled;
                }
                if (cancel) {
                    this.onFailure(new InsertException(InsertException.InsertExceptionMode.CANCELLED), null, context);
                    return false;
                }
            }
            catch (InsertException e) {
                Logger.error(this, "Failed to start insert: " + e, (Throwable)e);
                ClientPutter clientPutter = this;
                synchronized (clientPutter) {
                    this.finished = true;
                    this.currentState = null;
                }
                if (this.client != null) {
                    this.client.onFailure(e, this);
                }
            }
            catch (IOException e) {
                Logger.error(this, "Failed to start insert: " + e, (Throwable)e);
                ClientPutter clientPutter = this;
                synchronized (clientPutter) {
                    this.finished = true;
                    this.currentState = null;
                }
                if (this.client != null) {
                    this.client.onFailure(new InsertException(InsertException.InsertExceptionMode.BUCKET_ERROR, e, null), this);
                }
            }
            catch (BinaryBlobFormatException e) {
                Logger.error(this, "Failed to start insert: " + e, (Throwable)e);
                ClientPutter clientPutter = this;
                synchronized (clientPutter) {
                    this.finished = true;
                    this.currentState = null;
                }
                if (this.client == null) break block49;
                this.client.onFailure(new InsertException(InsertException.InsertExceptionMode.BINARY_BLOB_FORMAT_ERROR, e, null), this);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Started " + this);
        }
        return true;
    }

    public static boolean randomiseSplitfileKeys(FreenetURI targetURI, InsertContext ctx, boolean persistent) {
        InsertContext.CompatibilityMode cmode;
        boolean randomiseSplitfileKeys;
        boolean bl = randomiseSplitfileKeys = targetURI.isSSK() || targetURI.isKSK() || targetURI.isUSK();
        if (randomiseSplitfileKeys && (cmode = ctx.getCompatibilityMode()) != InsertContext.CompatibilityMode.COMPAT_CURRENT && cmode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1255.ordinal()) {
            randomiseSplitfileKeys = false;
        }
        return randomiseSplitfileKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(ClientPutState state, ClientContext context) {
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            this.finished = true;
            this.currentState = null;
        }
        if (!(this.failedBlocks <= 0 && this.fatallyFailedBlocks <= 0 && this.successfulBlocks >= this.totalBlocks || this.uri.isUSK() || this.ctx.getCHKOnly)) {
            Logger.error(this, "Failed blocks: " + this.failedBlocks + ", Fatally failed blocks: " + this.fatallyFailedBlocks + ", Successful blocks: " + this.successfulBlocks + ", Total blocks: " + this.totalBlocks + " but success?! on " + this + " from " + state, (Throwable)new Exception("debug"));
        }
        this.client.onSuccess(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(InsertException e, ClientPutState state, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "onFailure() for " + this + " : " + state + " : " + e, (Throwable)e);
        }
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            this.finished = true;
            this.currentState = null;
        }
        this.client.onFailure(e, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEncode(BaseClientKey key, ClientPutState state, ClientContext context) {
        FreenetURI u;
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            u = key.getURI();
            if (this.gotFinalMetadata) {
                Logger.error(this, "Generated URI *and* sent final metadata??? on " + this + " from " + state);
            }
            if (this.targetFilename != null) {
                u = u.pushMetaString(this.targetFilename);
            }
            if (this.uri != null) {
                if (!this.uri.equals(u)) {
                    Logger.error(this, "onEncode() called twice with different URIs: " + this.uri + " -> " + u + " for " + this, (Throwable)new Exception("error"));
                }
                return;
            }
            this.uri = u;
        }
        this.client.onGeneratedURI(u, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMetadata(Bucket finalMetadata, ClientPutState state, ClientContext context) {
        boolean freeIt = false;
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            if (this.uri != null) {
                Logger.error(this, "Generated URI *and* sent final metadata??? on " + this + " from " + state);
            }
            if (this.gotFinalMetadata) {
                Logger.error(this, "onMetadata called twice - already sent metadata to client for " + this);
                freeIt = true;
            } else {
                this.gotFinalMetadata = true;
            }
        }
        if (freeIt) {
            finalMetadata.free();
            return;
        }
        this.client.onGeneratedMetadata(finalMetadata, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Cancelling " + this, (Throwable)new Exception("debug"));
        }
        ClientPutState oldState = null;
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            if (this.cancelled) {
                return;
            }
            if (this.finished) {
                return;
            }
            super.cancel();
            oldState = this.currentState;
        }
        if (oldState != null) {
            oldState.cancel(context);
        }
        this.onFailure(new InsertException(InsertException.InsertExceptionMode.CANCELLED), null, context);
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finished || this.cancelled;
    }

    public Bucket getData() {
        return this.data;
    }

    public FreenetURI getTargetURI() {
        return this.targetURI;
    }

    @Override
    public FreenetURI getURI() {
        return this.uri;
    }

    public byte[] getSplitfileCryptoKey() {
        return this.cryptoKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransition(ClientPutState oldState, ClientPutState newState, ClientContext context) {
        if (newState == null) {
            throw new NullPointerException();
        }
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            if (this.currentState == oldState) {
                this.currentState = newState;
                return;
            }
        }
        if (this.persistent()) {
            context.jobRunner.setCheckpointASAP();
        }
        Logger.normal(this, "onTransition: cur=" + this.currentState + ", old=" + oldState + ", new=" + newState);
    }

    @Override
    public void onMetadata(Metadata m, ClientPutState state, ClientContext context) {
        Logger.error(this, "Got metadata on " + this + " from " + state + " (this means the metadata won't be inserted)");
    }

    @Override
    public int getMinSuccessFetchBlocks() {
        return this.minSuccessFetchBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlock() {
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            ++this.minSuccessFetchBlocks;
        }
        super.addBlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlocks(int num) {
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            this.minSuccessFetchBlocks += num;
        }
        super.addBlocks(num);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMustSucceedBlocks(int blocks) {
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            this.minSuccessFetchBlocks += blocks;
        }
        super.addMustSucceedBlocks(blocks);
    }

    @Override
    public void addRedundantBlocksInsert(int blocks) {
        super.addMustSucceedBlocks(blocks);
    }

    @Override
    protected void clearCountersOnRestart() {
        this.minSuccessFetchBlocks = 0;
        super.clearCountersOnRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void innerNotifyClients(ClientContext context) {
        SplitfileProgressEvent e;
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            e = new SplitfileProgressEvent(this.totalBlocks, this.successfulBlocks, this.latestSuccess, this.failedBlocks, this.fatallyFailedBlocks, this.latestFailure, this.minSuccessBlocks, this.minSuccessFetchBlocks, this.blockSetFinalized);
        }
        this.ctx.eventProducer.produceEvent(e, context);
    }

    @Override
    protected void innerToNetwork(ClientContext context) {
        this.ctx.eventProducer.produceEvent(new SendingToNetworkEvent(), context);
    }

    @Override
    public void onBlockSetFinished(ClientPutState state, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Set finished", (Throwable)new Exception("debug"));
        }
        this.blockSetFinalized(context);
    }

    @Override
    public void onFetchable(ClientPutState state) {
        this.client.onFetchable(this);
    }

    public boolean canRestart() {
        if (this.currentState != null && !this.finished) {
            Logger.minor(this, "Cannot restart because not finished for " + this.uri);
            return false;
        }
        return this.data != null;
    }

    public boolean restart(ClientContext context) throws InsertException {
        return this.start(true, context);
    }

    @Override
    public void onTransition(ClientGetState oldState, ClientGetState newState, ClientContext context) {
    }

    @Override
    public void dump() {
        System.out.println("URI: " + this.uri);
        System.out.println("Client: " + this.client);
        System.out.println("Finished: " + this.finished);
        System.out.println("Data: " + this.data);
    }

    @Override
    public byte[] getClientDetail(ChecksumChecker checker) throws IOException {
        if (this.client instanceof PersistentClientCallback) {
            return ClientPutter.getClientDetail((PersistentClientCallback)((Object)this.client), checker);
        }
        return new byte[0];
    }

    @Override
    public void innerOnResume(ClientContext context) throws ResumeFailedException {
        super.innerOnResume(context);
        if (this.currentState != null) {
            try {
                this.currentState.onResume(context);
            }
            catch (InsertException e) {
                this.onFailure(e, null, context);
                return;
            }
        }
        if (this.data != null) {
            this.data.onResume(context);
        }
        this.notifyClients(context);
    }

    @Override
    protected ClientBaseCallback getCallback() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onShutdown(ClientContext context) {
        ClientPutState state;
        ClientPutter clientPutter = this;
        synchronized (clientPutter) {
            state = this.currentState;
        }
        if (state != null) {
            state.onShutdown(context);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

