/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.NodeL10n;
import freenet.support.HTMLNode;
import freenet.support.MultiValueTable;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;
import java.util.NoSuchElementException;
import javax.naming.SizeLimitExceededException;

public class UserAlertsToadlet
extends Toadlet {
    UserAlertsToadlet(HighLevelSimpleClient client) {
        super(client);
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        PageNode page = ctx.getPageMaker().getPageNode(this.l10n("title"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode alertsNode = ctx.getAlertManager().createAlerts(false);
        if (alertsNode.getFirstTag() == null) {
            alertsNode = new HTMLNode("div", "class", "infobox");
            alertsNode.addChild("div", "class", "infobox-content").addChild("div", NodeL10n.getBase().getString("UserAlertsToadlet.noMessages"));
        }
        contentNode.addChild(alertsNode);
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        String redirect;
        MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
        if (request.isPartSet("dismiss-user-alert")) {
            int userAlertHashCode = request.getIntPart("disable", -1);
            ctx.getAlertManager().dismissAlert(userAlertHashCode);
        }
        try {
            redirect = request.getPartAsStringThrowing("redirectToAfterDisable", 1024);
        }
        catch (NoSuchElementException | SizeLimitExceededException e) {
            redirect = ".";
        }
        headers.put("Location", redirect);
        ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
    }

    protected String l10n(String name) {
        return NodeL10n.getBase().getString("UserAlertsToadlet." + name);
    }

    @Override
    public String path() {
        return "/alerts/";
    }
}

