/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.Util;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerContext;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.comm.RetrievalException;
import freenet.io.comm.SlowAsyncMessageFilterCallback;
import freenet.io.xfer.BulkReceiver;
import freenet.io.xfer.BulkTransmitter;
import freenet.io.xfer.PartiallyReceivedBulk;
import freenet.node.AnnounceSender;
import freenet.node.AnnouncementCallback;
import freenet.node.Announcer;
import freenet.node.FSParseException;
import freenet.node.Location;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.NodeCryptoConfig;
import freenet.node.NodeInitException;
import freenet.node.OpennetPeerNode;
import freenet.node.PeerNode;
import freenet.node.RequestSender;
import freenet.node.SeedAnnounceTracker;
import freenet.support.Fields;
import freenet.support.HTMLNode;
import freenet.support.LRUQueue;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeSortedHashtable;
import freenet.support.io.ByteArrayRandomAccessBuffer;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import freenet.support.io.NativeThread;
import freenet.support.transport.ip.HostnameSyntaxException;
import freenet.support.transport.ip.IPUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class OpennetManager {
    final Node node;
    final NodeCrypto crypto;
    final Announcer announcer;
    final SeedAnnounceTracker seedTracker = new SeedAnnounceTracker();
    static final double LONG_DISTANCE = 0.01;
    static final double LONG_PROPORTION = 0.3;
    public static final double SHORT_PROPORTION = 0.7;
    private final EnumMap<LinkLengthClass, LRUQueue<OpennetPeerNode>> peersLRUByDistance;
    private final LRUQueue<OpennetPeerNode> oldPeers;
    static final int MAX_OLD_PEERS = 25;
    private final EnumMap<ConnectionType, Long> timeLastDropped;
    private final EnumMap<ConnectionType, Long> connectionAttempts;
    private final EnumMap<ConnectionType, Long> connectionAttemptsAdded;
    private final EnumMap<ConnectionType, Long> connectionAttemptsAddedPlentySpace;
    private final EnumMap<ConnectionType, Long> connectionAttemptsRejectedByPerTypeEnforcement;
    private final EnumMap<ConnectionType, Long> connectionAttemptsRejectedNoPeersDroppable;
    private final EnumMap<ConnectionType, Long> successCount;
    public static final int MIN_SUCCESS_BETWEEN_DROP_CONNS = 10;
    public static final int RESET_PATH_FOLDING_PROB = 20;
    public static final long DONT_READD_TIME = TimeUnit.MINUTES.toMillis(1L);
    public static final long DROP_MIN_AGE = TimeUnit.MINUTES.toMillis(5L);
    public static final long DROP_MIN_AGE_DISCONNECTED = TimeUnit.MINUTES.toMillis(5L);
    public static final long DROP_STARTUP_DELAY = TimeUnit.MINUTES.toMillis(2L);
    public static final long DROP_DISCONNECT_DELAY = TimeUnit.MINUTES.toMillis(5L);
    public static final long DROP_DISCONNECT_DELAY_COOLDOWN = TimeUnit.MINUTES.toMillis(60L);
    public static final long DROP_CONNECTED_TIME = TimeUnit.MINUTES.toMillis(5L);
    public static final long MIN_TIME_BETWEEN_OFFERS = TimeUnit.SECONDS.toMillis(30L);
    private static volatile boolean logMINOR;
    public static final int PADDED_NODEREF_SIZE = 3072;
    public static final int MAX_OPENNET_NODEREF_LENGTH = 32768;
    public static final boolean ENABLE_PEERS_PER_KB_OUTPUT = true;
    public static final double SCALING_CONSTANT = 12.0;
    public static final int MIN_PEERS_FOR_SCALING = 10;
    public static final double MAX_DISTANCE = 0.5;
    public static final double SHORT_NODES_FRACTION = 0.02;
    public static final int LAST_NETWORK_SIZE_ESTIMATE = 5000;
    public static final int AVAILABLE_SHORT_DISTANCE_NODES = 100;
    public static final int MAX_PEERS_FOR_SCALING = 142;
    public static final int PANIC_MAX_PEERS = 152;
    public static final long MAX_TIME_ON_OLD_OPENNET_PEERS;
    private final long creationTime = System.currentTimeMillis();
    private boolean stopping;
    private long timeLastOffered;
    private static final long MAX_AGE;
    private static final TimeSortedHashtable<String> knownIds;

    public OpennetManager(Node node, NodeCryptoConfig opennetConfig, long startupTime, boolean enableAnnouncement) throws NodeInitException {
        this.node = node;
        this.crypto = new NodeCrypto(node, true, opennetConfig, startupTime, node.enableARKs);
        this.timeLastDropped = new EnumMap(ConnectionType.class);
        this.connectionAttempts = new EnumMap(ConnectionType.class);
        this.connectionAttemptsAdded = new EnumMap(ConnectionType.class);
        this.connectionAttemptsAddedPlentySpace = new EnumMap(ConnectionType.class);
        this.connectionAttemptsRejectedByPerTypeEnforcement = new EnumMap(ConnectionType.class);
        this.connectionAttemptsRejectedNoPeersDroppable = new EnumMap(ConnectionType.class);
        this.successCount = new EnumMap(ConnectionType.class);
        for (ConnectionType c : ConnectionType.values()) {
            this.timeLastDropped.put(c, 0L);
            this.connectionAttempts.put(c, 0L);
            this.connectionAttemptsAdded.put(c, 0L);
            this.connectionAttemptsAddedPlentySpace.put(c, 0L);
            this.connectionAttemptsRejectedByPerTypeEnforcement.put(c, 0L);
            this.connectionAttemptsRejectedNoPeersDroppable.put(c, 0L);
            this.successCount.put(c, 0L);
        }
        File nodeFile = node.nodeDir().file("opennet-" + this.crypto.portNumber);
        File backupNodeFile = node.nodeDir().file("opennet-" + this.crypto.portNumber + ".bak");
        try {
            this.readFile(nodeFile);
        }
        catch (IOException e) {
            try {
                this.readFile(backupNodeFile);
            }
            catch (IOException e1) {
                this.crypto.initCrypto();
            }
        }
        this.peersLRUByDistance = new EnumMap(LinkLengthClass.class);
        for (LinkLengthClass l : LinkLengthClass.values()) {
            this.peersLRUByDistance.put(l, new LRUQueue());
        }
        this.oldPeers = new LRUQueue();
        this.announcer = enableAnnouncement ? new Announcer(this) : null;
    }

    public void writeFile() {
        File nodeFile = this.node.nodeDir().file("opennet-" + this.crypto.portNumber);
        File backupNodeFile = this.node.nodeDir().file("opennet-" + this.crypto.portNumber + ".bak");
        this.writeFile(nodeFile, backupNodeFile);
    }

    private void writeFile(File orig, File backup) {
        SimpleFieldSet fs = this.crypto.exportPrivateFieldSet();
        if (orig.exists()) {
            backup.delete();
        }
        FileOutputStream fos = null;
        OutputStreamWriter osr = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(backup);
            osr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            bw = new BufferedWriter(osr);
            fs.writeTo(bw);
            bw.close();
            FileUtil.renameTo(backup, orig);
        }
        catch (IOException e) {
            Closer.close(bw);
            Closer.close(osr);
            Closer.close(fos);
        }
    }

    private void readFile(File filename) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        SimpleFieldSet fs = new SimpleFieldSet(br, false, true);
        br.close();
        String[] udp = fs.getAll("physical.udp");
        if (udp != null && udp.length > 0) {
            for (String u : udp) {
                Peer p;
                try {
                    p = new Peer(u, false, true);
                }
                catch (HostnameSyntaxException e) {
                    Logger.error(this, "Invalid hostname or IP Address syntax error while loading opennet peer node reference: " + u);
                    System.err.println("Invalid hostname or IP Address syntax error while loading opennet peer node reference: " + u);
                    continue;
                }
                catch (PeerParseException e) {
                    throw (IOException)new IOException().initCause(e);
                }
                if (p.getPort() != this.crypto.portNumber) continue;
                this.node.ipDetector.setOldIPAddress(p.getFreenetAddress());
                break;
            }
        }
        this.crypto.readCrypto(fs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        OpennetManager opennetManager = this;
        synchronized (opennetManager) {
            this.stopping = false;
        }
        this.node.peers.tryReadPeers(this.node.nodeDir().file("openpeers-" + this.crypto.portNumber).toString(), this.crypto, this, true, false);
        OpennetPeerNode[] nodes = this.node.peers.getOpennetPeers();
        Arrays.sort(nodes, new Comparator<OpennetPeerNode>(){

            @Override
            public int compare(OpennetPeerNode pn1, OpennetPeerNode pn2) {
                long lastSuccess2;
                if (pn1 == pn2) {
                    return 0;
                }
                long lastSuccess1 = pn1.timeLastSuccess();
                if (lastSuccess1 > (lastSuccess2 = pn2.timeLastSuccess())) {
                    return 1;
                }
                if (lastSuccess2 > lastSuccess1) {
                    return -1;
                }
                boolean neverConnected1 = pn1.neverConnected();
                boolean neverConnected2 = pn2.neverConnected();
                if (neverConnected1 && !neverConnected2) {
                    return -1;
                }
                if (!neverConnected1 && neverConnected2) {
                    return 1;
                }
                if (pn1.hashCode > pn2.hashCode) {
                    return 1;
                }
                if (pn1.hashCode < pn2.hashCode) {
                    return -1;
                }
                Logger.error(this, "Two OpennetPeerNodes with the same hashcode: " + pn1 + " vs " + pn2);
                return Fields.compareObjectID(pn1, pn2);
            }
        });
        for (OpennetPeerNode opn : nodes) {
            if (Location.isValid(opn.getLocation())) {
                this.lruQueue(opn).push(opn);
                continue;
            }
            this.node.peers.disconnectAndRemove(opn, false, false, false);
        }
        if (logMINOR) {
            Logger.minor(this, "My full compressed ref: " + this.crypto.myCompressedFullRef().length);
            Logger.minor(this, "My full setup ref: " + this.crypto.myCompressedSetupRef().length);
            Logger.minor(this, "My heavy setup ref: " + this.crypto.myCompressedHeavySetupRef().length);
        }
        this.dropAllExcessPeers();
        this.writeFile();
        this.node.peers.tryReadPeers(this.node.nodeDir().file("openpeers-old-" + this.crypto.portNumber).toString(), this.crypto, this, true, true);
        this.crypto.start();
        if (this.announcer != null) {
            this.announcer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean purge) {
        OpennetManager opennetManager = this;
        synchronized (opennetManager) {
            this.stopping = true;
        }
        if (this.announcer != null) {
            this.announcer.stop();
        }
        this.crypto.stop();
        if (purge) {
            this.node.peers.removeOpennetPeers();
        }
        this.crypto.socket.getAddressTracker().setPresumedInnocent();
    }

    synchronized boolean stopping() {
        return this.stopping;
    }

    private LRUQueue<OpennetPeerNode> lruQueue(LinkLengthClass distance) {
        return this.peersLRUByDistance.get((Object)distance);
    }

    private LRUQueue<OpennetPeerNode> lruQueue(OpennetPeerNode pn) {
        return this.lruQueue(pn.linkLengthClass());
    }

    public boolean alreadyHaveOpennetNode(SimpleFieldSet fs) {
        try {
            OpennetPeerNode pn = new OpennetPeerNode(fs, this.node, this.crypto, this, false);
            if (this.lruQueue(pn).contains(pn)) {
                if (logMINOR) {
                    Logger.minor(this, "Not adding " + pn.userToString() + " to opennet list as already there");
                }
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t + " parsing opennet node from fieldset", t);
            return false;
        }
    }

    public OpennetPeerNode addNewOpennetNode(SimpleFieldSet fs, ConnectionType connectionType, boolean allowExisting) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException {
        try {
            OpennetPeerNode pn = new OpennetPeerNode(fs, this.node, this.crypto, this, false);
            if (Arrays.equals(pn.peerECDSAPubKeyHash, this.crypto.ecdsaPubKeyHash)) {
                if (logMINOR) {
                    Logger.minor(this, "Not adding self as opennet peer");
                }
                return null;
            }
            LinkLengthClass distance = pn.linkLengthClass();
            LRUQueue<OpennetPeerNode> peersLRU = this.lruQueue(distance);
            if (peersLRU.contains(pn)) {
                if (logMINOR) {
                    Logger.minor(this, "Not adding " + pn.userToString() + " to opennet list as already there");
                }
                if (allowExisting) {
                    return peersLRU.get(pn);
                }
                return null;
            }
            if (pn.isUnroutableOlderVersion() && this.node.nodeUpdater != null && this.node.nodeUpdater.dontAllowUOM()) {
                return null;
            }
            if (this.wantPeer(pn, true, false, false, connectionType, distance)) {
                return pn;
            }
            return null;
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t + " adding opennet node from fieldset", t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceAddPeer(OpennetPeerNode nodeToAddNow, boolean addAtLRU) {
        LinkLengthClass distance = nodeToAddNow.linkLengthClass();
        LRUQueue<OpennetPeerNode> peersLRU = this.lruQueue(distance);
        OpennetManager opennetManager = this;
        synchronized (opennetManager) {
            if (addAtLRU) {
                peersLRU.pushLeast(nodeToAddNow);
            } else {
                peersLRU.push(nodeToAddNow);
            }
            this.oldPeers.remove(nodeToAddNow);
        }
        this.dropExcessPeers(distance);
    }

    public boolean wantPeer(OpennetPeerNode nodeToAddNow, boolean addAtLRU, boolean justChecking, boolean oldOpennetPeer, ConnectionType connectionType) {
        if (nodeToAddNow != null) {
            if (!Location.isValid(nodeToAddNow.getLocation())) {
                Logger.error(this, "Added opennet node reference must include a valid location", (Throwable)new Exception("error"));
                return false;
            }
            LinkLengthClass distance = nodeToAddNow.linkLengthClass();
            return this.wantPeer(nodeToAddNow, addAtLRU, justChecking, oldOpennetPeer, connectionType, distance);
        }
        return this.wantPeer(nodeToAddNow, addAtLRU, justChecking, oldOpennetPeer, connectionType, LinkLengthClass.SHORT) || this.wantPeer(nodeToAddNow, addAtLRU, justChecking, oldOpennetPeer, connectionType, LinkLengthClass.LONG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wantPeer(OpennetPeerNode nodeToAddNow, boolean addAtLRU, boolean justChecking, boolean oldOpennetPeer, ConnectionType connectionType, LinkLengthClass distance) {
        boolean noDisconnect;
        boolean outdated;
        LRUQueue<OpennetPeerNode> peersLRU = this.lruQueue(distance);
        boolean notMany = false;
        long now = System.currentTimeMillis();
        if (logMINOR) {
            Logger.minor(this, "wantPeer(" + (nodeToAddNow != null) + "," + addAtLRU + "," + justChecking + "," + oldOpennetPeer + "," + (Object)((Object)connectionType) + "," + (Object)((Object)distance) + ")");
        }
        boolean bl = outdated = nodeToAddNow == null ? false : nodeToAddNow.isUnroutableOlderVersion();
        if (outdated && logMINOR) {
            Logger.minor(this, "Peer is outdated: " + nodeToAddNow.getVersionNumber() + " for " + (Object)((Object)connectionType));
        }
        if (outdated && this.tooManyOutdatedPeers()) {
            if (logMINOR) {
                Logger.minor(this, "Rejecting TOO OLD peer from " + (Object)((Object)connectionType) + " (too many already): " + nodeToAddNow);
            }
            return false;
        }
        if (nodeToAddNow != null && this.crypto.config.oneConnectionPerAddress()) {
            boolean okay = false;
            boolean any = false;
            Peer[] handshakeIPs = nodeToAddNow.getHandshakeIPs();
            if (handshakeIPs != null) {
                for (Peer p : handshakeIPs) {
                    InetAddress a;
                    FreenetInetAddress addr;
                    if (p == null || (addr = p.getFreenetAddress()) == null || (a = addr.getAddress(false)) == null || a.isAnyLocalAddress() || a.isLinkLocalAddress() || IPUtil.isSiteLocalAddress(a)) continue;
                    any = true;
                    if (this.crypto.allowConnection(nodeToAddNow, addr)) {
                        okay = true;
                        continue;
                    }
                    okay = false;
                    break;
                }
            } else {
                Logger.error(this, "Peer does not have any IP addresses???");
            }
            if (any && !okay) {
                Logger.normal(this, "Rejecting peer as we are already connected to a peer with the same IP address");
                return false;
            }
        }
        int maxPeers = this.getNumberOfConnectedPeersToAim(distance);
        if (logMINOR) {
            Logger.minor(this, "Peers target: " + maxPeers);
        }
        OpennetManager any = this;
        synchronized (any) {
            if (nodeToAddNow != null && peersLRU.contains(nodeToAddNow)) {
                if (logMINOR) {
                    Logger.minor(this, "Opennet peer already present in LRU: " + nodeToAddNow);
                }
                return true;
            }
            if (nodeToAddNow != null) {
                this.connectionAttempts.put(connectionType, this.connectionAttempts.get((Object)connectionType) + 1L);
            }
            if (this.getSize(distance) < maxPeers || outdated) {
                if (nodeToAddNow != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Added opennet peer " + nodeToAddNow + " as opennet peers list not full");
                    }
                    if (addAtLRU) {
                        peersLRU.pushLeast(nodeToAddNow);
                    } else {
                        peersLRU.push(nodeToAddNow);
                    }
                    this.oldPeers.remove(nodeToAddNow);
                    this.connectionAttemptsAddedPlentySpace.put(connectionType, this.connectionAttemptsAddedPlentySpace.get((Object)connectionType) + 1L);
                } else if (logMINOR) {
                    Logger.minor(this, "Want peer because not enough opennet nodes");
                }
                if (nodeToAddNow == null && !justChecking) {
                    this.timeLastOffered = System.currentTimeMillis();
                }
                notMany = true;
            }
            noDisconnect = this.successCount.get((Object)connectionType) < 10L || oldOpennetPeer || nodeToAddNow == null && now - this.timeLastOffered <= MIN_TIME_BETWEEN_OFFERS || now - this.timeLastDropped.get((Object)connectionType) < DROP_CONNECTED_TIME;
        }
        if (nodeToAddNow != null) {
            nodeToAddNow.setAddedReason(connectionType);
        }
        if (notMany) {
            if (nodeToAddNow != null) {
                this.node.peers.addPeer(nodeToAddNow, true, true);
            }
            return true;
        }
        boolean canAdd = true;
        ArrayList<OpennetPeerNode> dropList = new ArrayList<OpennetPeerNode>();
        maxPeers = this.getNumberOfConnectedPeersToAim(distance);
        OpennetManager opennetManager = this;
        synchronized (opennetManager) {
            int size = this.getSize(distance);
            if (size == maxPeers && nodeToAddNow == null) {
                OpennetPeerNode toDrop = this.peerToDrop(noDisconnect, false, nodeToAddNow != null, connectionType, maxPeers, distance, peersLRU);
                if (toDrop == null) {
                    if (logMINOR) {
                        Logger.minor(this, "No more peers to drop (in first bit), still " + peersLRU.size() + " peers, cannot accept peer" + (nodeToAddNow == null ? "" : nodeToAddNow.toString()));
                    }
                    canAdd = false;
                    if (nodeToAddNow != null) {
                        this.connectionAttemptsRejectedNoPeersDroppable.put(connectionType, this.connectionAttemptsRejectedNoPeersDroppable.get((Object)connectionType) + 1L);
                    }
                } else if (toDrop.isConnected() && this.enforcePerTypeGracePeriodLimits(maxPeers, connectionType, nodeToAddNow != null, peersLRU)) {
                    if (nodeToAddNow != null) {
                        this.connectionAttemptsRejectedByPerTypeEnforcement.put(connectionType, this.connectionAttemptsRejectedByPerTypeEnforcement.get((Object)connectionType) + 1L);
                    }
                    return false;
                }
            } else {
                while (canAdd && (size = this.getSize(distance)) > maxPeers - (nodeToAddNow == null || outdated ? 0 : 1)) {
                    OpennetPeerNode toDrop = this.peerToDrop(noDisconnect, false, nodeToAddNow != null, connectionType, maxPeers, distance, peersLRU);
                    if (toDrop == null) {
                        if (logMINOR) {
                            Logger.minor(this, "No more peers to drop, still " + peersLRU.size() + " peers, cannot accept peer" + (nodeToAddNow == null ? "" : nodeToAddNow.toString()));
                        }
                        canAdd = false;
                        if (nodeToAddNow == null) break;
                        this.connectionAttemptsRejectedNoPeersDroppable.put(connectionType, this.connectionAttemptsRejectedNoPeersDroppable.get((Object)connectionType) + 1L);
                        break;
                    }
                    if (toDrop.isConnected() && this.enforcePerTypeGracePeriodLimits(maxPeers, connectionType, nodeToAddNow != null, peersLRU)) {
                        if (nodeToAddNow != null) {
                            this.connectionAttemptsRejectedByPerTypeEnforcement.put(connectionType, this.connectionAttemptsRejectedByPerTypeEnforcement.get((Object)connectionType) + 1L);
                        }
                        return false;
                    }
                    if (nodeToAddNow == null && size <= maxPeers) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Drop opennet peer: " + toDrop + " (connected=" + toDrop.isConnected() + ") of " + peersLRU.size() + ":" + this.getSize(distance));
                    }
                    peersLRU.remove(toDrop);
                    dropList.add(toDrop);
                }
            }
            if (canAdd && !justChecking) {
                if (nodeToAddNow != null) {
                    this.successCount.put(connectionType, 0L);
                    if (addAtLRU) {
                        peersLRU.pushLeast(nodeToAddNow);
                    } else {
                        peersLRU.push(nodeToAddNow);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Added opennet peer " + nodeToAddNow + " after clearing " + dropList.size() + " items - now have " + peersLRU.size() + " opennet peers");
                    }
                    this.oldPeers.remove(nodeToAddNow);
                    if (!dropList.isEmpty()) {
                        if (logMINOR) {
                            Logger.minor(this, "Dropped opennet peer: " + dropList.get(0));
                        }
                        this.timeLastDropped.put(connectionType, now);
                    }
                    this.connectionAttemptsAdded.put(connectionType, this.connectionAttemptsAdded.get((Object)connectionType) + 1L);
                } else if (!justChecking) {
                    this.timeLastOffered = now;
                    if (logMINOR) {
                        Logger.minor(this, "Sending offer");
                    }
                }
            }
        }
        if (nodeToAddNow != null && canAdd && !this.node.peers.addPeer(nodeToAddNow, true, true) && logMINOR) {
            Logger.minor(this, "Already in global peers list: " + nodeToAddNow + " when adding opennet node");
        }
        for (OpennetPeerNode pn : dropList) {
            if (logMINOR) {
                Logger.minor(this, "Dropping LRU opennet peer: " + pn);
            }
            pn.setAddedReason(null);
            this.node.peers.disconnectAndRemove(pn, true, true, true);
        }
        return canAdd;
    }

    private int maxOutdatedPeers() {
        return Math.max(5, this.getNumberOfConnectedPeersToAimIncludingDarknet() / 4);
    }

    private boolean tooManyOutdatedPeers() {
        OpennetPeerNode[] peers;
        int maxTooOldPeers = this.maxOutdatedPeers();
        int count = 0;
        for (OpennetPeerNode pn : peers = this.node.peers.getOpennetPeers()) {
            if (!pn.isUnroutableOlderVersion() || ++count < maxTooOldPeers) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean enforcePerTypeGracePeriodLimits(int maxPeers, ConnectionType type, boolean addingPeer, LRUQueue<OpennetPeerNode> peersLRU) {
        OpennetPeerNode[] peers;
        int reconnectMax;
        int announceMax;
        int maxGracePeriodPeers;
        int pathFoldingMax;
        if (type == null && logMINOR) {
            Logger.minor(this, "No type set, not enforcing per type limits");
        }
        if ((pathFoldingMax = (maxGracePeriodPeers = maxPeers / 2) - (announceMax = (reconnectMax = maxGracePeriodPeers / 5 + 1)) - reconnectMax) < 2) {
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Per type grace period limits: total peers: " + maxPeers + " announce " + announceMax + " reconnect " + reconnectMax + " path folding " + pathFoldingMax);
        }
        int myLimit = type == ConnectionType.PATH_FOLDING ? pathFoldingMax : (type == ConnectionType.ANNOUNCE ? announceMax : reconnectMax);
        int count = 0;
        for (OpennetPeerNode pn : peers = peersLRU.toArray(new OpennetPeerNode[peersLRU.size()])) {
            if (pn.getAddedReason() != type || !pn.isConnected() || pn.isDroppable(false) || ++count < myLimit) continue;
            if (logMINOR) {
                Logger.minor(this, "Per type grace period limit rejected peer of type " + (Object)((Object)type) + " count is " + count + " limit is " + myLimit);
            }
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "Per type grace period limit allowed connection of type " + (Object)((Object)type) + " count is " + count + " limit is " + myLimit + " addingPeer=" + addingPeer);
        }
        return false;
    }

    void dropAllExcessPeers() {
        for (LinkLengthClass l : LinkLengthClass.values()) {
            this.dropExcessPeers(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropExcessPeers(LinkLengthClass distance) {
        LRUQueue<OpennetPeerNode> peersLRU = this.lruQueue(distance);
        int maxPeers = this.getNumberOfConnectedPeersToAim(distance);
        while (peersLRU.size() > maxPeers) {
            OpennetPeerNode toDrop;
            if (logMINOR) {
                Logger.minor(this, "Dropping opennet peers: currently " + peersLRU.size() + " of " + maxPeers + " for " + (Object)((Object)distance) + " distance links");
            }
            if ((toDrop = this.peerToDrop(false, false, false, null, maxPeers, distance, peersLRU)) == null) {
                toDrop = this.peerToDrop(false, true, false, null, maxPeers, distance, peersLRU);
            }
            if (toDrop == null) {
                return;
            }
            OpennetManager opennetManager = this;
            synchronized (opennetManager) {
                peersLRU.remove(toDrop);
            }
            if (logMINOR) {
                Logger.minor(this, "Dropping " + toDrop);
            }
            this.node.peers.disconnectAndRemove(toDrop, true, true, true);
        }
    }

    public synchronized int getSize(LinkLengthClass distance) {
        int x = 0;
        Enumeration<OpennetPeerNode> e = this.lruQueue(distance).elements();
        while (e.hasMoreElements()) {
            OpennetPeerNode pn = e.nextElement();
            if (pn.isUnroutableOlderVersion()) continue;
            ++x;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpennetPeerNode peerToDrop(boolean noDisconnect, boolean force, boolean addingNode, ConnectionType connectionType, int maxPeers, LinkLengthClass distance, LRUQueue<OpennetPeerNode> peersLRU) {
        if (this.getSize(distance) < maxPeers) {
            if (logMINOR) {
                Logger.minor(this, "peerToDrop(): Not dropping any peer (force=" + force + " addingNode=" + addingNode + ") because don't need to");
            }
            return null;
        }
        OpennetManager opennetManager = this;
        synchronized (opennetManager) {
            Integer x;
            OpennetPeerNode.NOT_DROP_REASON reason;
            boolean tooOld;
            EnumMap<OpennetPeerNode.NOT_DROP_REASON, Integer> map = null;
            if (addingNode) {
                map = new EnumMap<OpennetPeerNode.NOT_DROP_REASON, Integer>(OpennetPeerNode.NOT_DROP_REASON.class);
            }
            OpennetPeerNode[] peers = peersLRU.toArrayOrdered(new OpennetPeerNode[peersLRU.size()]);
            for (OpennetPeerNode opennetPeerNode : peers) {
                if (opennetPeerNode == null) continue;
                tooOld = opennetPeerNode.isUnroutableOlderVersion();
                if (opennetPeerNode.isConnected() && tooOld) continue;
                reason = opennetPeerNode.isDroppableWithReason(false);
                if (map != null) {
                    x = (Integer)map.get((Object)reason);
                    if (x == null) {
                        map.put(reason, 1);
                    } else {
                        map.put(reason, x + 1);
                    }
                }
                if (reason != OpennetPeerNode.NOT_DROP_REASON.DROPPABLE && (!force || tooOld) || opennetPeerNode.isConnected()) continue;
                if (logMINOR) {
                    Logger.minor(this, "Possibly dropping opennet peer " + opennetPeerNode + " as is disconnected (reason=" + (Object)((Object)reason) + " force=" + force + " tooOld=" + tooOld);
                }
                opennetPeerNode.setWasDropped();
                return opennetPeerNode;
            }
            if (noDisconnect) {
                if (addingNode && logMINOR) {
                    Logger.minor(this, "Not disconnecting");
                    if (map != null) {
                        for (Map.Entry entry : map.entrySet()) {
                            Logger.minor(this, "" + entry.getKey() + " : " + entry.getValue());
                        }
                    }
                }
                return null;
            }
            if (map != null) {
                map.clear();
            }
            for (OpennetPeerNode opennetPeerNode : peers) {
                if (opennetPeerNode == null) continue;
                tooOld = opennetPeerNode.isUnroutableOlderVersion();
                if (opennetPeerNode.isConnected() && tooOld) continue;
                reason = opennetPeerNode.isDroppableWithReason(false);
                if (map != null) {
                    x = (Integer)map.get((Object)reason);
                    if (x == null) {
                        map.put(reason, 1);
                    } else {
                        map.put(reason, x + 1);
                    }
                }
                if (reason != OpennetPeerNode.NOT_DROP_REASON.DROPPABLE && (!force || tooOld)) continue;
                if (logMINOR) {
                    Logger.minor(this, "Possibly dropping opennet peer " + opennetPeerNode + " " + (connectionType == null ? "" : System.currentTimeMillis() - this.timeLastDropped.get((Object)connectionType) + " ms since last dropped peer of type " + (Object)((Object)connectionType)));
                }
                opennetPeerNode.setWasDropped();
                return opennetPeerNode;
            }
            if (addingNode && logMINOR) {
                Logger.minor(this, "Nothing to drop");
                if (map != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        Logger.minor(this, "" + entry.getKey() + " : " + entry.getValue());
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess(OpennetPeerNode pn) {
        LinkLengthClass distance = pn.linkLengthClass();
        LRUQueue<OpennetPeerNode> peersLRU = this.lruQueue(distance);
        OpennetManager opennetManager = this;
        synchronized (opennetManager) {
            for (ConnectionType type : ConnectionType.values()) {
                this.successCount.put(type, this.successCount.get((Object)type) + 1L);
            }
            if (peersLRU.contains(pn)) {
                peersLRU.push(pn);
                if (logMINOR) {
                    Logger.minor(this, "Opennet peer " + pn + " promoted to top of LRU because of successful request");
                }
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Success on opennet peer which isn't in the LRU!: " + pn, (Throwable)new Exception("debug"));
            }
        }
        if (!this.wantPeer(pn, false, false, false, ConnectionType.RECONNECT, distance)) {
            this.node.peers.disconnectAndRemove(pn, true, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove(OpennetPeerNode pn) {
        long now = System.currentTimeMillis();
        LRUQueue<OpennetPeerNode> peersLRU = this.lruQueue(pn);
        OpennetManager opennetManager = this;
        synchronized (opennetManager) {
            peersLRU.remove(pn);
            if (pn.isDroppable(true) && !pn.grabWasDropped()) {
                if (logMINOR) {
                    Logger.minor(this, "onRemove() for " + pn);
                }
                if (pn.timeLastConnected(now) > 0L) {
                    this.oldPeers.push(pn);
                    while (this.oldPeers.size() > 25) {
                        this.oldPeers.pop();
                    }
                }
            }
        }
    }

    synchronized OpennetPeerNode[] getOldPeers() {
        return this.oldPeers.toArrayOrdered(new OpennetPeerNode[this.oldPeers.size()]);
    }

    synchronized OpennetPeerNode[] getUnsortedOldPeers() {
        return this.oldPeers.toArray(new OpennetPeerNode[this.oldPeers.size()]);
    }

    synchronized void addOldOpennetNode(OpennetPeerNode pn) {
        this.oldPeers.push(pn);
    }

    final String getOldPeersFilename() {
        return this.node.nodeDir().file("openpeers-old-" + this.crypto.portNumber).toString();
    }

    synchronized int countOldOpennetPeers() {
        return this.oldPeers.size();
    }

    OpennetPeerNode randomOldOpennetNode() {
        OpennetPeerNode[] nodes = this.getUnsortedOldPeers();
        if (nodes.length == 0) {
            return null;
        }
        return nodes[this.node.random.nextInt(nodes.length)];
    }

    public synchronized void purgeOldOpennetPeer(OpennetPeerNode source) {
        this.oldPeers.remove(source);
    }

    public int getNumberOfConnectedPeersToAimIncludingDarknet() {
        int max = this.node.getMaxOpennetPeers();
        int obwLimit = this.node.getOutputBandwidthLimit();
        int targetPeers = (int)Math.round(Math.min(142.0, Math.sqrt((double)obwLimit * 12.0 / 1000.0)));
        if (targetPeers < 10) {
            targetPeers = 10;
        }
        if (max > targetPeers) {
            max = targetPeers;
        }
        return max;
    }

    public int getNumberOfConnectedPeersToAim(LinkLengthClass distance) {
        if (distance == null) {
            throw new IllegalArgumentException();
        }
        int target = this.getNumberOfConnectedPeersToAim();
        return distance.getTargetPeers(target);
    }

    public int getNumberOfConnectedPeersToAim() {
        int max = this.getNumberOfConnectedPeersToAimIncludingDarknet();
        return max - this.node.peers.countConnectedDarknetPeers();
    }

    public void sendOpennetRef(boolean isReply, long uid, PeerNode peer, byte[] noderef, ByteCounter ctr) throws NotConnectedException {
        this.sendOpennetRef(isReply, uid, peer, noderef, ctr, null);
    }

    public boolean sendOpennetRef(boolean isReply, long uid, PeerNode peer, byte[] noderef, ByteCounter ctr, BulkTransmitter.AllSentCallback cb) throws NotConnectedException {
        byte[] padded = new byte[this.paddedSize(noderef.length)];
        if (noderef.length > padded.length) {
            Logger.error(this, "Noderef too big: " + noderef.length + " bytes");
            return false;
        }
        System.arraycopy(noderef, 0, padded, 0, noderef.length);
        Util.randomBytes(this.node.fastWeakRandom, padded, noderef.length, padded.length - noderef.length);
        long xferUID = this.node.random.nextLong();
        Message msg2 = isReply ? DMT.createFNPOpennetConnectReplyNew(uid, xferUID, noderef.length, padded.length) : DMT.createFNPOpennetConnectDestinationNew(uid, xferUID, noderef.length, padded.length);
        peer.sendAsync(msg2, null, ctr);
        return this.innerSendOpennetRef(xferUID, padded, peer, ctr, cb);
    }

    private boolean innerSendOpennetRef(long xferUID, byte[] padded, PeerNode peer, ByteCounter ctr, BulkTransmitter.AllSentCallback cb) throws NotConnectedException {
        ByteArrayRandomAccessBuffer raf = new ByteArrayRandomAccessBuffer(padded);
        raf.setReadOnly();
        PartiallyReceivedBulk prb = new PartiallyReceivedBulk(this.node.usm, padded.length, 1024, raf, true);
        try {
            BulkTransmitter bt = new BulkTransmitter(prb, peer, xferUID, true, ctr, true, cb);
            return bt.send();
        }
        catch (DisconnectedException e) {
            throw new NotConnectedException(e);
        }
    }

    public long startSendAnnouncementRequest(long uid, PeerNode peer, byte[] noderef, ByteCounter ctr, double target, short htl) throws NotConnectedException {
        long xferUID = this.node.random.nextLong();
        Message msg = DMT.createFNPOpennetAnnounceRequest(uid, xferUID, noderef.length, this.paddedSize(noderef.length), target, htl);
        peer.sendAsync(msg, null, ctr);
        return xferUID;
    }

    public void finishSentAnnouncementRequest(PeerNode peer, byte[] noderef, ByteCounter ctr, long xferUID) throws NotConnectedException {
        byte[] padded = new byte[this.paddedSize(noderef.length)];
        System.arraycopy(noderef, 0, padded, 0, noderef.length);
        Util.randomBytes(this.node.fastWeakRandom, padded, noderef.length, padded.length - noderef.length);
        this.innerSendOpennetRef(xferUID, padded, peer, ctr, null);
    }

    private int paddedSize(int length) {
        if (length < 3072) {
            return 3072;
        }
        Logger.normal(this, "Large noderef: " + length);
        if (length > 32768) {
            throw new IllegalArgumentException("Too big noderef: " + length + " limit is " + 32768);
        }
        return (length >>> 10) + ((length & 0x3FF) == 0 ? 0 : 1) << 10;
    }

    public void sendAnnouncementReply(long uid, PeerNode peer, byte[] noderef, ByteCounter ctr) throws NotConnectedException {
        byte[] padded = new byte[3072];
        if (noderef.length > padded.length) {
            Logger.error(this, "Noderef too big: " + noderef.length + " bytes");
            return;
        }
        System.arraycopy(noderef, 0, padded, 0, noderef.length);
        long xferUID = this.node.random.nextLong();
        Message msg = DMT.createFNPOpennetAnnounceReply(uid, xferUID, noderef.length, padded.length);
        peer.sendAsync(msg, null, ctr);
        this.innerSendOpennetRef(xferUID, padded, peer, ctr, null);
    }

    public static byte[] waitForOpennetNoderef(boolean isReply, PeerNode source, long uid, ByteCounter ctr, Node node) throws WaitedTooLongForOpennetNoderefException {
        SyncNoderefCallback cb = new SyncNoderefCallback();
        if (logMINOR) {
            Logger.minor(OpennetManager.class, "Waiting for opennet noderef on " + uid + " from " + source + " reply=" + isReply);
        }
        OpennetManager.waitForOpennetNoderef(isReply, source, uid, ctr, cb, node);
        return cb.waitForResult();
    }

    public static void waitForOpennetNoderef(final boolean isReply, final PeerNode source, final long uid, final ByteCounter ctr, final NoderefCallback callback, final Node node) {
        MessageFilter mf = MessageFilter.create().setSource(source).setField("uid", uid).setTimeout(RequestSender.OPENNET_TIMEOUT).setType(isReply ? DMT.FNPOpennetConnectReplyNew : DMT.FNPOpennetConnectDestinationNew);
        MessageFilter mfAck = MessageFilter.create().setSource(source).setField("uid", uid).setTimeout(RequestSender.OPENNET_TIMEOUT).setType(DMT.FNPOpennetCompletedAck);
        MessageFilter mfAckTimeout = MessageFilter.create().setSource(source).setField("uid", uid).setTimeout(RequestSender.OPENNET_TIMEOUT).setType(DMT.FNPOpennetCompletedTimeout);
        mf = mfAck.or(mfAckTimeout.or(mf));
        try {
            node.usm.addAsyncFilter(mf, new SlowAsyncMessageFilterCallback(){
                boolean completed;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onMatched(Message msg) {
                    if (msg.getSpec() == DMT.FNPOpennetCompletedAck || msg.getSpec() == DMT.FNPOpennetCompletedTimeout) {
                        3 var2_2 = this;
                        synchronized (var2_2) {
                            if (this.completed) {
                                return;
                            }
                            this.completed = true;
                        }
                        callback.acked(msg.getSpec() == DMT.FNPOpennetCompletedTimeout);
                    } else {
                        long xferUID = msg.getLong("transferUID");
                        int paddedLength = msg.getInt("paddedLength");
                        int realLength = msg.getInt("noderefLength");
                        this.complete(OpennetManager.innerWaitForOpennetNoderef(xferUID, paddedLength, realLength, source, isReply, uid, false, ctr, node));
                    }
                }

                @Override
                public boolean shouldTimeout() {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onTimeout() {
                    3 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.completed) {
                            return;
                        }
                        this.completed = true;
                    }
                    callback.timedOut();
                }

                @Override
                public void onDisconnect(PeerContext ctx) {
                    this.complete(null);
                }

                @Override
                public void onRestarted(PeerContext ctx) {
                    this.complete(null);
                }

                @Override
                public int getPriority() {
                    return NativeThread.NORM_PRIORITY;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void complete(byte[] buf) {
                    3 var2_2 = this;
                    synchronized (var2_2) {
                        if (this.completed) {
                            return;
                        }
                        this.completed = true;
                    }
                    callback.gotNoderef(buf);
                }
            }, ctr);
        }
        catch (DisconnectedException e) {
            callback.gotNoderef(null);
        }
    }

    static byte[] innerWaitForOpennetNoderef(long xferUID, int paddedLength, int realLength, PeerNode source, boolean isReply, long uid, boolean sendReject, ByteCounter ctr, Node node) {
        byte[] buf = new byte[paddedLength];
        ByteArrayRandomAccessBuffer raf = new ByteArrayRandomAccessBuffer(buf);
        PartiallyReceivedBulk prb = new PartiallyReceivedBulk(node.usm, buf.length, 1024, raf, false);
        BulkReceiver br = new BulkReceiver(prb, source, xferUID, ctr);
        if (logMINOR) {
            Logger.minor(OpennetManager.class, "Receiving noderef (reply=" + isReply + ") as bulk transfer for request uid " + uid + " with transfer " + xferUID + " from " + source);
        }
        if (!br.receive()) {
            if (source.isConnected()) {
                String msg = "Failed to receive noderef bulk transfer : " + RetrievalException.getErrString(prb.getAbortReason()) + " : " + prb.getAbortDescription() + " from " + source;
                if (prb.getAbortReason() != 7) {
                    Logger.warning(OpennetManager.class, msg);
                } else {
                    Logger.normal(OpennetManager.class, msg);
                }
                if (sendReject) {
                    OpennetManager.rejectRef(uid, source, 3, ctr);
                }
            }
            return null;
        }
        byte[] noderef = Arrays.copyOf(buf, realLength);
        return noderef;
    }

    public static void rejectRef(long uid, PeerNode source, int reason, ByteCounter ctr) {
        Message msg = DMT.createFNPOpennetNoderefRejected(uid, reason);
        try {
            source.sendAsync(msg, null, ctr);
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    public static SimpleFieldSet validateNoderef(byte[] noderef, int offset, int length, PeerNode from, boolean forceOpennetEnabled) {
        String identity;
        SimpleFieldSet ref;
        try {
            ref = PeerNode.compressedNoderefToFieldSet(noderef, 0, noderef.length);
        }
        catch (FSParseException e) {
            Logger.error(OpennetManager.class, "Invalid noderef: " + e, (Throwable)e);
            return null;
        }
        if (forceOpennetEnabled) {
            ref.put("opennet", true);
        }
        if (!OpennetPeerNode.validateRef(ref)) {
            Logger.error(OpennetManager.class, "Could not parse opennet noderef from " + from);
            return null;
        }
        if (ref != null && (identity = ref.get("identity")) != null) {
            OpennetManager.registerKnownIdentity(identity);
        }
        return ref;
    }

    public void announce(double target, AnnouncementCallback cb) {
        AnnounceSender sender = new AnnounceSender(target, this, this.node, cb, null);
        this.node.executor.execute(sender, "Announcement to " + target);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerKnownIdentity(String d) {
        if (logMINOR) {
            Logger.minor(OpennetManager.class, "Known Id: " + d);
        }
        long now = System.currentTimeMillis();
        TimeSortedHashtable<String> timeSortedHashtable = knownIds;
        synchronized (timeSortedHashtable) {
            if (logMINOR) {
                Logger.minor(OpennetManager.class, "Adding Id " + d + " knownIds size " + knownIds.size());
            }
            knownIds.push(d, now);
            if (logMINOR) {
                Logger.minor(OpennetManager.class, "Added Id " + d + " knownIds size " + knownIds.size());
            }
            knownIds.removeBefore(now - MAX_AGE);
            if (logMINOR) {
                Logger.minor(OpennetManager.class, "Added and pruned location " + d + " knownIds size " + knownIds.size());
            }
        }
        if (logMINOR) {
            Logger.minor(OpennetManager.class, "Estimated opennet size(session): " + knownIds.size());
        }
    }

    public int getNetworkSizeEstimate(long timestamp) {
        return knownIds.countValuesAfter(timestamp);
    }

    public int getAnnouncementThreshold() {
        return this.announcer.getAnnouncementThreshold();
    }

    public void onDisconnect(PeerNode node2) {
        if (this.announcer != null) {
            this.announcer.maybeSendAnnouncementOffThread();
        }
    }

    public void drawOpennetStatsBox(HTMLNode box) {
        HTMLNode table = box.addChild("table", "border", "0");
        HTMLNode row = table.addChild("tr");
        row.addChild("th");
        for (ConnectionType type : ConnectionType.values()) {
            row.addChild("th", type.name());
        }
        row = table.addChild("tr");
        row.addChild("td", "Connection attempts");
        for (ConnectionType type : ConnectionType.values()) {
            row.addChild("td", Long.toString(this.connectionAttempts.get((Object)type)));
        }
        row = table.addChild("tr");
        row.addChild("td", "Connections accepted");
        for (ConnectionType type : ConnectionType.values()) {
            row.addChild("td", Long.toString(this.connectionAttemptsAdded.get((Object)type)));
        }
        row = table.addChild("tr");
        row.addChild("td", "Accepted (free slots)");
        for (ConnectionType type : ConnectionType.values()) {
            row.addChild("td", Long.toString(this.connectionAttemptsAddedPlentySpace.get((Object)type)));
        }
        row = table.addChild("tr");
        row.addChild("td", "Rejected (per-type grace periods)");
        for (ConnectionType type : ConnectionType.values()) {
            row.addChild("td", Long.toString(this.connectionAttemptsRejectedByPerTypeEnforcement.get((Object)type)));
        }
        row = table.addChild("tr");
        row.addChild("td", "Rejected (no droppable peers)");
        for (ConnectionType type : ConnectionType.values()) {
            row.addChild("td", Long.toString(this.connectionAttemptsRejectedNoPeersDroppable.get((Object)type)));
        }
    }

    public boolean waitingForUpdater() {
        return this.announcer.isWaitingForUpdater();
    }

    public void reannounce() {
        this.announcer.reannounce();
    }

    public void drawSeedStatsBox(HTMLNode content) {
        this.seedTracker.drawSeedStats(content);
    }

    public void onConnectedPeer(PeerNode pn) {
        if (pn instanceof OpennetPeerNode) {
            this.dropExcessPeers(((OpennetPeerNode)pn).linkLengthClass());
        } else {
            this.dropAllExcessPeers();
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        MAX_TIME_ON_OLD_OPENNET_PEERS = TimeUnit.DAYS.toMillis(31L);
        MAX_AGE = TimeUnit.DAYS.toMillis(7L);
        knownIds = new TimeSortedHashtable();
    }

    static class WaitedTooLongForOpennetNoderefException
    extends Exception {
        WaitedTooLongForOpennetNoderefException() {
        }
    }

    private static class SyncNoderefCallback
    implements NoderefCallback {
        byte[] returned;
        boolean finished;
        boolean timedOut;

        private SyncNoderefCallback() {
        }

        @Override
        public synchronized void timedOut() {
            this.timedOut = true;
            this.finished = true;
            this.notifyAll();
        }

        @Override
        public void acked(boolean timedOutMessage) {
            this.gotNoderef(null);
        }

        @Override
        public synchronized void gotNoderef(byte[] noderef) {
            this.returned = noderef;
            this.finished = true;
            this.notifyAll();
        }

        public synchronized byte[] waitForResult() throws WaitedTooLongForOpennetNoderefException {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.timedOut) {
                throw new WaitedTooLongForOpennetNoderefException();
            }
            return this.returned;
        }
    }

    static interface NoderefCallback {
        public void gotNoderef(byte[] var1);

        public void timedOut();

        public void acked(boolean var1);
    }

    public static enum ConnectionType {
        PATH_FOLDING,
        ANNOUNCE,
        RECONNECT;

    }

    static enum LinkLengthClass {
        SHORT{

            @Override
            public int getTargetPeers(int target) {
                int longPeers = (int)((double)target * 0.3);
                return target - longPeers;
            }
        }
        ,
        LONG{

            @Override
            public int getTargetPeers(int target) {
                int longPeers = (int)((double)target * 0.3);
                return longPeers;
            }
        };


        public abstract int getTargetPeers(int var1);
    }
}

