/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.probe;

import freenet.config.InvalidConfigValueException;
import freenet.config.NodeNeedRestartException;
import freenet.config.SubConfig;
import freenet.io.comm.AsyncMessageFilterCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerContext;
import freenet.node.Location;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.probe.Counter;
import freenet.node.probe.Error;
import freenet.node.probe.Listener;
import freenet.node.probe.Type;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.BooleanCallback;
import freenet.support.api.LongCallback;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public class Probe
implements ByteCounter {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private static volatile boolean logWARNING;
    private static final String SOURCE_DISCONNECT = "Previous step in probe chain no longer connected.";
    public static final byte MAX_HTL = 70;
    public static final int MAX_SEND_ATTEMPTS = 50;
    public static final float DECREMENT_PROBABILITY = 0.2f;
    public static final long TIMEOUT_PER_HTL;
    public static final long TIMEOUT_HTL1;
    public static final long WAIT_BASE;
    public static final long WAIT_MAX;
    public final int COUNTER_MAX_PEER = 10;
    public final int COUNTER_MAX_LOCAL = 1420;
    private final Map<PeerNode, Counter> accepted;
    private final Node node;
    private final Timer timer;
    private volatile boolean respondBandwidth;
    private volatile boolean respondBuild;
    private volatile boolean respondIdentifier;
    private volatile boolean respondLinkLengths;
    private volatile boolean respondLocation;
    private volatile boolean respondStoreSize;
    private volatile boolean respondUptime;
    private volatile boolean respondRejectStats;
    private volatile boolean respondOverallBulkOutputCapacityUsage;
    private volatile long probeIdentifier;

    private final double randomNoise(double input, double sigma) {
        return this.node.nodeStats.randomNoise(input, sigma);
    }

    @Override
    public void sentBytes(int bytes) {
        this.node.nodeStats.probeRequestCtr.sentBytes(bytes);
    }

    @Override
    public void receivedBytes(int bytes) {
        this.node.nodeStats.probeRequestCtr.receivedBytes(bytes);
    }

    @Override
    public void sentPayload(int bytes) {
    }

    public Probe(final Node node) {
        this.node = node;
        this.accepted = Collections.synchronizedMap(new HashMap());
        this.timer = new Timer(true);
        int sortOrder = 0;
        SubConfig nodeConfig = node.config.get("node");
        nodeConfig.register("probeBandwidth", true, sortOrder++, true, true, "Node.probeBandwidthShort", "Node.probeBandwidthLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Probe.this.respondBandwidth;
            }

            @Override
            public void set(Boolean val) {
                Probe.this.respondBandwidth = val;
            }
        });
        this.respondBandwidth = nodeConfig.getBoolean("probeBandwidth");
        nodeConfig.register("probeBuild", true, sortOrder++, true, true, "Node.probeBuildShort", "Node.probeBuildLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Probe.this.respondBuild;
            }

            @Override
            public void set(Boolean val) {
                Probe.this.respondBuild = val;
            }
        });
        this.respondBuild = nodeConfig.getBoolean("probeBuild");
        nodeConfig.register("probeIdentifier", true, sortOrder++, true, true, "Node.probeRespondIdentifierShort", "Node.probeRespondIdentifierLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Probe.this.respondIdentifier;
            }

            @Override
            public void set(Boolean val) {
                Probe.this.respondIdentifier = val;
            }
        });
        this.respondIdentifier = nodeConfig.getBoolean("probeIdentifier");
        nodeConfig.register("probeLinkLengths", true, sortOrder++, true, true, "Node.probeLinkLengthsShort", "Node.probeLinkLengthsLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Probe.this.respondLinkLengths;
            }

            @Override
            public void set(Boolean val) {
                Probe.this.respondLinkLengths = val;
            }
        });
        this.respondLinkLengths = nodeConfig.getBoolean("probeLinkLengths");
        nodeConfig.register("probeLocation", true, sortOrder++, true, true, "Node.probeLocationShort", "Node.probeLocationLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Probe.this.respondLocation;
            }

            @Override
            public void set(Boolean val) {
                Probe.this.respondLocation = val;
            }
        });
        this.respondLocation = nodeConfig.getBoolean("probeLocation");
        nodeConfig.register("probeStoreSize", true, sortOrder++, true, true, "Node.probeStoreSizeShort", "Node.probeStoreSizeLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Probe.this.respondStoreSize;
            }

            @Override
            public void set(Boolean val) {
                Probe.this.respondStoreSize = val;
            }
        });
        this.respondStoreSize = nodeConfig.getBoolean("probeStoreSize");
        nodeConfig.register("probeUptime", true, sortOrder++, true, true, "Node.probeUptimeShort", "Node.probeUptimeLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Probe.this.respondUptime;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                Probe.this.respondUptime = val;
            }
        });
        this.respondUptime = nodeConfig.getBoolean("probeUptime");
        nodeConfig.register("probeRejectStats", true, sortOrder++, true, true, "Node.probeRejectStatsShort", "Node.probeRejectStatsLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Probe.this.respondRejectStats;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                Probe.this.respondRejectStats = val;
            }
        });
        this.respondRejectStats = nodeConfig.getBoolean("probeRejectStats");
        nodeConfig.register("probeOverallBulkOutputCapacityUsage", true, sortOrder++, true, true, "Node.respondOverallBulkOutputCapacityUsage", "Node.respondOverallBulkOutputCapacityUsageLong", new BooleanCallback(){

            @Override
            public Boolean get() {
                return Probe.this.respondOverallBulkOutputCapacityUsage;
            }

            @Override
            public void set(Boolean val) throws InvalidConfigValueException, NodeNeedRestartException {
                Probe.this.respondOverallBulkOutputCapacityUsage = val;
            }
        });
        this.respondOverallBulkOutputCapacityUsage = nodeConfig.getBoolean("probeOverallBulkOutputCapacityUsage");
        nodeConfig.register("identifier", -1L, sortOrder++, true, true, "Node.probeIdentifierShort", "Node.probeIdentifierLong", new LongCallback(){

            @Override
            public Long get() {
                return Probe.this.probeIdentifier;
            }

            @Override
            public void set(Long val) {
                Probe.this.probeIdentifier = val;
                while (Probe.this.probeIdentifier == -1L) {
                    Probe.this.probeIdentifier = node.random.nextLong();
                }
            }
        }, false);
        this.probeIdentifier = nodeConfig.getLong("identifier");
        try {
            if (this.probeIdentifier == -1L) {
                nodeConfig.getOption("identifier").setValue("-1");
                node.config.store();
            }
        }
        catch (InvalidConfigValueException e) {
            Logger.error(Probe.class, "node.identifier set() unexpectedly threw.", (Throwable)e);
        }
        catch (NodeNeedRestartException e) {
            Logger.error(Probe.class, "node.identifier set() unexpectedly threw.", (Throwable)e);
        }
    }

    public void start(byte htl, long uid, Type type, Listener listener) {
        this.request(DMT.createProbeRequest(htl, uid, type), null, listener);
    }

    public void request(Message message, PeerNode source) {
        this.request(message, source, new ResultRelay(source, message.getLong("uid")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void request(Message message, final PeerNode source, final Listener listener) {
        Type type;
        Long uid = message.getLong("uid");
        byte typeCode = message.getByte("type");
        if (Type.isValid(typeCode)) {
            type = Type.valueOf(typeCode);
            if (logDEBUG) {
                Logger.debug(Probe.class, "Probe type is " + type.name() + ".");
            }
        } else {
            if (logMINOR) {
                Logger.minor(Probe.class, "Invalid probe type " + typeCode + ".");
            }
            listener.onError(Error.UNRECOGNIZED_TYPE, typeCode, true);
            return;
        }
        byte htl = message.getByte("hopsToLive");
        if (htl < 1) {
            if (logWARNING) {
                Logger.warning(Probe.class, "Received out-of-bounds HTL of " + htl + " from " + source.getIdentityString() + " (" + source.userToString() + "); discarding.");
            }
            return;
        }
        if (htl > 70) {
            if (logMINOR) {
                Logger.minor(Probe.class, "Received out-of-bounds HTL of " + htl + " from " + source.getIdentityString() + " (" + source.userToString() + "); interpreting as " + 70 + ".");
            }
            htl = 70;
        }
        boolean availableSlot = true;
        TimerTask task = null;
        Map<PeerNode, Counter> map = this.accepted;
        synchronized (map) {
            Counter counter;
            if (!this.accepted.containsKey(source)) {
                this.accepted.put(source, new Counter(source == null ? 1420 : 10));
            }
            if ((counter = this.accepted.get(source)).value() == counter.maxAccepted) {
                availableSlot = false;
            } else {
                counter.increment();
                task = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Map map = Probe.this.accepted;
                        synchronized (map) {
                            counter.decrement();
                            if (counter.value() == 0) {
                                Probe.this.accepted.remove(source);
                            }
                        }
                    }
                };
            }
        }
        if (!availableSlot) {
            if (logDEBUG) {
                Logger.debug(Probe.class, "Already accepted maximum number of probes; rejecting incoming.");
            }
            listener.onError(Error.OVERLOAD, null, true);
            return;
        }
        this.timer.schedule(task, TimeUnit.MINUTES.toMillis(1L));
        htl = this.probabilisticDecrement(htl);
        if (htl == 0 || !this.route(type, uid, htl, listener)) {
            long wait = WAIT_MAX;
            while (wait >= WAIT_MAX) {
                wait = (long)(-Math.log(this.node.random.nextDouble()) * (double)WAIT_BASE / Math.E);
            }
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Probe.this.respond(type, listener);
                }
            }, wait);
        }
    }

    private boolean route(Type type, long uid, byte htl, Listener listener) {
        Message message = DMT.createProbeRequest(htl, uid, type);
        for (int sendAttempts = 0; sendAttempts < 50; ++sendAttempts) {
            PeerNode[] peers = this.node.getConnectedPeers();
            int degree = peers.length;
            if (degree == 0) {
                if (logMINOR) {
                    Logger.minor(Probe.class, "Aborting probe request: no connections.");
                }
                listener.onError(Error.DISCONNECTED, null, true);
                return true;
            }
            PeerNode candidate = peers[this.node.random.nextInt(degree)];
            if (candidate.isConnected()) {
                int candidateDegree = candidate.getDegree();
                float acceptProbability = candidateDegree == 0 ? 1.0f : (float)degree / (float)candidateDegree;
                if (logDEBUG) {
                    Logger.debug(Probe.class, "acceptProbability is " + acceptProbability);
                }
                if (this.node.random.nextFloat() < acceptProbability) {
                    if (logDEBUG) {
                        Logger.debug(Probe.class, "Accepted candidate.");
                    }
                    MessageFilter filter = Probe.createResponseFilter(type, candidate, uid, htl);
                    message.set("hopsToLive", htl);
                    try {
                        this.node.getUSM().addAsyncFilter(filter, new ResultListener(listener), this);
                        if (logDEBUG) {
                            Logger.debug(Probe.class, "Sending.");
                        }
                        candidate.sendAsync(message, null, this);
                        return true;
                    }
                    catch (NotConnectedException e) {
                        if (!logMINOR) continue;
                        Logger.minor(Probe.class, "Peer became disconnected between check and send attempt.", (Throwable)e);
                        continue;
                    }
                    catch (DisconnectedException e) {
                        if (!logMINOR) continue;
                        Logger.minor(Probe.class, "Peer became disconnected while attempting to add filter.", (Throwable)e);
                        continue;
                    }
                }
                if ((htl = this.probabilisticDecrement(htl)) != 0) continue;
                return false;
            }
            if (!logMINOR) continue;
            Logger.minor(Probe.class, "Peer in connectedPeers was not connected.", (Throwable)new Exception());
        }
        if (logWARNING) {
            Logger.warning(Probe.class, "Aborting probe request: send attempt limit reached.");
        }
        listener.onError(Error.CANNOT_FORWARD, null, true);
        return true;
    }

    private static MessageFilter createResponseFilter(Type type, PeerNode candidate, long uid, byte htl) {
        long timeout = (long)(htl - 1) * TIMEOUT_PER_HTL + TIMEOUT_HTL1;
        MessageFilter filter = Probe.createFilter(candidate, uid, timeout);
        switch (type) {
            case BANDWIDTH: {
                filter.setType(DMT.ProbeBandwidth);
                break;
            }
            case BUILD: {
                filter.setType(DMT.ProbeBuild);
                break;
            }
            case IDENTIFIER: {
                filter.setType(DMT.ProbeIdentifier);
                break;
            }
            case LINK_LENGTHS: {
                filter.setType(DMT.ProbeLinkLengths);
                break;
            }
            case LOCATION: {
                filter.setType(DMT.ProbeLocation);
                break;
            }
            case STORE_SIZE: {
                filter.setType(DMT.ProbeStoreSize);
                break;
            }
            case UPTIME_48H: 
            case UPTIME_7D: {
                filter.setType(DMT.ProbeUptime);
                break;
            }
            case REJECT_STATS: {
                filter.setType(DMT.ProbeRejectStats);
                break;
            }
            case OVERALL_BULK_OUTPUT_CAPACITY_USAGE: {
                filter.setType(DMT.ProbeOverallBulkOutputCapacityUsage);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Missing filter for " + type.name());
            }
        }
        filter.or(Probe.createFilter(candidate, uid, timeout).setType(DMT.ProbeRefused).or(Probe.createFilter(candidate, uid, timeout).setType(DMT.ProbeError)));
        return filter;
    }

    private static MessageFilter createFilter(PeerNode source, long uid, long timeout) {
        return MessageFilter.create().setSource(source).setField("uid", uid).setTimeout(timeout);
    }

    private void respond(Type type, Listener listener) {
        if (!this.respondTo(type)) {
            listener.onRefused();
            return;
        }
        switch (type) {
            case BANDWIDTH: {
                listener.onOutputBandwidth((float)this.randomNoise((double)this.node.getOutputBandwidthLimit() / 1024.0, 0.05));
                break;
            }
            case BUILD: {
                listener.onBuild(this.node.nodeUpdater.getMainVersion());
                break;
            }
            case IDENTIFIER: {
                long percent = Math.round(this.randomNoise(100.0 * this.node.uptime.getUptimeWeek(), 0.05));
                if (percent > 127L) {
                    percent = 127L;
                } else if (percent < -128L) {
                    percent = -128L;
                }
                listener.onIdentifier(this.probeIdentifier, (byte)percent);
                break;
            }
            case LINK_LENGTHS: {
                PeerNode[] peers = this.node.getConnectedPeers();
                float[] linkLengths = new float[peers.length];
                int i = 0;
                double myLoc = this.node.getLocation();
                for (PeerNode peer : peers) {
                    double peerLoc = peer.getLocation();
                    if (!Location.isValid(peerLoc)) continue;
                    linkLengths[i++] = (float)this.randomNoise(Location.distance(myLoc, peerLoc), 0.01);
                }
                linkLengths = Arrays.copyOf(linkLengths, i);
                Arrays.sort(linkLengths);
                listener.onLinkLengths(linkLengths);
                break;
            }
            case LOCATION: {
                listener.onLocation((float)this.node.getLocation());
                break;
            }
            case STORE_SIZE: {
                listener.onStoreSize((float)this.randomNoise((double)this.node.getStoreSize() / 1.073741824E9, 0.05));
                break;
            }
            case UPTIME_48H: {
                listener.onUptime((float)this.randomNoise(100.0 * this.node.uptime.getUptime(), 0.04));
                break;
            }
            case UPTIME_7D: {
                listener.onUptime((float)this.randomNoise(100.0 * this.node.uptime.getUptimeWeek(), 0.03));
                break;
            }
            case REJECT_STATS: {
                byte[] stats = this.node.nodeStats.getNoisyRejectStats();
                listener.onRejectStats(stats);
                break;
            }
            case OVERALL_BULK_OUTPUT_CAPACITY_USAGE: {
                byte bandwidthClass = DMT.bandwidthClassForCapacityUsage(this.node.getOutputBandwidthLimit());
                listener.onOverallBulkOutputCapacity(bandwidthClass, (float)this.randomNoise(this.node.nodeStats.getBandwidthLiabilityUsage(), 0.1));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Missing response for " + type.name());
            }
        }
    }

    private boolean respondTo(Type type) {
        switch (type) {
            case BANDWIDTH: {
                return this.respondBandwidth;
            }
            case BUILD: {
                return this.respondBuild;
            }
            case IDENTIFIER: {
                return this.respondIdentifier;
            }
            case LINK_LENGTHS: {
                return this.respondLinkLengths;
            }
            case LOCATION: {
                return this.respondLocation;
            }
            case STORE_SIZE: {
                return this.respondStoreSize;
            }
            case UPTIME_48H: 
            case UPTIME_7D: {
                return this.respondUptime;
            }
            case REJECT_STATS: {
                return this.respondRejectStats;
            }
            case OVERALL_BULK_OUTPUT_CAPACITY_USAGE: {
                return this.respondOverallBulkOutputCapacityUsage;
            }
        }
        throw new UnsupportedOperationException("Missing permissions check for " + type.name());
    }

    private byte probabilisticDecrement(byte htl) {
        assert (htl > 0);
        if (htl == 1) {
            if (this.node.random.nextFloat() < 0.2f) {
                return 0;
            }
            return 1;
        }
        return (byte)(htl - 1);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logWARNING = Logger.shouldLog(Logger.LogLevel.WARNING, (Object)this);
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        TIMEOUT_PER_HTL = TimeUnit.SECONDS.toMillis(3L);
        TIMEOUT_HTL1 = (long)((float)TIMEOUT_PER_HTL / 0.2f);
        WAIT_BASE = TimeUnit.SECONDS.toMillis(1L);
        WAIT_MAX = TimeUnit.SECONDS.toMillis(2L);
    }

    private class ResultRelay
    implements Listener {
        private final PeerNode source;
        private final Long uid;

        public ResultRelay(PeerNode source, Long uid) {
            this.source = source;
            this.uid = uid;
        }

        private void send(Message message) {
            block5: {
                if (!this.source.isConnected()) {
                    if (logDEBUG) {
                        Logger.debug(Probe.class, Probe.SOURCE_DISCONNECT);
                    }
                    return;
                }
                if (logDEBUG) {
                    Logger.debug(Probe.class, "Relaying " + message.getSpec().getName() + " back to " + this.source.userToString());
                }
                try {
                    this.source.sendAsync(message, null, Probe.this);
                }
                catch (NotConnectedException e) {
                    if (!logDEBUG) break block5;
                    Logger.debug(Probe.class, Probe.SOURCE_DISCONNECT, (Throwable)e);
                }
            }
        }

        @Override
        public void onError(Error error, Byte code, boolean local) {
            this.send(DMT.createProbeError(this.uid, error));
        }

        @Override
        public void onRefused() {
            this.send(DMT.createProbeRefused(this.uid));
        }

        @Override
        public void onOutputBandwidth(float outputBandwidth) {
            this.send(DMT.createProbeBandwidth(this.uid, outputBandwidth));
        }

        @Override
        public void onBuild(int build) {
            this.send(DMT.createProbeBuild(this.uid, build));
        }

        @Override
        public void onIdentifier(long identifier, byte uptimePercentage) {
            this.send(DMT.createProbeIdentifier(this.uid, identifier, uptimePercentage));
        }

        @Override
        public void onLinkLengths(float[] linkLengths) {
            this.send(DMT.createProbeLinkLengths(this.uid, linkLengths));
        }

        @Override
        public void onLocation(float location) {
            this.send(DMT.createProbeLocation(this.uid, location));
        }

        @Override
        public void onStoreSize(float storeSize) {
            this.send(DMT.createProbeStoreSize(this.uid, storeSize));
        }

        @Override
        public void onUptime(float uptimePercentage) {
            this.send(DMT.createProbeUptime(this.uid, uptimePercentage));
        }

        @Override
        public void onRejectStats(byte[] stats) {
            if (stats.length < 4) {
                Logger.warning(this, "Unknown length for stats: " + stats.length);
                this.onError(Error.UNKNOWN, Error.UNKNOWN.code, true);
            } else {
                if (stats.length > 4) {
                    stats = Arrays.copyOf(stats, 4);
                }
                this.send(DMT.createProbeRejectStats(this.uid, stats));
            }
        }

        @Override
        public void onOverallBulkOutputCapacity(byte bandwidthClassForCapacityUsage, float capacityUsage) {
            this.send(DMT.createProbeOverallBulkOutputCapacityUsage(this.uid, bandwidthClassForCapacityUsage, capacityUsage));
        }
    }

    private class ResultListener
    implements AsyncMessageFilterCallback {
        private final Listener listener;

        public ResultListener(Listener listener) {
            this.listener = listener;
        }

        @Override
        public void onDisconnect(PeerContext context) {
            if (logDEBUG) {
                Logger.debug(Probe.class, "Next node in chain disconnected.");
            }
            this.listener.onError(Error.DISCONNECTED, null, true);
        }

        @Override
        public void onMatched(Message message) {
            if (logDEBUG) {
                Logger.debug(Probe.class, "Matched " + message.getSpec().getName());
            }
            if (message.getSpec().equals(DMT.ProbeBandwidth)) {
                this.listener.onOutputBandwidth(message.getFloat("outputBandwidthUpperLimit"));
            } else if (message.getSpec().equals(DMT.ProbeBuild)) {
                this.listener.onBuild(message.getInt("build"));
            } else if (message.getSpec().equals(DMT.ProbeIdentifier)) {
                this.listener.onIdentifier(message.getLong("probeIdentifier"), message.getByte("uptimePercent"));
            } else if (message.getSpec().equals(DMT.ProbeLinkLengths)) {
                this.listener.onLinkLengths(message.getFloatArray("linkLengths"));
            } else if (message.getSpec().equals(DMT.ProbeLocation)) {
                this.listener.onLocation(message.getFloat("location"));
            } else if (message.getSpec().equals(DMT.ProbeStoreSize)) {
                this.listener.onStoreSize(message.getFloat("storeSize"));
            } else if (message.getSpec().equals(DMT.ProbeUptime)) {
                this.listener.onUptime(message.getFloat("uptimePercent"));
            } else if (message.getSpec().equals(DMT.ProbeRejectStats)) {
                this.listener.onRejectStats(message.getShortBufferBytes("rejectStats"));
            } else if (message.getSpec().equals(DMT.ProbeOverallBulkOutputCapacityUsage)) {
                this.listener.onOverallBulkOutputCapacity(message.getByte("outputBandwidthClass"), message.getFloat("capacityUsage"));
            } else if (message.getSpec().equals(DMT.ProbeError)) {
                byte rawError = message.getByte("type");
                if (Error.isValid(rawError)) {
                    this.listener.onError(Error.valueOf(rawError), null, false);
                } else {
                    this.listener.onError(Error.UNKNOWN, rawError, false);
                }
            } else if (message.getSpec().equals(DMT.ProbeRefused)) {
                this.listener.onRefused();
            } else {
                throw new UnsupportedOperationException("Missing handling for " + message.getSpec().getName());
            }
        }

        @Override
        public void onRestarted(PeerContext context) {
        }

        @Override
        public void onTimeout() {
            if (logDEBUG) {
                Logger.debug(Probe.class, "Timed out.");
            }
            this.listener.onError(Error.TIMEOUT, null, true);
        }

        @Override
        public boolean shouldTimeout() {
            return false;
        }
    }
}

