/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.ContentDataFilter;
import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.client.filter.OggBitstreamFilter;
import freenet.client.filter.OggPage;
import freenet.l10n.NodeL10n;
import freenet.support.io.Closer;
import freenet.support.io.CountedOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;

public class OggFilter
implements ContentDataFilter {
    @Override
    public void readFilter(InputStream input, OutputStream output, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        HashMap<Integer, OggBitstreamFilter> streamFilters = new HashMap<Integer, OggBitstreamFilter>();
        LinkedList<OggPage> splitPages = new LinkedList<OggPage>();
        CountedOutputStream out = new CountedOutputStream(output);
        DataInputStream in = new DataInputStream(new BufferedInputStream(input, 255));
        OggPage page = null;
        OggPage nextPage = OggPage.readPage(in);
        boolean running = true;
        while (running) {
            page = nextPage;
            try {
                nextPage = OggPage.readPage(in);
            }
            catch (EOFException e) {
                nextPage = null;
                running = false;
            }
            OggBitstreamFilter filter = null;
            if (streamFilters.containsKey(page.getSerial())) {
                filter = (OggBitstreamFilter)streamFilters.get(page.getSerial());
            } else {
                filter = OggBitstreamFilter.getBitstreamFilter(page);
                streamFilters.put(page.getSerial(), filter);
            }
            if (filter == null) continue;
            if ((page = filter.parse(page)) != null && page.headerValid() && !this.hasValidSubpage(page, nextPage)) {
                splitPages.add(page);
                if (nextPage != null && nextPage.isPacketContinued()) continue;
                while (!splitPages.isEmpty()) {
                    OggPage part = (OggPage)splitPages.remove();
                    out.write(part.toArray());
                }
                continue;
            }
            if (splitPages.isEmpty()) continue;
            splitPages.clear();
        }
        out.flush();
        if (out.written() == 0L) {
            throw new DataFilterException(OggFilter.l10n("EmptyOutputTitle"), OggFilter.l10n("EmptyOutputTitle"), OggFilter.l10n("EmptyOutputDescription"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasValidSubpage(OggPage page, OggPage nextPage) throws IOException {
        OggPage subpage = null;
        int pageCount = 0;
        ByteArrayOutputStream data = null;
        FilterInputStream in = null;
        try {
            try {
                data = new ByteArrayOutputStream();
                data.write(page.toArray());
                if (nextPage != null) {
                    data.write(nextPage.toArray());
                }
                in = new DataInputStream(new ByteArrayInputStream(data.toByteArray()));
                data.close();
                while (true) {
                    OggPage.seekToPage((DataInputStream)in);
                    in.mark(65307);
                    subpage = new OggPage((DataInputStream)in);
                    if (subpage.headerValid()) {
                        ++pageCount;
                    }
                    in.reset();
                    in.skip(1L);
                }
            }
            catch (EOFException e) {
                in.close();
                Closer.close(data);
                Closer.close(in);
            }
        }
        catch (Throwable throwable) {
            Closer.close(data);
            Closer.close(in);
            throw throwable;
        }
        return pageCount > 2 || this.hasValidSubpage(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasValidSubpage(OggPage page) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(page.toArray()));
        in.skip(1L);
        try {
            while (true) {
                OggPage subpage;
                if ((subpage = OggPage.readPage(in)).headerValid()) {
                    boolean bl = true;
                    return bl;
                }
                continue;
                break;
            }
        }
        catch (EOFException e) {
            in.close();
            return false;
        }
        finally {
            Closer.close(in);
        }
    }

    public void writeFilter(InputStream input, OutputStream output, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("OggFilter." + key);
    }
}

