/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CodecPacket;
import freenet.client.filter.CodecPacketFilter;
import freenet.support.Logger;
import freenet.support.io.Closer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TheoraPacketFilter
implements CodecPacketFilter {
    static final byte[] magicNumber = new byte[]{116, 104, 101, 111, 114, 97};
    State currentState = State.UNINITIALIZED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CodecPacket parse(CodecPacket packet) throws IOException {
        boolean logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(packet.payload));
        byte[] magicHeader = null;
        try {
            switch (this.currentState) {
                case UNINITIALIZED: {
                    magicHeader = new byte[1 + magicNumber.length];
                    input.readFully(magicHeader);
                    if (logMINOR) {
                        Logger.minor(this, "Header type: " + magicHeader[0]);
                    }
                    if (magicHeader[0] != -128) {
                        return null;
                    }
                    for (int i = 0; i < magicNumber.length; ++i) {
                        if (magicHeader[i + 1] == magicNumber[i]) continue;
                        return null;
                    }
                    int VMAJ = input.readUnsignedByte();
                    int VMIN = input.readUnsignedByte();
                    int VREV = input.readUnsignedByte();
                    short FMBW = input.readShort();
                    short FMBH = input.readShort();
                    int PICW = input.readShort() << 8 | input.readUnsignedByte();
                    int PICH = input.readShort() << 8 | input.readUnsignedByte();
                    int PICX = input.readUnsignedByte();
                    int PICY = input.readUnsignedByte();
                    long FRN = input.readInt();
                    long FRD = input.readInt();
                    int PARN = input.readShort() << 8 | input.readUnsignedByte();
                    int PARD = input.readShort() << 8 | input.readUnsignedByte();
                    byte CS = input.readByte();
                    int NOMBR = input.readShort() << 8 | input.readUnsignedByte();
                    short unalignedBytes = input.readShort();
                    byte QUAL = (byte)(unalignedBytes & 0x3F);
                    byte KFGSHIFT = (byte)(unalignedBytes & 0x3C0);
                    byte PF = (byte)(unalignedBytes & 0x1800);
                    byte Res = (byte)(unalignedBytes & 0xE000);
                    if (VMAJ != 3) {
                        return null;
                    }
                    if (VMIN != 2) {
                        return null;
                    }
                    if (VREV > 1) {
                        return null;
                    }
                    if (FMBW == 0) {
                        return null;
                    }
                    if (FMBH == 0) {
                        return null;
                    }
                    if (PICW > FMBW * 16) {
                        return null;
                    }
                    if (PICH > FMBH * 16) {
                        return null;
                    }
                    if (PICX > FMBW * 16 - PICX) {
                        return null;
                    }
                    if (PICY > FMBH * 16 - PICY) {
                        return null;
                    }
                    if (FRN == 0L) {
                        return null;
                    }
                    if (FRD == 0L) {
                        return null;
                    }
                    if (CS != 1 && CS != 2) {
                        return null;
                    }
                    if (PF == 1) {
                        return null;
                    }
                    if (Res != 0) {
                        return null;
                    }
                    this.currentState = State.IDENTIFICATION_FOUND;
                    break;
                }
                case IDENTIFICATION_FOUND: {
                    magicHeader = new byte[1 + magicNumber.length];
                    input.readFully(magicHeader);
                    Logger.minor(this, "Header type: " + magicHeader[0]);
                    if (magicHeader[0] != -127) {
                        return null;
                    }
                    for (int i = 0; i < magicNumber.length; ++i) {
                        if (magicHeader[i + 1] == magicNumber[i]) continue;
                        return null;
                    }
                    long vendor_length = this.decode32bitIntegerFrom8BitChunks(input);
                    if (logMINOR) {
                        Logger.minor(this, "Vendor string is " + vendor_length + " bytes long");
                    }
                    for (long i = 0L; i < vendor_length; ++i) {
                        input.skipBytes(1);
                    }
                    long NCOMMENTS = this.decode32bitIntegerFrom8BitChunks(input);
                    for (long i = 0L; i < NCOMMENTS; ++i) {
                        long comment_length = this.decode32bitIntegerFrom8BitChunks(input);
                        for (long j = 0L; j < comment_length; ++j) {
                            input.skipBytes(1);
                        }
                    }
                    DataOutputStream output = null;
                    try {
                        ByteArrayOutputStream data = new ByteArrayOutputStream();
                        output = new DataOutputStream(data);
                        output.write(magicHeader);
                        output.writeInt(0);
                        output.writeInt(0);
                        packet = new CodecPacket(data.toByteArray());
                        output.close();
                    }
                    catch (Throwable throwable) {
                        Closer.close(output);
                        throw throwable;
                    }
                    Closer.close(output);
                    this.currentState = State.COMMENT_FOUND;
                    break;
                }
            }
        }
        catch (IOException e) {
            if (logMINOR) {
                Logger.minor(this, "In theora parser caught " + e, (Throwable)e);
            }
            throw e;
        }
        return packet;
    }

    private long decode32bitIntegerFrom8BitChunks(DataInputStream input) throws IOException {
        int LEN0 = input.readUnsignedByte();
        int LEN1 = input.readUnsignedByte();
        int LEN2 = input.readUnsignedByte();
        int LEN3 = input.readUnsignedByte();
        int LEN = LEN0 | LEN1 << 8 | LEN2 << 16 | LEN3 << 24;
        return LEN;
    }

    static enum State {
        UNINITIALIZED,
        IDENTIFICATION_FOUND,
        COMMENT_FOUND;

    }
}

