/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.ClientMetadata;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertBlock;
import freenet.client.InsertException;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.bookmark.BookmarkCategory;
import freenet.clients.http.bookmark.BookmarkItem;
import freenet.clients.http.bookmark.BookmarkManager;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.DarknetPeerNode;
import freenet.node.Node;
import freenet.node.NodeStarter;
import freenet.node.Version;
import freenet.node.useralerts.UserAlert;
import freenet.support.HTMLNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.URLDecoder;
import freenet.support.api.HTTPRequest;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import freenet.support.io.LineReadingInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import org.tanukisoftware.wrapper.WrapperManager;

public class WelcomeToadlet
extends Toadlet {
    public static final String BOOKMARKS_ANCHOR = "bookmarks";
    final Node node;
    private static volatile boolean logMINOR;
    public static final String PATH = "/";

    WelcomeToadlet(HighLevelSimpleClient client, Node node) {
        super(client);
        this.node = node;
    }

    void redirectToRoot(ToadletContext ctx) throws ToadletContextClosedException, IOException {
        MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
        headers.put("Location", PATH);
        ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
    }

    private void addCategoryToList(BookmarkCategory cat, HTMLNode list, boolean noActiveLinks, ToadletContext ctx) {
        int i;
        List<BookmarkItem> items;
        if (ctx.getPageMaker().getTheme().forceActivelinks) {
            noActiveLinks = false;
        }
        if ((items = cat.getItems()).size() > 0) {
            HTMLNode table = list.addChild("li").addChild("table", new String[]{"border", "style"}, new String[]{"0", "border: none"});
            for (i = 0; i < items.size(); ++i) {
                BookmarkItem item = items.get(i);
                HTMLNode row = table.addChild("tr");
                HTMLNode cell = row.addChild("td", "style", "border: none;");
                if (item.hasAnActivelink() && !noActiveLinks) {
                    String initialKey = item.getKey();
                    String key = '/' + initialKey + (initialKey.endsWith(PATH) ? "" : PATH) + "activelink.png";
                    cell.addChild("div", "style", "height: 36px; width: 108px;").addChild("a", "href", '/' + item.getKey()).addChild("img", new String[]{"src", "alt", "style", "title"}, new String[]{key, "activelink", "height: 36px; width: 108px", item.getDescription()});
                } else {
                    cell.addChild("#", " ");
                }
                cell = row.addChild("td", "style", "border: none");
                boolean updated = item.hasUpdated();
                String linkClass = updated ? "bookmark-title-updated" : "bookmark-title";
                cell.addChild("a", new String[]{"href", "title", "class"}, new String[]{'/' + item.getKey(), item.getDescription(), linkClass}, item.getVisibleName());
                String explain = item.getShortDescription();
                if (explain != null && explain.length() > 0) {
                    cell.addChild("#", " (");
                    cell.addChild("#", explain);
                    cell.addChild("#", ")");
                }
                if (!updated) continue;
                cell = row.addChild("td", "style", "border: none");
                cell.addChild(this.node.clientCore.alerts.renderDismissButton(item.getUserAlert(), this.path() + "#" + BOOKMARKS_ANCHOR));
            }
        }
        List<BookmarkCategory> cats = cat.getSubCategories();
        for (i = 0; i < cats.size(); ++i) {
            list.addChild("li", "class", "cat", cats.get(i).getVisibleName());
            this.addCategoryToList(cats.get(i), list.addChild("li").addChild("ul"), noActiveLinks, ctx);
        }
    }

    @Override
    public boolean allowPOSTWithoutPassword() {
        return true;
    }

    public boolean showSearchBox() {
        return this.node.pluginManager != null && this.node.pluginManager.isPluginLoaded("plugins.Library.Main");
    }

    public boolean showSearchBoxLoading() {
        return this.node.pluginManager == null || !this.node.pluginManager.isPluginLoaded("plugins.Library.Main") && this.node.pluginManager.isPluginLoadedOrLoadingOrWantLoad("Library");
    }

    public void addSearchBox(HTMLNode contentNode) {
        HTMLNode searchBox = contentNode.addChild("div", "class", "infobox infobox-normal");
        searchBox.addAttribute("id", "search-freenet");
        searchBox.addChild("div", "class", "infobox-header").addChild("span", "class", "search-title-label", NodeL10n.getBase().getString("WelcomeToadlet.searchBoxLabel"));
        HTMLNode searchBoxContent = searchBox.addChild("div", "class", "infobox-content");
        if (this.showSearchBox()) {
            searchBoxContent.addChild("span", "class", "search-warning-text", WelcomeToadlet.l10n("searchBoxWarningSlow"));
            HTMLNode searchForm = this.container.addFormChild(searchBoxContent, "/library/", "searchform");
            searchForm.addChild("input", new String[]{"type", "size", "name"}, new String[]{"text", "80", "search"});
            searchForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "find", WelcomeToadlet.l10n("searchFreenet")});
            searchForm.addAttribute("target", "_blank");
        } else if (this.showSearchBoxLoading()) {
            HTMLNode textSpan = searchBoxContent.addChild("span", "class", "search-not-availible-warning");
            NodeL10n.getBase().addL10nSubstitution(textSpan, "WelcomeToadlet.searchPluginLoading", new String[]{"link"}, new HTMLNode[]{HTMLNode.link("/plugins/")});
        } else {
            HTMLNode textSpan = searchBoxContent.addChild("span", "class", "search-not-availible-warning");
            NodeL10n.getBase().addL10nSubstitution(textSpan, "WelcomeToadlet.searchPluginNotLoaded", new String[]{"link"}, new HTMLNode[]{HTMLNode.link("/plugins/")});
        }
    }

    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        if (request.getPartAsStringFailsafe("updateconfirm", 32).length() > 0) {
            if (!ctx.checkFormPassword(request)) {
                return;
            }
            PageNode page = ctx.getPageMaker().getPageNode(WelcomeToadlet.l10n("updatingTitle"), ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode content = ctx.getPageMaker().getInfobox("infobox-information", WelcomeToadlet.l10n("updatingTitle"), contentNode, null, true);
            content.addChild("p").addChild("#", WelcomeToadlet.l10n("updating"));
            content.addChild("p").addChild("#", WelcomeToadlet.l10n("thanks"));
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
            Logger.normal(this, "Node is updating/restarting");
            this.node.getNodeUpdater().arm();
        } else if (request.getPartAsStringFailsafe("update", 32).length() > 0) {
            PageNode page = ctx.getPageMaker().getPageNode(WelcomeToadlet.l10n("nodeUpdateConfirmTitle"), ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            HTMLNode content = ctx.getPageMaker().getInfobox("infobox-query", WelcomeToadlet.l10n("nodeUpdateConfirmTitle"), contentNode, "update-node-confirm", true);
            content.addChild("p").addChild("#", WelcomeToadlet.l10n("nodeUpdateConfirm"));
            HTMLNode updateForm = ctx.addFormChild(content, PATH, "updateConfirmForm");
            updateForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", NodeL10n.getBase().getString("Toadlet.cancel")});
            updateForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "updateconfirm", WelcomeToadlet.l10n("update")});
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
        } else if (request.isPartSet("getThreadDump")) {
            if (!ctx.checkFormPassword(request)) {
                return;
            }
            PageNode page = ctx.getPageMaker().getPageNode(WelcomeToadlet.l10n("threadDumpTitle"), ctx);
            HTMLNode pageNode = page.outer;
            HTMLNode contentNode = page.content;
            if (this.node.isUsingWrapper()) {
                ctx.getPageMaker().getInfobox("#", WelcomeToadlet.l10n("threadDumpSubTitle"), contentNode, "thread-dump-generation", true).addChild("#", WelcomeToadlet.l10n("threadDumpWithFilename", "filename", WrapperManager.getProperties().getProperty("wrapper.logfile")));
                System.out.println("Thread Dump:");
                WrapperManager.requestThreadDump();
            } else {
                ctx.getPageMaker().getInfobox("infobox-error", WelcomeToadlet.l10n("threadDumpSubTitle"), contentNode, "thread-dump-generation", true).addChild("#", WelcomeToadlet.l10n("threadDumpNotUsingWrapper"));
            }
            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
        } else {
            if (request.isPartSet("disable")) {
                UserAlert[] alerts;
                if (!ctx.checkFormPassword(request)) {
                    return;
                }
                int validAlertsRemaining = 0;
                for (UserAlert alert : alerts = ctx.getAlertManager().getAlerts()) {
                    if (request.getIntPart("disable", -1) == alert.hashCode()) {
                        if (alert.userCanDismiss() && alert.shouldUnregisterOnDismiss()) {
                            alert.onDismiss();
                            Logger.normal(this, "Unregistering the userAlert " + alert.hashCode());
                            ctx.getAlertManager().unregister(alert);
                            continue;
                        }
                        Logger.normal(this, "Disabling the userAlert " + alert.hashCode());
                        alert.isValid(false);
                        continue;
                    }
                    if (!alert.isValid()) continue;
                    ++validAlertsRemaining;
                }
                WelcomeToadlet.writePermanentRedirect(ctx, WelcomeToadlet.l10n("disabledAlert"), validAlertsRemaining > 0 ? "/alerts/" : PATH);
                return;
            }
            if (request.isPartSet("key") && request.isPartSet("filename")) {
                HTMLNode content;
                HTMLNode pageNode;
                RandomAccessBucket bucket;
                block37: {
                    String[] metas;
                    if (!ctx.checkFormPassword(request)) {
                        return;
                    }
                    FreenetURI key = new FreenetURI(request.getPartAsStringFailsafe("key", Short.MAX_VALUE));
                    String type = request.getPartAsStringFailsafe("content-type", 128);
                    if (type == null) {
                        type = "text/plain";
                    }
                    ClientMetadata contentType = new ClientMetadata(type);
                    bucket = request.getPart("filename");
                    PageNode page = ctx.getPageMaker().getPageNode(WelcomeToadlet.l10n("insertedTitle"), ctx);
                    pageNode = page.outer;
                    HTMLNode contentNode = page.content;
                    String filenameHint = null;
                    if (key.getKeyType().equals("CHK") && (metas = key.getAllMetaStrings()) != null && metas.length > 1) {
                        filenameHint = metas[0];
                    }
                    InsertBlock block = new InsertBlock(bucket, contentType, key);
                    try {
                        key = this.insert(block, filenameHint, false);
                        content = ctx.getPageMaker().getInfobox("infobox-success", WelcomeToadlet.l10n("insertSucceededTitle"), contentNode, "successful-insert", false);
                        String u = key.toString();
                        NodeL10n.getBase().addL10nSubstitution(content, "WelcomeToadlet.keyInsertedSuccessfullyWithKeyAndName", new String[]{"link", "name"}, new HTMLNode[]{HTMLNode.link(PATH + u), HTMLNode.text(u)});
                    }
                    catch (InsertException e) {
                        InsertException.InsertExceptionMode mode;
                        content = ctx.getPageMaker().getInfobox("infobox-error", WelcomeToadlet.l10n("insertFailedTitle"), contentNode, "failed-insert", false);
                        content.addChild("#", WelcomeToadlet.l10n("insertFailedWithMessage", "message", e.getMessage()));
                        content.addChild("br");
                        if (e.uri != null) {
                            content.addChild("#", WelcomeToadlet.l10n("uriWouldHaveBeen", "uri", e.uri.toString()));
                        }
                        if ((mode = e.getMode()) != InsertException.InsertExceptionMode.FATAL_ERRORS_IN_BLOCKS && mode != InsertException.InsertExceptionMode.TOO_MANY_RETRIES_IN_BLOCKS) break block37;
                        content.addChild("br");
                        content.addChild("#", WelcomeToadlet.l10n("splitfileErrorLabel"));
                        content.addChild("pre", e.errorCodes.toVerboseString());
                    }
                }
                content.addChild("br");
                WelcomeToadlet.addHomepageLink(content);
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                request.freeParts();
                bucket.free();
                return;
            }
            if (request.isPartSet("key")) {
                String key;
                if (!ctx.checkFormPassword(request)) {
                    return;
                }
                try {
                    key = URLDecoder.decode(new FreenetURI(request.getPartAsStringFailsafe("key", Short.MAX_VALUE)).toURI(PATH).toString(), false);
                }
                catch (Exception e) {
                    this.sendErrorPage(ctx, WelcomeToadlet.l10n("invalidURI"), WelcomeToadlet.l10n("invalidURILong"), e);
                    return;
                }
                this.writeTemporaryRedirect(ctx, "OK", key);
                return;
            }
            if (request.isPartSet("exit")) {
                PageNode page = ctx.getPageMaker().getPageNode(WelcomeToadlet.l10n("shutdownConfirmTitle"), ctx);
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                HTMLNode content = ctx.getPageMaker().getInfobox("infobox-query", WelcomeToadlet.l10n("shutdownConfirmTitle"), contentNode, "shutdown-confirm", true);
                content.addChild("p").addChild("#", WelcomeToadlet.l10n("shutdownConfirm"));
                HTMLNode shutdownForm = ctx.addFormChild(content.addChild("p"), PATH, "confirmShutdownForm");
                shutdownForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", NodeL10n.getBase().getString("Toadlet.cancel")});
                shutdownForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "shutdownconfirm", WelcomeToadlet.l10n("shutdown")});
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            if (request.isPartSet("shutdownconfirm")) {
                if (!ctx.checkFormPassword(request)) {
                    return;
                }
                MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
                headers.put("Location", "/?terminated&formPassword=" + ctx.getFormPassword());
                ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                this.node.ticker.queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        WelcomeToadlet.this.node.exit("Shutdown from fproxy");
                    }
                }, 1L);
                return;
            }
            if (request.isPartSet("restart")) {
                PageNode page = ctx.getPageMaker().getPageNode(WelcomeToadlet.l10n("restartConfirmTitle"), ctx);
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                HTMLNode content = ctx.getPageMaker().getInfobox("infobox-query", WelcomeToadlet.l10n("restartConfirmTitle"), contentNode, "restart-confirm", true);
                content.addChild("p").addChild("#", WelcomeToadlet.l10n("restartConfirm"));
                HTMLNode restartForm = ctx.addFormChild(content.addChild("p"), PATH, "confirmRestartForm");
                restartForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", NodeL10n.getBase().getString("Toadlet.cancel")});
                restartForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "restartconfirm", WelcomeToadlet.l10n("restart")});
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            if (request.isPartSet("restartconfirm")) {
                if (!ctx.checkFormPassword(request)) {
                    return;
                }
                MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
                headers.put("Location", "/?restarted&formPassword=" + ctx.getFormPassword());
                ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                this.node.ticker.queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        WelcomeToadlet.this.node.getNodeStarter().restart();
                    }
                }, 1L);
                return;
            }
            if (request.isPartSet("dismiss-events")) {
                if (!ctx.checkFormPassword(request)) {
                    return;
                }
                String alertsToDump = request.getPartAsStringFailsafe("events", Integer.MAX_VALUE);
                String[] alertAnchors = alertsToDump.split(",");
                HashSet<String> toDump = new HashSet<String>();
                for (String alertAnchor : alertAnchors) {
                    toDump.add(alertAnchor);
                }
                ctx.getAlertManager().dumpEvents(toDump);
                this.redirectToRoot(ctx);
            } else {
                this.redirectToRoot(ctx);
            }
        }
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        if (ctx.isAllowedFullAccess()) {
            if (request.isParameterSet("latestlog")) {
                File logs = new File(this.node.config.get("logger").getString("dirname") + File.separator + "freenet-latest.log");
                String text = WelcomeToadlet.readLogTail(logs, 100000L);
                this.writeTextReply(ctx, 200, "OK", text);
                return;
            }
            if (request.isParameterSet("terminated")) {
                if (!request.isParameterSet("formPassword") || !request.getParam("formPassword").equals(ctx.getFormPassword())) {
                    this.redirectToRoot(ctx);
                    return;
                }
                PageNode page = ctx.getPageMaker().getPageNode("Node Shutdown", ctx, new PageMaker.RenderParameters().renderNavigationLinks(false));
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                ctx.getPageMaker().getInfobox("infobox-information", WelcomeToadlet.l10n("shutdownDone"), contentNode, "shutdown-progressing", true).addChild("#", WelcomeToadlet.l10n("thanks"));
                WelcomeToadlet.maybeDisplayWrapperLogfile(ctx, contentNode);
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            if (request.isParameterSet("restarted")) {
                if (!request.isParameterSet("formPassword") || !request.getParam("formPassword").equals(ctx.getFormPassword())) {
                    this.redirectToRoot(ctx);
                    return;
                }
                this.sendRestartingPage(ctx);
                return;
            }
            if (request.getParam("newbookmark").length() > 0) {
                PageNode page = ctx.getPageMaker().getPageNode(WelcomeToadlet.l10n("confirmAddBookmarkTitle"), ctx);
                HTMLNode pageNode = page.outer;
                HTMLNode contentNode = page.content;
                HTMLNode infoboxContent = ctx.getPageMaker().getInfobox("#", WelcomeToadlet.l10n("confirmAddBookmarkSubTitle"), contentNode, "add-bookmark-confirm", true);
                HTMLNode addForm = ctx.addFormChild(infoboxContent, "/bookmarkEditor/", "editBookmarkForm");
                addForm.addChild("#", WelcomeToadlet.l10n("confirmAddBookmarkWithKey", "key", request.getParam("newbookmark")));
                addForm.addChild("br");
                String key = request.getParam("newbookmark");
                if (key.startsWith("freenet:")) {
                    key = key.substring(8);
                }
                addForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "key", key});
                if (request.isParameterSet("hasAnActivelink")) {
                    addForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "hasAnActivelink", request.getParam("hasAnActivelink")});
                }
                addForm.addChild("label", "for", "name", NodeL10n.getBase().getString("BookmarkEditorToadlet.nameLabel") + ' ');
                addForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"text", "name", request.getParam("desc")});
                addForm.addChild("br");
                addForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "bookmark", PATH});
                addForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "action", "addItem"});
                addForm.addChild("label", "for", "descB", NodeL10n.getBase().getString("BookmarkEditorToadlet.descLabel") + ' ');
                addForm.addChild("br");
                addForm.addChild("textarea", new String[]{"id", "name", "row", "cols"}, new String[]{"descB", "descB", "3", "70"});
                if (this.node.getDarknetConnections().length > 0) {
                    addForm.addChild("br");
                    addForm.addChild("br");
                    if (this.node.isFProxyJavascriptEnabled()) {
                        addForm.addChild("script", new String[]{"type", "src"}, new String[]{"text/javascript", "/static/js/checkall.js"});
                    }
                    HTMLNode peerTable = addForm.addChild("table", "class", "darknet_connections");
                    if (this.node.isFProxyJavascriptEnabled()) {
                        DarknetPeerNode[] headerRow = peerTable.addChild("tr");
                        headerRow.addChild("th").addChild("input", new String[]{"type", "onclick"}, new String[]{"checkbox", "checkAll(this, 'darknet_connections')"});
                        headerRow.addChild("th", NodeL10n.getBase().getString("QueueToadlet.recommendToFriends"));
                    } else {
                        peerTable.addChild("tr").addChild("th", "colspan", "2", NodeL10n.getBase().getString("QueueToadlet.recommendToFriends"));
                    }
                    for (DarknetPeerNode peer : this.node.getDarknetConnections()) {
                        HTMLNode peerRow = peerTable.addChild("tr", "class", "darknet_connections_normal");
                        peerRow.addChild("td", "class", "peer-marker").addChild("input", new String[]{"type", "name"}, new String[]{"checkbox", "node_" + peer.hashCode()});
                        peerRow.addChild("td", "class", "peer-name").addChild("#", peer.getName());
                    }
                    addForm.addChild("label", "for", "descB", NodeL10n.getBase().getString("BookmarkEditorToadlet.publicDescLabel") + ' ');
                    addForm.addChild("br");
                    addForm.addChild("textarea", new String[]{"id", "name", "row", "cols"}, new String[]{"descB", "publicDescB", "3", "70"}, "");
                }
                addForm.addChild("br");
                addForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "addbookmark", NodeL10n.getBase().getString("BookmarkEditorToadlet.addBookmark")});
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            if (uri.getQuery() != null && uri.getQuery().startsWith("_CHECKED_HTTP_=")) {
                super.writeTemporaryRedirect(ctx, "Depreciated", "/external-link/?" + uri.getQuery());
                return;
            }
        }
        PageNode page = ctx.getPageMaker().getPageNode(WelcomeToadlet.l10n("homepageFullTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        String useragent = ctx.getHeaders().get("user-agent");
        if (useragent != null && (useragent = useragent.toLowerCase()).indexOf("msie") > -1 && useragent.indexOf("opera") == -1) {
            ctx.getPageMaker().getInfobox("infobox-alert", WelcomeToadlet.l10n("ieWarningTitle"), contentNode, "internet-explorer-used", true).addChild("#", WelcomeToadlet.l10n("ieWarning"));
        }
        if (ctx.isAllowedFullAccess()) {
            contentNode.addChild(ctx.getAlertManager().createSummary());
        }
        if (ctx.getPageMaker().getTheme().fetchKeyBoxAboveBookmarks) {
            this.putFetchKeyBox(ctx, contentNode);
        }
        HTMLNode bookmarkBox = contentNode.addChild("div", "class", "infobox infobox-normal bookmarks-box");
        HTMLNode bookmarkBoxHeader = bookmarkBox.addChild("div", "class", "infobox-header");
        bookmarkBoxHeader.addChild("a", new String[]{"class", "title"}, new String[]{"bookmarks-header-text", NodeL10n.getBase().getString("BookmarkEditorToadlet.myBookmarksExplanation")}, NodeL10n.getBase().getString("BookmarkEditorToadlet.myBookmarksTitle"));
        if (ctx.isAllowedFullAccess()) {
            bookmarkBoxHeader.addChild("span", "class", "edit-bracket", "[");
            bookmarkBoxHeader.addChild("span", "id", "bookmarkedit").addChild("a", new String[]{"href", "class"}, new String[]{"/bookmarkEditor/", "interfacelink"}, NodeL10n.getBase().getString("BookmarkEditorToadlet.edit"));
            bookmarkBoxHeader.addChild("span", "class", "edit-bracket", "]");
        }
        HTMLNode bookmarkBoxContent = bookmarkBox.addChild("div", "class", "infobox-content");
        HTMLNode bookmarksList = bookmarkBoxContent.addChild("ul", "id", BOOKMARKS_ANCHOR);
        if (ctx.isAllowedFullAccess() || !ctx.getContainer().publicGatewayMode()) {
            this.addCategoryToList(BookmarkManager.MAIN_CATEGORY, bookmarksList, !this.container.enableActivelinks() || useragent != null && useragent.contains("khtml") && !useragent.contains("chrome"), ctx);
        } else {
            this.addCategoryToList(BookmarkManager.DEFAULT_CATEGORY, bookmarksList, !this.container.enableActivelinks() || useragent != null && useragent.contains("khtml") && !useragent.contains("chrome"), ctx);
        }
        if (this.showSearchBox()) {
            this.addSearchBox(contentNode);
        }
        if (!ctx.getPageMaker().getTheme().fetchKeyBoxAboveBookmarks) {
            this.putFetchKeyBox(ctx, contentNode);
        }
        HTMLNode versionContent = ctx.getPageMaker().getInfobox("infobox-information", WelcomeToadlet.l10n("versionHeader"), contentNode, "freenet-version", true);
        versionContent.addChild("span", "class", "freenet-full-version", NodeL10n.getBase().getString("WelcomeToadlet.version", new String[]{"fullVersion", "build", "rev"}, new String[]{Version.publicVersion(), Integer.toString(Version.buildNumber()), Version.cvsRevision()}));
        versionContent.addChild("br");
        versionContent.addChild("span", "class", "freenet-ext-version", NodeL10n.getBase().getString("WelcomeToadlet.extVersion", new String[]{"build", "rev"}, new String[]{Integer.toString(NodeStarter.extBuildNumber), NodeStarter.extRevisionNumber}));
        versionContent.addChild("br");
        if (ctx.isAllowedFullAccess()) {
            HTMLNode shutdownForm = ctx.addFormChild(versionContent, ".", "shutdownForm");
            shutdownForm.addChild("input", new String[]{"type", "name"}, new String[]{"hidden", "exit"});
            shutdownForm.addChild("input", new String[]{"type", "value"}, new String[]{"submit", WelcomeToadlet.l10n("shutdownNode")});
            if (this.node.isUsingWrapper()) {
                HTMLNode restartForm = ctx.addFormChild(versionContent, ".", "restartForm");
                restartForm.addChild("input", new String[]{"type", "name"}, new String[]{"hidden", "restart"});
                restartForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "restart2", WelcomeToadlet.l10n("restartNode")});
            }
        }
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private void putFetchKeyBox(ToadletContext ctx, HTMLNode contentNode) {
        HTMLNode fetchKeyContent = ctx.getPageMaker().getInfobox("infobox-normal", WelcomeToadlet.l10n("fetchKeyLabel"), contentNode, "fetch-key", true);
        fetchKeyContent.addAttribute("id", "keyfetchbox");
        HTMLNode fetchKeyForm = fetchKeyContent.addChild("form", new String[]{"method"}, new String[]{"POST"}).addChild("div");
        fetchKeyForm.addChild("span", "class", "fetch-key-label", WelcomeToadlet.l10n("keyRequestLabel") + ' ');
        fetchKeyForm.addChild("input", new String[]{"type", "size", "name"}, new String[]{"text", "80", "key"});
        fetchKeyForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", ctx.getFormPassword()});
        fetchKeyForm.addChild("input", new String[]{"type", "value"}, new String[]{"submit", WelcomeToadlet.l10n("fetch")});
    }

    private void sendRestartingPage(ToadletContext ctx) throws ToadletContextClosedException, IOException {
        this.writeHTMLReply(ctx, 200, "OK", WelcomeToadlet.sendRestartingPageInner(ctx).generate());
    }

    static HTMLNode sendRestartingPageInner(ToadletContext ctx) {
        PageNode page = ctx.getPageMaker().getPageNode("Node Restart", ctx, new PageMaker.RenderParameters().renderNavigationLinks(false));
        HTMLNode pageNode = page.outer;
        HTMLNode headNode = page.headNode;
        headNode.addChild("meta", new String[]{"http-equiv", "content"}, new String[]{"refresh", "20; url="});
        HTMLNode contentNode = page.content;
        ctx.getPageMaker().getInfobox("infobox-information", WelcomeToadlet.l10n("restartingTitle"), contentNode, "shutdown-progressing", true).addChild("#", WelcomeToadlet.l10n("restarting"));
        Logger.normal(WelcomeToadlet.class, "Node is restarting");
        return pageNode;
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("WelcomeToadlet." + key);
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("WelcomeToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void maybeDisplayWrapperLogfile(ToadletContext ctx, HTMLNode contentNode) {
        File logs = new File("wrapper.log");
        long logSize = logs.length();
        if (logs.exists() && logs.isFile() && logs.canRead() && logSize > 0L) {
            HTMLNode logInfoboxContent = ctx.getPageMaker().getInfobox("infobox-info", "Current status", contentNode, "start-progress", true);
            LineReadingInputStream logreader = null;
            try {
                String line;
                logreader = FileUtil.getLogTailReader(logs, 2000L);
                while ((line = logreader.readLine(100000, 200, true)) != null) {
                    logInfoboxContent.addChild("#", line);
                    logInfoboxContent.addChild("br");
                }
            }
            catch (IOException iOException) {
            }
            finally {
                Closer.close(logreader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readLogTail(File logfile, long byteLimit) throws IOException {
        LineReadingInputStream stream = null;
        try {
            stream = FileUtil.getLogTailReader(logfile, byteLimit);
            String string = FileUtil.readUTF(stream).toString();
            return string;
        }
        finally {
            Closer.close(stream);
        }
    }

    @Override
    public String path() {
        return PATH;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

