/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestSelector;
import freenet.support.Logger;
import freenet.support.RandomGrabArrayItem;
import freenet.support.RandomGrabArrayWithObject;
import freenet.support.RemoveRandomParent;
import freenet.support.SectoredRandomGrabArrayWithObject;

public class SectoredRandomGrabArraySimple<MyType, ChildType>
extends SectoredRandomGrabArrayWithObject<MyType, ChildType, RandomGrabArrayWithObject<ChildType>> {
    private static volatile boolean logMINOR;

    public SectoredRandomGrabArraySimple(MyType object, RemoveRandomParent parent, ClientRequestSelector root) {
        super(object, parent, root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ChildType client, RandomGrabArrayItem item, ClientContext context) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            RandomGrabArrayWithObject<ChildType> rga = (RandomGrabArrayWithObject<ChildType>)this.getGrabber(client);
            if (rga == null) {
                if (logMINOR) {
                    Logger.minor(this, "Adding new RGAWithClient for " + client + " on " + this + " for " + item);
                }
                rga = new RandomGrabArrayWithObject<ChildType>(client, this, this.root);
                this.addElement(client, rga);
            }
            if (logMINOR) {
                Logger.minor(this, "Adding " + item + " to RGA " + rga + " for " + client);
            }
            rga.add(item, context);
            if (context != null) {
                this.clearWakeupTime(context);
            }
            if (logMINOR) {
                Logger.minor(this, "Size now " + this.size() + " on " + this);
            }
        }
    }

    static {
        Logger.registerClass(SectoredRandomGrabArraySimple.class);
    }
}

