/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.collections.facades;

import com.db4o.collections.facades.CachedObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class FastListCache {
    private transient List _list;

    public FastListCache(int size) {
        this._list = new ArrayList(size);
        for (int i = 0; i < this._list.size(); ++i) {
            this._list.set(i, CachedObject.NONE);
        }
    }

    public void add(Object o) {
        this._list.add(new CachedObject(o));
    }

    public void add(int index, Object element) {
        this._list.add(index, new CachedObject(element));
    }

    public void addAll(Collection c) {
        this._list.addAll(this.toCachedObjectCollection(c));
    }

    public void addAll(int index, Collection c) {
        this._list.addAll(index, this.toCachedObjectCollection(c));
    }

    public void clear() {
        this._list.clear();
    }

    public boolean contains(Object o) {
        return this._list.contains(new CachedObject(o));
    }

    public int indexOf(Object o) {
        return this._list.indexOf(new CachedObject(o));
    }

    public void remove(Object o) {
        this._list.remove(new CachedObject(o));
    }

    public void remove(int index) {
        this._list.remove(index);
    }

    public void removeAll(Collection c) {
        this._list.removeAll(this.toCachedObjectCollection(c));
    }

    public void retainAll(Collection c) {
        this._list.retainAll(this.toCachedObjectCollection(c));
    }

    public void set(int index, Object element) {
        this._list.set(index, new CachedObject(element));
    }

    private Collection toCachedObjectCollection(Collection c) {
        ArrayList<CachedObject> cachedObjectList = new ArrayList<CachedObject>(c.size());
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            cachedObjectList.add(new CachedObject(iter.next()));
        }
        return cachedObjectList;
    }

    public CachedObject get(int index) {
        return (CachedObject)this._list.get(index);
    }

    public boolean containsAll(Collection c) {
        return this._list.containsAll(this.toCachedObjectCollection(c));
    }
}

