/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINBoundary;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.CursorsExistException;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INDeleteInfo;
import com.sleepycat.je.tree.INDupDeleteInfo;
import com.sleepycat.je.tree.InconsistentNodeException;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.NodeNotEmptyException;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.SplitRequiredException;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeStats;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.Tracer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Tree
implements Loggable {
    private static final String TRACE_ROOT_SPLIT = "RootSplit:";
    private static final String TRACE_DUP_ROOT_SPLIT = "DupRootSplit:";
    private static final String TRACE_MUTATE = "Mut:";
    private static final String TRACE_INSERT = "Ins:";
    private static final String TRACE_INSERT_DUPLICATE = "InsD:";
    private DatabaseImpl database;
    private ChildReference root;
    private int maxMainTreeEntriesPerNode;
    private int maxDupTreeEntriesPerNode;
    private boolean purgeRoot;
    private SharedLatch rootLatch;
    private TreeStats treeStats;
    private ThreadLocal<TreeWalkerStatsAccumulator> treeStatsAccumulatorTL = new ThreadLocal();
    private static SplitRequiredException splitRequiredException = new SplitRequiredException();
    private TestHook waitHook;
    private TestHook searchHook;
    private TestHook ckptHook;
    private static RelatchRequiredException relatchRequiredException = new RelatchRequiredException();

    public Tree(DatabaseImpl database) throws DatabaseException {
        this.init(database);
        this.setDatabase(database);
    }

    public Tree() throws DatabaseException {
        this.init(null);
        this.maxMainTreeEntriesPerNode = 0;
        this.maxDupTreeEntriesPerNode = 0;
    }

    private void init(DatabaseImpl database) {
        this.rootLatch = new SharedLatch("RootLatch");
        this.treeStats = new TreeStats();
        this.root = null;
        this.database = database;
    }

    public void setDatabase(DatabaseImpl database) throws DatabaseException {
        this.database = database;
        this.maxMainTreeEntriesPerNode = database.getNodeMaxEntries();
        this.maxDupTreeEntriesPerNode = database.getNodeMaxDupTreeEntries();
        DbConfigManager configManager = database.getDbEnvironment().getConfigManager();
        this.purgeRoot = configManager.getBoolean(EnvironmentParams.COMPRESSOR_PURGE_ROOT);
    }

    public DatabaseImpl getDatabase() {
        return this.database;
    }

    public void setRoot(ChildReference newRoot, boolean notLatched) {
        assert (notLatched || this.rootLatch.isWriteLockedByCurrentThread());
        this.root = newRoot;
    }

    public ChildReference makeRootChildReference(Node target, byte[] key, long lsn) {
        return new RootChildReference(target, key, lsn);
    }

    private ChildReference makeRootChildReference() {
        return new RootChildReference();
    }

    public boolean rootExists() {
        if (this.root == null) {
            return false;
        }
        return this.root.getTarget() != null || this.root.getLsn() != -1L;
    }

    public boolean isRootResident() {
        return this.root != null && this.root.getTarget() != null;
    }

    public long getRootLsn() {
        if (this.root == null) {
            return -1L;
        }
        return this.root.getLsn();
    }

    TreeStats getTreeStats() {
        return this.treeStats;
    }

    private TreeWalkerStatsAccumulator getTreeStatsAccumulator() {
        if (EnvironmentImpl.getThreadLocalReferenceCount() > 0) {
            return this.treeStatsAccumulatorTL.get();
        }
        return null;
    }

    public void setTreeStatsAccumulator(TreeWalkerStatsAccumulator tSA) {
        this.treeStatsAccumulatorTL.set(tSA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN withRootLatchedExclusive(WithRootLatched wrl) throws DatabaseException {
        IN iN;
        try {
            this.rootLatch.acquireExclusive();
            iN = wrl.doWork(this.root);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.rootLatch.release();
            throw throwable;
        }
        this.rootLatch.release();
        return iN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN withRootLatchedShared(WithRootLatched wrl) throws DatabaseException {
        IN iN;
        try {
            this.rootLatch.acquireShared();
            iN = wrl.doWork(this.root);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.rootLatch.release();
            throw throwable;
        }
        this.rootLatch.release();
        return iN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(byte[] idKey, LocalUtilizationTracker localTracker) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        boolean rootNeedsUpdating;
        IN rootIN;
        ArrayList<SplitInfo> nodeLadder;
        IN subtreeRootIN;
        block12: {
            block11: {
                subtreeRootIN = null;
                nodeLadder = new ArrayList<SplitInfo>();
                rootIN = null;
                rootNeedsUpdating = false;
                this.rootLatch.acquireExclusive();
                try {
                    if (!this.rootExists()) {
                        Object var10_7 = null;
                        break block11;
                    }
                    rootIN = (IN)this.root.fetchTarget(this.database, null);
                    rootIN.latch(CacheMode.UNCHANGED);
                    this.searchDeletableSubTree(rootIN, idKey, nodeLadder);
                    if (nodeLadder.size() == 0) {
                        if (this.purgeRoot && (subtreeRootIN = this.logTreeRemoval(rootIN)) != null) {
                            rootNeedsUpdating = true;
                        }
                        break block12;
                    }
                    SplitInfo detachPoint = nodeLadder.get(nodeLadder.size() - 1);
                    boolean deleteOk = detachPoint.parent.deleteEntry(detachPoint.index, true);
                    assert (deleteOk);
                    rootNeedsUpdating = this.cascadeUpdates(nodeLadder, null, -1);
                    subtreeRootIN = detachPoint.child;
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    this.releaseNodeLadderLatches(nodeLadder);
                    if (rootIN != null) {
                        rootIN.releaseLatch();
                    }
                    this.rootLatch.release();
                    throw throwable;
                }
            }
            this.releaseNodeLadderLatches(nodeLadder);
            if (rootIN != null) {
                rootIN.releaseLatch();
            }
            this.rootLatch.release();
            return;
        }
        Object var10_8 = null;
        this.releaseNodeLadderLatches(nodeLadder);
        if (rootIN != null) {
            rootIN.releaseLatch();
        }
        this.rootLatch.release();
        if (subtreeRootIN != null) {
            EnvironmentImpl envImpl = this.database.getDbEnvironment();
            if (rootNeedsUpdating) {
                DbTree dbTree = envImpl.getDbTree();
                dbTree.optionalModifyDbRoot(this.database);
                RecoveryManager.traceRootDeletion(Level.FINE, this.database);
            }
            INList inList = envImpl.getInMemoryINs();
            this.accountForSubtreeRemoval(inList, subtreeRootIN, localTracker);
        }
    }

    private void releaseNodeLadderLatches(ArrayList<SplitInfo> nodeLadder) throws DatabaseException {
        ListIterator<SplitInfo> iter = nodeLadder.listIterator(nodeLadder.size());
        while (iter.hasPrevious()) {
            SplitInfo info = iter.previous();
            info.child.releaseLatch();
        }
    }

    private IN logTreeRemoval(IN rootIN) throws DatabaseException {
        assert (this.rootLatch.isWriteLockedByCurrentThread());
        IN detachedRootIN = null;
        if (rootIN.getNEntries() <= 1 && rootIN.validateSubtreeBeforeDelete(0)) {
            this.root = null;
            INDeleteInfo info = new INDeleteInfo(rootIN.getNodeId(), rootIN.getIdentifierKey(), this.database.getId());
            info.optionalLog(this.database.getDbEnvironment().getLogManager(), this.database);
            detachedRootIN = rootIN;
        }
        return detachedRootIN;
    }

    private boolean cascadeUpdates(ArrayList<SplitInfo> nodeLadder, BIN binRoot, int index) throws DatabaseException {
        ListIterator<SplitInfo> iter = nodeLadder.listIterator(nodeLadder.size());
        EnvironmentImpl envImpl = this.database.getDbEnvironment();
        LogManager logManager = envImpl.getLogManager();
        long newLsn = -1L;
        SplitInfo info = null;
        while (iter.hasPrevious()) {
            info = iter.previous();
            if (newLsn != -1L) {
                info.parent.updateEntry(info.index, newLsn);
            }
            newLsn = info.parent.optionalLog(logManager);
        }
        boolean rootNeedsUpdating = false;
        if (info != null) {
            if (info.parent.isDbRoot()) {
                assert (this.rootLatch.isWriteLockedByCurrentThread());
                this.root.updateLsnAfterOptionalLog(this.database, newLsn);
                rootNeedsUpdating = true;
            } else if (binRoot != null && info.parent.isRoot()) {
                binRoot.updateEntry(index, newLsn);
            } else assert (false);
        }
        return rootNeedsUpdating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDup(byte[] idKey, byte[] mainKey, LocalUtilizationTracker localTracker) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        IN in = this.search(mainKey, SearchType.NORMAL, -1L, null, CacheMode.UNCHANGED);
        IN deletedSubtreeRoot = null;
        try {
            assert (in.isLatchOwnerForWrite());
            assert (in instanceof BIN);
            assert (in.getNEntries() > 0);
            int index = in.findEntry(mainKey, false, true);
            if (index >= 0) {
                deletedSubtreeRoot = this.deleteDupSubtree(idKey, (BIN)in, index);
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            in.releaseLatch();
            throw throwable;
        }
        in.releaseLatch();
        if (deletedSubtreeRoot != null) {
            EnvironmentImpl envImpl = this.database.getDbEnvironment();
            this.accountForSubtreeRemoval(envImpl.getInMemoryINs(), deletedSubtreeRoot, localTracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IN deleteDupSubtree(byte[] idKey, BIN bin, int index) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        EnvironmentImpl envImpl = this.database.getDbEnvironment();
        DupCountLN dcl = null;
        BasicLocker locker = BasicLocker.createBasicLocker(envImpl);
        DIN duplicateRoot = (DIN)bin.fetchTarget(index);
        duplicateRoot.latch(CacheMode.UNCHANGED);
        ArrayList<SplitInfo> nodeLadder = new ArrayList<SplitInfo>();
        IN subtreeRootIN = null;
        try {
            ChildReference dclRef = duplicateRoot.getDupCountLNRef();
            dcl = (DupCountLN)dclRef.fetchTarget(this.database, duplicateRoot);
            LockResult lockResult = locker.nonBlockingLock(dcl.getNodeId(), LockType.READ, this.database);
            if (lockResult.getLockGrant() == LockGrantType.DENIED) {
                throw CursorsExistException.CURSORS_EXIST;
            }
            this.searchDeletableSubTree(duplicateRoot, idKey, nodeLadder);
            if (nodeLadder.size() == 0) {
                if (bin.nCursors() != 0) throw CursorsExistException.CURSORS_EXIST;
                boolean deleteOk = bin.deleteEntry(index, true);
                assert (deleteOk);
                INDupDeleteInfo info = new INDupDeleteInfo(duplicateRoot.getNodeId(), duplicateRoot.getMainTreeKey(), duplicateRoot.getDupTreeKey(), this.database.getId());
                info.optionalLog(envImpl.getLogManager(), this.database);
                subtreeRootIN = duplicateRoot;
                if (bin.getNEntries() == 0) {
                    this.database.getDbEnvironment().addToCompressorQueue(bin, null, false);
                }
            } else {
                SplitInfo detachPoint = nodeLadder.get(nodeLadder.size() - 1);
                boolean deleteOk = detachPoint.parent.deleteEntry(detachPoint.index, true);
                assert (deleteOk);
                this.cascadeUpdates(nodeLadder, bin, index);
                subtreeRootIN = detachPoint.child;
            }
            Object var15_16 = null;
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.releaseNodeLadderLatches(nodeLadder);
            locker.operationEnd(true);
            duplicateRoot.releaseLatch();
            throw throwable;
        }
        this.releaseNodeLadderLatches(nodeLadder);
        locker.operationEnd(true);
        duplicateRoot.releaseLatch();
        return subtreeRootIN;
    }

    public IN getFirstNode(CacheMode cacheMode) throws DatabaseException {
        return this.search(null, SearchType.LEFT, -1L, null, cacheMode);
    }

    public IN getLastNode(CacheMode cacheMode) throws DatabaseException {
        return this.search(null, SearchType.RIGHT, -1L, null, cacheMode);
    }

    public DBIN getFirstNode(DIN dupRoot, CacheMode cacheMode) throws DatabaseException {
        if (dupRoot == null) {
            throw new IllegalArgumentException("getFirstNode passed null root");
        }
        assert (dupRoot.isLatchOwnerForWrite());
        IN ret = this.searchSubTree(dupRoot, null, SearchType.LEFT, -1L, null, cacheMode);
        return (DBIN)ret;
    }

    public DBIN getLastNode(DIN dupRoot, CacheMode cacheMode) throws DatabaseException {
        if (dupRoot == null) {
            throw new IllegalArgumentException("getLastNode passed null root");
        }
        assert (dupRoot.isLatchOwnerForWrite());
        IN ret = this.searchSubTree(dupRoot, null, SearchType.RIGHT, -1L, null, cacheMode);
        return (DBIN)ret;
    }

    public SearchResult getParentINForChildIN(IN child, boolean requireExactMatch, CacheMode cacheMode) throws DatabaseException {
        return this.getParentINForChildIN(child, requireExactMatch, cacheMode, -1, null);
    }

    public SearchResult getParentINForChildIN(IN child, boolean requireExactMatch, CacheMode cacheMode, int targetLevel, List<TrackingInfo> trackingList) throws DatabaseException {
        if (child == null) {
            throw new IllegalArgumentException("getParentNode passed null");
        }
        assert (child.isLatchOwnerForWrite());
        byte[] mainTreeKey = child.getMainTreeKey();
        byte[] dupTreeKey = child.getDupTreeKey();
        boolean isRoot = child.isRoot();
        child.releaseLatch();
        return this.getParentINForChildIN(child.getNodeId(), child.containsDuplicates(), isRoot, mainTreeKey, dupTreeKey, requireExactMatch, cacheMode, targetLevel, trackingList, true);
    }

    public SearchResult getParentINForChildIN(long targetNodeId, boolean targetContainsDuplicates, boolean targetIsRoot, byte[] targetMainTreeKey, byte[] targetDupTreeKey, boolean requireExactMatch, CacheMode cacheMode, int targetLevel, List<TrackingInfo> trackingList, boolean doFetch) throws DatabaseException {
        IN rootIN = doFetch ? this.getRootINLatchedExclusive(cacheMode) : this.getRootIN(cacheMode);
        SearchResult result = new SearchResult();
        if (rootIN != null) {
            if (trackingList != null) {
                trackingList.add(new TrackingInfo(this.root.getLsn(), rootIN.getNodeId()));
            }
            IN potentialParent = rootIN;
            try {
                while (result.keepSearching) {
                    assert (TestHookExecute.doHookIfSet(this.searchHook));
                    potentialParent.findParent(SearchType.NORMAL, targetNodeId, targetContainsDuplicates, targetIsRoot, targetMainTreeKey, targetDupTreeKey, result, requireExactMatch, cacheMode, targetLevel, trackingList, doFetch);
                    potentialParent = result.parent;
                }
            }
            catch (Exception e) {
                potentialParent.releaseLatch();
                throw new DatabaseException(e);
            }
        }
        return result;
    }

    public boolean getParentBINForChildLN(TreeLocation location, byte[] mainKey, byte[] dupKey, LN ln, boolean splitsAllowed, boolean findDeletedEntries, boolean searchDupTree, CacheMode cacheMode) throws DatabaseException {
        IN searchResult = null;
        searchResult = splitsAllowed ? this.searchSplitsAllowed(mainKey, -1L, cacheMode) : this.search(mainKey, SearchType.NORMAL, -1L, null, cacheMode);
        location.bin = (BIN)searchResult;
        if (location.bin == null) {
            return false;
        }
        boolean exactSearch = false;
        boolean indicateIfExact = true;
        if (!findDeletedEntries) {
            exactSearch = true;
            indicateIfExact = false;
        }
        location.index = location.bin.findEntry(mainKey, indicateIfExact, exactSearch);
        boolean match = false;
        if (findDeletedEntries) {
            match = location.index >= 0 && (location.index & 0x10000) != 0;
            location.index &= 0xFFFEFFFF;
        } else {
            boolean bl = match = location.index >= 0;
        }
        if (match) {
            if (!location.bin.isEntryKnownDeleted(location.index) && this.database.getSortedDuplicates()) {
                Node childNode = location.bin.fetchTarget(location.index);
                try {
                    if (childNode != null) {
                        if (ln.containsDuplicates()) {
                            return this.searchDupTreeForDupCountLNParent(location, mainKey, childNode);
                        }
                        if (childNode.containsDuplicates()) {
                            if (dupKey == null) {
                                return this.searchDupTreeByNodeId(location, childNode, ln, searchDupTree, cacheMode);
                            }
                            return this.searchDupTreeForDBIN(location, dupKey, (DIN)childNode, ln, findDeletedEntries, indicateIfExact, exactSearch, splitsAllowed, cacheMode);
                        }
                    }
                }
                catch (DatabaseException e) {
                    location.bin.releaseLatchIfOwner();
                    throw e;
                }
            }
            location.childLsn = location.bin.getLsn(location.index);
            return true;
        }
        location.lnKey = mainKey;
        return false;
    }

    private boolean searchDupTreeByNodeId(TreeLocation location, Node childNode, LN ln, boolean searchDupTree, CacheMode cacheMode) throws DatabaseException {
        if (searchDupTree) {
            BIN oldBIN = location.bin;
            if (childNode.matchLNByNodeId(location, ln.getNodeId(), cacheMode)) {
                location.index &= 0xFFFEFFFF;
                if (oldBIN != null) {
                    oldBIN.releaseLatch();
                }
                location.bin.latch(cacheMode);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean searchDupTreeForDupCountLNParent(TreeLocation location, byte[] mainKey, Node childNode) {
        location.lnKey = mainKey;
        if (childNode instanceof DIN) {
            DIN dupRoot = (DIN)childNode;
            location.childLsn = dupRoot.getDupCountLNRef().getLsn();
            return true;
        }
        return false;
    }

    private boolean searchDupTreeForDBIN(TreeLocation location, byte[] dupKey, DIN dupRoot, LN ln, boolean findDeletedEntries, boolean indicateIfExact, boolean exactSearch, boolean splitsAllowed, CacheMode cacheMode) throws DatabaseException {
        boolean match;
        assert (dupKey != null);
        dupRoot.latch(cacheMode);
        if (this.maybeSplitDuplicateRoot(location.bin, location.index, cacheMode)) {
            dupRoot = (DIN)location.bin.fetchTarget(location.index);
        }
        location.bin.releaseLatch();
        location.lnKey = dupKey;
        if (splitsAllowed) {
            try {
                location.bin = (BIN)this.searchSubTreeSplitsAllowed(dupRoot, location.lnKey, ln.getNodeId(), cacheMode);
            }
            catch (SplitRequiredException e) {
                throw new DatabaseException(e);
            }
        } else {
            location.bin = (BIN)this.searchSubTree(dupRoot, location.lnKey, SearchType.NORMAL, ln.getNodeId(), null, cacheMode);
        }
        location.index = location.bin.findEntry(location.lnKey, indicateIfExact, exactSearch);
        if (findDeletedEntries) {
            match = location.index >= 0 && (location.index & 0x10000) != 0;
            location.index &= 0xFFFEFFFF;
        } else {
            boolean bl = match = location.index >= 0;
        }
        if (match) {
            location.childLsn = location.bin.getLsn(location.index);
            return true;
        }
        return false;
    }

    public BIN getNextBin(BIN bin, boolean traverseWithinDupTree, CacheMode cacheMode) throws DatabaseException {
        return this.getNextBinInternal(traverseWithinDupTree, bin, true, cacheMode);
    }

    public BIN getPrevBin(BIN bin, boolean traverseWithinDupTree, CacheMode cacheMode) throws DatabaseException {
        return this.getNextBinInternal(traverseWithinDupTree, bin, false, cacheMode);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BIN getNextBinInternal(boolean traverseWithinDupTree, BIN bin, boolean forward, CacheMode cacheMode) throws DatabaseException {
        byte[] idKey = null;
        idKey = bin.getNEntries() == 0 ? bin.getIdentifierKey() : (forward ? bin.getKey(bin.getNEntries() - 1) : bin.getKey(0));
        BIN bIN = bin;
        boolean nextIsLatched = false;
        assert (LatchSupport.countLatchesHeld() == 1) : LatchSupport.latchesHeldToString();
        IN parent = null;
        IN nextIN = null;
        boolean nextINIsLatched = false;
        try {
            while (true) {
                block24: {
                    void var6_7;
                    SearchResult result = null;
                    if (!traverseWithinDupTree) {
                        nextIsLatched = false;
                        result = this.getParentINForChildIN((IN)var6_7, true, cacheMode);
                        if (result.exactParentFound) {
                            parent = result.parent;
                            break block24;
                        } else {
                            assert (LatchSupport.countLatchesHeld() == 0) : LatchSupport.latchesHeldToString();
                            return null;
                        }
                    }
                    if (var6_7.isRoot()) {
                        var6_7.releaseLatch();
                        return null;
                    }
                    nextIsLatched = false;
                    result = this.getParentINForChildIN((IN)var6_7, true, cacheMode);
                    if (!result.exactParentFound) {
                        return null;
                    }
                    parent = result.parent;
                }
                assert (LatchSupport.countLatchesHeld() == 1) : LatchSupport.latchesHeldToString();
                int index = parent.findEntry(idKey, false, false);
                boolean moreEntriesThisBin = false;
                if (forward) {
                    if (++index < parent.getNEntries()) {
                        moreEntriesThisBin = true;
                    }
                } else {
                    if (index > 0) {
                        moreEntriesThisBin = true;
                    }
                    --index;
                }
                if (moreEntriesThisBin) {
                    nextIN = (IN)parent.fetchTarget(index);
                    nextIN.latch(cacheMode);
                    nextINIsLatched = true;
                    assert (LatchSupport.countLatchesHeld() == 2) : LatchSupport.latchesHeldToString();
                    if (nextIN instanceof BIN) {
                        parent.releaseLatch();
                        parent = null;
                        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
                        if (treeStatsAccumulator != null) {
                            nextIN.accumulateStats(treeStatsAccumulator);
                        }
                        return (BIN)nextIN;
                    }
                    IN ret = this.searchSubTree(nextIN, null, forward ? SearchType.LEFT : SearchType.RIGHT, -1L, null, cacheMode);
                    nextINIsLatched = false;
                    parent.releaseLatch();
                    parent = null;
                    assert (LatchSupport.countLatchesHeld() == 1) : LatchSupport.latchesHeldToString();
                    if (ret instanceof BIN) {
                        return (BIN)ret;
                    }
                    throw new InconsistentNodeException("subtree did not have a BIN for leaf");
                }
                IN iN = parent;
                nextIsLatched = true;
                parent = null;
            }
        }
        catch (DatabaseException e) {
            if (bIN != null && nextIsLatched) {
                bIN.releaseLatch();
            }
            if (parent != null) {
                parent.releaseLatch();
            }
            if (nextIN != null && nextINIsLatched) {
                nextIN.releaseLatch();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitRoot(CacheMode cacheMode) throws DatabaseException {
        EnvironmentImpl env = this.database.getDbEnvironment();
        LogManager logManager = env.getLogManager();
        INList inMemoryINs = env.getInMemoryINs();
        IN curRoot = null;
        curRoot = (IN)this.root.fetchTarget(this.database, null);
        curRoot.latch(cacheMode);
        long curRootLsn = 0L;
        long logLsn = 0L;
        IN newRoot = null;
        try {
            byte[] rootIdKey = curRoot.getKey(0);
            newRoot = new IN(this.database, rootIdKey, this.maxMainTreeEntriesPerNode, curRoot.getLevel() + 1);
            newRoot.latch(cacheMode);
            newRoot.setIsRoot(true);
            curRoot.setIsRoot(false);
            try {
                curRootLsn = curRoot.optionalLogProvisional(logManager, newRoot);
                boolean insertOk = newRoot.insertEntry(new ChildReference(curRoot, rootIdKey, curRootLsn));
                assert (insertOk);
                logLsn = newRoot.optionalLog(logManager);
            }
            catch (DatabaseException e) {
                curRoot.setIsRoot(true);
                throw e;
            }
            inMemoryINs.add(newRoot);
            this.root.setTarget(newRoot);
            this.root.updateLsnAfterOptionalLog(this.database, logLsn);
            curRoot.split(newRoot, 0, this.maxMainTreeEntriesPerNode, cacheMode);
            this.root.setLsn(newRoot.getLastFullVersion());
            Object var14_12 = null;
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            newRoot.releaseLatch();
            curRoot.releaseLatch();
            throw throwable;
        }
        newRoot.releaseLatch();
        curRoot.releaseLatch();
        ++this.treeStats.nRootSplits;
        this.traceSplitRoot(Level.FINE, TRACE_ROOT_SPLIT, newRoot, logLsn, curRoot, curRootLsn);
    }

    public IN search(byte[] key, SearchType searchType, long nid, BINBoundary binBoundary, CacheMode cacheMode) throws DatabaseException {
        IN rootIN = this.getRootIN(cacheMode);
        if (rootIN != null) {
            return this.searchSubTree(rootIN, key, searchType, nid, binBoundary, cacheMode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IN searchSplitsAllowed(byte[] key, long nid, CacheMode cacheMode) throws DatabaseException {
        IN insertTarget = null;
        while (insertTarget == null) {
            IN rootIN;
            boolean rootINLatched;
            boolean rootLatched;
            block12: {
                Object var13_12;
                this.rootLatch.acquireShared();
                rootLatched = true;
                boolean rootLatchedExclusive = false;
                rootINLatched = false;
                boolean success = false;
                rootIN = null;
                try {
                    while (this.rootExists()) {
                        rootIN = (IN)this.root.fetchTarget(this.database, null);
                        if (rootIN.needsSplitting()) {
                            if (!rootLatchedExclusive) {
                                rootIN = null;
                                this.rootLatch.release();
                                this.rootLatch.acquireExclusive();
                                rootLatchedExclusive = true;
                                continue;
                            }
                            this.splitRoot(cacheMode);
                            this.rootLatch.release();
                            rootLatched = false;
                            EnvironmentImpl env = this.database.getDbEnvironment();
                            env.getDbTree().optionalModifyDbRoot(this.database);
                            rootLatched = true;
                            this.rootLatch.acquireExclusive();
                            rootIN = (IN)this.root.fetchTarget(this.database, null);
                        }
                        rootIN.latch(cacheMode);
                        rootINLatched = true;
                        break;
                    }
                    success = true;
                    var13_12 = null;
                    if (success || !rootINLatched) break block12;
                }
                catch (Throwable throwable) {
                    var13_12 = null;
                    if (!success && rootINLatched) {
                        rootIN.releaseLatch();
                    }
                    if (rootLatched) {
                        this.rootLatch.release();
                    }
                    throw throwable;
                }
                rootIN.releaseLatch();
            }
            if (rootLatched) {
                this.rootLatch.release();
            }
            if (rootIN == null) break;
            try {
                assert (rootINLatched);
                insertTarget = this.searchSubTreeSplitsAllowed(rootIN, key, nid, cacheMode);
            }
            catch (SplitRequiredException e) {}
        }
        return insertTarget;
    }

    public IN searchSubTree(IN parent, byte[] key, SearchType searchType, long nid, BINBoundary binBoundary, CacheMode cacheMode) throws DatabaseException {
        for (int i = 0; i < 2; ++i) {
            try {
                return this.searchSubTreeInternal(parent, key, searchType, nid, binBoundary, cacheMode);
            }
            catch (RelatchRequiredException RRE) {
                parent = this.getRootINLatchedExclusive(cacheMode);
                continue;
            }
        }
        throw new DatabaseException("searchSubTreeInternal should have completed in two tries");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IN searchSubTreeInternal(IN parent, byte[] key, SearchType searchType, long nid, BINBoundary binBoundary, CacheMode cacheMode) throws DatabaseException {
        if (parent == null) {
            return null;
        }
        if ((searchType == SearchType.LEFT || searchType == SearchType.RIGHT) && key != null) {
            throw new IllegalArgumentException("searchSubTree passed key and left/right search");
        }
        assert (parent.isLatchOwnerForRead());
        if (parent.getNodeId() == nid) {
            parent.releaseLatch();
            return null;
        }
        if (binBoundary != null) {
            binBoundary.isLastBin = true;
            binBoundary.isFirstBin = true;
        }
        IN child = null;
        IN grandParent = null;
        boolean childIsLatched = false;
        boolean grandParentIsLatched = false;
        boolean maintainGrandParentLatches = !parent.isLatchOwnerForWrite();
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        try {
            try {}
            catch (Exception t) {
                try {
                    if (child != null && childIsLatched) {
                        child.releaseLatch();
                    }
                    if (parent != child) {
                        parent.releaseLatch();
                    }
                }
                catch (Exception t2) {
                    t2.printStackTrace();
                }
                if (!(t instanceof DatabaseException)) throw new DatabaseException(t);
                throw (DatabaseException)t;
            }
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            if (grandParent == null) throw throwable;
            if (!grandParentIsLatched) throw throwable;
            grandParent.releaseLatch();
            grandParentIsLatched = false;
            throw throwable;
        }
        do {
            int index;
            if (treeStatsAccumulator != null) {
                parent.accumulateStats(treeStatsAccumulator);
            }
            if (parent.getNEntries() == 0) {
                IN iN = parent;
                Object var18_18 = null;
                if (grandParent == null) return iN;
                if (!grandParentIsLatched) return iN;
                grandParent.releaseLatch();
                return iN;
            }
            if (searchType == SearchType.NORMAL) {
                index = parent.findEntry(key, false, false);
            } else if (searchType == SearchType.LEFT) {
                index = 0;
            } else {
                if (searchType != SearchType.RIGHT) throw new IllegalArgumentException("Invalid value of searchType: " + searchType);
                index = parent.getNEntries() - 1;
            }
            assert (index >= 0);
            if (binBoundary != null) {
                if (index != parent.getNEntries() - 1) {
                    binBoundary.isLastBin = false;
                }
                if (index != 0) {
                    binBoundary.isFirstBin = false;
                }
            }
            if (maintainGrandParentLatches && parent.getTarget(index) == null && !parent.isAlwaysLatchedExclusively()) {
                if (grandParent == null) {
                    throw relatchRequiredException;
                }
                parent.releaseLatch();
                parent.latch(cacheMode);
                if (grandParent != null) {
                    grandParent.releaseLatch();
                    grandParentIsLatched = false;
                    grandParent = null;
                }
            }
            child = (IN)parent.fetchTarget(index);
            if (grandParent != null) {
                grandParent.releaseLatch();
                grandParentIsLatched = false;
            }
            if (maintainGrandParentLatches) {
                child.latchShared(cacheMode);
            } else {
                child.latch(cacheMode);
            }
            childIsLatched = true;
            if (treeStatsAccumulator != null) {
                child.accumulateStats(treeStatsAccumulator);
            }
            if (child.getNodeId() == nid) {
                child.releaseLatch();
                childIsLatched = false;
                IN iN = parent;
                Object var18_19 = null;
                if (grandParent == null) return iN;
                if (!grandParentIsLatched) return iN;
                grandParent.releaseLatch();
                return iN;
            }
            if (maintainGrandParentLatches) {
                grandParent = parent;
                grandParentIsLatched = true;
                continue;
            }
            parent.releaseLatch();
        } while (!((parent = child) instanceof BIN));
        IN iN = child;
        Object var18_20 = null;
        if (grandParent == null) return iN;
        if (!grandParentIsLatched) return iN;
        grandParent.releaseLatch();
        return iN;
    }

    public void searchDeletableSubTree(IN parent, byte[] key, ArrayList<SplitInfo> nodeLadder) throws DatabaseException, NodeNotEmptyException, CursorsExistException {
        assert (parent != null);
        assert (key != null);
        assert (parent.isLatchOwnerForWrite());
        IN child = null;
        IN lowestMultipleEntryIN = null;
        while (parent.getNEntries() != 0) {
            if (parent.getNEntries() > 1) {
                lowestMultipleEntryIN = parent;
            }
            int index = parent.findEntry(key, false, false);
            assert (index >= 0);
            child = (IN)parent.fetchTarget(index);
            child.latch(CacheMode.UNCHANGED);
            nodeLadder.add(new SplitInfo(parent, child, index));
            parent = child;
            if (!(parent instanceof BIN)) continue;
        }
        if (child != null && child instanceof BIN) {
            if (child.getNEntries() != 0) {
                throw NodeNotEmptyException.NODE_NOT_EMPTY;
            }
            if (((BIN)child).nCursors() > 0) {
                throw CursorsExistException.CURSORS_EXIST;
            }
        }
        if (lowestMultipleEntryIN != null) {
            ListIterator<SplitInfo> iter = nodeLadder.listIterator(nodeLadder.size());
            while (iter.hasPrevious()) {
                SplitInfo info = iter.previous();
                if (info.parent != lowestMultipleEntryIN) {
                    info.child.releaseLatch();
                    iter.remove();
                    continue;
                }
                break;
            }
        } else {
            this.releaseNodeLadderLatches(nodeLadder);
            nodeLadder.clear();
        }
    }

    private IN searchSubTreeSplitsAllowed(IN parent, byte[] key, long nid, CacheMode cacheMode) throws DatabaseException, SplitRequiredException {
        if (parent != null) {
            while (true) {
                try {
                    return this.searchSubTreeUntilSplit(parent, key, nid, cacheMode);
                }
                catch (SplitRequiredException e) {
                    assert (TestHookExecute.doHookIfSet(this.waitHook));
                    parent = this.forceSplit(parent, key, cacheMode);
                    continue;
                }
                break;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IN searchSubTreeUntilSplit(IN parent, byte[] key, long nid, CacheMode cacheMode) throws DatabaseException, SplitRequiredException {
        IN iN;
        boolean success;
        boolean childIsLatched;
        IN child;
        block15: {
            IN iN2;
            block14: {
                IN iN3;
                block12: {
                    block13: {
                        assert (parent.isLatchOwnerForWrite());
                        if (parent.getNodeId() == nid) {
                            parent.releaseLatch();
                            return null;
                        }
                        child = null;
                        childIsLatched = false;
                        success = false;
                        try {
                            do {
                                if (parent.getNEntries() == 0) {
                                    success = true;
                                    iN3 = parent;
                                    Object var12_12 = null;
                                    if (success) return iN3;
                                    if (child == null || !childIsLatched) break block12;
                                    break block13;
                                }
                                int index = parent.findEntry(key, false, false);
                                assert (index >= 0);
                                child = (IN)parent.fetchTarget(index);
                                child.latch(cacheMode);
                                childIsLatched = true;
                                if (child.needsSplitting()) {
                                    throw splitRequiredException;
                                }
                                if (child.getNodeId() == nid) {
                                    child.releaseLatch();
                                    childIsLatched = false;
                                    success = true;
                                    iN2 = parent;
                                    break block14;
                                }
                                parent.releaseLatch();
                            } while (!((parent = child) instanceof BIN));
                            success = true;
                            iN = parent;
                            break block15;
                        }
                        catch (Throwable throwable) {
                            Object var12_15 = null;
                            if (success) throw throwable;
                            if (child != null && childIsLatched) {
                                child.releaseLatch();
                            }
                            if (parent == child) throw throwable;
                            parent.releaseLatch();
                            throw throwable;
                        }
                    }
                    child.releaseLatch();
                }
                if (parent == child) return iN3;
                parent.releaseLatch();
                return iN3;
            }
            Object var12_13 = null;
            if (success) return iN2;
            if (child != null && childIsLatched) {
                child.releaseLatch();
            }
            if (parent == child) return iN2;
            parent.releaseLatch();
            return iN2;
        }
        Object var12_14 = null;
        if (success) return iN;
        if (child != null && childIsLatched) {
            child.releaseLatch();
        }
        if (parent == child) return iN;
        parent.releaseLatch();
        return iN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN forceSplit(IN parent, byte[] key, CacheMode cacheMode) throws DatabaseException, SplitRequiredException {
        boolean isRootLatched;
        IN originalParent;
        block24: {
            ListIterator iter;
            ArrayList<SplitInfo> nodeLadder;
            block25: {
                nodeLadder = new ArrayList<SplitInfo>();
                boolean allLeftSideDescent = true;
                boolean allRightSideDescent = true;
                IN child = null;
                originalParent = parent;
                iter = null;
                isRootLatched = false;
                boolean success = false;
                try {
                    int index;
                    if (originalParent.isDbRoot()) {
                        this.rootLatch.acquireExclusive();
                        isRootLatched = true;
                        originalParent = parent = (IN)this.root.fetchTarget(this.database, null);
                    }
                    originalParent.latch(cacheMode);
                    if (originalParent.needsSplitting() || !originalParent.isRoot()) {
                        throw splitRequiredException;
                    }
                    while (parent.getNEntries() != 0) {
                        index = parent.findEntry(key, false, false);
                        if (index != 0) {
                            allLeftSideDescent = false;
                        }
                        if (index != parent.getNEntries() - 1) {
                            allRightSideDescent = false;
                        }
                        assert (index >= 0);
                        child = (IN)parent.getTarget(index);
                        if (child == null) break;
                        child.latch(cacheMode);
                        nodeLadder.add(new SplitInfo(parent, child, index));
                        parent = child;
                        if (!(parent instanceof BIN)) continue;
                    }
                    boolean startedSplits = false;
                    LogManager logManager = this.database.getDbEnvironment().getLogManager();
                    iter = nodeLadder.listIterator(nodeLadder.size());
                    long lastParentForSplit = -1L;
                    while (iter.hasPrevious()) {
                        SplitInfo info = (SplitInfo)iter.previous();
                        iter.remove();
                        child = info.child;
                        parent = info.parent;
                        index = info.index;
                        if (child.needsSplitting()) {
                            int maxEntriesPerNode;
                            int n = maxEntriesPerNode = child.containsDuplicates() ? this.maxDupTreeEntriesPerNode : this.maxMainTreeEntriesPerNode;
                            if (allLeftSideDescent || allRightSideDescent) {
                                child.splitSpecial(parent, index, maxEntriesPerNode, key, allLeftSideDescent, cacheMode);
                            } else {
                                child.split(parent, index, maxEntriesPerNode, cacheMode);
                            }
                            lastParentForSplit = parent.getNodeId();
                            startedSplits = true;
                            if (parent.isDbRoot()) {
                                assert (isRootLatched);
                                this.root.setLsn(parent.getLastFullVersion());
                                parent.setDirty(true);
                            }
                        } else if (startedSplits) {
                            long newLsn = 0L;
                            newLsn = lastParentForSplit == child.getNodeId() ? child.getLastFullVersion() : child.optionalLog(logManager);
                            parent.updateEntry(index, newLsn);
                        }
                        child.releaseLatch();
                        child = null;
                    }
                    success = true;
                    Object var21_19 = null;
                    if (success) break block24;
                    if (child == null) break block25;
                }
                catch (Throwable throwable) {
                    Object var21_20 = null;
                    if (!success) {
                        if (child != null) {
                            child.releaseLatch();
                        }
                        if (nodeLadder.size() > 0) {
                            iter = nodeLadder.listIterator(nodeLadder.size());
                            while (iter.hasPrevious()) {
                                SplitInfo info = (SplitInfo)iter.previous();
                                info.child.releaseLatch();
                            }
                        }
                        originalParent.releaseLatch();
                    }
                    if (isRootLatched) {
                        this.rootLatch.release();
                    }
                    throw throwable;
                }
                child.releaseLatch();
            }
            if (nodeLadder.size() > 0) {
                iter = nodeLadder.listIterator(nodeLadder.size());
                while (iter.hasPrevious()) {
                    SplitInfo info = (SplitInfo)iter.previous();
                    info.child.releaseLatch();
                }
            }
            originalParent.releaseLatch();
        }
        if (isRootLatched) {
            this.rootLatch.release();
        }
        return originalParent;
    }

    public IN getRootIN(CacheMode cacheMode) throws DatabaseException {
        return this.getRootINInternal(cacheMode, false);
    }

    public IN getRootINLatchedExclusive(CacheMode cacheMode) throws DatabaseException {
        return this.getRootINInternal(cacheMode, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN getRootINInternal(CacheMode cacheMode, boolean exclusive) throws DatabaseException {
        IN iN;
        this.rootLatch.acquireShared();
        IN rootIN = null;
        try {
            if (this.rootExists()) {
                rootIN = (IN)this.root.fetchTarget(this.database, null);
                if (exclusive) {
                    rootIN.latch(cacheMode);
                } else {
                    rootIN.latchShared(cacheMode);
                }
            }
            iN = rootIN;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.rootLatch.release();
            throw throwable;
        }
        this.rootLatch.release();
        return iN;
    }

    public IN getResidentRootIN(boolean latched) throws DatabaseException {
        IN rootIN = null;
        if (this.rootExists() && (rootIN = (IN)this.root.getTarget()) != null && latched) {
            rootIN.latchShared(CacheMode.UNCHANGED);
        }
        return rootIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(LN ln, byte[] key, boolean allowDuplicates, CursorImpl cursor, LockResult lnLock, ReplicationContext repContext) throws DatabaseException {
        BIN bin;
        INList inMemoryINs;
        LogManager logManager;
        block20: {
            int index;
            EnvironmentImpl env;
            block19: {
                boolean bl;
                this.validateInsertArgs(allowDuplicates);
                env = this.database.getDbEnvironment();
                logManager = env.getLogManager();
                inMemoryINs = env.getInMemoryINs();
                bin = null;
                try {
                    bin = this.findBinForInsert(key, logManager, inMemoryINs, cursor);
                    assert (bin.isLatchOwnerForWrite());
                    ChildReference newLNRef = new ChildReference(ln, key, -1L);
                    cursor.setBIN(bin);
                    index = bin.insertEntry1(newLNRef);
                    if ((index & 0x20000) == 0) break block19;
                    cursor.updateBin(bin, index &= 0xFFFDFFFF);
                    long newLsn = -1L;
                    try {
                        newLsn = ln.optionalLog(env, this.database, key, -1L, cursor.getLocker(), repContext);
                        Object var16_15 = null;
                        if (newLsn == -1L && !this.database.isDeferredWriteMode()) {
                            bin.setKnownDeleted(index);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_16 = null;
                        if (newLsn == -1L && !this.database.isDeferredWriteMode()) {
                            bin.setKnownDeleted(index);
                        }
                        throw throwable;
                    }
                    lnLock.setAbortLsn(-1L, true, true);
                    bin.updateEntry(index, newLsn);
                    this.traceInsert(Level.FINER, env, bin, ln, newLsn, index);
                    bl = true;
                    Object var26_21 = null;
                }
                catch (Throwable throwable) {
                    Object var26_24 = null;
                    cursor.releaseBIN();
                    throw throwable;
                }
                cursor.releaseBIN();
                return bl;
            }
            cursor.updateBin(bin, index &= 0xFFFEFFFF);
            if (this.database.getSortedDuplicates() && this.database.getBtreeComparator() != null && !Arrays.equals(key, bin.getKey(index))) {
                throw new IllegalArgumentException("Custom Btree comparator matches two non-identical keys in a Database with duplicates configured");
            }
            LN currentLN = null;
            boolean isDup = false;
            Node n = bin.fetchTarget(index);
            if (n == null || n instanceof LN) {
                currentLN = (LN)n;
            } else {
                isDup = true;
            }
            boolean isDeleted = false;
            LockResult currentLock = null;
            if (!isDup) {
                if (currentLN == null) {
                    isDeleted = true;
                } else {
                    currentLock = cursor.lockLNDeletedAllowed(currentLN, LockType.WRITE);
                    currentLN = currentLock.getLN();
                    bin = cursor.getBIN();
                    index = cursor.getIndex();
                    if (cursor.getDupBIN() != null) {
                        cursor.clearDupBIN(true);
                        isDup = true;
                    } else if (bin.isEntryKnownDeleted(index) || currentLN == null || currentLN.isDeleted()) {
                        isDeleted = true;
                    }
                }
            }
            if (!isDeleted) break block20;
            long abortLsn = bin.getLsn(index);
            boolean abortKnownDeleted = true;
            if (currentLN != null && currentLock.getLockGrant() == LockGrantType.EXISTING) {
                long nodeId = currentLN.getNodeId();
                Locker locker = cursor.getLocker();
                WriteLockInfo info = locker.getWriteLockInfo(nodeId);
                abortLsn = info.getAbortLsn();
                abortKnownDeleted = info.getAbortKnownDeleted();
                lnLock.copyAbortInfo(info);
            }
            lnLock.setAbortLsn(abortLsn, abortKnownDeleted);
            long newLsn = ln.optionalLog(env, this.database, key, -1L, cursor.getLocker(), repContext);
            bin.updateEntry(index, ln, newLsn, key);
            bin.clearKnownDeleted(index);
            bin.clearPendingDeleted(index);
            this.traceInsert(Level.FINER, env, bin, ln, newLsn, index);
            boolean bl = true;
            Object var26_22 = null;
            cursor.releaseBIN();
            return bl;
        }
        boolean bl = this.insertDuplicate(key, bin, ln, logManager, inMemoryINs, cursor, lnLock, allowDuplicates, repContext);
        Object var26_23 = null;
        cursor.releaseBIN();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean insertDuplicate(byte[] key, BIN bin, LN newLN, LogManager logManager, INList inMemoryINs, CursorImpl cursor, LockResult lnLock, boolean allowDuplicates, ReplicationContext repContext) throws DatabaseException {
        EnvironmentImpl env = this.database.getDbEnvironment();
        int index = cursor.getIndex();
        boolean successfulInsert = false;
        DIN dupRoot = null;
        Node n = bin.fetchTarget(index);
        long binNid = bin.getNodeId();
        if (n instanceof DIN) {
            IN dupBin;
            block28: {
                boolean bl;
                block25: {
                    block26: {
                        dupBin = null;
                        try {
                            CacheMode cacheMode = cursor.getCacheMode();
                            dupRoot = (DIN)n;
                            dupRoot.latch(cacheMode);
                            LockResult dclLockResult = cursor.lockDupCountLN(dupRoot, LockType.WRITE);
                            bin = cursor.getBIN();
                            index = cursor.getIndex();
                            if (!allowDuplicates) {
                                dupRoot = (DIN)bin.fetchTarget(index);
                                DupCountLN dcl = (DupCountLN)dclLockResult.getLN();
                                if (dcl.getDupCount() > 0) {
                                    bl = false;
                                    Object var38_22 = null;
                                    if (dupBin == null) break block25;
                                    break block26;
                                }
                            }
                            this.maybeSplitDuplicateRoot(bin, index, cacheMode);
                            dupRoot = (DIN)bin.fetchTarget(index);
                            byte[] newLNKey = newLN.getData();
                            long previousLsn = dupRoot.getLastFullVersion();
                            try {
                                dupBin = (DBIN)this.searchSubTreeSplitsAllowed(dupRoot, newLNKey, -1L, cacheMode);
                            }
                            catch (SplitRequiredException e) {
                                throw new DatabaseException(e);
                            }
                            long currentLsn = dupRoot.getLastFullVersion();
                            if (currentLsn != previousLsn) {
                                bin.updateEntry(index, currentLsn);
                            }
                            cursor.releaseBIN();
                            bin = null;
                            dupRoot = null;
                            ChildReference newLNRef = new ChildReference(newLN, newLNKey, -1L);
                            int dupIndex = dupBin.insertEntry1(newLNRef);
                            if ((dupIndex & 0x20000) != 0) {
                                long newLsn;
                                block27: {
                                    cursor.updateDBin((DBIN)dupBin, dupIndex &= 0xFFFDFFFF);
                                    newLsn = -1L;
                                    try {
                                        newLsn = newLN.optionalLog(env, this.database, key, -1L, cursor.getLocker(), repContext);
                                        Object var30_31 = null;
                                        if (newLsn != -1L || this.database.isDeferredWriteMode()) break block27;
                                    }
                                    catch (Throwable throwable) {
                                        Object var30_32 = null;
                                        if (newLsn != -1L) throw throwable;
                                        if (this.database.isDeferredWriteMode()) throw throwable;
                                        ((BIN)dupBin).setKnownDeleted(dupIndex);
                                        throw throwable;
                                    }
                                    ((BIN)dupBin).setKnownDeleted(dupIndex);
                                }
                                lnLock.setAbortLsn(-1L, true, true);
                                dupBin.updateEntry(dupIndex, newLsn);
                                this.traceInsertDuplicate(Level.FINER, this.database.getDbEnvironment(), (BIN)dupBin, newLN, newLsn, binNid);
                                successfulInsert = true;
                            } else {
                                cursor.updateDBin((DBIN)dupBin, dupIndex &= 0xFFFEFFFF);
                                LN currentLN = (LN)dupBin.fetchTarget(dupIndex);
                                boolean isDeleted = false;
                                LockResult currentLock = null;
                                if (currentLN == null) {
                                    isDeleted = true;
                                } else {
                                    currentLock = cursor.lockLNDeletedAllowed(currentLN, LockType.WRITE);
                                    currentLN = currentLock.getLN();
                                    cursor.releaseBIN();
                                    dupBin = cursor.getDupBIN();
                                    dupIndex = cursor.getDupIndex();
                                    if (dupBin.isEntryKnownDeleted(dupIndex) || currentLN == null || currentLN.isDeleted()) {
                                        isDeleted = true;
                                    }
                                }
                                if (isDeleted) {
                                    long abortLsn = dupBin.getLsn(dupIndex);
                                    boolean abortKnownDeleted = true;
                                    if (currentLN != null && currentLock.getLockGrant() == LockGrantType.EXISTING) {
                                        long nodeId = currentLN.getNodeId();
                                        Locker locker = cursor.getLocker();
                                        WriteLockInfo info = locker.getWriteLockInfo(nodeId);
                                        abortLsn = info.getAbortLsn();
                                        abortKnownDeleted = info.getAbortKnownDeleted();
                                        lnLock.copyAbortInfo(info);
                                    }
                                    lnLock.setAbortLsn(abortLsn, abortKnownDeleted);
                                    long newLsn = newLN.optionalLog(env, this.database, key, -1L, cursor.getLocker(), repContext);
                                    dupBin.updateEntry(dupIndex, newLN, newLsn, newLNKey);
                                    ((BIN)dupBin).clearKnownDeleted(dupIndex);
                                    dupBin.clearPendingDeleted(dupIndex);
                                    this.traceInsertDuplicate(Level.FINER, this.database.getDbEnvironment(), (BIN)dupBin, newLN, newLsn, binNid);
                                    successfulInsert = true;
                                } else {
                                    successfulInsert = false;
                                }
                            }
                            dupBin.releaseLatch();
                            dupBin = null;
                            if (successfulInsert) {
                                cursor.latchBIN();
                                dupRoot = cursor.getLatchedDupRoot(false);
                                cursor.releaseBIN();
                                dupRoot.incrementDuplicateCount(dclLockResult, key, cursor.getLocker(), true);
                            }
                            break block28;
                        }
                        catch (Throwable throwable) {
                            Object var38_24 = null;
                            if (dupBin != null) {
                                dupBin.releaseLatch();
                            }
                            if (dupRoot == null) throw throwable;
                            dupRoot.releaseLatch();
                            throw throwable;
                        }
                    }
                    dupBin.releaseLatch();
                }
                if (dupRoot == null) return bl;
                dupRoot.releaseLatch();
                return bl;
            }
            Object var38_23 = null;
            if (dupBin != null) {
                dupBin.releaseLatch();
            }
            if (dupRoot == null) return successfulInsert;
            dupRoot.releaseLatch();
            return successfulInsert;
        }
        if (!(n instanceof LN)) throw new InconsistentNodeException("neither LN or DIN found in BIN");
        if (!allowDuplicates) {
            return false;
        }
        try {
            lnLock.setAbortLsn(-1L, true, true);
            dupRoot = this.createDuplicateTree(key, logManager, inMemoryINs, newLN, cursor, repContext);
            Object var40_42 = null;
            if (dupRoot == null) return false;
        }
        catch (Throwable throwable) {
            Object var40_43 = null;
            if (dupRoot != null) {
                dupRoot.releaseLatch();
                successfulInsert = true;
                throw throwable;
            }
            successfulInsert = false;
            throw throwable;
        }
        dupRoot.releaseLatch();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeSplitDuplicateRoot(BIN bin, int index, CacheMode cacheMode) throws DatabaseException {
        DIN curRoot = (DIN)bin.fetchTarget(index);
        if (curRoot.needsSplitting()) {
            EnvironmentImpl env = this.database.getDbEnvironment();
            LogManager logManager = env.getLogManager();
            INList inMemoryINs = env.getInMemoryINs();
            byte[] rootIdKey = curRoot.getKey(0);
            DIN newRoot = new DIN(this.database, rootIdKey, this.maxDupTreeEntriesPerNode, curRoot.getDupKey(), curRoot.getDupCountLNRef(), curRoot.getLevel() + 1);
            newRoot.latch(cacheMode);
            long curRootLsn = 0L;
            long logLsn = 0L;
            try {
                newRoot.setIsRoot(true);
                curRoot.setDupCountLN(null);
                curRoot.setIsRoot(false);
                try {
                    curRootLsn = curRoot.optionalLogProvisional(logManager, newRoot);
                    boolean insertOk = newRoot.insertEntry(new ChildReference(curRoot, rootIdKey, bin.getLsn(index)));
                    assert (insertOk);
                    logLsn = newRoot.optionalLog(logManager);
                }
                catch (DatabaseException e) {
                    curRoot.setIsRoot(true);
                    throw e;
                }
                inMemoryINs.add(newRoot);
                bin.updateNode(index, newRoot, logLsn, null);
                curRoot.split(newRoot, 0, this.maxDupTreeEntriesPerNode, cacheMode);
                Object var16_14 = null;
            }
            catch (Throwable throwable) {
                Object var16_15 = null;
                curRoot.releaseLatch();
                throw throwable;
            }
            curRoot.releaseLatch();
            this.traceSplitRoot(Level.FINE, TRACE_DUP_ROOT_SPLIT, newRoot, logLsn, curRoot, curRootLsn);
            return true;
        }
        return false;
    }

    private DIN createDuplicateTree(byte[] key, LogManager logManager, INList inMemoryINs, LN newLN, CursorImpl cursor, ReplicationContext repContext) throws DatabaseException {
        long nodeId;
        boolean keysEqual;
        boolean existingLNIsDeleted;
        EnvironmentImpl env = this.database.getDbEnvironment();
        DIN dupRoot = null;
        DBIN dupBin = null;
        boolean dupBinIsLatched = false;
        BIN bin = cursor.getBIN();
        int index = cursor.getIndex();
        LN existingLN = (LN)bin.fetchTarget(index);
        boolean bl = existingLNIsDeleted = bin.isEntryKnownDeleted(index) || existingLN.isDeleted();
        assert (existingLN != null);
        byte[] existingKey = existingLN.getData();
        byte[] newLNKey = newLN.getData();
        boolean bl2 = keysEqual = Key.compareKeys(newLNKey, existingKey, this.database.getDuplicateComparator()) == 0;
        if (keysEqual) {
            return null;
        }
        Locker locker = cursor.getLocker();
        int startingCount = locker.createdNode(nodeId = existingLN.getNodeId()) || existingLNIsDeleted || locker.getWriteLockInfo(nodeId).getAbortKnownDeleted() ? 0 : 1;
        DupCountLN dupCountLN = new DupCountLN(this.database.getDbEnvironment(), startingCount);
        long firstDupCountLNLsn = dupCountLN.optionalLogProvisional(env, this.database, key, -1L, ReplicationContext.NO_REPLICATE);
        dupRoot = new DIN(this.database, existingKey, this.maxDupTreeEntriesPerNode, key, new ChildReference(dupCountLN, key, firstDupCountLNLsn), 2);
        CacheMode cacheMode = cursor.getCacheMode();
        dupRoot.latch(cacheMode);
        dupRoot.setIsRoot(true);
        dupBin = new DBIN(this.database, existingKey, this.maxDupTreeEntriesPerNode, key, 1);
        dupBin.latch(cacheMode);
        dupBinIsLatched = true;
        ChildReference newExistingLNRef = new ChildReference(existingLN, existingKey, bin.getLsn(index), bin.getState(index));
        boolean insertOk = dupBin.insertEntry(newExistingLNRef);
        assert (insertOk);
        try {
            long dbinLsn = dupBin.optionalLogProvisional(logManager, dupRoot);
            inMemoryINs.add(dupBin);
            dupRoot.setEntry(0, dupBin, dupBin.getKey(0), dbinLsn, dupBin.getState(0));
            long dinLsn = dupRoot.optionalLog(logManager);
            inMemoryINs.add(dupRoot);
            LockResult lockResult = locker.lock(dupCountLN.getNodeId(), LockType.WRITE, false, this.database);
            lockResult.setAbortLsn(firstDupCountLNLsn, false);
            dupCountLN.setDupCount(2);
            long dupCountLsn = dupCountLN.optionalLog(env, this.database, key, firstDupCountLNLsn, locker, ReplicationContext.NO_REPLICATE);
            dupRoot.updateDupCountLNRef(dupCountLsn);
            long newLsn = newLN.optionalLog(env, this.database, key, -1L, locker, repContext);
            int dupIndex = dupBin.insertEntry1(new ChildReference(newLN, newLNKey, newLsn));
            cursor.updateDBin(dupBin, dupIndex &= 0xFFFDFFFF);
            bin.adjustCursorsForMutation(index, dupBin, dupIndex ^ 1, cursor);
            dupBin.releaseLatch();
            dupBinIsLatched = false;
            bin.updateNode(index, dupRoot, dinLsn, null);
            bin.setMigrate(index, false);
            this.traceMutate(Level.FINE, bin, existingLN, newLN, newLsn, dupCountLN, dupCountLsn, dupRoot, dinLsn, dupBin, dbinLsn);
        }
        catch (DatabaseException e) {
            if (dupBinIsLatched) {
                dupBin.releaseLatch();
            }
            dupRoot.releaseLatch();
            throw e;
        }
        return dupRoot;
    }

    private void validateInsertArgs(boolean allowDuplicates) throws DatabaseException {
        if (allowDuplicates && !this.database.getSortedDuplicates()) {
            throw new DatabaseException("allowDuplicates passed to insert but database doesn't have allow duplicates set.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BIN findBinForInsert(byte[] key, LogManager logManager, INList inMemoryINs, CursorImpl cursor) throws DatabaseException {
        BIN bin;
        block11: {
            bin = cursor.latchBIN();
            if (bin != null) {
                if (!bin.needsSplitting() && bin.isKeyInBounds(key)) {
                    return bin;
                }
                bin.releaseLatch();
            }
            boolean rootLatchIsHeld = false;
            try {
                block10: {
                    IN in;
                    while (true) {
                        rootLatchIsHeld = true;
                        this.rootLatch.acquireShared();
                        if (!this.rootExists()) {
                            this.rootLatch.release();
                            this.rootLatch.acquireExclusive();
                            if (this.rootExists()) {
                                this.rootLatch.release();
                                rootLatchIsHeld = false;
                                continue;
                            }
                            CacheMode cacheMode = cursor.getCacheMode();
                            bin = new BIN(this.database, key, this.maxMainTreeEntriesPerNode, 1);
                            bin.latch(cacheMode);
                            long logLsn = bin.optionalLogProvisional(logManager, null);
                            IN rootIN = new IN(this.database, key, this.maxMainTreeEntriesPerNode, 2);
                            rootIN.latch(cacheMode);
                            rootIN.setIsRoot(true);
                            boolean insertOk = rootIN.insertEntry(new ChildReference(bin, key, logLsn));
                            assert (insertOk);
                            logLsn = rootIN.optionalLog(logManager);
                            rootIN.setDirty(true);
                            this.root = this.makeRootChildReference(rootIN, new byte[0], logLsn);
                            rootIN.releaseLatch();
                            inMemoryINs.add(bin);
                            inMemoryINs.add(rootIN);
                            this.rootLatch.release();
                            rootLatchIsHeld = false;
                            break block10;
                        }
                        this.rootLatch.release();
                        rootLatchIsHeld = false;
                        in = this.searchSplitsAllowed(key, -1L, cursor.getCacheMode());
                        if (in != null) break;
                    }
                    bin = (BIN)in;
                }
                Object var13_11 = null;
                if (!rootLatchIsHeld) break block11;
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                if (rootLatchIsHeld) {
                    this.rootLatch.release();
                }
                throw throwable;
            }
            this.rootLatch.release();
        }
        assert (TestHookExecute.doHookIfSet(this.ckptHook));
        return bin;
    }

    private void accountForSubtreeRemoval(INList inList, IN subtreeRoot, LocalUtilizationTracker localTracker) throws DatabaseException {
        subtreeRoot.accountForSubtreeRemoval(inList, localTracker);
        Tracer.trace(Level.FINE, this.database.getDbEnvironment(), "SubtreeRemoval: subtreeRoot = " + subtreeRoot.getNodeId());
    }

    @Override
    public int getLogSize() {
        int size = 1;
        if (this.root != null) {
            size += this.root.getLogSize();
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        byte booleans = (byte)(this.root != null ? 1 : 0);
        logBuffer.put(booleans);
        if (this.root != null) {
            this.root.writeToLog(logBuffer);
        }
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) {
        boolean rootExists = false;
        byte booleans = itemBuffer.get();
        boolean bl = rootExists = (booleans & 1) != 0;
        if (rootExists) {
            this.root = this.makeRootChildReference();
            this.root.readFromLog(itemBuffer, entryVersion);
        }
    }

    @Override
    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<root>");
        if (this.root != null) {
            this.root.dumpLog(sb, verbose);
        }
        sb.append("</root>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildINList() throws DatabaseException {
        INList inMemoryList = this.database.getDbEnvironment().getInMemoryINs();
        if (this.root != null) {
            this.rootLatch.acquireShared();
            try {
                Node rootIN = this.root.getTarget();
                if (rootIN != null) {
                    rootIN.rebuildINList(inMemoryList);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.rootLatch.release();
                throw throwable;
            }
            this.rootLatch.release();
            {
            }
        }
    }

    public void dump() throws DatabaseException {
        System.out.println(this.dumpString(0));
    }

    public String dumpString(int nSpaces) throws DatabaseException {
        StringBuffer sb = new StringBuffer();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<tree>");
        sb.append('\n');
        if (this.root != null) {
            sb.append(DbLsn.dumpString(this.root.getLsn(), nSpaces));
            sb.append('\n');
            IN rootIN = (IN)this.root.getTarget();
            if (rootIN == null) {
                sb.append("<in/>");
            } else {
                sb.append(rootIN.toString());
            }
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("</tree>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateDelete(int index) throws DatabaseException {
        boolean bl;
        this.rootLatch.acquireShared();
        try {
            IN rootIN = (IN)this.root.fetchTarget(this.database, null);
            bl = rootIN.validateSubtreeBeforeDelete(index);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.rootLatch.release();
            throw throwable;
        }
        this.rootLatch.release();
        return bl;
    }

    public void validateINList(IN parent) throws DatabaseException {
        if (parent == null) {
            parent = (IN)this.root.getTarget();
        }
        if (parent != null) {
            INList inList = this.database.getDbEnvironment().getInMemoryINs();
            if (!inList.contains(parent)) {
                throw new DatabaseException("IN " + parent.getNodeId() + " missing from INList");
            }
            int i = 0;
            while (true) {
                block9: {
                    try {
                        Node node = parent.getTarget(i);
                        if (i >= parent.getNEntries()) {
                            if (node != null) {
                                throw new DatabaseException("IN " + parent.getNodeId() + " has stray node " + node.getNodeId() + " at index " + i);
                            }
                            byte[] key = parent.getKey(i);
                            if (key != null) {
                                throw new DatabaseException("IN " + parent.getNodeId() + " has stray key " + key + " at index " + i);
                            }
                        }
                        if (!(node instanceof IN)) break block9;
                        this.validateINList((IN)node);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public void setWaitHook(TestHook hook) {
        this.waitHook = hook;
    }

    public void setSearchHook(TestHook hook) {
        this.searchHook = hook;
    }

    public void setCkptHook(TestHook hook) {
        this.ckptHook = hook;
    }

    private void traceSplitRoot(Level level, String splitType, IN newRoot, long newRootLsn, IN oldRoot, long oldRootLsn) {
        Logger logger = this.database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(splitType);
            sb.append(" newRoot=").append(newRoot.getNodeId());
            sb.append(" newRootLsn=").append(DbLsn.getNoFormatString(newRootLsn));
            sb.append(" oldRoot=").append(oldRoot.getNodeId());
            sb.append(" oldRootLsn=").append(DbLsn.getNoFormatString(oldRootLsn));
            logger.log(level, sb.toString());
        }
    }

    private void traceMutate(Level level, BIN theBin, LN existingLn, LN newLn, long newLsn, DupCountLN dupCountLN, long dupRootLsn, DIN dupRoot, long ddinLsn, DBIN dupBin, long dbinLsn) {
        Logger logger = this.database.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_MUTATE);
            sb.append(" existingLn=");
            sb.append(existingLn.getNodeId());
            sb.append(" newLn=");
            sb.append(newLn.getNodeId());
            sb.append(" newLnLsn=");
            sb.append(DbLsn.getNoFormatString(newLsn));
            sb.append(" dupCountLN=");
            sb.append(dupCountLN.getNodeId());
            sb.append(" dupRootLsn=");
            sb.append(DbLsn.getNoFormatString(dupRootLsn));
            sb.append(" rootdin=");
            sb.append(dupRoot.getNodeId());
            sb.append(" ddinLsn=");
            sb.append(DbLsn.getNoFormatString(ddinLsn));
            sb.append(" dbin=");
            sb.append(dupBin.getNodeId());
            sb.append(" dbinLsn=");
            sb.append(DbLsn.getNoFormatString(dbinLsn));
            sb.append(" bin=");
            sb.append(theBin.getNodeId());
            logger.log(level, sb.toString());
        }
    }

    private void traceInsert(Level level, EnvironmentImpl env, BIN insertingBin, LN ln, long lnLsn, int index) {
        Logger logger = env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_INSERT);
            sb.append(" bin=");
            sb.append(insertingBin.getNodeId());
            sb.append(" ln=");
            sb.append(ln.getNodeId());
            sb.append(" lnLsn=");
            sb.append(DbLsn.getNoFormatString(lnLsn));
            sb.append(" index=");
            sb.append(index);
            logger.log(level, sb.toString());
        }
    }

    private void traceInsertDuplicate(Level level, EnvironmentImpl env, BIN insertingDBin, LN ln, long lnLsn, long binNid) {
        Logger logger = env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(TRACE_INSERT_DUPLICATE);
            sb.append(" dbin=");
            sb.append(insertingDBin.getNodeId());
            sb.append(" bin=");
            sb.append(binNid);
            sb.append(" ln=");
            sb.append(ln.getNodeId());
            sb.append(" lnLsn=");
            sb.append(DbLsn.getNoFormatString(lnLsn));
            logger.log(level, sb.toString());
        }
    }

    private static class SplitInfo {
        IN parent;
        IN child;
        int index;

        SplitInfo(IN parent, IN child, int index) {
            this.parent = parent;
            this.child = child;
            this.index = index;
        }
    }

    private static class RelatchRequiredException
    extends DatabaseException {
        private RelatchRequiredException() {
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private class RootChildReference
    extends ChildReference {
        private RootChildReference() {
        }

        private RootChildReference(Node target, byte[] key, long lsn) {
            super(target, key, lsn);
        }

        public Node fetchTarget(DatabaseImpl database, IN in) throws DatabaseException {
            if (this.getTarget() == null && !Tree.this.rootLatch.isWriteLockedByCurrentThread()) {
                Tree.this.rootLatch.release();
                Tree.this.rootLatch.acquireExclusive();
            }
            return super.fetchTarget(database, in);
        }

        public void setTarget(Node target) {
            assert (Tree.this.rootLatch.isWriteLockedByCurrentThread());
            super.setTarget(target);
        }

        public void clearTarget() {
            assert (Tree.this.rootLatch.isWriteLockedByCurrentThread());
            super.clearTarget();
        }

        public void setLsn(long lsn) {
            assert (Tree.this.rootLatch.isWriteLockedByCurrentThread());
            super.setLsn(lsn);
        }

        void updateLsnAfterOptionalLog(DatabaseImpl dbImpl, long lsn) {
            assert (Tree.this.rootLatch.isWriteLockedByCurrentThread());
            super.updateLsnAfterOptionalLog(dbImpl, lsn);
        }
    }

    public static class SearchType {
        public static final SearchType NORMAL = new SearchType();
        public static final SearchType LEFT = new SearchType();
        public static final SearchType RIGHT = new SearchType();

        private SearchType() {
        }
    }
}

