/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.events;

import freenet.client.events.ClientEvent;
import freenet.support.CurrentTimeUTC;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.Date;

public class SplitfileProgressEvent
implements ClientEvent {
    private static volatile boolean logMINOR;
    public static final int CODE = 7;
    public final int totalBlocks;
    public final int succeedBlocks;
    public final Date latestSuccess;
    public final int failedBlocks;
    public final int fatallyFailedBlocks;
    public final Date latestFailure;
    public final int minSuccessFetchBlocks;
    public int minSuccessfulBlocks;
    public final boolean finalizedTotal;

    public SplitfileProgressEvent(int totalBlocks, int succeedBlocks, Date latestSuccess, int failedBlocks, int fatallyFailedBlocks, Date latestFailure, int minSuccessfulBlocks, int minSuccessFetchBlocks, boolean finalizedTotal) {
        this.totalBlocks = totalBlocks;
        this.succeedBlocks = succeedBlocks;
        this.latestSuccess = latestSuccess != null ? (Date)latestSuccess.clone() : null;
        this.failedBlocks = failedBlocks;
        this.fatallyFailedBlocks = fatallyFailedBlocks;
        this.latestFailure = latestFailure != null ? (Date)latestFailure.clone() : null;
        this.minSuccessfulBlocks = minSuccessfulBlocks;
        this.finalizedTotal = finalizedTotal;
        this.minSuccessFetchBlocks = minSuccessFetchBlocks;
        if (logMINOR) {
            Logger.minor(this, "Created SplitfileProgressEvent: total=" + totalBlocks + " succeed=" + succeedBlocks + " failed=" + failedBlocks + " fatally=" + fatallyFailedBlocks + " min success=" + minSuccessfulBlocks + " finalized=" + finalizedTotal);
        }
    }

    protected SplitfileProgressEvent() {
        this.totalBlocks = 0;
        this.succeedBlocks = 0;
        this.latestSuccess = CurrentTimeUTC.get();
        this.failedBlocks = 0;
        this.fatallyFailedBlocks = 0;
        this.latestFailure = null;
        this.minSuccessFetchBlocks = 0;
        this.finalizedTotal = false;
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Completed ");
        if (this.minSuccessfulBlocks == 0 && this.succeedBlocks == 0) {
            this.minSuccessfulBlocks = 1;
        }
        if (this.minSuccessfulBlocks == 0) {
            if (Logger.LogLevel.MINOR.matchesThreshold(Logger.globalGetThresholdNew())) {
                Logger.error(this, "minSuccessfulBlocks=0, succeedBlocks=" + this.succeedBlocks + ", totalBlocks=" + this.totalBlocks + ", failedBlocks=" + this.failedBlocks + ", fatallyFailedBlocks=" + this.fatallyFailedBlocks + ", finalizedTotal=" + this.finalizedTotal, (Throwable)new Exception("debug"));
            } else {
                Logger.error(this, "minSuccessfulBlocks=0, succeedBlocks=" + this.succeedBlocks + ", totalBlocks=" + this.totalBlocks + ", failedBlocks=" + this.failedBlocks + ", fatallyFailedBlocks=" + this.fatallyFailedBlocks + ", finalizedTotal=" + this.finalizedTotal);
            }
        } else {
            sb.append(100 * this.succeedBlocks / this.minSuccessfulBlocks);
            sb.append('%');
        }
        sb.append(' ');
        sb.append(this.succeedBlocks);
        sb.append('/');
        sb.append(this.minSuccessfulBlocks);
        sb.append(" (failed ");
        sb.append(this.failedBlocks);
        sb.append(", fatally ");
        sb.append(this.fatallyFailedBlocks);
        sb.append(", total ");
        sb.append(this.totalBlocks);
        sb.append(", minSuccessFetch ");
        sb.append(this.minSuccessFetchBlocks);
        sb.append(") ");
        sb.append(this.finalizedTotal ? " (finalized total)" : "");
        return sb.toString();
    }

    @Override
    public int getCode() {
        return 7;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

