/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.ContentDataFilter;
import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.l10n.NodeL10n;
import freenet.support.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class MP3Filter
implements ContentDataFilter {
    static final short[][][] bitRateIndices = new short[][][]{new short[][]{new short[0], {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256}}, new short[0][], new short[][]{new short[0], {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256}}, new short[][]{new short[0], {0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384}, {0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448}}};
    static final int[][] sampleRateIndices = new int[][]{{11025, 12000, 8000}, new int[0], {22050, 24000, 16000}, {44100, 48000, 32000}};
    static final int[][] samplesPerFrame = new int[][]{{0, 576, 1152, 384}, new int[0], {0, 576, 1152, 384}, {0, 1152, 1152, 384}};
    static final int[] bitsPerSlot = new int[]{0, 8, 8, 32};

    @Override
    public void readFilter(InputStream input, OutputStream output, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        this.filter(input, output);
    }

    public void filter(InputStream input, OutputStream output) throws DataFilterException, IOException {
        DataInputStream in = new DataInputStream(input);
        DataOutputStream out = new DataOutputStream(output);
        boolean foundStream = true;
        int totalFrames = 0;
        int totalCRCs = 0;
        int foundFrames = 0;
        int maxFoundFrames = 0;
        long countLostSyncBytes = 0L;
        int countFreeBitrate = 0;
        try {
            int frameHeader = in.readInt();
            boolean bl = foundStream = (frameHeader & 0xFFE00000) == -2097152;
            while (true) {
                if (foundStream && (frameHeader & 0xFFE00000) == -2097152) {
                    byte version = (byte)((frameHeader & 0x180000) >>> 19);
                    if (version == 1) {
                        foundStream = false;
                        continue;
                    }
                    byte layer = (byte)((frameHeader & 0x60000) >>> 17);
                    if (layer == 0) {
                        foundStream = false;
                        continue;
                    }
                    boolean hasCRC = (frameHeader & 0x10000) >>> 16 != 1;
                    byte bitrateIndex = (byte)((frameHeader & 0xF000) >>> 12);
                    if (bitrateIndex == 0) {
                        foundStream = false;
                        ++countFreeBitrate;
                        continue;
                    }
                    if (bitrateIndex == 15) {
                        foundStream = false;
                        continue;
                    }
                    byte samplerateIndex = (byte)((frameHeader & 0xC00) >>> 10);
                    if (samplerateIndex == 3) {
                        foundStream = false;
                        continue;
                    }
                    boolean paddingBit = (frameHeader & 0x200) >>> 9 == 1;
                    byte emphasis = (byte)(frameHeader & 3);
                    if (emphasis == 2) {
                        foundStream = false;
                        continue;
                    }
                    int bitrate = bitRateIndices[version][layer][bitrateIndex] * 1000;
                    int samplerate = sampleRateIndices[version][samplerateIndex];
                    int samples = samplesPerFrame[version][layer];
                    int granularity = bitsPerSlot[layer];
                    int frameLength = samples / granularity * bitrate / samplerate;
                    frameLength += paddingBit ? 1 : 0;
                    frameLength *= granularity / 8;
                    short crc = 0;
                    if (hasCRC) {
                        ++totalCRCs;
                        crc = in.readShort();
                        Logger.normal(this, "Found a CRC");
                    }
                    byte[] frame = null;
                    frame = new byte[frameLength - 4];
                    in.readFully(frame);
                    out.writeInt(frameHeader);
                    if (hasCRC) {
                        out.writeShort(crc);
                    }
                    out.write(frame);
                    ++totalFrames;
                    ++foundFrames;
                    if (countLostSyncBytes != 0L) {
                        Logger.normal(this, "Lost sync for " + countLostSyncBytes + " bytes");
                    }
                    countLostSyncBytes = 0L;
                    frameHeader = in.readInt();
                    continue;
                }
                if (!foundStream && (frameHeader & 0xFFFFFF00) == 1229206272) {
                    in.skip(2L);
                    byte[] encodedSize = new byte[4];
                    in.readFully(encodedSize);
                    int size = 0;
                    size |= (encodedSize[0] & 0x7F) << 21;
                    size |= (encodedSize[1] & 0x7F) << 14;
                    size |= (encodedSize[2] & 0x7F) << 7;
                    in.skip(size |= encodedSize[3] & 0x7F);
                    Logger.normal(this, "Skipped " + size + " bytes of ID3v2 data");
                    frameHeader = in.readInt();
                    foundStream = (frameHeader & 0xFFE00000) == -2097152;
                    continue;
                }
                if (!foundStream && (frameHeader & 0xFFFFFF00) == 1413564160) {
                    in.skip(124L);
                    Logger.normal(this, "Skipped an ID3v1 TAG");
                    frameHeader = in.readInt();
                    foundStream = (frameHeader & 0xFFE00000) == -2097152;
                    continue;
                }
                if (foundFrames != 0) {
                    Logger.normal(this, "Series of frames: " + foundFrames);
                }
                if (foundFrames > maxFoundFrames) {
                    maxFoundFrames = foundFrames;
                }
                foundFrames = 0;
                frameHeader <<= 8;
                if (((frameHeader |= in.readUnsignedByte()) & 0xFFE00000) == -2097152) {
                    foundStream = true;
                    continue;
                }
                ++countLostSyncBytes;
            }
        }
        catch (EOFException e) {
            if (foundFrames != 0) {
                Logger.normal(this, "Series of frames: " + foundFrames);
            }
            if (countLostSyncBytes != 0L) {
                Logger.normal(this, "Lost sync for " + countLostSyncBytes + " bytes");
            }
            if (totalFrames == 0 || maxFoundFrames < 10) {
                if (countFreeBitrate > 100) {
                    throw new DataFilterException(this.l10n("freeBitrateNotSupported"), this.l10n("freeBitrateNotSupported"), this.l10n("freeBitrateNotSupportedExplanation"));
                }
                if (totalFrames == 0) {
                    throw new DataFilterException(this.l10n("bogusMP3NoFrames"), this.l10n("bogusMP3NoFrames"), this.l10n("bogusMP3NoFramesExplanation"));
                }
            }
            out.flush();
            Logger.normal(this, totalFrames + " frames, of which " + totalCRCs + " had a CRC");
            return;
        }
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("MP3Filter." + key);
    }

    public static void main(String[] args) throws DataFilterException, IOException {
        File f = new File(args[0]);
        FileInputStream fis = new FileInputStream(f);
        File out = new File(args[0] + ".filtered.mp3");
        FileOutputStream fos = new FileOutputStream(out);
        MP3Filter filter = new MP3Filter();
        filter.readFilter(fis, fos, null, null, null);
        fis.close();
        fos.close();
    }
}

