/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import freenet.client.FetchResult;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.RequestClient;
import freenet.node.Version;
import freenet.node.updater.NodeUpdateManager;
import freenet.node.updater.NodeUpdater;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.pluginmanager.PluginManager;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class PluginJarUpdater
extends NodeUpdater {
    final String pluginName;
    final PluginManager pluginManager;
    private UserAlert alert;
    private boolean deployOnNoRevocation;
    private boolean deployOnNextNoRevocation;
    private boolean readyToDeploy;
    private FetchResult result;
    private final Object writeJarSync = new Object();
    private int writtenVersion;
    private int requiredNodeVersion;
    private static final String REQUIRED_NODE_VERSION_PREFIX = "Required-Node-Version: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onNoRevocation() {
        UserAlert a;
        PluginJarUpdater pluginJarUpdater = this;
        synchronized (pluginJarUpdater) {
            if (!this.readyToDeploy) {
                return false;
            }
            if (!this.deployOnNoRevocation) {
                if (this.deployOnNextNoRevocation) {
                    this.deployOnNoRevocation = true;
                    this.deployOnNextNoRevocation = false;
                    System.out.println("Deploying " + this.pluginName + " after next revocation check");
                    return true;
                }
                return false;
            }
        }
        if (!this.pluginManager.isPluginLoaded(this.pluginName)) {
            Logger.error(this, "Plugin is not loaded, so not deploying: " + this.pluginName);
            this.tempBlobFile.delete();
            return false;
        }
        System.out.println("Deploying new version of " + this.pluginName + " : unloading old version...");
        try {
            this.writeJar();
        }
        catch (IOException e) {
            Logger.error(this, "Cannot deploy: " + e, (Throwable)e);
            System.err.println("Cannot deploy new version of " + this.pluginName + " : " + e);
            e.printStackTrace();
            return false;
        }
        this.pluginManager.killPluginByFilename(this.pluginName, Integer.MAX_VALUE, true);
        this.pluginManager.startPluginAuto(this.pluginName, true);
        PluginJarUpdater pluginJarUpdater2 = this;
        synchronized (pluginJarUpdater2) {
            a = this.alert;
            this.alert = null;
        }
        this.node.clientCore.alerts.unregister(a);
        return false;
    }

    PluginJarUpdater(NodeUpdateManager manager, FreenetURI URI2, int current, int min, int max, String blobFilenamePrefix, String pluginName, PluginManager pm, boolean autoDeployOnRestart) {
        super(manager, URI2, current, min, max, blobFilenamePrefix);
        this.pluginName = pluginName;
        this.pluginManager = pm;
    }

    @Override
    public String jarName() {
        return this.pluginName;
    }

    @Override
    protected void maybeParseManifest(FetchResult result, int build) {
        this.requiredNodeVersion = -1;
        this.parseManifest(result);
        if (this.requiredNodeVersion != -1) {
            System.err.println("Required node version for plugin " + this.pluginName + ": " + this.requiredNodeVersion);
            Logger.normal(this, "Required node version for plugin " + this.pluginName + ": " + this.requiredNodeVersion);
        }
    }

    @Override
    protected void parseManifestLine(String line) {
        if (line.startsWith(REQUIRED_NODE_VERSION_PREFIX)) {
            this.requiredNodeVersion = Integer.parseInt(line.substring(REQUIRED_NODE_VERSION_PREFIX.length()));
        }
    }

    @Override
    protected void onStartFetching() {
        System.err.println("Starting to fetch plugin " + this.pluginName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSuccess(int build, FetchResult result, File blob) {
        PluginInfoWrapper loaded;
        Bucket oldResult = null;
        PluginJarUpdater pluginJarUpdater = this;
        synchronized (pluginJarUpdater) {
            if (this.requiredNodeVersion > Version.buildNumber()) {
                System.err.println("Found version " + this.fetchedVersion + " of " + this.pluginName + " but needs node version " + this.requiredNodeVersion);
                this.tempBlobFile.delete();
                return;
            }
            if (this.result != null) {
                oldResult = this.result.asBucket();
            }
            this.result = result;
        }
        if (oldResult != null) {
            oldResult.free();
        }
        if ((loaded = this.pluginManager.getPluginInfo(this.pluginName)) == null && !this.node.pluginManager.isPluginLoadedOrLoadingOrWantLoad(this.pluginName)) {
            System.err.println("Don't want plugin: " + this.pluginName);
            Logger.error(this, "Don't want plugin: " + this.pluginName);
            this.tempBlobFile.delete();
            return;
        }
        if (loaded.getPluginLongVersion() >= (long)this.fetchedVersion) {
            this.tempBlobFile.delete();
            return;
        }
        AbstractUserAlert toRegister = null;
        PluginJarUpdater pluginJarUpdater2 = this;
        synchronized (pluginJarUpdater2) {
            this.readyToDeploy = true;
            if (this.alert != null) {
                return;
            }
            this.alert = new AbstractUserAlert(true, this.l10n("pluginUpdatedTitle", "name", this.pluginName), this.l10n("pluginUpdatedText", "name", this.pluginName), this.l10n("pluginUpdatedShortText", "name", this.pluginName), null, 1, true, NodeL10n.getBase().getString("UserAlert.hide"), true, this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onDismiss() {
                    PluginJarUpdater pluginJarUpdater = PluginJarUpdater.this;
                    synchronized (pluginJarUpdater) {
                        PluginJarUpdater.this.alert = null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public HTMLNode getHTMLText() {
                    HTMLNode div = new HTMLNode("div");
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        if (PluginJarUpdater.this.deployOnNoRevocation || PluginJarUpdater.this.deployOnNextNoRevocation) {
                            div.addChild("#", PluginJarUpdater.this.l10n("willDeployAfterRevocationCheck", "name", PluginJarUpdater.this.pluginName));
                        } else {
                            div.addChild("#", PluginJarUpdater.this.l10n("pluginUpdatedText", new String[]{"name", "newVersion"}, new String[]{PluginJarUpdater.this.pluginName, Long.toString(PluginJarUpdater.this.fetchedVersion)}));
                            HTMLNode formNode = div.addChild("form", new String[]{"action", "method"}, new String[]{"/plugins/", "post"});
                            formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "formPassword", PluginJarUpdater.this.node.clientCore.formPassword});
                            formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "update", PluginJarUpdater.this.pluginName});
                            formNode.addChild("input", new String[]{"type", "value"}, new String[]{"submit", PluginJarUpdater.this.l10n("updatePlugin")});
                        }
                    }
                    return div;
                }
            };
            toRegister = this.alert;
        }
        if (toRegister != null) {
            this.node.clientCore.alerts.register(toRegister);
        }
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("PluginJarUpdater." + key);
    }

    private String l10n(String key, String name, String value) {
        return NodeL10n.getBase().getString("PluginJarUpdater." + key, name, value);
    }

    private String l10n(String key, String[] names, String[] values) {
        return NodeL10n.getBase().getString("PluginJarUpdater." + key, names, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJarTo(FetchResult result, File fNew) throws IOException {
        int fetched;
        Object object = this;
        synchronized (object) {
            fetched = this.fetchedVersion;
        }
        object = this.writeJarSync;
        synchronized (object) {
            if (!fNew.delete() && fNew.exists()) {
                System.err.println("Can't delete " + fNew + "!");
            }
            FileOutputStream fos = new FileOutputStream(fNew);
            BucketTools.copyTo(result.asBucket(), fos, -1L);
            fos.flush();
            fos.close();
        }
        object = this;
        synchronized (object) {
            this.writtenVersion = fetched;
        }
        System.err.println("Written " + this.jarName() + " to " + fNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeJar() throws IOException {
        UserAlert a;
        this.writeJarTo(this.result, this.pluginManager.getPluginFilename(this.pluginName));
        PluginJarUpdater pluginJarUpdater = this;
        synchronized (pluginJarUpdater) {
            a = this.alert;
            this.alert = null;
        }
        if (a != null) {
            this.node.clientCore.alerts.unregister(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void kill() {
        UserAlert a;
        super.kill();
        PluginJarUpdater pluginJarUpdater = this;
        synchronized (pluginJarUpdater) {
            a = this.alert;
            this.alert = null;
        }
        if (a != null) {
            this.node.clientCore.alerts.unregister(a);
        }
    }

    public synchronized void arm(boolean wasRunning) {
        if (wasRunning) {
            this.deployOnNextNoRevocation = true;
            System.out.println("Deploying " + this.pluginName + " after next but one revocation check");
        } else {
            this.deployOnNoRevocation = true;
            System.out.println("Deploying " + this.pluginName + " after next revocation check");
        }
    }

    @Override
    public RequestClient getRequestClient() {
        return this.pluginManager.singleUpdaterRequestClient;
    }
}

