/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.support.Logger;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.DiskSpaceCheckingOutputStream;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.PersistentFileTracker;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import freenet.support.io.TempFileBucket;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class PersistentTempFileBucket
extends TempFileBucket
implements Serializable {
    private static final long serialVersionUID = 1L;
    transient PersistentFileTracker tracker;
    private static volatile boolean logMINOR;
    static final int BUFFER_SIZE = 4096;
    public static final int MAGIC = 805164239;

    public PersistentTempFileBucket(long id, FilenameGenerator generator, PersistentFileTracker tracker) {
        this(id, generator, tracker, true);
    }

    protected PersistentTempFileBucket(long id, FilenameGenerator generator, PersistentFileTracker tracker, boolean deleteOnFree) {
        super(id, generator, deleteOnFree);
        this.tracker = tracker;
    }

    protected PersistentTempFileBucket() {
    }

    @Override
    protected boolean deleteOnExit() {
        return false;
    }

    @Override
    public OutputStream getOutputStreamUnbuffered() throws IOException {
        OutputStream os = super.getOutputStreamUnbuffered();
        os = new DiskSpaceCheckingOutputStream(os, this.tracker, this.getFile(), 4096);
        return os;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new BufferedOutputStream(this.getOutputStreamUnbuffered(), 4096);
    }

    @Override
    public RandomAccessBucket createShadow() {
        PersistentTempFileBucket ret = new PersistentTempFileBucket(this.filenameID, this.generator, this.tracker, false);
        ret.setReadOnly();
        if (!this.getFile().exists()) {
            Logger.error(this, "File does not exist when creating shadow: " + this.getFile());
        }
        return ret;
    }

    @Override
    protected void innerResume(ClientContext context) throws ResumeFailedException {
        super.innerResume(context);
        if (logMINOR) {
            Logger.minor(this, "Resuming " + this, (Throwable)new Exception("debug"));
        }
        this.tracker = context.persistentFileTracker;
        this.tracker.register(this.getFile());
    }

    @Override
    protected boolean persistent() {
        return true;
    }

    @Override
    protected int magic() {
        return 805164239;
    }

    protected PersistentTempFileBucket(DataInputStream dis) throws IOException, StorageFormatException {
        super(dis);
    }

    @Override
    protected long getPersistentTempID() {
        return this.filenameID;
    }

    static {
        Logger.registerClass(PersistentTempFileBucket.class);
    }
}

