/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Collection4Iterator;
import com.db4o.foundation.DeepClone;
import com.db4o.foundation.Iterable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.Iterators;
import com.db4o.foundation.List4;
import com.db4o.foundation.Sequence4;
import com.db4o.types.Unversioned;

public class Collection4
implements Sequence4,
Iterable4,
DeepClone,
Unversioned {
    public List4 _first;
    public List4 _last;
    public int _size;
    public int _version;

    public Collection4() {
    }

    public Collection4(Object[] elements) {
        this.addAll(elements);
    }

    public Collection4(Iterable4 other) {
        this.addAll(other);
    }

    public Collection4(Iterator4 iterator) {
        this.addAll(iterator);
    }

    public Object singleElement() {
        if (this.size() != 1) {
            throw new IllegalStateException();
        }
        return this._first._element;
    }

    @Override
    public final void add(Object element) {
        this.doAdd(element);
        this.changed();
    }

    public final void prepend(Object element) {
        this.doPrepend(element);
        this.changed();
    }

    private void doPrepend(Object element) {
        if (this._first == null) {
            this.doAdd(element);
        } else {
            this._first = new List4(this._first, element);
            ++this._size;
        }
    }

    private void doAdd(Object element) {
        this._last = this._last == null ? (this._first = new List4(element)) : (this._last._next = new List4(element));
        ++this._size;
    }

    public final void addAll(Object[] elements) {
        this.assertNotNull(elements);
        for (int i = 0; i < elements.length; ++i) {
            this.add(elements[i]);
        }
    }

    public final void addAll(Iterable4 other) {
        this.assertNotNull(other);
        this.addAll(other.iterator());
    }

    public final void addAll(Iterator4 iterator) {
        this.assertNotNull(iterator);
        while (iterator.moveNext()) {
            this.add(iterator.current());
        }
    }

    public final void clear() {
        this._first = null;
        this._last = null;
        this._size = 0;
        this.changed();
    }

    public final boolean contains(Object element) {
        return this.find(element) != null;
    }

    public boolean containsAll(Iterator4 iter) {
        this.assertNotNull(iter);
        while (iter.moveNext()) {
            if (this.contains(iter.current())) continue;
            return false;
        }
        return true;
    }

    public final boolean containsByIdentity(Object element) {
        Iterator4 i = this.internalIterator();
        while (i.moveNext()) {
            Object current = i.current();
            if (current != element) continue;
            return true;
        }
        return false;
    }

    private List4 find(Object obj) {
        List4 current = this._first;
        while (current != null) {
            if (current.holds(obj)) {
                return current;
            }
            current = current._next;
        }
        return null;
    }

    public final Object get(Object element) {
        List4 holder = this.find(element);
        return holder == null ? null : holder._element;
    }

    @Override
    public Object deepClone(Object newParent) {
        Collection4 col = new Collection4();
        Object element = null;
        Iterator4 i = this.internalIterator();
        while (i.moveNext()) {
            element = i.current();
            if (element instanceof DeepClone) {
                col.add(((DeepClone)element).deepClone(newParent));
                continue;
            }
            col.add(element);
        }
        return col;
    }

    public final Object ensure(Object element) {
        List4 list = this.find(element);
        if (list == null) {
            this.add(element);
            return element;
        }
        return list._element;
    }

    @Override
    public final Iterator4 iterator() {
        return this._first == null ? Iterators.EMPTY_ITERATOR : new Collection4Iterator(this, this._first);
    }

    @Override
    public Object get(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        List4 cur = this._first;
        while (index > 0 && cur != null) {
            cur = cur._next;
            --index;
        }
        if (cur == null) {
            throw new IllegalArgumentException();
        }
        return cur._element;
    }

    public void removeAll(Iterable4 iterable) {
        this.removeAll(iterable.iterator());
    }

    public void removeAll(Iterator4 iterator) {
        while (iterator.moveNext()) {
            this.remove(iterator.current());
        }
    }

    public Object remove(Object a_object) {
        List4 previous = null;
        List4 current = this._first;
        while (current != null) {
            if (current.holds(a_object)) {
                --this._size;
                this.adjustOnRemoval(previous, current);
                this.changed();
                return current._element;
            }
            previous = current;
            current = current._next;
        }
        return null;
    }

    public void replace(Object oldObject, Object newObject) {
        List4 list = this.find(oldObject);
        if (list != null) {
            list._element = newObject;
        }
    }

    private void adjustOnRemoval(List4 previous, List4 removed) {
        if (removed == this._first) {
            this._first = removed._next;
        } else {
            previous._next = removed._next;
        }
        if (removed == this._last) {
            this._last = previous;
        }
    }

    public final int size() {
        return this._size;
    }

    public int indexOf(Object obj) {
        int index = 0;
        List4 current = this._first;
        while (current != null) {
            if (current.holds(obj)) {
                return index;
            }
            ++index;
            current = current._next;
        }
        return -1;
    }

    @Override
    public final boolean isEmpty() {
        return this._size == 0;
    }

    public final Object[] toArray(Object[] a_array) {
        int j = 0;
        Iterator4 i = this.internalIterator();
        while (i.moveNext()) {
            a_array[j++] = i.current();
        }
        return a_array;
    }

    public final Object[] toArray() {
        Object[] array = new Object[this._size];
        this.toArray(array);
        return array;
    }

    public String toString() {
        return Iterators.toString(this.internalIterator());
    }

    private void changed() {
        ++this._version;
    }

    int version() {
        return this._version;
    }

    private void assertNotNull(Object element) {
        if (element == null) {
            throw new ArgumentNullException();
        }
    }

    private Iterator4 internalIterator() {
        return new Iterator4Impl(this._first);
    }
}

