/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.fec;

import com.onionnetworks.fec.FECMath;
import com.onionnetworks.fec.PureCode;
import com.onionnetworks.util.Util;

public class Pure16Code
extends PureCode {
    protected static final FECMath fecMath = new FECMath(16);

    public Pure16Code(int n, int n2) {
        super(n, n2, fecMath.createEncodeMatrix(n, n2));
    }

    @Override
    protected void encode(byte[][] byArray, int[] nArray, byte[][] byArray2, int[] nArray2, int[] nArray3, int n) {
        int n2;
        if (n % 2 != 0) {
            throw new IllegalArgumentException("For 16 bit codes, buffers must be 16 bit aligned.");
        }
        char[][] cArrayArray = new char[byArray.length][];
        int[] nArray4 = new int[byArray.length];
        int n3 = n / 2;
        char[] cArray = new char[n3];
        for (n2 = 0; n2 < cArrayArray.length; ++n2) {
            cArrayArray[n2] = new char[n3];
            Util.arraycopy(byArray[n2], nArray[n2], cArrayArray[n2], 0, n);
            nArray4[n2] = 0;
        }
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            if (nArray3[n2] < this.k) {
                System.arraycopy(byArray[nArray3[n2]], nArray[nArray3[n2]], byArray2[n2], nArray2[n2], n);
                continue;
            }
            this.encode(cArrayArray, nArray4, cArray, 0, nArray3[n2], n3);
            Util.arraycopy(cArray, 0, byArray2[n2], nArray2[n2], n);
        }
    }

    protected void encode(char[][] cArray, int[] nArray, char[] cArray2, int n, int n2, int n3) {
        int n4 = n2 * this.k;
        Util.bzero(cArray2, n, n3);
        for (int i = 0; i < this.k; ++i) {
            fecMath.addMul(cArray2, n, cArray[i], nArray[i], this.encMatrix[n4 + i], n3);
        }
    }

    @Override
    protected void decode(byte[][] byArray, int[] nArray, int[] nArray2, int n, boolean bl) {
        if (n % 2 != 0) {
            throw new IllegalArgumentException("For 16 bit codes, buffers must be 16 bit aligned.");
        }
        if (!bl) {
            Pure16Code.shuffle(byArray, nArray, nArray2, this.k);
        }
        char[][] cArrayArray = new char[byArray.length][];
        int[] nArray3 = new int[byArray.length];
        int n2 = n / 2;
        for (int i = 0; i < cArrayArray.length; ++i) {
            cArrayArray[i] = new char[n2];
            Util.arraycopy(byArray[i], nArray[i], cArrayArray[i], 0, n);
            nArray3[i] = 0;
        }
        char[][] cArray = this.decode(cArrayArray, nArray3, nArray2, n2);
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == null) continue;
            Util.arraycopy(cArray[i], 0, byArray[i], nArray[i], n);
            nArray2[i] = i;
        }
    }

    protected char[][] decode(char[][] cArray, int[] nArray, int[] nArray2, int n) {
        char[] cArray2 = fecMath.createDecodeMatrix(this.encMatrix, nArray2, this.k, this.n);
        char[][] cArrayArray = new char[this.k][];
        for (int i = 0; i < this.k; ++i) {
            if (nArray2[i] < this.k) continue;
            cArrayArray[i] = new char[n];
            for (int j = 0; j < this.k; ++j) {
                fecMath.addMul(cArrayArray[i], 0, cArray[j], nArray[j], cArray2[i * this.k + j], n);
            }
        }
        return cArrayArray;
    }

    @Override
    public String toString() {
        return new String("Pure16Code[k=" + this.k + ",n=" + this.n + "]");
    }
}

