/*
 * Decompiled with CFR 0.152.
 */
package net.contrapunctus.lzma;

import SevenZip.Compression.LZMA.Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ArrayBlockingQueue;
import net.contrapunctus.lzma.ConcurrentBufferInputStream;

class EncoderThread
extends Thread {
    protected ArrayBlockingQueue<byte[]> q = new ArrayBlockingQueue(4096);
    protected InputStream in = ConcurrentBufferInputStream.create(this.q);
    protected OutputStream out;
    protected Encoder enc;
    protected IOException exn;
    private static final PrintStream dbg = System.err;
    private static final boolean DEBUG;

    EncoderThread(OutputStream _out) {
        this.out = _out;
        this.enc = new Encoder();
        this.exn = null;
        if (DEBUG) {
            dbg.printf("%s << %s (%s)%n", this, this.in, this.q);
        }
    }

    @Override
    public void run() {
        block4: {
            try {
                this.enc.SetEndMarkerMode(true);
                this.enc.SetDictionarySize(0x100000);
                if (DEBUG) {
                    dbg.printf("%s begins%n", this);
                }
                this.enc.Code(this.in, this.out, -1L, -1L, null);
                if (DEBUG) {
                    dbg.printf("%s ends%n", this);
                }
                this.out.close();
            }
            catch (IOException _exn) {
                this.exn = _exn;
                if (!DEBUG) break block4;
                dbg.printf("%s exception: %s%n", this.exn.getMessage());
            }
        }
    }

    @Override
    public String toString() {
        return String.format("Enc@%x", this.hashCode());
    }

    static {
        String ds = null;
        try {
            ds = System.getProperty("DEBUG_LzmaCoders");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DEBUG = ds != null;
    }
}

