/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ArchiveContext;
import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.InsertContext;
import freenet.client.async.BaseClientGetter;
import freenet.client.async.BinaryBlobWriter;
import freenet.client.async.ClientBaseCallback;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientGetWorkerThread;
import freenet.client.async.FileGetCompletionCallback;
import freenet.client.async.PersistentClientCallback;
import freenet.client.async.PersistentJob;
import freenet.client.async.SingleFileFetcher;
import freenet.client.async.SnoopBucket;
import freenet.client.async.SnoopMetadata;
import freenet.client.async.SplitFileFetcher;
import freenet.client.async.StreamGenerator;
import freenet.client.async.WantsCooldownCallback;
import freenet.client.events.EnterFiniteCooldownEvent;
import freenet.client.events.ExpectedFileSizeEvent;
import freenet.client.events.ExpectedHashesEvent;
import freenet.client.events.ExpectedMIMEEvent;
import freenet.client.events.SendingToNetworkEvent;
import freenet.client.events.SplitfileCompatibilityModeEvent;
import freenet.client.events.SplitfileProgressEvent;
import freenet.client.filter.ContentFilter;
import freenet.client.filter.FilterMIMEType;
import freenet.client.filter.UnsafeContentTypeException;
import freenet.crypt.ChecksumChecker;
import freenet.crypt.HashResult;
import freenet.keys.ClientKeyBlock;
import freenet.keys.FreenetURI;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.compress.Compressor;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import freenet.support.io.NullOutputStream;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;

public class ClientGetter
extends BaseClientGetter
implements WantsCooldownCallback,
FileGetCompletionCallback,
Serializable {
    private static final long serialVersionUID = 1L;
    private static volatile boolean logMINOR;
    final ClientGetCallback clientCallback;
    FreenetURI uri;
    final FetchContext ctx;
    final ArchiveContext actx;
    private ClientGetState currentState;
    private boolean finished;
    private int archiveRestarts;
    final Bucket returnBucket;
    private final BinaryBlobWriter binaryBlobWriter;
    private final boolean dontFinalizeBlobWriter;
    private String expectedMIME;
    private long expectedSize;
    private boolean finalizedMetadata;
    private SnoopMetadata snoopMeta;
    private SnoopBucket snoopBucket;
    private HashResult[] hashes;
    private final Bucket initialMetadata;
    final String forceCompatibleExtension;
    private transient boolean resumedFetcher;
    private int finalBlocksRequired;
    private int finalBlocksTotal;

    public ClientGetter(ClientGetCallback client, FreenetURI uri, FetchContext ctx, short priorityClass) {
        this(client, uri, ctx, priorityClass, null, null, null);
    }

    public ClientGetter(ClientGetCallback client, FreenetURI uri, FetchContext ctx, short priorityClass, Bucket returnBucket) {
        this(client, uri, ctx, priorityClass, returnBucket, null, null);
    }

    public ClientGetter(ClientGetCallback client, FreenetURI uri, FetchContext ctx, short priorityClass, Bucket returnBucket, BinaryBlobWriter binaryBlobWriter) {
        this(client, uri, ctx, priorityClass, returnBucket, binaryBlobWriter, null);
    }

    public ClientGetter(ClientGetCallback client, FreenetURI uri, FetchContext ctx, short priorityClass, Bucket returnBucket, BinaryBlobWriter binaryBlobWriter, Bucket initialMetadata) {
        this(client, uri, ctx, priorityClass, returnBucket, binaryBlobWriter, false, initialMetadata);
    }

    public ClientGetter(ClientGetCallback client, FreenetURI uri, FetchContext ctx, short priorityClass, Bucket returnBucket, BinaryBlobWriter binaryBlobWriter, boolean dontFinalizeBlobWriter, Bucket initialMetadata) {
        this(client, uri, ctx, priorityClass, returnBucket, binaryBlobWriter, dontFinalizeBlobWriter, initialMetadata, null);
    }

    public ClientGetter(ClientGetCallback client, FreenetURI uri, FetchContext ctx, short priorityClass, Bucket returnBucket, BinaryBlobWriter binaryBlobWriter, boolean dontFinalizeBlobWriter, Bucket initialMetadata, String forceCompatibleExtension) {
        super(priorityClass, client.getRequestClient());
        this.clientCallback = client;
        this.returnBucket = returnBucket;
        this.uri = uri;
        this.ctx = ctx;
        this.finished = false;
        this.actx = new ArchiveContext(ctx.maxTempLength, ctx.maxArchiveLevels);
        this.binaryBlobWriter = binaryBlobWriter;
        this.dontFinalizeBlobWriter = dontFinalizeBlobWriter;
        this.initialMetadata = initialMetadata;
        this.archiveRestarts = 0;
        this.forceCompatibleExtension = forceCompatibleExtension;
    }

    protected ClientGetter() {
        this.clientCallback = null;
        this.ctx = null;
        this.actx = null;
        this.returnBucket = null;
        this.binaryBlobWriter = null;
        this.dontFinalizeBlobWriter = false;
        this.initialMetadata = null;
        this.forceCompatibleExtension = null;
    }

    public void start(ClientContext context) throws FetchException {
        this.start(false, null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(boolean restart, FreenetURI overrideURI, ClientContext context) throws FetchException {
        if (logMINOR) {
            Logger.minor(this, "Starting " + this + " persistent=" + this.persistent() + " for " + this.uri);
        }
        try {
            HashResult[] oldHashes = null;
            String overrideMIME = this.ctx.overrideMIME;
            ClientGetter clientGetter = this;
            synchronized (clientGetter) {
                if (restart) {
                    this.clearCountersOnRestart();
                }
                if (overrideURI != null) {
                    this.uri = overrideURI;
                }
                if (this.finished) {
                    if (!restart) {
                        return false;
                    }
                    this.currentState = null;
                    this.cancelled = false;
                    this.finished = false;
                }
                if (!this.resumedFetcher) {
                    this.actx.clear();
                    this.expectedMIME = null;
                    this.expectedSize = 0L;
                    oldHashes = this.hashes;
                    this.hashes = null;
                    this.finalBlocksRequired = 0;
                    this.finalBlocksTotal = 0;
                    this.resetBlocks();
                    this.currentState = SingleFileFetcher.create(this, this, this.uri, this.ctx, this.actx, this.ctx.maxNonSplitfileRetries, 0, false, -1L, true, true, context, this.realTimeFlag, this.initialMetadata != null);
                }
                if (overrideMIME != null) {
                    this.expectedMIME = overrideMIME;
                }
            }
            if (this.cancelled) {
                this.cancel();
            }
            if (this.currentState != null && !this.finished) {
                if (this.initialMetadata != null && this.currentState instanceof SingleFileFetcher && !this.resumedFetcher) {
                    ((SingleFileFetcher)this.currentState).startWithMetadata(this.initialMetadata, context);
                } else {
                    this.currentState.schedule(context);
                }
            }
            if (this.cancelled) {
                this.cancel();
            }
        }
        catch (MalformedURLException e) {
            throw new FetchException(FetchException.FetchExceptionMode.INVALID_URI, (Throwable)e);
        }
        return true;
    }

    @Override
    protected void clearCountersOnRestart() {
        this.archiveRestarts = 0;
        this.expectedMIME = null;
        this.expectedSize = 0L;
        this.finalBlocksRequired = 0;
        this.finalBlocksTotal = 0;
        super.clearCountersOnRestart();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void onSuccess(StreamGenerator streamGenerator, ClientMetadata clientMetadata, List<? extends Compressor> decompressors, ClientGetState state, ClientContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSuccess(File tempFile, long length, ClientMetadata metadata, ClientGetState state, ClientContext context) {
        context.uskManager.checkUSK(this.uri, this.persistent(), false);
        try {
            if (this.binaryBlobWriter != null && !this.dontFinalizeBlobWriter) {
                this.binaryBlobWriter.finalizeBucket();
            }
        }
        catch (IOException ioe) {
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, "Failed to close binary blob stream: " + ioe), null, context);
            return;
        }
        catch (BinaryBlobWriter.BinaryBlobAlreadyClosedException e) {
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, "Failed to close binary blob stream, already closed: " + e, e), null, context);
            return;
        }
        File completionFile = this.getCompletionFile();
        assert (completionFile != null);
        assert (!this.ctx.filterData);
        Logger.normal(this, "Succeeding via truncation from " + tempFile + " to " + completionFile);
        FetchException ex = null;
        RandomAccessFile raf = null;
        FetchResult result = null;
        try {
            raf = new RandomAccessFile(tempFile, "rw");
            if (raf.length() < length) {
                throw new IOException("File is shorter than target length " + length);
            }
            raf.setLength(length);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(raf.getFD()));
            Object decompressorManager = null;
            ClientGetWorkerThread worker = null;
            worker = new ClientGetWorkerThread(is, new NullOutputStream(), this.uri, null, this.hashes, false, null, this.ctx.prefetchHook, this.ctx.tagReplacer, context.linkFilterExceptionProvider);
            worker.start();
            if (logMINOR) {
                Logger.minor(this, "Waiting for hashing, filtration, and writing to finish");
            }
            worker.waitFinished();
            ((InputStream)is).close();
            is = null;
            raf = null;
            if (!FileUtil.renameTo(tempFile, completionFile)) {
                throw new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, "Failed to rename from temp file " + tempFile);
            }
            ClientGetter clientGetter = this;
            synchronized (clientGetter) {
                this.finished = true;
                this.currentState = null;
                this.expectedMIME = metadata.getMIMEType();
                this.expectedSize = length;
            }
            result = new FetchResult(metadata, this.returnBucket);
        }
        catch (IOException e) {
            Logger.error(this, "Failed while completing via truncation: " + e, (Throwable)e);
            ex = new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, (Throwable)e);
        }
        catch (URISyntaxException e) {
            Logger.error(this, "Impossible failure while completing via truncation: " + e, (Throwable)e);
            ex = new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, (Throwable)e);
        }
        catch (FetchException e) {
            Logger.error(this, "Caught " + e, (Throwable)e);
            ex = e;
        }
        catch (Throwable e) {
            Logger.error(this, "Failed while completing via truncation: " + e, e);
            ex = new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, e);
        }
        if (ex != null) {
            this.onFailure(ex, state, context, true);
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            tempFile.delete();
        } else {
            context.getJobRunner(this.persistent()).setCheckpointASAP();
            this.clientCallback.onSuccess(result, this);
        }
    }

    @Override
    public void onFailure(FetchException e, ClientGetState state, ClientContext context) {
        this.onFailure(e, state, context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(FetchException e, ClientGetState state, ClientContext context, boolean force) {
        Serializable e12;
        boolean alreadyFinished;
        block29: {
            Serializable unsafe;
            if (logMINOR) {
                Logger.minor(this, "Failed from " + state + " : " + e + " on " + this, (Throwable)e);
            }
            ClientGetState oldState = null;
            if (this.expectedSize > 0L && (e.expectedSize <= 0L || this.finalBlocksTotal != 0)) {
                e.expectedSize = this.expectedSize;
            }
            context.getJobRunner(this.persistent()).setCheckpointASAP();
            if (e.mode == FetchException.FetchExceptionMode.TOO_BIG && this.ctx.filterData && e.finalizedSize()) {
                String mime = e.getExpectedMimeType();
                if (this.ctx.overrideMIME != null) {
                    mime = this.ctx.overrideMIME;
                }
                if (mime != null && !"".equals(mime) && (unsafe = ContentFilter.checkMIMEType(mime)) != null) {
                    e = ((UnsafeContentTypeException)unsafe).recreateFetchException(e, mime);
                }
            }
            while (e.mode == FetchException.FetchExceptionMode.ARCHIVE_RESTART) {
                int ar;
                unsafe = this;
                synchronized (unsafe) {
                    ar = ++this.archiveRestarts;
                }
                if (logMINOR) {
                    Logger.minor(this, "Archive restart on " + this + " ar=" + ar);
                }
                if (ar > this.ctx.maxArchiveRestarts) {
                    e = new FetchException(FetchException.FetchExceptionMode.TOO_MANY_ARCHIVE_RESTARTS);
                    break;
                }
                try {
                    this.start(context);
                }
                catch (FetchException e12) {
                    e = e12;
                    continue;
                }
                return;
            }
            alreadyFinished = false;
            e12 = this;
            synchronized (e12) {
                if (this.finished && !force) {
                    if (!this.cancelled) {
                        Logger.error(this, "Already finished - not calling callbacks on " + this, (Throwable)new Exception("error"));
                    }
                    alreadyFinished = true;
                }
                this.finished = true;
                oldState = this.currentState;
                this.currentState = null;
                String mime = e.getExpectedMimeType();
                if (mime != null) {
                    this.expectedMIME = mime;
                }
            }
            if (!alreadyFinished) {
                try {
                    if (this.binaryBlobWriter != null && !this.dontFinalizeBlobWriter) {
                        this.binaryBlobWriter.finalizeBucket();
                    }
                }
                catch (IOException ioe) {
                    if (e.mode != FetchException.FetchExceptionMode.CANCELLED && !force) {
                        e = new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, "Failed to close binary blob stream: " + ioe);
                    }
                }
                catch (BinaryBlobWriter.BinaryBlobAlreadyClosedException ee) {
                    if (e.mode == FetchException.FetchExceptionMode.BUCKET_ERROR || e.mode == FetchException.FetchExceptionMode.CANCELLED || force) break block29;
                    e = new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, "Failed to close binary blob stream, already closed: " + ee, ee);
                }
            }
        }
        if (e.errorCodes != null && e.errorCodes.isOneCodeOnly()) {
            e = new FetchException(e.errorCodes.getFirstCodeFetch());
        }
        if (e.mode == FetchException.FetchExceptionMode.DATA_NOT_FOUND && this.successfulBlocks > 0) {
            e = new FetchException(e, FetchException.FetchExceptionMode.ALL_DATA_NOT_FOUND);
        }
        if (logMINOR) {
            Logger.minor(this, "onFailure(" + e + ", " + state + ") on " + this + " for " + this.uri, (Throwable)e);
        }
        e12 = e;
        if (!alreadyFinished) {
            this.clientCallback.onFailure((FetchException)e12, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ClientContext context) {
        ClientGetState s;
        if (logMINOR) {
            Logger.minor(this, "Cancelling " + this, (Throwable)new Exception("debug"));
        }
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            if (super.cancel()) {
                if (logMINOR) {
                    Logger.minor(this, "Already cancelled " + this);
                }
                return;
            }
            s = this.currentState;
        }
        if (s != null) {
            if (logMINOR) {
                Logger.minor(this, "Cancelling " + s + " for " + this + " instance " + super.toString());
            }
            s.cancel(context);
        } else if (logMINOR) {
            Logger.minor(this, "Nothing to cancel");
        }
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finished || this.cancelled;
    }

    @Override
    public FreenetURI getURI() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void innerNotifyClients(ClientContext context) {
        SplitfileProgressEvent e;
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            int total = this.totalBlocks;
            int minSuccess = this.minSuccessBlocks;
            boolean finalized = this.blockSetFinalized;
            if (this.finalBlocksRequired != 0) {
                total = this.finalBlocksTotal;
                minSuccess = this.finalBlocksRequired;
                finalized = true;
            }
            e = new SplitfileProgressEvent(total, this.successfulBlocks, this.latestSuccess, this.failedBlocks, this.fatallyFailedBlocks, this.latestFailure, minSuccess, 0, finalized);
        }
        this.ctx.eventProducer.produceEvent(e, context);
    }

    @Override
    protected void innerToNetwork(ClientContext context) {
        context.getJobRunner(this.persistent()).queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                ClientGetter.this.ctx.eventProducer.produceEvent(new SendingToNetworkEvent(), context);
                return false;
            }
        });
    }

    @Override
    public void onBlockSetFinished(ClientGetState state, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Set finished", (Throwable)new Exception("debug"));
        }
        this.blockSetFinalized(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTransition(ClientGetState oldState, ClientGetState newState, ClientContext context) {
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            if (this.currentState == oldState) {
                this.currentState = newState;
                if (logMINOR) {
                    Logger.minor(this, "Transition: " + oldState + " -> " + newState + " on " + this + " persistent = " + this.persistent() + " instance = " + super.toString(), (Throwable)new Exception("debug"));
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Ignoring transition: " + oldState + " -> " + newState + " because current = " + this.currentState + " on " + this + " persistent = " + this.persistent(), (Throwable)new Exception("debug"));
                }
                return;
            }
        }
        if (this.persistent()) {
            context.jobRunner.setCheckpointASAP();
        }
    }

    public boolean canRestart() {
        if (this.currentState != null && !this.finished) {
            if (logMINOR) {
                Logger.minor(this, "Cannot restart because not finished for " + this.uri);
            }
            return false;
        }
        return true;
    }

    public boolean restart(FreenetURI redirect, boolean filterData, ClientContext context) throws FetchException {
        this.ctx.filterData = filterData;
        return this.start(true, redirect, context);
    }

    public String toString() {
        return super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addKeyToBinaryBlob(ClientKeyBlock block, ClientContext context) {
        if (this.binaryBlobWriter == null) {
            return;
        }
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            if (this.finished) {
                if (logMINOR) {
                    Logger.minor(this, "Add key to binary blob for " + this + " but already finished");
                }
                return;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Adding key " + block.getClientKey().getURI() + " to " + this, (Throwable)new Exception("debug"));
        }
        try {
            this.binaryBlobWriter.addKey(block, context);
        }
        catch (IOException e) {
            Logger.error(this, "Failed to write key to binary blob stream: " + e, (Throwable)e);
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, "Failed to write key to binary blob stream: " + e), null, context);
        }
        catch (BinaryBlobWriter.BinaryBlobAlreadyClosedException e) {
            Logger.error(this, "Failed to write key to binary blob stream (already closed??): " + e, (Throwable)e);
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, "Failed to write key to binary blob stream (already closed??): " + e), null, context);
        }
    }

    protected boolean collectingBinaryBlob() {
        return this.binaryBlobWriter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExpectedMIME(ClientMetadata clientMetadata, ClientContext context) throws FetchException {
        if (this.finalizedMetadata) {
            return;
        }
        String mime = null;
        if (!clientMetadata.isTrivial()) {
            mime = clientMetadata.getMIMEType();
        }
        if (this.ctx.overrideMIME != null) {
            mime = this.ctx.overrideMIME;
        }
        if (mime == null || mime.equals("")) {
            return;
        }
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            this.expectedMIME = mime;
        }
        if (this.ctx.filterData) {
            UnsafeContentTypeException e = ContentFilter.checkMIMEType(mime);
            if (e != null) {
                throw e.createFetchException(mime, this.expectedSize);
            }
            if (this.forceCompatibleExtension != null) {
                this.checkCompatibleExtension(mime);
            }
        }
        context.getJobRunner(this.persistent()).queueNormalOrDrop(new PersistentJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ClientContext context) {
                String mime;
                2 var3_2 = this;
                synchronized (var3_2) {
                    mime = ClientGetter.this.expectedMIME;
                }
                ClientGetter.this.ctx.eventProducer.produceEvent(new ExpectedMIMEEvent(mime), context);
                return false;
            }
        });
    }

    private void checkCompatibleExtension(String mimeType) throws FetchException {
        FilterMIMEType type = ContentFilter.getMIMEType(mimeType);
        if (type == null) {
            return;
        }
        if (!DefaultMIMETypes.isValidExt(mimeType, this.forceCompatibleExtension)) {
            throw new FetchException(FetchException.FetchExceptionMode.MIME_INCOMPATIBLE_WITH_EXTENSION);
        }
    }

    @Override
    public void onExpectedSize(final long size, ClientContext context) {
        if (this.finalizedMetadata) {
            return;
        }
        if (this.finalBlocksRequired != 0) {
            return;
        }
        this.expectedSize = size;
        context.getJobRunner(this.persistent()).queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                ClientGetter.this.ctx.eventProducer.produceEvent(new ExpectedFileSizeEvent(size), context);
                return false;
            }
        });
    }

    @Override
    public void onFinalizedMetadata() {
        this.finalizedMetadata = true;
    }

    public boolean finalizedMetadata() {
        return this.finalizedMetadata;
    }

    public synchronized String expectedMIME() {
        return this.expectedMIME;
    }

    public synchronized long expectedSize() {
        return this.expectedSize;
    }

    public ClientGetCallback getClientCallback() {
        return this.clientCallback;
    }

    public SnoopMetadata getMetaSnoop() {
        return this.snoopMeta;
    }

    public SnoopMetadata setMetaSnoop(SnoopMetadata newSnoop) {
        SnoopMetadata old = this.snoopMeta;
        this.snoopMeta = newSnoop;
        return old;
    }

    public SnoopBucket getBucketSnoop() {
        return this.snoopBucket;
    }

    public SnoopBucket setBucketSnoop(SnoopBucket newSnoop) {
        SnoopBucket old = this.snoopBucket;
        this.snoopBucket = newSnoop;
        return old;
    }

    @Override
    public void onExpectedTopSize(long size, long compressed, int blocksReq, int blocksTotal, ClientContext context) {
        if (this.finalBlocksRequired != 0 || this.finalBlocksTotal != 0) {
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "New format metadata has top data: original size " + size + " (compressed " + compressed + ") blocks " + blocksReq + " / " + blocksTotal);
        }
        this.onExpectedSize(size, context);
        this.finalBlocksRequired = this.minSuccessBlocks + blocksReq;
        this.finalBlocksTotal = this.totalBlocks + blocksTotal;
        this.notifyClients(context);
    }

    @Override
    public void onSplitfileCompatibilityMode(final InsertContext.CompatibilityMode min, final InsertContext.CompatibilityMode max, final byte[] customSplitfileKey, final boolean dontCompress, final boolean bottomLayer, final boolean definitiveAnyway, ClientContext context) {
        context.getJobRunner(this.persistent()).queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                ClientGetter.this.ctx.eventProducer.produceEvent(new SplitfileCompatibilityModeEvent(min, max, customSplitfileKey, dontCompress, bottomLayer || definitiveAnyway), context);
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHashes(HashResult[] hashes, ClientContext context) {
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            if (this.hashes != null) {
                if (!HashResult.strictEquals(hashes, this.hashes)) {
                    Logger.error(this, "Two sets of hashes?!");
                }
                return;
            }
            this.hashes = hashes;
        }
        HashResult[] clientHashes = hashes;
        if (this.persistent()) {
            clientHashes = HashResult.copy(hashes);
        }
        final HashResult[] h = clientHashes;
        context.getJobRunner(this.persistent()).queueNormalOrDrop(new PersistentJob(){

            @Override
            public boolean run(ClientContext context) {
                ClientGetter.this.ctx.eventProducer.produceEvent(new ExpectedHashesEvent(h), context);
                return false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enterCooldown(ClientGetState state, long wakeupTime, ClientContext context) {
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            if (state != this.currentState) {
                return;
            }
        }
        if (wakeupTime != Long.MAX_VALUE) {
            this.ctx.eventProducer.produceEvent(new EnterFiniteCooldownEvent(wakeupTime), context);
        }
    }

    @Override
    public void clearCooldown(ClientGetState state) {
    }

    public Bucket getBlobBucket() {
        return this.binaryBlobWriter.getFinalBucket();
    }

    @Override
    public byte[] getClientDetail(ChecksumChecker checker) throws IOException {
        if (this.clientCallback instanceof PersistentClientCallback) {
            return ClientGetter.getClientDetail((PersistentClientCallback)((Object)this.clientCallback), checker);
        }
        return new byte[0];
    }

    @Override
    public void innerOnResume(ClientContext context) throws ResumeFailedException {
        super.innerOnResume(context);
        if (this.currentState != null) {
            try {
                this.currentState.onResume(context);
            }
            catch (FetchException e) {
                this.currentState = null;
                Logger.error(this, "Failed to resume: " + e, (Throwable)e);
                throw new ResumeFailedException(e);
            }
            catch (RuntimeException e) {
                Logger.error(this, "Failed to resume: " + e, (Throwable)e);
                throw new ResumeFailedException(e);
            }
        }
        this.notifyClients(context);
    }

    @Override
    protected ClientBaseCallback getCallback() {
        return this.clientCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeTrivialProgress(DataOutputStream dos) throws IOException {
        if (this.binaryBlobWriter != null || this.snoopBucket != null || this.snoopMeta != null || this.initialMetadata != null) {
            dos.writeBoolean(false);
            return false;
        }
        ClientGetState state = null;
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            state = this.currentState;
        }
        if (state == null || !(state instanceof SplitFileFetcher)) {
            dos.writeBoolean(false);
            return false;
        }
        SplitFileFetcher fetcher = (SplitFileFetcher)state;
        if (fetcher.cb != this) {
            dos.writeBoolean(false);
            return false;
        }
        return ((SplitFileFetcher)state).writeTrivialProgress(dos);
    }

    public boolean resumeFromTrivialProgress(DataInputStream dis, ClientContext context) throws IOException {
        if (dis.readBoolean()) {
            try {
                this.currentState = new SplitFileFetcher(this, dis, context);
                this.resumedFetcher = true;
                return true;
            }
            catch (StorageFormatException e) {
                Logger.error(this, "Failed to restore from splitfile, restarting: " + e, (Throwable)e);
                return false;
            }
            catch (ResumeFailedException e) {
                Logger.error(this, "Failed to restore from splitfile, restarting: " + e, (Throwable)e);
                return false;
            }
            catch (IOException e) {
                Logger.error(this, "Failed to restore from splitfile, restarting: " + e, (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public boolean resumedFetcher() {
        return this.resumedFetcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onShutdown(ClientContext context) {
        ClientGetState state;
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            state = this.currentState;
        }
        if (state != null) {
            state.onShutdown(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurrentState(ClientGetState state) {
        ClientGetter clientGetter = this;
        synchronized (clientGetter) {
            return this.currentState == state;
        }
    }

    @Override
    public File getCompletionFile() {
        if (this.returnBucket == null) {
            return null;
        }
        if (!(this.returnBucket instanceof FileBucket)) {
            return null;
        }
        return ((FileBucket)this.returnBucket).getFile();
    }

    static {
        Logger.registerClass(ClientGetter.class);
    }
}

