/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.async.ClientContext;
import freenet.client.async.USKCallback;
import freenet.client.async.USKProgressCallback;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.IdentifierCollisionException;
import freenet.clients.fcp.SubscribeUSKMessage;
import freenet.clients.fcp.SubscribedUSKRoundFinishedMessage;
import freenet.clients.fcp.SubscribedUSKSendingToNetworkMessage;
import freenet.clients.fcp.SubscribedUSKUpdate;
import freenet.keys.USK;
import freenet.node.NodeClientCore;

public class SubscribeUSK
implements USKProgressCallback {
    final FCPConnectionHandler handler;
    final String identifier;
    final NodeClientCore core;
    final boolean dontPoll;
    final short prio;
    final short prioProgress;
    final USK usk;
    final USKCallback toUnsub;

    public SubscribeUSK(SubscribeUSKMessage message, NodeClientCore core, FCPConnectionHandler handler) throws IdentifierCollisionException {
        this.handler = handler;
        this.dontPoll = message.dontPoll;
        this.identifier = message.identifier;
        this.core = core;
        this.usk = message.key;
        this.prio = message.prio;
        this.prioProgress = message.prioProgress;
        handler.addUSKSubscription(this.identifier, this);
        if (!message.dontPoll && message.sparsePoll) {
            this.toUnsub = core.uskManager.subscribeSparse(message.key, this, message.ignoreUSKDatehints, handler.getRebootClient().lowLevelClient(message.realTimeFlag));
        } else {
            core.uskManager.subscribe(message.key, this, !message.dontPoll, message.ignoreUSKDatehints, handler.getRebootClient().lowLevelClient(message.realTimeFlag));
            this.toUnsub = this;
        }
    }

    @Override
    public void onFoundEdition(long l, USK key, ClientContext context, boolean wasMetadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
        if (this.handler.isClosed()) {
            this.core.uskManager.unsubscribe(key, this.toUnsub);
            return;
        }
        SubscribedUSKUpdate msg = new SubscribedUSKUpdate(this.identifier, l, key, newKnownGood, newSlotToo);
        this.handler.send(msg);
    }

    @Override
    public short getPollingPriorityNormal() {
        return this.prio;
    }

    @Override
    public short getPollingPriorityProgress() {
        return this.prioProgress;
    }

    public void unsubscribe() {
        this.core.uskManager.unsubscribe(this.usk, this.toUnsub);
    }

    @Override
    public void onSendingToNetwork(ClientContext context) {
        this.handler.send(new SubscribedUSKSendingToNetworkMessage(this.identifier));
    }

    @Override
    public void onRoundFinished(ClientContext context) {
        this.handler.send(new SubscribedUSKRoundFinishedMessage(this.identifier));
    }
}

