/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class MultiValueTable<K, V> {
    private Hashtable<K, Vector<V>> table;
    private int ies;

    public MultiValueTable() {
        this(16, 3);
    }

    public MultiValueTable(int initialSize) {
        this(initialSize, 3);
    }

    public MultiValueTable(int initialSize, int initialEntrySize) {
        this.table = new Hashtable(initialSize);
        this.ies = initialEntrySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            Vector<Object> v = this.table.get(key);
            if (v == null) {
                v = new Vector(this.ies);
                this.table.put(key, v);
            }
            v.addElement(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            Vector<V> v = this.table.get(key);
            return v == null ? null : (V)v.firstElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            return this.table.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsElement(K key, V value) {
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            Vector<V> v = this.table.get(key);
            return v != null && v.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<V> getAll(K key) {
        Vector<V> v;
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            v = this.table.get(key);
        }
        return v == null ? new EmptyEnumeration() : v.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<V> iterateAll(K key) {
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            return this.table.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countAll(K key) {
        Vector<V> v;
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            v = this.table.get(key);
        }
        if (v != null) {
            return v.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSync(K key) {
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            return this.table.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getArray(K key) {
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            Vector<V> v = this.table.get(key);
            if (v == null) {
                return null;
            }
            Object[] r = new Object[v.size()];
            v.copyInto(r);
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            this.table.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            return this.table.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            this.table.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeElement(K key, V value) {
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            Vector<V> v = this.table.get(key);
            if (v == null) {
                return false;
            }
            boolean b = v.removeElement(value);
            if (v.isEmpty()) {
                this.table.remove(key);
            }
            return b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<K> keys() {
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            return this.table.keys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration<V> elements() {
        Hashtable<K, Vector<V>> hashtable = this.table;
        synchronized (hashtable) {
            if (this.table.isEmpty()) {
                return new EmptyEnumeration();
            }
            return new MultiValueEnumeration();
        }
    }

    private class MultiValueEnumeration
    implements Enumeration<V> {
        private Enumeration<V> current;
        private Enumeration<Vector<V>> global;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MultiValueEnumeration() {
            Hashtable hashtable = MultiValueTable.this.table;
            synchronized (hashtable) {
                this.global = MultiValueTable.this.table.elements();
            }
            this.current = this.global.nextElement().elements();
            this.step();
        }

        public final void step() {
            while (!this.current.hasMoreElements() && this.global.hasMoreElements()) {
                this.current = this.global.nextElement().elements();
            }
        }

        @Override
        public final boolean hasMoreElements() {
            return this.global.hasMoreElements();
        }

        @Override
        public final V nextElement() {
            Object o = this.current.nextElement();
            this.step();
            return o;
        }
    }

    private static class EmptyEnumeration<E>
    implements Enumeration<E> {
        private EmptyEnumeration() {
        }

        @Override
        public final boolean hasMoreElements() {
            return false;
        }

        @Override
        public final E nextElement() {
            throw new NoSuchElementException();
        }
    }
}

