/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.util;

public class RateCalculator {
    public static final int DEFAULT_INTERVAL_LENGTH = 300;
    public static final int DEFAULT_HISTORY_SIZE = 100;
    public static final float DEFAULT_HISTORY_WEIGHT = 0.8f;
    protected int intervalLength;
    protected int historySize;
    protected float historyWeight;
    protected double[] history;
    protected int historyPos;
    protected long lastIntervalTime = -1L;
    protected double currentIntervalEvents;
    protected double totalEvents;
    protected double lastEstimatedEventCount;
    protected long lastPositiveUpdateTime = -1L;
    protected long pauseTime = -1L;

    public RateCalculator() {
        this(300, 100, 0.8f);
    }

    public RateCalculator(int intervalLength, int historySize, float historyWeight) {
        this.intervalLength = intervalLength;
        this.historySize = historySize;
        this.historyWeight = historyWeight;
        this.history = new double[historySize];
        for (int i = 0; i < this.history.length; ++i) {
            this.history[i] = -1.0;
        }
    }

    public void pause() {
        this.pause(System.currentTimeMillis());
    }

    public void pause(long time) {
        if (this.pauseTime != -1L) {
            throw new IllegalStateException("RateCalculator already paused");
        }
        this.pauseTime = time;
    }

    public boolean isPaused() {
        return this.pauseTime != -1L;
    }

    public void resume() {
        this.resume(System.currentTimeMillis());
    }

    public void resume(long time) {
        if (this.pauseTime == -1L) {
            throw new IllegalStateException("RateCalculator not paused");
        }
        this.update(0.0, time);
        this.pauseTime = -1L;
    }

    public void update(double numEvents) {
        this.update(numEvents, System.currentTimeMillis());
    }

    public void update(double numEvents, long eventTime) {
        long deltaTime;
        this.currentIntervalEvents += numEvents;
        this.totalEvents += numEvents;
        if (this.pauseTime != -1L) {
            if (this.lastIntervalTime != -1L) {
                this.lastIntervalTime += eventTime - this.pauseTime;
            }
            if (this.lastPositiveUpdateTime != -1L) {
                this.lastPositiveUpdateTime += eventTime - this.pauseTime;
            }
            this.pauseTime = eventTime;
        }
        if (this.lastIntervalTime == -1L) {
            this.lastIntervalTime = eventTime;
            this.lastPositiveUpdateTime = eventTime;
            return;
        }
        if (numEvents > 0.0) {
            this.lastPositiveUpdateTime = eventTime;
        }
        if ((deltaTime = eventTime - this.lastIntervalTime) >= (long)this.intervalLength) {
            this.history[this.historyPos] = this.currentIntervalEvents / (double)deltaTime;
            this.historyPos = (this.historyPos + 1) % this.history.length;
            this.lastIntervalTime = eventTime;
            this.currentIntervalEvents = 0.0;
        }
    }

    public double getRate() {
        return this.getRate(System.currentTimeMillis());
    }

    public double getRate(long time) {
        this.update(0.0, time);
        double rate = 0.0;
        double total = 0.0;
        double weight = 1.0;
        for (int i = this.history.length - 1; i >= 0; --i) {
            double intervalRate = this.history[(this.historyPos + i) % this.history.length];
            if (intervalRate == -1.0) continue;
            rate += intervalRate * weight;
            total += weight;
            weight *= (double)this.historyWeight;
        }
        if (total == 0.0 && rate == 0.0) {
            return this.currentIntervalEvents / (double)(time - this.lastIntervalTime + 1L);
        }
        return rate / total;
    }

    public double getEstimatedEventCount(double maxEvents) {
        return this.getEstimatedEventCount(maxEvents, System.currentTimeMillis());
    }

    public double getEstimatedEventCount(double maxEvents, long time) {
        double rate = this.getRate(time);
        long deltaTime = time - this.lastPositiveUpdateTime;
        double estimatedEventCount = this.totalEvents + (double)deltaTime * rate;
        return estimatedEventCount;
    }

    public long getEstimatedTimeRemaining(double maxEvents) {
        return this.getEstimatedTimeRemaining(maxEvents, System.currentTimeMillis());
    }

    public long getEstimatedTimeRemaining(double maxEvents, long time) {
        double rate = this.getRate(time);
        double estimatedEventCount = this.getEstimatedEventCount(maxEvents, time);
        return (long)((maxEvents - estimatedEventCount) / rate);
    }
}

