/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.ContentDataFilter;
import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.l10n.NodeL10n;
import freenet.support.io.FileUtil;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;

public class BMPFilter
implements ContentDataFilter {
    static final byte[] bmpHeaderwindows = new byte[]{66, 77};
    static final byte[] bmpHeaderos2bArray = new byte[]{66, 65};
    static final byte[] bmpHeaderos2cIcon = new byte[]{67, 73};
    static final byte[] bmpHeaderos2cPointer = new byte[]{67, 80};
    static final byte[] bmpHeaderos2Icon = new byte[]{73, 67};
    static final byte[] bmpHeaderos2Pointer = new byte[]{80, 84};

    private int unsignedByte(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    public int readInt(DataInputStream dis) throws IOException {
        byte[] data = new byte[4];
        int result = dis.read(data);
        if (result < 0) {
            throw new EOFException();
        }
        result = this.unsignedByte(data[2]) << 16 | this.unsignedByte(data[1]) << 8 | this.unsignedByte(data[0]);
        return result |= this.unsignedByte(data[3]) << 24;
    }

    public int readShort(DataInputStream dis) throws IOException {
        int result = dis.read();
        if (result < 0) {
            throw new EOFException();
        }
        int r2 = dis.read();
        if (r2 < 0) {
            throw new EOFException();
        }
        return result | r2 * 256;
    }

    @Override
    public void readFilter(InputStream input, OutputStream output, String charset, HashMap<String, String> otherParams, String schemeHostAndPort, FilterCallback cb) throws DataFilterException, IOException {
        int imagedatasize;
        int compression_type;
        int bitDepth;
        int no_plane;
        int size_bitmapinfoheader;
        DataInputStream dis = new DataInputStream(input);
        dis.mark(54);
        byte[] StartWord = new byte[2];
        dis.readFully(StartWord);
        if (!(Arrays.equals(StartWord, bmpHeaderwindows) || Arrays.equals(StartWord, bmpHeaderos2bArray) || Arrays.equals(StartWord, bmpHeaderos2cIcon) || Arrays.equals(StartWord, bmpHeaderos2cPointer) || Arrays.equals(StartWord, bmpHeaderos2Icon) || Arrays.equals(StartWord, bmpHeaderos2Pointer))) {
            this.throwHeaderError(BMPFilter.l10n("InvalidStartWordT"), BMPFilter.l10n("InvalidStartWordD"));
        }
        int fileSize = this.readInt(dis);
        byte[] skipbytes = new byte[4];
        dis.readFully(skipbytes);
        int headerSize = this.readInt(dis);
        if (headerSize < 0) {
            this.throwHeaderError(BMPFilter.l10n("InvalidOffsetT"), BMPFilter.l10n("InvalidOffsetD"));
        }
        if ((size_bitmapinfoheader = this.readInt(dis)) != 40) {
            this.throwHeaderError(BMPFilter.l10n("InvalidBitMapInfoHeaderSizeT"), BMPFilter.l10n("InvalidBitMapInfoHeaderSizeD"));
        }
        int imageWidth = this.readInt(dis);
        int imageHeight = this.readInt(dis);
        if (imageWidth < 0 || imageHeight < 0) {
            this.throwHeaderError(BMPFilter.l10n("InvalidDimensionT"), BMPFilter.l10n("InvalidDimensionD"));
        }
        if ((no_plane = this.readShort(dis)) != 1) {
            this.throwHeaderError(BMPFilter.l10n("InvalidNoOfPlanesT"), BMPFilter.l10n("InvalidNoOfPlanesD"));
        }
        if ((bitDepth = this.readShort(dis)) != 1 && bitDepth != 2 && bitDepth != 4 && bitDepth != 8 && bitDepth != 16 && bitDepth != 24 && bitDepth != 32) {
            this.throwHeaderError(BMPFilter.l10n("InvalidBitDepthT"), BMPFilter.l10n("InvalidBitDepthD"));
        }
        if ((compression_type = this.readInt(dis)) < 0 || compression_type > 3) {
            this.throwHeaderError(BMPFilter.l10n("Invalid Compression type"), BMPFilter.l10n("Compression type field is set to " + compression_type + " instead of 0-3"));
        }
        if (fileSize != headerSize + (imagedatasize = this.readInt(dis))) {
            this.throwHeaderError(BMPFilter.l10n("InvalidFileSizeT"), BMPFilter.l10n("InvalidFileSizeD"));
        }
        int horizontal_resolution = this.readInt(dis);
        int vertical_resolution = this.readInt(dis);
        if (horizontal_resolution < 0 || vertical_resolution < 0) {
            this.throwHeaderError(BMPFilter.l10n("InvalidResolutionT"), BMPFilter.l10n("InvalidResolutionD"));
        }
        if (compression_type == 0) {
            int bytesPerLine;
            int calculatedsize;
            int bitsPerLine = imageWidth * bitDepth;
            if (bitsPerLine % 32 != 0) {
                bitsPerLine += 32 - bitsPerLine % 32;
            }
            if ((calculatedsize = (bytesPerLine = bitsPerLine / 8) * imageHeight) != imagedatasize) {
                this.throwHeaderError(BMPFilter.l10n("InvalidImageDataSizeT"), BMPFilter.l10n("InvalidImageDataSizeD"));
            }
        }
        dis.reset();
        FileUtil.copy(dis, output, -1L);
        output.flush();
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("BMPFilter." + key);
    }

    private void throwHeaderError(String shortReason, String reason) throws DataFilterException {
        String message = BMPFilter.l10n("notBMP");
        if (reason != null) {
            message = message + ' ' + reason;
        }
        if (shortReason != null) {
            message = message + " - (" + shortReason + ')';
        }
        throw new DataFilterException(shortReason, shortReason, message);
    }
}

