/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CodecPacket;
import freenet.client.filter.ContentDataFilter;
import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.client.filter.FlacFrame;
import freenet.client.filter.FlacMetadataBlock;
import freenet.client.filter.FlacPacketFilter;
import freenet.l10n.NodeL10n;
import freenet.support.Logger;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class FlacFilter
implements ContentDataFilter {
    static final byte[] magicNumber = new byte[]{102, 76, 97, 67};

    @Override
    public void readFilter(InputStream input, OutputStream output, String charset, HashMap<String, String> otherParams, String schemeHostAndPort, FilterCallback cb) throws DataFilterException, IOException {
        boolean logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, this.getClass());
        FlacPacketFilter parser = new FlacPacketFilter();
        DataInputStream in = new DataInputStream(input);
        State currentState = State.UNINITIALIZED;
        short frameHeader = 0;
        for (byte magicCharacter : magicNumber) {
            if (magicCharacter == in.readByte()) continue;
            throw new DataFilterException(FlacFilter.l10n("InvalidFLACStreamTitle"), FlacFilter.l10n("InvalidFLACStreamTitle"), FlacFilter.l10n("InvalidFLACStreamMessage"));
        }
        output.write(magicNumber);
        while (currentState != State.STREAM_FINISHED) {
            CodecPacket packet = null;
            try {
                if (currentState == State.METADATA_FOUND) {
                    frameHeader = (short)(in.readUnsignedShort() & 0xFFFF);
                }
                byte[] payload = null;
                switch (currentState) {
                    case UNINITIALIZED: {
                        if (logMINOR) {
                            Logger.minor(this, "Reading metadata packet");
                        }
                        int header = in.readInt();
                        payload = new byte[header & 0xFFFFFF];
                        if (logMINOR) {
                            Logger.minor(this, "About to read " + payload.length + " bytes");
                        }
                        in.readFully(payload);
                        packet = new FlacMetadataBlock(header, payload);
                        if (!logMINOR) break;
                        Logger.minor(this, (Object)((Object)((FlacMetadataBlock)packet).getMetadataBlockType()) + " packet read");
                        break;
                    }
                    case METADATA_FOUND: {
                        if (logMINOR) {
                            Logger.minor(this, "Reading audio packet");
                        }
                        boolean firstHalfOfSyncHeaderFound = false;
                        ArrayList<Byte> buffer = new ArrayList<Byte>();
                        int data = 0;
                        buffer.add((byte)((frameHeader & 0xFF00) >>> 8));
                        buffer.add((byte)(frameHeader & 0xFF));
                        boolean running = true;
                        while (running) {
                            try {
                                data = in.readUnsignedByte();
                            }
                            catch (EOFException e) {
                                currentState = State.STREAM_FINISHED;
                                running = false;
                                frameHeader = 0;
                                payload = new byte[buffer.size()];
                                for (int i = 0; i < buffer.size(); ++i) {
                                    byte item;
                                    payload[i] = item = ((Byte)buffer.get(i)).byteValue();
                                }
                                packet = new FlacFrame(payload);
                            }
                            if (!firstHalfOfSyncHeaderFound) {
                                if ((data & 0xFF) == 255) {
                                    firstHalfOfSyncHeaderFound = true;
                                    continue;
                                }
                            } else if ((data & 0x7E) == 125) {
                                frameHeader = (short)(0xFF00 | data);
                                payload = new byte[buffer.size()];
                                for (int i = 0; i < buffer.size(); ++i) {
                                    byte item;
                                    payload[i] = item = ((Byte)buffer.get(i)).byteValue();
                                }
                                running = false;
                                packet = new FlacFrame(payload);
                            } else {
                                firstHalfOfSyncHeaderFound = false;
                                buffer.add((byte)-1);
                            }
                            buffer.add((byte)(data & 0xFF));
                        }
                        break;
                    }
                }
                if (currentState == State.UNINITIALIZED && packet instanceof FlacMetadataBlock && ((FlacMetadataBlock)packet).isLastMetadataBlock()) {
                    currentState = State.METADATA_FOUND;
                }
                if ((packet = parser.parse(packet)) == null) continue;
                output.write(packet.toArray());
            }
            catch (EOFException e) {
                return;
            }
        }
    }

    public void writeFilter(InputStream input, OutputStream output, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("FLAC." + key);
    }

    static enum State {
        UNINITIALIZED,
        STREAMINFO_FOUND,
        METADATA_FOUND,
        STREAM_FINISHED;

    }
}

