/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.ContentDataFilter;
import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.l10n.NodeL10n;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;

public class GIFFilter
implements ContentDataFilter {
    static final int HEADER_SIZE = 6;
    static final byte[] gif87aHeader = new byte[]{71, 73, 70, 56, 55, 97};
    static final byte[] gif89aHeader = new byte[]{71, 73, 70, 56, 57, 97};

    @Override
    public void readFilter(InputStream input, OutputStream output, String charset, HashMap<String, String> otherParams, String schemeHostAndPort, FilterCallback cb) throws DataFilterException, IOException {
        DataInputStream dis = new DataInputStream(input);
        try {
            byte[] headerCheck = new byte[6];
            dis.readFully(headerCheck);
            boolean isGIF87a = Arrays.equals(headerCheck, gif87aHeader);
            boolean isGIF89a = Arrays.equals(headerCheck, gif89aHeader);
            if (!isGIF87a && !isGIF89a) {
                GIFFilter.throwDataError(GIFFilter.l10n("invalidHeaderTitle"), GIFFilter.l10n("invalidHeader"));
            }
            output.write(headerCheck);
            if (isGIF87a) {
                GIF87aValidator.filter(input, output);
            } else if (isGIF89a) {
                GIF89aValidator.filter(input, output);
            }
        }
        catch (EOFException e) {
            GIFFilter.throwDataError(GIFFilter.l10n("unexpectedEOFTitle"), GIFFilter.l10n("unexpectedEOF"));
        }
        output.flush();
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("GIFFilter." + key);
    }

    private static void throwDataError(String shortReason, String reason) throws DataFilterException {
        String message = GIFFilter.l10n("notGif");
        if (reason != null) {
            message = message + ' ' + reason;
        }
        if (shortReason != null) {
            message = message + " - (" + shortReason + ')';
        }
        throw new DataFilterException(shortReason, shortReason, message);
    }

    private static class GIF89aValidator
    extends GIFValidator {
        private boolean hasGraphicControl = false;
        private int gcFlags;
        private int gcDelayTime;
        private int gcTransparentColor;
        private boolean firstBlock = true;
        private static final int GRAPHIC_CONTROL_LABEL = 249;
        private static final int APPLICATION_LABEL = 255;
        private static final byte[] NETSCAPE2_0_SIG = new byte[]{78, 69, 84, 83, 67, 65, 80, 69, 50, 46, 48};
        private static final byte[] ANIMEXTS1_0_SIG = new byte[]{65, 78, 73, 77, 69, 88, 84, 83, 49, 46, 48};

        private GIF89aValidator(InputStream input, OutputStream output) {
            super(input, output);
        }

        static void filter(InputStream input, OutputStream output) throws IOException, DataFilterException {
            new GIF89aValidator(input, output).filter();
        }

        @Override
        protected void filterExtensionBlock() throws IOException {
            int label = this.readByte();
            switch (label) {
                case 249: {
                    this.readGraphicControl();
                    break;
                }
                case 255: {
                    this.filterApplicationBlock();
                    break;
                }
                default: {
                    this.skipSubBlocks();
                }
            }
        }

        @Override
        protected void foundImageData(boolean success) throws IOException {
            if (success && this.hasGraphicControl) {
                this.writeGraphicControl();
            }
            this.hasGraphicControl = false;
            if (success) {
                this.firstBlock = false;
            }
        }

        private void filterApplicationBlock() throws IOException {
            int remaining;
            int length = this.readByte();
            byte[] signature = this.readBytes(length);
            if (Arrays.equals(signature, ANIMEXTS1_0_SIG) || Arrays.equals(signature, NETSCAPE2_0_SIG)) {
                int subLength = this.readByte();
                if (subLength == 3) {
                    int subID = this.readByte();
                    int loopCount = this.readShort();
                    remaining = this.readByte();
                    if (remaining == 0 && subID == 1 && this.firstBlock) {
                        this.writeByte(33);
                        this.writeByte(255);
                        this.writeByte(NETSCAPE2_0_SIG.length);
                        this.writeBytes(NETSCAPE2_0_SIG);
                        this.writeByte(subLength);
                        this.writeByte(subID);
                        this.writeShort(loopCount);
                        this.writeByte(0);
                        this.firstBlock = false;
                    }
                } else {
                    remaining = subLength;
                }
            } else {
                remaining = this.readByte();
            }
            if (remaining != 0) {
                this.skip(remaining);
                this.skipSubBlocks();
            }
        }

        private void readGraphicControl() throws IOException {
            if (this.hasGraphicControl) {
                this.skipSubBlocks();
                return;
            }
            int length = this.readByte();
            if (length != 4) {
                this.skip(length);
                this.skipSubBlocks();
                return;
            }
            this.gcFlags = this.readByte();
            this.gcDelayTime = this.readShort();
            this.gcTransparentColor = this.readByte();
            int terminator = this.readByte();
            if (terminator != 0) {
                this.skip(terminator);
                this.skipSubBlocks();
                return;
            }
            int disposalMethod = (this.gcFlags & 0x1C) >>> 2;
            if (disposalMethod >= 4) {
                return;
            }
            this.hasGraphicControl = true;
        }

        private void writeGraphicControl() throws IOException {
            this.writeByte(33);
            this.writeByte(249);
            this.writeByte(4);
            this.writeByte(this.gcFlags);
            this.writeShort(this.gcDelayTime);
            this.writeByte(this.gcTransparentColor);
            this.writeByte(0);
            this.firstBlock = false;
        }
    }

    private static class GIF87aValidator
    extends GIFValidator {
        private GIF87aValidator(InputStream input, OutputStream output) {
            super(input, output);
        }

        @Override
        protected boolean validateScreenDescriptor() {
            boolean sort;
            boolean bl = sort = (this.screenFlags & 8) == 8;
            if (sort || this.screenAspectRatio != 0) {
                return false;
            }
            return super.validateScreenDescriptor();
        }

        @Override
        protected boolean validateImageFlags(int imageFlags) {
            return (imageFlags & 0x38) == 0 && super.validateImageFlags(imageFlags);
        }

        static void filter(InputStream input, OutputStream output) throws IOException, DataFilterException {
            new GIF87aValidator(input, output).filter();
        }
    }

    private static abstract class GIFValidator {
        private final InputStream input;
        private final OutputStream output;
        protected int screenWidth;
        protected int screenHeight;
        protected int screenFlags;
        protected int screenColors;
        protected int screenBackgroundColor;
        protected int screenAspectRatio;
        private static final int IMAGE_SEPARATOR = 44;
        private static final int GIF_TERMINATOR = 59;
        protected static final int EXTENSION_INTRODUCER = 33;

        protected GIFValidator(InputStream input, OutputStream output) {
            this.input = input;
            this.output = output;
        }

        protected boolean validateScreenDescriptor() {
            return this.screenBackgroundColor < this.screenColors;
        }

        protected boolean validateImageFlags(int imageFlags) {
            return true;
        }

        protected void filterExtensionBlock() throws IOException {
            this.skipExtensionBlock();
        }

        protected void foundImageData(boolean valid) throws IOException {
        }

        protected final void filter() throws IOException, DataFilterException {
            boolean hasGlobalColorMap;
            this.readScreenDescriptor();
            if (!this.validateScreenDescriptor()) {
                GIFFilter.throwDataError(GIFFilter.l10n("invalidHeaderTitle"), GIFFilter.l10n("invalidHeader"));
            }
            this.writeScreenDescriptor();
            boolean bl = hasGlobalColorMap = (this.screenFlags & 0x80) == 128;
            if (hasGlobalColorMap) {
                this.copy(3 * this.screenColors);
            }
            this.filterData();
        }

        private void readScreenDescriptor() throws IOException, DataFilterException {
            this.screenWidth = this.readShort();
            this.screenHeight = this.readShort();
            this.screenFlags = this.readByte();
            this.screenBackgroundColor = this.readByte();
            this.screenAspectRatio = this.readByte();
            int bitsPerPixel = (this.screenFlags & 7) + 1;
            this.screenColors = 1 << bitsPerPixel;
        }

        private void writeScreenDescriptor() throws IOException {
            this.writeShort(this.screenWidth);
            this.writeShort(this.screenHeight);
            this.writeByte(this.screenFlags);
            this.writeByte(this.screenBackgroundColor);
            this.writeByte(this.screenAspectRatio);
        }

        private void filterData() throws IOException, DataFilterException {
            int lastByte;
            boolean imageSeen = false;
            boolean terminated = false;
            block5: while (!terminated && (lastByte = this.input.read()) != -1) {
                switch (lastByte) {
                    case 44: {
                        imageSeen |= this.filterImage();
                        continue block5;
                    }
                    case 59: {
                        terminated |= imageSeen;
                        continue block5;
                    }
                    case 33: {
                        this.filterExtensionBlock();
                        continue block5;
                    }
                }
            }
            if (!imageSeen) {
                GIFFilter.throwDataError(GIFFilter.l10n("noDataTitle"), GIFFilter.l10n("noData"));
            }
            if (!terminated) {
                GIFFilter.throwDataError(GIFFilter.l10n("unterminatedGifTitle"), GIFFilter.l10n("unterminatedGif"));
            }
            this.writeByte(59);
        }

        private boolean filterImage() throws IOException, DataFilterException {
            byte[] localColorMap;
            boolean hasLocalColorMap;
            int imageLeft = this.readShort();
            int imageTop = this.readShort();
            int imageWidth = this.readShort();
            int imageHeight = this.readShort();
            int imageFlags = this.readByte();
            boolean bl = hasLocalColorMap = (imageFlags & 0x80) == 128;
            if (hasLocalColorMap) {
                int bitsPerPixel = (imageFlags & 7) + 1;
                int imageColors = 1 << bitsPerPixel;
                localColorMap = this.readBytes(3 * imageColors);
            } else {
                localColorMap = new byte[]{};
            }
            int lzwCodeSize = this.readByte();
            if (imageLeft + imageWidth > this.screenWidth || imageTop + imageHeight > this.screenHeight || lzwCodeSize < 2 || lzwCodeSize >= 12 || !this.validateImageFlags(imageFlags)) {
                this.foundImageData(false);
                this.skipSubBlocks();
                return false;
            }
            this.foundImageData(true);
            this.writeByte(44);
            this.writeShort(imageLeft);
            this.writeShort(imageTop);
            this.writeShort(imageWidth);
            this.writeShort(imageHeight);
            this.writeByte(imageFlags);
            this.writeBytes(localColorMap);
            this.writeByte(lzwCodeSize);
            this.copySubBlocks();
            return true;
        }

        private void skipExtensionBlock() throws IOException {
            this.skip(1);
            this.skipSubBlocks();
        }

        protected final void skipSubBlocks() throws IOException {
            int length;
            while ((length = this.readByte()) != 0) {
                this.skip(length);
            }
        }

        protected final void copySubBlocks() throws IOException {
            int length;
            while ((length = this.readByte()) != 0) {
                this.writeByte(length);
                this.copy(length);
            }
            this.writeByte(0);
        }

        protected final void copy(int length) throws IOException {
            for (int i = 0; i < length; ++i) {
                this.writeByte(this.readByte());
            }
        }

        protected final int readByte() throws IOException {
            int val = this.input.read();
            if (val == -1) {
                throw new EOFException();
            }
            return val;
        }

        protected final void writeByte(int val) throws IOException {
            this.output.write(val & 0xFF);
        }

        protected final byte[] readBytes(int num) throws IOException {
            int read;
            byte[] buf = new byte[num];
            for (int remaining = buf.length; remaining > 0; remaining -= read) {
                read = this.input.read(buf, buf.length - remaining, remaining);
                if (read > 0) continue;
                throw new EOFException();
            }
            return buf;
        }

        protected final void writeBytes(byte[] data) throws IOException {
            this.output.write(data);
        }

        protected final int readShort() throws IOException {
            int lsb = this.readByte();
            int msb = this.readByte();
            return msb << 8 | lsb;
        }

        protected final void writeShort(int val) throws IOException {
            this.output.write(val & 0xFF);
            this.output.write(val >>> 8 & 0xFF);
        }

        protected final void skip(int num) throws IOException {
            long remaining = num;
            while (remaining > 0L) {
                long skipped = this.input.skip(remaining);
                remaining -= skipped;
                if (skipped != 0L) continue;
                this.readByte();
                --remaining;
            }
        }
    }
}

