/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.ContentDataFilter;
import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.l10n.NodeL10n;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.CountedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;

public class JPEGFilter
implements ContentDataFilter {
    private final boolean deleteComments;
    private final boolean deleteExif;
    private static final int MARKER_EOI = 217;
    private static final int MARKER_RST0 = 208;
    private static final int MARKER_RST7 = 215;
    private static volatile boolean logMINOR;
    static final byte[] soi;
    static final byte[] identifier;
    static final byte[] extensionIdentifier;

    JPEGFilter(boolean deleteComments, boolean deleteExif) {
        this.deleteComments = deleteComments;
        this.deleteExif = deleteExif;
    }

    @Override
    public void readFilter(InputStream input, OutputStream output, String charset, HashMap<String, String> otherParams, String schemeHostAndPort, FilterCallback cb) throws DataFilterException, IOException {
        this.readFilter(input, output, charset, otherParams, cb, this.deleteComments, this.deleteExif);
        output.flush();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void readFilter(InputStream input, OutputStream output, String charset, HashMap<String, String> otherParams, FilterCallback cb, boolean deleteComments, boolean deleteExif) throws DataFilterException, IOException {
        CountedInputStream cis = new CountedInputStream(input);
        DataInputStream dis = new DataInputStream(cis);
        this.assertHeader(dis, soi);
        output.write(soi);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        boolean finished = false;
        int forceMarkerType = -1;
        block3: while (true) {
            block51: {
                int blockLength;
                long countAtStart;
                int markerType;
                block49: {
                    block52: {
                        String type;
                        block53: {
                            block50: {
                                if (finished) return;
                                baos.reset();
                                if (forceMarkerType != -1) {
                                    markerType = forceMarkerType;
                                    forceMarkerType = -1;
                                } else {
                                    int markerStart = dis.read();
                                    if (markerStart == -1) {
                                        return;
                                    }
                                    if (finished) {
                                        if (!logMINOR) return;
                                        Logger.minor(this, "More data after EOI, copying to truncate");
                                        return;
                                    }
                                    if (markerStart != 255) {
                                        this.throwError("Invalid marker", "The file includes an invalid marker start " + Integer.toHexString(markerStart) + " and cannot be parsed further.");
                                    }
                                    if (baos != null) {
                                        baos.write(255);
                                    }
                                    markerType = dis.readUnsignedByte();
                                    if (baos != null) {
                                        baos.write(markerType);
                                    }
                                }
                                if (logMINOR) {
                                    Logger.minor(this, "Marker type: " + Integer.toHexString(markerType));
                                }
                                countAtStart = cis.count();
                                if (markerType == 217 || markerType >= 208 && markerType <= 215) {
                                    blockLength = 0;
                                } else {
                                    blockLength = dis.readUnsignedShort();
                                    dos.writeShort(blockLength);
                                }
                                if (markerType != 218) break block50;
                                if (blockLength < 2) {
                                    this.throwError("Invalid frame length", "The file includes an invalid frame (length " + blockLength + ").");
                                }
                                byte[] buf = new byte[blockLength - 2];
                                dis.readFully(buf);
                                dos.write(buf);
                                Logger.minor(this, "Copied start-of-frame marker length " + (blockLength - 2));
                                if (baos != null) {
                                    baos.writeTo(output);
                                }
                                break block51;
                            }
                            if (markerType != 224) break block52;
                            if (logMINOR) {
                                Logger.minor(this, "APP0");
                            }
                            type = this.readNullTerminatedAsciiString(dis);
                            if (baos != null) {
                                this.writeNullTerminatedString(baos, type);
                            }
                            if (logMINOR) {
                                Logger.minor(this, "Type: " + type + " length " + type.length());
                            }
                            if (!type.equals("JFIF")) break block53;
                            Logger.minor(this, "JFIF Header");
                            int majorVersion = dis.readUnsignedByte();
                            if (majorVersion != 1) {
                                this.throwError("Invalid header", "Unrecognized major version " + majorVersion + ".");
                            }
                            dos.write(majorVersion);
                            int minorVersion = dis.readUnsignedByte();
                            if (minorVersion > 2) {
                                this.throwError("Invalid header", "Unrecognized version 1." + minorVersion + ".");
                            }
                            dos.write(minorVersion);
                            int units = dis.readUnsignedByte();
                            if (units > 2) {
                                this.throwError("Invalid header", "Unrecognized units type " + units + ".");
                            }
                            dos.write(units);
                            dos.writeShort(dis.readShort());
                            dos.writeShort(dis.readShort());
                            int thumbX = dis.readUnsignedByte();
                            dos.writeByte(thumbX);
                            int thumbY = dis.readUnsignedByte();
                            dos.writeByte(thumbY);
                            int thumbLen = thumbX * thumbY * 3;
                            byte[] buf = new byte[thumbLen];
                            dis.readFully(buf);
                            dos.write(buf);
                            break block49;
                        }
                        if (type.equals("JFXX")) {
                            int extensionCode = dis.readUnsignedByte();
                            if (extensionCode == 16 || extensionCode == 17 || extensionCode == 19) {
                                dos.write(extensionCode);
                                this.skipRest(blockLength, countAtStart, cis, dis, dos, "thumbnail frame");
                                Logger.minor(this, "Thumbnail frame");
                                break block49;
                            } else {
                                this.throwError("Unknown JFXX extension " + extensionCode, "The file contains an unknown JFXX extension.");
                            }
                            break block49;
                        } else {
                            if (logMINOR) {
                                Logger.minor(this, "Dropping application-specific APP0 chunk named " + type);
                            }
                            this.skipRest(blockLength, countAtStart, cis, dis, dos, "application-specific frame");
                            continue;
                        }
                    }
                    if (markerType == 225) {
                        if (deleteExif) {
                            if (logMINOR) {
                                Logger.minor(this, "Dropping EXIF data");
                            }
                            this.skipBytes(dis, blockLength - 2);
                            continue;
                        }
                        this.skipRest(blockLength, countAtStart, cis, dis, dos, "EXIF frame");
                    } else if (markerType == 254) {
                        if (deleteComments) {
                            this.skipBytes(dis, blockLength - 2);
                            if (!logMINOR) continue;
                            Logger.minor(this, "Dropping comment length " + (blockLength - 2) + '.');
                            continue;
                        }
                        this.skipRest(blockLength, countAtStart, cis, dis, dos, "comment");
                    } else if (markerType == 217) {
                        finished = true;
                        if (logMINOR) {
                            Logger.minor(this, "End of image");
                        }
                    } else {
                        boolean valid = false;
                        switch (markerType) {
                            case 192: 
                            case 193: 
                            case 194: 
                            case 195: 
                            case 196: 
                            case 197: 
                            case 198: 
                            case 199: 
                            case 201: 
                            case 202: 
                            case 203: 
                            case 204: 
                            case 205: 
                            case 207: 
                            case 208: 
                            case 209: 
                            case 210: 
                            case 211: 
                            case 212: 
                            case 213: 
                            case 214: 
                            case 215: 
                            case 216: 
                            case 217: 
                            case 218: 
                            case 219: 
                            case 220: 
                            case 221: 
                            case 222: 
                            case 223: {
                                valid = true;
                                break;
                            }
                        }
                        if (valid) {
                            if (blockLength < 2) {
                                this.throwError("Invalid frame length", "The file includes an invalid frame (length " + blockLength + ").");
                            }
                            byte[] buf = new byte[blockLength - 2];
                            dis.readFully(buf);
                            dos.write(buf);
                            Logger.minor(this, "Essential frame type " + Integer.toHexString(markerType) + " length " + (blockLength - 2) + " offset at end " + cis.count());
                        } else {
                            if (markerType >= 224 && markerType <= 239) {
                                if (logMINOR) {
                                    Logger.minor(this, "Dropping application marker type " + Integer.toHexString(markerType) + " length " + blockLength);
                                }
                            } else if (logMINOR) {
                                Logger.minor(this, "Dropping unknown frame type " + Integer.toHexString(markerType) + " blockLength");
                            }
                            this.skipBytes(dis, blockLength - 2);
                            continue;
                        }
                    }
                }
                if (cis.count() != countAtStart + (long)blockLength) {
                    this.throwError("Invalid frame", "The length of the frame is incorrect (read " + (cis.count() - countAtStart) + " bytes, frame length " + blockLength + " for type " + Integer.toHexString(markerType) + ").");
                }
                baos.writeTo(output);
                continue;
            }
            int prevChar = -1;
            while (true) {
                int x = dis.read();
                if (prevChar != -1 && output != null) {
                    output.write(prevChar);
                }
                if (x == -1) continue block3;
                if (prevChar == 255 && x != 0 && (x < 208 || x > 215)) {
                    forceMarkerType = x;
                    if (logMINOR) {
                        Logger.minor(this, "Moved scan at " + cis.count() + ", found a marker type " + Integer.toHexString(x));
                    }
                    if (output == null) continue block3;
                    output.write(x);
                    continue block3;
                }
                prevChar = x;
            }
            break;
        }
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("JPEGFilter." + key);
    }

    private void writeNullTerminatedString(ByteArrayOutputStream baos, String type) throws IOException {
        try {
            byte[] data = type.getBytes("ISO-8859-1");
            baos.write(data);
            baos.write(0);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support ISO-8859-1: " + e, e);
        }
    }

    private String readNullTerminatedAsciiString(DataInputStream dis) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int x;
            if ((x = dis.read()) == -1) {
                this.throwError("Invalid extension frame", "Could not read an extension frame name.");
            }
            if (x == 0) break;
            char c = (char)x;
            if (x > 128 || c < ' ' && c != '\n' && c != '\r') {
                this.throwError("Invalid extension frame name", "Non-ASCII character in extension frame name");
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void skipRest(int blockLength, long countAtStart, CountedInputStream cis, DataInputStream dis, DataOutputStream dos, String thing) throws IOException {
        int skip = (int)((long)blockLength - (cis.count() - countAtStart));
        if (skip < 0) {
            this.throwError("Invalid " + thing, "The file includes an invalid " + thing + '.');
        }
        if (skip == 0) {
            return;
        }
        byte[] buf = new byte[skip];
        dis.readFully(buf);
        dos.write(buf);
    }

    private void skipBytes(DataInputStream dis, int skip) throws IOException {
        int skipped = 0;
        while (skipped < skip) {
            long x = dis.skip(skip - skipped);
            if (x <= 0L) {
                byte[] buf = new byte[Math.min(4096, skip - skipped)];
                dis.readFully(buf);
                skipped += buf.length;
                continue;
            }
            skipped = (int)((long)skipped + x);
        }
    }

    private void assertHeader(DataInputStream dis, byte[] expected) throws IOException {
        byte[] read = new byte[expected.length];
        dis.readFully(read);
        if (!Arrays.equals(read, expected)) {
            this.throwError("Invalid header", "The file does not start with a valid JPEG (JFIF) header.");
        }
    }

    private void throwError(String shortReason, String reason) throws DataFilterException {
        String message = JPEGFilter.l10n("notJpeg");
        if (reason != null) {
            message = message + ' ' + reason;
        }
        if (shortReason != null) {
            message = message + " - " + shortReason;
        }
        DataFilterException e = new DataFilterException(shortReason, shortReason, message);
        if (logMINOR) {
            Logger.normal(this, "Throwing " + e.getMessage(), (Throwable)e);
        }
        throw e;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        soi = new byte[]{-1, -40};
        identifier = new byte[]{74, 70, 73, 70, 0};
        extensionIdentifier = new byte[]{74, 70, 88, 88, 0};
    }
}

