/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CommentException;
import freenet.client.filter.ContentDataFilter;
import freenet.client.filter.ContentFilter;
import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.l10n.NodeL10n;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;

public class M3UFilter
implements ContentDataFilter {
    static final byte[] CHAR_COMMENT_START = new byte[]{35};
    static final byte[] CHAR_NEWLINE = new byte[]{10};
    static final byte[] CHAR_CARRIAGE_RETURN = new byte[]{13};
    static final int MAX_URI_LENGTH = 16384;
    static final String badUriReplacement = "#bad-uri-removed";
    private final long MAX_LENGTH_NO_PROGRESS = 0x6E00000L;

    @Override
    public void readFilter(InputStream input, OutputStream output, String charset, HashMap<String, String> otherParams, String schemeHostAndPort, FilterCallback cb) throws DataFilterException, IOException {
        boolean isComment = false;
        boolean isBadUri = false;
        boolean numberOfDotsInUri = false;
        byte[] nextbyte = new byte[1];
        DataInputStream dis = new DataInputStream(input);
        DataOutputStream dos = new DataOutputStream(output);
        int readcount = dis.read(nextbyte);
        block5: while (readcount != -1) {
            isComment = M3UFilter.isCommentStart(nextbyte);
            if (M3UFilter.isNewline(nextbyte)) {
                readcount = dis.read(nextbyte);
                continue;
            }
            numberOfDotsInUri = false;
            isBadUri = false;
            int fileIndex = 0;
            byte[] fileUri = new byte[16384];
            while (readcount != -1) {
                if (!isComment && !M3UFilter.isCarriageReturn(nextbyte) && fileIndex <= 16384) {
                    fileUri[fileIndex] = nextbyte[0];
                    fileIndex += readcount;
                }
                readcount = dis.read(nextbyte);
                if (!M3UFilter.isNewline(nextbyte) && readcount != -1) continue;
                if (!isComment && fileIndex <= 16384) {
                    boolean lineIsEmpty;
                    boolean bl = lineIsEmpty = fileIndex == 0;
                    if (!lineIsEmpty) {
                        String filtered;
                        String uriold = new String(fileUri, 0, fileIndex, "UTF-8");
                        try {
                            String subMimetype = ContentFilter.mimeTypeForSrc(uriold);
                            filtered = cb.processURI(uriold, subMimetype, schemeHostAndPort, true);
                            if (!filtered.contains("/external-link/") && !filtered.contains("_CHECKED_HTTP_")) {
                                filtered = filtered.contains("?") ? filtered + "&" : filtered + "?";
                                filtered = filtered + "max-size=115343360";
                            }
                        }
                        catch (CommentException e) {
                            filtered = badUriReplacement;
                        }
                        catch (Exception e) {
                            filtered = badUriReplacement;
                        }
                        if (filtered == null) {
                            filtered = badUriReplacement;
                        }
                        try {
                            dos.write(filtered.getBytes("UTF-8"));
                        }
                        catch (Exception e) {
                            dos.write(badUriReplacement.getBytes("UTF-8"));
                        }
                    }
                    if (readcount != -1) {
                        dos.write(nextbyte);
                    }
                }
                readcount = dis.read(nextbyte);
                continue block5;
            }
        }
        dos.flush();
        dos.close();
        output.flush();
    }

    private static boolean isCommentStart(byte[] nextbyte) {
        return Arrays.equals(nextbyte, CHAR_COMMENT_START);
    }

    private static boolean isNewline(byte[] nextbyte) {
        return Arrays.equals(nextbyte, CHAR_NEWLINE);
    }

    private static boolean isCarriageReturn(byte[] nextbyte) {
        return Arrays.equals(nextbyte, CHAR_CARRIAGE_RETURN);
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("M3UFilter." + key);
    }
}

