/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.support.HTMLNode;
import freenet.support.MultiValueTable;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;

public class ExternalLinkToadlet
extends Toadlet {
    private static final int MAX_URL_LENGTH = 0x100000;
    public static final String PATH = "/external-link/";
    public static final String magicHTTPEscapeString = "_CHECKED_HTTP_";
    private final Node node;

    ExternalLinkToadlet(HighLevelSimpleClient client, Node node) {
        super(client);
        this.node = node;
    }

    @Override
    public String path() {
        return PATH;
    }

    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        String url = request.getPartAsStringFailsafe(magicHTTPEscapeString, 0x100000);
        MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
        if (request.getPartAsStringFailsafe("Go", 32).isEmpty() || url.isEmpty()) {
            url = "/";
        }
        headers.put("Location", url);
        ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        if (request.getParam(magicHTTPEscapeString).isEmpty()) {
            MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
            headers.put("Location", "/");
            ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
            return;
        }
        boolean renderBars = this.node.clientCore.getToadletContainer().fproxyHasCompletedWizard();
        PageNode page = ctx.getPageMaker().getPageNode(ExternalLinkToadlet.l10n("confirmExternalLinkTitle"), ctx, new PageMaker.RenderParameters().renderNavigationLinks(renderBars).renderStatus(renderBars));
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode warnboxContent = ctx.getPageMaker().getInfobox("infobox-warning", ExternalLinkToadlet.l10n("confirmExternalLinkSubTitle"), contentNode, "confirm-external-link", true);
        HTMLNode externalLinkForm = ctx.addFormChild(warnboxContent, PATH, "confirmExternalLinkForm");
        String target = request.getParam(magicHTTPEscapeString);
        externalLinkForm.addChild("#", ExternalLinkToadlet.l10n("confirmExternalLinkWithURL", "url", target));
        externalLinkForm.addChild("br");
        externalLinkForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", magicHTTPEscapeString, target});
        externalLinkForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "cancel", NodeL10n.getBase().getString("Toadlet.cancel")});
        externalLinkForm.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "Go", ExternalLinkToadlet.l10n("goToExternalLink")});
        this.writeHTMLReply(ctx, 200, "OK", null, pageNode.generate(), true);
    }

    public static String escape(String uri) {
        return "/external-link/?_CHECKED_HTTP_=" + uri;
    }

    private static String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("WelcomeToadlet." + key, new String[]{pattern}, new String[]{value});
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("WelcomeToadlet." + key);
    }
}

