/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree.algebra;

import com.db4o.foundation.Iterator4;
import com.db4o.foundation.SortedCollection4;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.BTreeRangeSingle;
import com.db4o.internal.btree.BTreeRangeUnion;

class BTreeAlgebra {
    BTreeAlgebra() {
    }

    public static BTreeRange intersect(BTreeRangeUnion union, BTreeRangeSingle single) {
        SortedCollection4 collection = BTreeAlgebra.newBTreeRangeSingleCollection();
        BTreeAlgebra.collectIntersections(collection, union, single);
        return BTreeAlgebra.toRange(collection);
    }

    public static BTreeRange intersect(BTreeRangeUnion union1, BTreeRangeUnion union2) {
        SortedCollection4 collection = BTreeAlgebra.newBTreeRangeSingleCollection();
        Iterator4 ranges = union1.ranges();
        while (ranges.moveNext()) {
            BTreeRangeSingle current = (BTreeRangeSingle)ranges.current();
            BTreeAlgebra.collectIntersections(collection, union2, current);
        }
        return BTreeAlgebra.toRange(collection);
    }

    private static void collectIntersections(SortedCollection4 collection, BTreeRangeUnion union, BTreeRangeSingle single) {
        Iterator4 ranges = union.ranges();
        while (ranges.moveNext()) {
            BTreeRangeSingle current = (BTreeRangeSingle)ranges.current();
            if (!single.overlaps(current)) continue;
            collection.add(single.intersect(current));
        }
    }

    public static BTreeRange intersect(BTreeRangeSingle single1, BTreeRangeSingle single2) {
        BTreePointer first = BTreePointer.max(single1.first(), single2.first());
        BTreePointer end = BTreePointer.min(single1.end(), single2.end());
        return single1.newBTreeRangeSingle(first, end);
    }

    public static BTreeRange union(BTreeRangeUnion union1, BTreeRangeUnion union2) {
        Iterator4 ranges = union1.ranges();
        BTreeRange merged = union2;
        while (ranges.moveNext()) {
            merged = merged.union((BTreeRange)ranges.current());
        }
        return merged;
    }

    public static BTreeRange union(BTreeRangeUnion union, BTreeRangeSingle single) {
        if (single.isEmpty()) {
            return union;
        }
        SortedCollection4 sorted = BTreeAlgebra.newBTreeRangeSingleCollection();
        sorted.add(single);
        BTreeRangeSingle range = single;
        Iterator4 ranges = union.ranges();
        while (ranges.moveNext()) {
            BTreeRangeSingle current = (BTreeRangeSingle)ranges.current();
            if (BTreeAlgebra.canBeMerged(current, range)) {
                sorted.remove(range);
                range = BTreeAlgebra.merge(current, range);
                sorted.add(range);
                continue;
            }
            sorted.add(current);
        }
        return BTreeAlgebra.toRange(sorted);
    }

    private static BTreeRange toRange(SortedCollection4 sorted) {
        if (1 == sorted.size()) {
            return (BTreeRange)sorted.singleElement();
        }
        return new BTreeRangeUnion(sorted);
    }

    private static SortedCollection4 newBTreeRangeSingleCollection() {
        return new SortedCollection4(BTreeRangeSingle.COMPARISON);
    }

    public static BTreeRange union(BTreeRangeSingle single1, BTreeRangeSingle single2) {
        if (single1.isEmpty()) {
            return single2;
        }
        if (single2.isEmpty()) {
            return single1;
        }
        if (BTreeAlgebra.canBeMerged(single1, single2)) {
            return BTreeAlgebra.merge(single1, single2);
        }
        return new BTreeRangeUnion(new BTreeRangeSingle[]{single1, single2});
    }

    private static BTreeRangeSingle merge(BTreeRangeSingle range1, BTreeRangeSingle range2) {
        return range1.newBTreeRangeSingle(BTreePointer.min(range1.first(), range2.first()), BTreePointer.max(range1.end(), range2.end()));
    }

    private static boolean canBeMerged(BTreeRangeSingle range1, BTreeRangeSingle range2) {
        return range1.overlaps(range2) || range1.adjacent(range2);
    }
}

