/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.ContentDataFilter;
import freenet.client.filter.ContentFilter;
import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.l10n.NodeL10n;
import freenet.support.HexUtil;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.zip.CRC32;

public class PNGFilter
implements ContentDataFilter {
    private final boolean deleteText;
    private final boolean deleteTimestamp;
    private final boolean checkCRCs;
    static final byte[] pngHeader = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    static final String[] HARMLESS_CHUNK_TYPES = new String[]{"tRNS", "cHRM", "gAMA", "iCCP", "sBIT", "sRGB", "bKGD", "hIST", "pHYs", "sPLT", "acTL", "fcTL", "fdAT"};
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;

    PNGFilter(boolean deleteText, boolean deleteTimestamp, boolean checkCRCs) {
        this.deleteText = deleteText;
        this.deleteTimestamp = deleteTimestamp;
        this.checkCRCs = checkCRCs;
    }

    @Override
    public void readFilter(InputStream input, OutputStream output, String charset, Map<String, String> otherParams, String schemeHostAndPort, FilterCallback cb) throws DataFilterException, IOException {
        this.readFilter(input, output, charset, otherParams, cb, this.deleteText, this.deleteTimestamp, this.checkCRCs);
        output.flush();
    }

    public void readFilter(InputStream input, OutputStream output, String charset, Map<String, String> otherParams, FilterCallback cb, boolean deleteText, boolean deleteTimestamp, boolean checkCRCs) throws DataFilterException, IOException {
        DataInputStream dis = null;
        boolean hasSeenIHDR = false;
        boolean hasSeenIEND = false;
        boolean hasSeenIDAT = false;
        try {
            long offset = 0L;
            dis = new DataInputStream(input);
            byte[] headerCheck = new byte[pngHeader.length];
            dis.readFully(headerCheck);
            offset += (long)pngHeader.length;
            if (!Arrays.equals(headerCheck, pngHeader)) {
                String message = this.l10n("invalidHeader");
                String title = this.l10n("invalidHeaderTitle");
                throw new DataFilterException(title, title, message);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            output.write(pngHeader);
            if (logMINOR) {
                Logger.minor(this, "Writing the PNG header to the output bucket");
            }
            String lastChunkType = "";
            while (!hasSeenIEND) {
                boolean skip = false;
                baos.reset();
                String chunkTypeString = null;
                byte[] lengthBytes = new byte[4];
                try {
                    dis.readFully(lengthBytes);
                    offset += 4L;
                }
                catch (EOFException e) {
                    break;
                }
                int length = ((lengthBytes[0] & 0xFF) << 24) + ((lengthBytes[1] & 0xFF) << 16) + ((lengthBytes[2] & 0xFF) << 8) + (lengthBytes[3] & 0xFF);
                if (logMINOR) {
                    Logger.minor(this, "length " + length + "(offset=0x" + Long.toHexString(offset) + ") ");
                }
                if (dos != null) {
                    dos.write(lengthBytes);
                }
                dis.readFully(lengthBytes);
                offset += 4L;
                StringBuilder sb = new StringBuilder();
                byte[] chunkTypeBytes = new byte[4];
                for (int i = 0; i < 4; ++i) {
                    char val = (char)lengthBytes[i];
                    if (val >= 'A' && val <= 'c' || val >= 'a' && val <= 'z') {
                        chunkTypeBytes[i] = lengthBytes[i];
                        sb.append(val);
                        continue;
                    }
                    String chunkName = HexUtil.bytesToHex(lengthBytes, 0, 4);
                    this.throwError("Unknown Chunk", "The name of the chunk is invalid! (" + chunkName + ")");
                }
                chunkTypeString = sb.toString();
                if (logMINOR) {
                    Logger.minor(this, "name " + chunkTypeString);
                }
                if (dos != null) {
                    dos.write(chunkTypeBytes);
                }
                byte[] chunkData = new byte[length];
                if (length > 0) {
                    dis.readFully(chunkData, 0, length);
                    offset += (long)length;
                    if (logMINOR) {
                        if (logDEBUG) {
                            Logger.minor(this, "data (offset=0x" + Long.toHexString(offset) + ") " + (chunkData.length == 0 ? "null" : HexUtil.bytesToHex(chunkData)));
                        } else {
                            Logger.minor(this, "data " + chunkData.length);
                        }
                    }
                    if (dos != null) {
                        dos.write(chunkData);
                    }
                }
                byte[] crcLengthBytes = new byte[4];
                dis.readFully(crcLengthBytes);
                offset += 4L;
                if (logMINOR) {
                    Logger.minor(this, "CRC offset=0x" + Long.toHexString(offset));
                }
                if (dos != null) {
                    dos.write(crcLengthBytes);
                }
                if (checkCRCs) {
                    long computedCRC;
                    long readCRC = (long)(((crcLengthBytes[0] & 0xFF) << 24) + ((crcLengthBytes[1] & 0xFF) << 16) + ((crcLengthBytes[2] & 0xFF) << 8) + (crcLengthBytes[3] & 0xFF)) & 0xFFFFFFFFL;
                    CRC32 crc = new CRC32();
                    crc.update(chunkTypeBytes);
                    if (length > 0) {
                        crc.update(chunkData);
                    }
                    if (readCRC != (computedCRC = crc.getValue())) {
                        skip = true;
                        if (logMINOR) {
                            Logger.minor(this, "CRC of the chunk " + chunkTypeString + " doesn't match (" + Long.toHexString(readCRC) + " but should be " + Long.toHexString(computedCRC) + ")!");
                        }
                    }
                }
                boolean validChunkType = false;
                if (!skip && "IHDR".equals(chunkTypeString)) {
                    byte interlaceMethod;
                    byte filterMethod;
                    if (hasSeenIHDR) {
                        this.throwError("Duplicate IHDR", "Two IHDR chunks detected!!");
                    }
                    if (length != 13) {
                        this.throwError("IHDR length!= 13", "The length of the IHDR file is not 13");
                    }
                    long width = ((chunkData[0] & 0xFF) << 24) + ((chunkData[1] & 0xFF) << 16) + ((chunkData[2] & 0xFF) << 8) + (chunkData[3] & 0xFF);
                    long height = ((chunkData[4] & 0xFF) << 24) + ((chunkData[5] & 0xFF) << 16) + ((chunkData[6] & 0xFF) << 8) + (chunkData[7] & 0xFF);
                    if (width < 1L || height < 1L) {
                        this.throwError("Width or Height is invalid", "Width or Height is invalid (<1)");
                    }
                    byte bitDepth = chunkData[8];
                    byte colourType = chunkData[9];
                    this.throwOnInvalidColour(bitDepth, colourType);
                    byte compressionMethod = chunkData[10];
                    if (compressionMethod != 0) {
                        this.throwError("Invalid CompressionMethod", "Invalid CompressionMethod! " + compressionMethod);
                    }
                    if ((filterMethod = chunkData[11]) != 0) {
                        this.throwError("Invalid FilterMethod", "Invalid FilterMethod! " + filterMethod);
                    }
                    if ((interlaceMethod = chunkData[12]) < 0 || interlaceMethod > 1) {
                        this.throwError("Invalid InterlaceMethod", "Invalid InterlaceMethod! " + interlaceMethod);
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Info from IHDR: width=" + width + "px height=" + height + "px bitDepth=" + bitDepth + " colourType=" + colourType + " compressionMethod=" + compressionMethod + " filterMethod=" + filterMethod + " interlaceMethod=" + interlaceMethod);
                    }
                    hasSeenIHDR = true;
                    validChunkType = true;
                }
                if (!hasSeenIHDR) {
                    this.throwError("No IHDR chunk!", "No IHDR chunk!");
                }
                if (!skip && "IEND".equals(chunkTypeString)) {
                    if (hasSeenIEND) {
                        this.throwError("Two IEND chunks detected!!", "Two IEND chunks detected!!");
                    }
                    hasSeenIEND = true;
                    validChunkType = true;
                }
                if (!skip && "PLTE".equalsIgnoreCase(chunkTypeString)) {
                    if (hasSeenIDAT) {
                        this.throwError("PLTE must be before IDAT", "PLTE must be before IDAT");
                    }
                    validChunkType = true;
                }
                if (!skip && "IDAT".equalsIgnoreCase(chunkTypeString)) {
                    if (hasSeenIDAT && !"IDAT".equalsIgnoreCase(lastChunkType)) {
                        this.throwError("Multiple IDAT chunks must be consecutive!", "Multiple IDAT chunks must be consecutive!");
                    }
                    hasSeenIDAT = true;
                    validChunkType = true;
                }
                if (!validChunkType) {
                    for (int i = 0; i < HARMLESS_CHUNK_TYPES.length; ++i) {
                        if (!HARMLESS_CHUNK_TYPES[i].equals(chunkTypeString)) continue;
                        validChunkType = true;
                    }
                }
                if ("text".equalsIgnoreCase(chunkTypeString) || "itxt".equalsIgnoreCase(chunkTypeString) || "ztxt".equalsIgnoreCase(chunkTypeString)) {
                    if (deleteText) {
                        skip = true;
                    } else {
                        validChunkType = true;
                    }
                } else if (deleteTimestamp && "time".equalsIgnoreCase(chunkTypeString)) {
                    if (deleteTimestamp) {
                        skip = true;
                    } else {
                        validChunkType = true;
                    }
                }
                if (!validChunkType) {
                    if (logMINOR) {
                        Logger.minor(this, "Skipping unknown chunk type " + chunkTypeString);
                    }
                    skip = true;
                } else if (!skip && output != null) {
                    if (logMINOR) {
                        Logger.minor(this, "Writing " + chunkTypeString + " (" + baos.size() + ") to the output bucket");
                    }
                    baos.writeTo(output);
                    baos.flush();
                }
                lastChunkType = chunkTypeString;
            }
            if (!hasSeenIEND) {
                this.throwError("Missing IEND", "Missing IEND");
            }
            if (!hasSeenIHDR) {
                this.throwError("Missing IHDR", "Missing IHDR");
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.throwError("ArrayIndexOutOfBoundsException while filtering", "ArrayIndexOutOfBoundsException while filtering");
        }
        catch (NegativeArraySizeException e) {
            this.throwError("NegativeArraySizeException while filtering", "NegativeArraySizeException while filtering");
        }
        catch (EOFException e) {
            if (hasSeenIEND && hasSeenIHDR) {
                return;
            }
            this.throwError("EOF Exception while filtering", "EOF Exception while filtering");
        }
    }

    private void throwOnInvalidColour(int bitDepth, int colourType) throws DataFilterException {
        switch (bitDepth) {
            case 1: 
            case 2: 
            case 4: {
                if (colourType == 0 || colourType == 3) break;
                this.throwError("Invalid colourType/bitDepth combination!", "Invalid colourType/bitDepth combination! (" + colourType + '|' + bitDepth + ')');
                break;
            }
            case 16: {
                if (colourType == 3) {
                    this.throwError("Invalid colourType/bitDepth combination!", "Invalid colourType/bitDepth combination! (" + colourType + '|' + bitDepth + ')');
                }
            }
            case 8: {
                if (colourType == 0 || colourType == 2 || colourType == 3 || colourType == 4 || colourType == 6) break;
            }
            default: {
                this.throwError("Invalid colourType/bitDepth combination!", "Invalid colourType/bitDepth combination! (" + colourType + '|' + bitDepth + ')');
            }
        }
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("PNGFilter." + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) throws Throwable {
        File fin = new File("/tmp/test.png");
        File fout = new File("/tmp/test2.png");
        fout.delete();
        FileBucket inputBucket = new FileBucket(fin, true, false, false, false);
        FileBucket outputBucket = new FileBucket(fout, false, true, false, false);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = inputBucket.getInputStream();
            outputStream = outputBucket.getOutputStream();
            Logger.setupStdoutLogging(Logger.LogLevel.MINOR, "");
            ContentFilter.filter(inputStream, outputStream, "image/png", new URI("http://127.0.0.1:8888/"), null, null, null, null);
        }
        finally {
            Closer.close(inputStream);
            Closer.close(outputStream);
            inputBucket.free();
            outputBucket.free();
        }
    }

    private void throwError(String shortReason, String reason) throws DataFilterException {
        String message = "Invalid PNG";
        if (reason != null) {
            message = message + ' ' + reason;
        }
        if (shortReason != null) {
            message = message + " - " + shortReason;
        }
        DataFilterException e = new DataFilterException(shortReason, shortReason, message);
        Logger.normal(this, "Throwing " + e.getMessage(), (Throwable)e);
        throw e;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }
}

