/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.ArchiveManager;
import freenet.client.ClientMetadata;
import freenet.client.DefaultMIMETypes;
import freenet.client.FetchException;
import freenet.client.InsertContext;
import freenet.client.MetadataParseException;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.SplitFileSegmentKeys;
import freenet.crypt.HashResult;
import freenet.crypt.HashType;
import freenet.crypt.SHA256;
import freenet.keys.BaseClientKey;
import freenet.keys.ClientCHK;
import freenet.keys.FreenetURI;
import freenet.keys.Key;
import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.compress.Compressor;
import freenet.support.io.Closer;
import freenet.support.io.CountedOutputStream;
import freenet.support.io.NullOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Metadata
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    static final long FREENET_METADATA_MAGIC = -1129362800769939413L;
    static final int MAX_SPLITFILE_PARAMS_LENGTH = 32768;
    static final int MAX_SPLITFILE_BLOCKS = 1000000;
    public static final short SPLITFILE_PARAMS_SIMPLE_SEGMENT = 0;
    public static final short SPLITFILE_PARAMS_SEGMENT_DEDUCT_BLOCKS = 1;
    public static final short SPLITFILE_PARAMS_CROSS_SEGMENT = 2;
    FreenetURI resolvedURI;
    String resolvedName;
    DocumentType documentType;
    short parsedVersion;
    boolean splitfile;
    boolean dbr;
    boolean noMIME = true;
    boolean compressedMIME;
    boolean extraMetadata;
    boolean fullKeys;
    static final short FLAGS_SPLITFILE = 1;
    static final short FLAGS_DBR = 2;
    static final short FLAGS_NO_MIME = 4;
    static final short FLAGS_COMPRESSED_MIME = 8;
    static final short FLAGS_EXTRA_METADATA = 16;
    static final short FLAGS_FULL_KEYS = 32;
    static final short FLAGS_COMPRESSED = 128;
    static final short FLAGS_TOP_SIZE = 256;
    static final short FLAGS_HASHES = 512;
    static final short FLAGS_SPECIFY_SPLITFILE_KEY = 1024;
    static final short FLAGS_HASH_THIS_LAYER = 2048;
    ArchiveManager.ARCHIVE_TYPE archiveType;
    Compressor.COMPRESSOR_TYPE compressionCodec;
    long dataLength;
    long decompressedLength;
    String mimeType;
    short compressedMIMEValue;
    boolean hasCompressedMIMEParams;
    short compressedMIMEParams;
    FreenetURI simpleRedirectKey;
    private final int hashCode;
    SplitfileAlgorithm splitfileAlgorithm;
    public static final int MAX_SIZE_IN_MANIFEST = Short.MAX_VALUE;
    byte[] splitfileParams;
    int splitfileBlocks;
    int splitfileCheckBlocks;
    ClientCHK[] splitfileDataKeys;
    ClientCHK[] splitfileCheckKeys;
    byte splitfileSingleCryptoAlgorithm;
    byte[] splitfileSingleCryptoKey;
    private boolean specifySplitfileKey;
    byte[] hashThisLayerOnly;
    int blocksPerSegment;
    int checkBlocksPerSegment;
    int segmentCount;
    int deductBlocksFromSegments;
    int crossCheckBlocks;
    SplitFileSegmentKeys[] segments;
    InsertContext.CompatibilityMode minCompatMode = InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
    InsertContext.CompatibilityMode maxCompatMode = InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
    HashMap<String, Metadata> manifestEntries;
    String targetName;
    ClientMetadata clientMetadata;
    private HashResult[] hashes;
    public final long topSize;
    public final long topCompressedSize;
    public final int topBlocksRequired;
    public final int topBlocksTotal;
    public final boolean topDontCompress;
    public final InsertContext.CompatibilityMode topCompatibilityMode;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private static final byte[] SPLITKEY;
    private static final byte[] CROSS_SEGMENT_SEED;

    public Object clone() {
        try {
            Metadata meta = (Metadata)super.clone();
            meta.finishClone(this);
            return meta;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Yes it is!");
        }
    }

    private void finishClone(Metadata orig) {
        int i;
        if (orig.segments != null) {
            this.segments = new SplitFileSegmentKeys[orig.segments.length];
            for (i = 0; i < this.segments.length; ++i) {
                this.segments[i] = orig.segments[i].clone();
            }
        }
        if (this.hashes != null) {
            this.hashes = new HashResult[orig.hashes.length];
            for (i = 0; i < this.hashes.length; ++i) {
                this.hashes[i] = orig.hashes[i].clone();
            }
        }
        if (this.manifestEntries != null) {
            this.manifestEntries = new HashMap<String, Metadata>(orig.manifestEntries);
            for (Map.Entry<String, Metadata> entry : this.manifestEntries.entrySet()) {
                entry.setValue((Metadata)entry.getValue().clone());
            }
        }
        if (this.clientMetadata != null) {
            this.clientMetadata = this.clientMetadata.clone();
        }
    }

    public static Metadata construct(byte[] data) throws MetadataParseException {
        try {
            return new Metadata(data);
        }
        catch (IOException e) {
            throw (MetadataParseException)new MetadataParseException("Caught " + e).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Metadata construct(Bucket data) throws MetadataParseException, IOException {
        Metadata m;
        InputStream is = data.getInputStream();
        try {
            DataInputStream dis = new DataInputStream(is);
            m = new Metadata(dis, data.size());
        }
        finally {
            is.close();
        }
        return m;
    }

    private Metadata(byte[] data) throws IOException, MetadataParseException {
        this(new DataInputStream(new ByteArrayInputStream(data)), data.length);
    }

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Metadata(DataInputStream dis, long length) throws IOException, MetadataParseException {
        int i;
        this.hashCode = super.hashCode();
        long magic = dis.readLong();
        if (magic != -1129362800769939413L) {
            throw new MetadataParseException("Invalid magic " + magic);
        }
        short version = dis.readShort();
        if (version < 0 || version > 1) {
            throw new MetadataParseException("Unsupported version " + version);
        }
        this.parsedVersion = version;
        try {
            this.documentType = DocumentType.byCode(dis.readByte());
        }
        catch (IllegalArgumentException e) {
            throw new MetadataParseException("Unsupported document type: " + (Object)((Object)this.documentType));
        }
        if (logMINOR) {
            Logger.minor(this, "Document type: " + (Object)((Object)this.documentType));
        }
        boolean compressed = false;
        boolean hasTopBlocks = false;
        HashResult[] h = null;
        if (this.haveFlags()) {
            short flags = dis.readShort();
            this.splitfile = (flags & 1) == 1;
            this.dbr = (flags & 2) == 2;
            this.noMIME = (flags & 4) == 4;
            this.compressedMIME = (flags & 8) == 8;
            this.extraMetadata = (flags & 0x10) == 16;
            this.fullKeys = (flags & 0x20) == 32;
            boolean bl = compressed = (flags & 0x80) == 128;
            if ((flags & 0x200) == 512) {
                if (version == 0) {
                    throw new MetadataParseException("Version 0 does not support hashes");
                }
                h = HashResult.readHashes(dis);
            }
            boolean bl2 = hasTopBlocks = (flags & 0x100) == 256;
            if (hasTopBlocks && version == 0) {
                throw new MetadataParseException("Version 0 does not support top block data");
            }
            boolean bl3 = this.specifySplitfileKey = (flags & 0x400) == 1024;
            if ((flags & 0x800) == 2048) {
                this.hashThisLayerOnly = new byte[32];
                dis.readFully(this.hashThisLayerOnly);
            }
        }
        this.hashes = h;
        if (hasTopBlocks) {
            if (this.parsedVersion == 0) {
                throw new MetadataParseException("Top size data not supported in version 0");
            }
            this.topSize = dis.readLong();
            this.topCompressedSize = dis.readLong();
            this.topBlocksRequired = dis.readInt();
            this.topBlocksTotal = dis.readInt();
            this.topDontCompress = dis.readBoolean();
            short code = dis.readShort();
            if (InsertContext.CompatibilityMode.hasCode(code) && code != InsertContext.CompatibilityMode.COMPAT_CURRENT.code) {
                this.topCompatibilityMode = InsertContext.CompatibilityMode.byCode(code);
                if (this.topSize != 0L && this.topCompatibilityMode == InsertContext.CompatibilityMode.COMPAT_UNKNOWN) {
                    this.maxCompatMode = InsertContext.CompatibilityMode.COMPAT_1416;
                }
            } else {
                if (!InsertContext.CompatibilityMode.maybeFutureCode(code)) throw new MetadataParseException("Bad compatibility mode " + code);
                Logger.warning(this, "Content may have been inserted with a newer version of Freenet?");
                this.topCompatibilityMode = InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
            }
        } else {
            this.topSize = 0L;
            this.topCompressedSize = 0L;
            this.topBlocksRequired = 0;
            this.topBlocksTotal = 0;
            this.topDontCompress = false;
            this.topCompatibilityMode = InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
        }
        if (this.documentType == DocumentType.ARCHIVE_MANIFEST) {
            if (logMINOR) {
                Logger.minor(this, "Archive manifest");
            }
            this.archiveType = ArchiveManager.ARCHIVE_TYPE.getArchiveType(dis.readShort());
            if (this.archiveType == null) {
                throw new MetadataParseException("Unrecognized archive type " + (Object)((Object)this.archiveType));
            }
        }
        if (this.splitfile) {
            if (this.parsedVersion >= 1) {
                this.splitfileSingleCryptoAlgorithm = dis.readByte();
                if (this.specifySplitfileKey || this.hashes == null || this.hashes.length == 0 || !HashResult.contains(this.hashes, HashType.SHA256)) {
                    byte[] key = new byte[32];
                    dis.readFully(key);
                    this.splitfileSingleCryptoKey = key;
                } else {
                    this.splitfileSingleCryptoKey = this.hashThisLayerOnly != null ? Metadata.getCryptoKey(this.hashThisLayerOnly) : Metadata.getCryptoKey(this.hashes);
                }
            } else {
                this.splitfileSingleCryptoAlgorithm = (byte)2;
            }
            if (logMINOR) {
                Logger.minor(this, "Splitfile");
            }
            this.dataLength = dis.readLong();
            if (this.dataLength < -1L) {
                throw new MetadataParseException("Invalid real content length " + this.dataLength);
            }
            if (this.dataLength == -1L && this.splitfile) {
                throw new MetadataParseException("Splitfile must have a real-length");
            }
        }
        if (compressed) {
            this.compressionCodec = Compressor.COMPRESSOR_TYPE.getCompressorByMetadataID(dis.readShort());
            if (this.compressionCodec == null) {
                throw new MetadataParseException("Unrecognized splitfile compression codec " + this.compressionCodec);
            }
            this.decompressedLength = dis.readLong();
        }
        if (this.noMIME) {
            this.mimeType = null;
            if (logMINOR) {
                Logger.minor(this, "noMIME enabled");
            }
        } else {
            if (this.compressedMIME) {
                if (logMINOR) {
                    Logger.minor(this, "Compressed MIME");
                }
                short x = dis.readShort();
                this.compressedMIMEValue = (short)(x & Short.MAX_VALUE);
                boolean bl = this.hasCompressedMIMEParams = (this.compressedMIMEValue & 0x8000) == 32768;
                if (this.hasCompressedMIMEParams) {
                    this.compressedMIMEParams = dis.readShort();
                    if (this.compressedMIMEParams != 0) {
                        throw new MetadataParseException("Unrecognized MIME params ID (not yet implemented)");
                    }
                }
                this.mimeType = DefaultMIMETypes.byNumber(x);
            } else {
                byte l = dis.readByte();
                int len = l & 0xFF;
                byte[] toRead = new byte[len];
                dis.readFully(toRead);
                this.mimeType = new String(toRead, "UTF-8");
                if (logMINOR) {
                    Logger.minor(this, "Raw MIME");
                }
                if (!DefaultMIMETypes.isPlausibleMIMEType(this.mimeType)) {
                    throw new MetadataParseException("Does not look like a MIME type: \"" + this.mimeType + "\"");
                }
            }
            if (logMINOR) {
                Logger.minor(this, "MIME = " + this.mimeType);
            }
        }
        if (this.dbr) {
            throw new MetadataParseException("Do not support DBRs pending decision on putting them in the key!");
        }
        if (this.extraMetadata) {
            int numberOfExtraFields = dis.readShort() & 0xFFFF;
            for (i = 0; i < numberOfExtraFields; ++i) {
                short type = dis.readShort();
                int len = dis.readByte() & 0xFF;
                byte[] buf = new byte[len];
                dis.readFully(buf);
                Logger.normal(this, "Ignoring type " + type + " extra-client-metadata field of " + len + " bytes");
            }
            this.extraMetadata = false;
        }
        this.clientMetadata = new ClientMetadata(this.mimeType);
        if (!(this.splitfile || this.documentType != DocumentType.SIMPLE_REDIRECT && this.documentType != DocumentType.ARCHIVE_MANIFEST)) {
            this.simpleRedirectKey = this.readKey(dis);
            if (this.simpleRedirectKey.isCHK()) {
                byte algo = ClientCHK.getCryptoAlgorithmFromExtra(this.simpleRedirectKey.getExtra());
                if (algo == 3) {
                    this.minCompatMode = InsertContext.CompatibilityMode.COMPAT_1416;
                    this.maxCompatMode = InsertContext.CompatibilityMode.latest();
                } else if (this.getParsedVersion() == 0) {
                    this.minCompatMode = InsertContext.CompatibilityMode.COMPAT_1250_EXACT;
                    this.maxCompatMode = InsertContext.CompatibilityMode.COMPAT_1251;
                } else {
                    this.minCompatMode = this.maxCompatMode = InsertContext.CompatibilityMode.COMPAT_1255;
                }
            }
        } else if (this.splitfile) {
            try {
                this.splitfileAlgorithm = SplitfileAlgorithm.getByCode(dis.readShort());
            }
            catch (IllegalArgumentException e) {
                throw new MetadataParseException("Invalid splitfile code");
            }
            if (this.splitfileAlgorithm != SplitfileAlgorithm.NONREDUNDANT && this.splitfileAlgorithm != SplitfileAlgorithm.ONION_STANDARD) {
                throw new MetadataParseException("Unknown splitfile algorithm " + (Object)((Object)this.splitfileAlgorithm));
            }
            if (this.splitfileAlgorithm == SplitfileAlgorithm.NONREDUNDANT) {
                throw new MetadataParseException("Non-redundant splitfile invalid");
            }
            int paramsLength = dis.readInt();
            if (paramsLength > 32768) {
                throw new MetadataParseException("Too many bytes of splitfile parameters: " + paramsLength);
            }
            if (paramsLength > 0) {
                this.splitfileParams = new byte[paramsLength];
                dis.readFully(this.splitfileParams);
            } else if (paramsLength < 0) {
                throw new MetadataParseException("Invalid splitfile params length: " + paramsLength);
            }
            this.splitfileBlocks = dis.readInt();
            if (this.splitfileBlocks < 0) {
                throw new MetadataParseException("Invalid number of blocks: " + this.splitfileBlocks);
            }
            if (this.splitfileBlocks > 1000000) {
                throw new MetadataParseException("Too many splitfile blocks (soft limit to prevent memory DoS): " + this.splitfileBlocks);
            }
            this.splitfileCheckBlocks = dis.readInt();
            if (this.splitfileCheckBlocks < 0) {
                throw new MetadataParseException("Invalid number of check blocks: " + this.splitfileCheckBlocks);
            }
            if (this.splitfileCheckBlocks > 1000000) {
                throw new MetadataParseException("Too many splitfile check-blocks (soft limit to prevent memory DoS): " + this.splitfileCheckBlocks);
            }
            this.crossCheckBlocks = 0;
            if (this.splitfileAlgorithm == SplitfileAlgorithm.NONREDUNDANT) {
                this.blocksPerSegment = -1;
                this.checkBlocksPerSegment = -1;
                this.segmentCount = 1;
                this.deductBlocksFromSegments = 0;
                if (this.splitfileCheckBlocks > 0) {
                    Logger.error(this, "Splitfile type is SPLITFILE_NONREDUNDANT yet " + this.splitfileCheckBlocks + " check blocks found!! : " + this);
                    throw new MetadataParseException("Splitfile type is non-redundant yet have " + this.splitfileCheckBlocks + " check blocks");
                }
            } else {
                int checkBlocks;
                if (this.splitfileAlgorithm != SplitfileAlgorithm.ONION_STANDARD) throw new MetadataParseException("Unknown splitfile format: " + (Object)((Object)this.splitfileAlgorithm));
                byte[] params = this.splitfileParams();
                if (this.getParsedVersion() == 0) {
                    if (params == null || params.length < 8) {
                        throw new MetadataParseException("No splitfile params");
                    }
                    this.blocksPerSegment = Fields.bytesToInt(params, 0);
                    checkBlocks = Fields.bytesToInt(params, 4);
                    this.deductBlocksFromSegments = 0;
                    int countDataBlocks = this.splitfileBlocks;
                    int countCheckBlocks = this.splitfileCheckBlocks;
                    if (countDataBlocks == countCheckBlocks) {
                        if (this.blocksPerSegment == 128) {
                            int segs = (countDataBlocks + 127) / 128;
                            int segSize = (countDataBlocks + segs - 1) / segs;
                            if (segSize == 128) {
                                this.minCompatMode = InsertContext.CompatibilityMode.COMPAT_1250_EXACT;
                                this.maxCompatMode = InsertContext.CompatibilityMode.COMPAT_1250;
                            } else {
                                this.minCompatMode = this.maxCompatMode = InsertContext.CompatibilityMode.COMPAT_1250_EXACT;
                            }
                        } else {
                            this.minCompatMode = this.maxCompatMode = InsertContext.CompatibilityMode.COMPAT_1250;
                        }
                    } else {
                        this.minCompatMode = checkBlocks == 64 ? (this.maxCompatMode = InsertContext.CompatibilityMode.COMPAT_UNKNOWN) : (this.maxCompatMode = InsertContext.CompatibilityMode.COMPAT_1251);
                    }
                } else {
                    if (this.splitfileSingleCryptoAlgorithm == 2) {
                        this.minCompatMode = this.maxCompatMode = InsertContext.CompatibilityMode.COMPAT_1255;
                    } else if (this.splitfileSingleCryptoAlgorithm == 3) {
                        this.minCompatMode = InsertContext.CompatibilityMode.COMPAT_1416;
                        if (this.maxCompatMode == InsertContext.CompatibilityMode.COMPAT_UNKNOWN) {
                            this.maxCompatMode = InsertContext.CompatibilityMode.latest();
                        }
                    }
                    if (params.length < 10) {
                        throw new MetadataParseException("Splitfile parameters too short for version 1");
                    }
                    short paramsType = Fields.bytesToShort(params, 0);
                    if (paramsType != 0 && paramsType != 1 && paramsType != 2) {
                        throw new MetadataParseException("Unknown splitfile params type " + paramsType);
                    }
                    this.blocksPerSegment = Fields.bytesToInt(params, 2);
                    checkBlocks = Fields.bytesToInt(params, 6);
                    if (paramsType == 1 || paramsType == 2) {
                        this.deductBlocksFromSegments = Fields.bytesToInt(params, 10);
                        if (paramsType == 2) {
                            this.crossCheckBlocks = Fields.bytesToInt(params, 14);
                        }
                    } else {
                        this.deductBlocksFromSegments = 0;
                    }
                }
                if (this.topCompatibilityMode != InsertContext.CompatibilityMode.COMPAT_UNKNOWN) {
                    if (this.minCompatMode != InsertContext.CompatibilityMode.COMPAT_UNKNOWN && (this.minCompatMode.ordinal() > this.topCompatibilityMode.ordinal() || this.maxCompatMode.ordinal() < this.topCompatibilityMode.ordinal())) throw new MetadataParseException("Top compatibility mode is incompatible with detected compatibility mode: min=" + (Object)((Object)this.minCompatMode) + " max=" + (Object)((Object)this.maxCompatMode) + " top=" + (Object)((Object)this.topCompatibilityMode));
                    this.minCompatMode = this.maxCompatMode = this.topCompatibilityMode;
                }
                if (checkBlocks == 64 && this.blocksPerSegment == 128 && this.splitfileCheckBlocks == this.splitfileBlocks - this.splitfileBlocks / 128) {
                    Logger.normal(this, "Activating 1135 wrong check blocks per segment workaround for " + this);
                    checkBlocks = 127;
                }
                this.checkBlocksPerSegment = checkBlocks;
                this.segmentCount = (this.splitfileBlocks + this.blocksPerSegment + this.crossCheckBlocks - 1) / (this.blocksPerSegment + this.crossCheckBlocks);
            }
            this.segments = new SplitFileSegmentKeys[this.segmentCount];
            if (this.segmentCount == 1) {
                this.segments[0] = new SplitFileSegmentKeys(this.splitfileBlocks, this.splitfileCheckBlocks, this.splitfileSingleCryptoKey, this.splitfileSingleCryptoAlgorithm);
            } else {
                int dataBlocksPtr = 0;
                int checkBlocksPtr = 0;
                for (int i2 = 0; i2 < this.segments.length; ++i2) {
                    int copyDataBlocks = this.blocksPerSegment + this.crossCheckBlocks;
                    int copyCheckBlocks = this.checkBlocksPerSegment;
                    if (i2 == this.segments.length - 1) {
                        copyDataBlocks = this.splitfileBlocks - dataBlocksPtr;
                        copyCheckBlocks = this.splitfileCheckBlocks - checkBlocksPtr;
                        if (copyCheckBlocks <= 0 || copyDataBlocks <= 0) {
                            throw new MetadataParseException("Last segment has bogus block count: total data blocks " + this.splitfileBlocks + " total check blocks " + this.splitfileCheckBlocks + " segment size " + this.blocksPerSegment + " data " + this.checkBlocksPerSegment + " check " + this.crossCheckBlocks + " cross check blocks, deduct " + this.deductBlocksFromSegments + ", segments " + this.segments.length);
                        }
                    } else if (this.segments.length - i2 <= this.deductBlocksFromSegments) {
                        --copyDataBlocks;
                    }
                    this.segments[i2] = new SplitFileSegmentKeys(copyDataBlocks, copyCheckBlocks, this.splitfileSingleCryptoKey, this.splitfileSingleCryptoAlgorithm);
                    if (logMINOR) {
                        Logger.minor(this, "REQUESTING: Segment " + i2 + " of " + this.segments.length + " : " + copyDataBlocks + " data blocks " + copyCheckBlocks + " check blocks");
                    }
                    dataBlocksPtr += copyDataBlocks;
                    checkBlocksPtr += copyCheckBlocks;
                }
                if (dataBlocksPtr != this.splitfileBlocks) {
                    throw new MetadataParseException("Unable to allocate all data blocks to segments - buggy or malicious inserter");
                }
                if (checkBlocksPtr != this.splitfileCheckBlocks) {
                    throw new MetadataParseException("Unable to allocate all check blocks to segments - buggy or malicious inserter");
                }
            }
            for (i = 0; i < this.segmentCount; ++i) {
                this.segments[i].readKeys(dis, false);
            }
            for (i = 0; i < this.segmentCount; ++i) {
                this.segments[i].readKeys(dis, true);
            }
        }
        if (this.documentType == DocumentType.SIMPLE_MANIFEST) {
            int manifestEntryCount = dis.readInt();
            if (manifestEntryCount < 0) {
                throw new MetadataParseException("Invalid manifest entry count: " + manifestEntryCount);
            }
            this.manifestEntries = new HashMap();
            if (logMINOR) {
                Logger.minor(this, "Simple manifest, " + manifestEntryCount + " entries");
            }
            for (i = 0; i < manifestEntryCount; ++i) {
                short len;
                short nameLength = dis.readShort();
                byte[] buf = new byte[nameLength];
                dis.readFully(buf);
                String name = new String(buf, "UTF-8").intern();
                if (logMINOR) {
                    Logger.minor(this, "Entry " + i + " name " + name);
                }
                if ((len = dis.readShort()) < 0) {
                    throw new MetadataParseException("Invalid manifest entry size: " + len);
                }
                if ((long)len > length) {
                    throw new MetadataParseException("Impossibly long manifest entry: " + len + " - metadata size " + length);
                }
                byte[] data = new byte[len];
                dis.readFully(data);
                Metadata m = Metadata.construct(data);
                this.manifestEntries.put(name, m);
            }
            if (logMINOR) {
                Logger.minor(this, "End of manifest");
            }
        }
        if (this.documentType != DocumentType.ARCHIVE_INTERNAL_REDIRECT && this.documentType != DocumentType.ARCHIVE_METADATA_REDIRECT && this.documentType != DocumentType.SYMBOLIC_SHORTLINK) return;
        short len = dis.readShort();
        if (logMINOR) {
            Logger.minor(this, "Reading archive internal redirect length " + len);
        }
        byte[] buf = new byte[len];
        dis.readFully(buf);
        this.targetName = new String(buf, "UTF-8");
        while (true) {
            if (this.targetName.isEmpty()) {
                throw new MetadataParseException("Invalid target name is empty: \"" + new String(buf, "UTF-8") + "\"");
            }
            if (this.targetName.charAt(0) != '/') break;
            this.targetName = this.targetName.substring(1);
        }
        if (!logMINOR) return;
        Logger.minor(this, "Archive and/or internal redirect: " + this.targetName + " (" + len + ')');
    }

    public static byte[] getCryptoKey(HashResult[] hashes) {
        if (hashes == null || hashes.length == 0 || !HashResult.contains(hashes, HashType.SHA256)) {
            throw new IllegalArgumentException("No hashes in getCryptoKey - need hashes to generate splitfile key!");
        }
        byte[] hash = HashResult.get(hashes, HashType.SHA256);
        return Metadata.getCryptoKey(hash);
    }

    public static byte[] getCryptoKey(byte[] hash) {
        MessageDigest md = SHA256.getMessageDigest();
        md.update(hash);
        md.update(SPLITKEY);
        byte[] buf = md.digest();
        SHA256.returnMessageDigest(md);
        return buf;
    }

    public static byte[] getCrossSegmentSeed(HashResult[] hashes, byte[] hashThisLayerOnly) {
        byte[] hash = hashThisLayerOnly;
        if (hash == null) {
            if (hashes == null || hashes.length == 0 || !HashResult.contains(hashes, HashType.SHA256)) {
                throw new IllegalArgumentException("No hashes in getCryptoKey - need hashes to generate splitfile key!");
            }
            hash = HashResult.get(hashes, HashType.SHA256);
        }
        return Metadata.getCrossSegmentSeed(hash);
    }

    public static byte[] getCrossSegmentSeed(byte[] hash) {
        MessageDigest md = SHA256.getMessageDigest();
        md.update(hash);
        md.update(CROSS_SEGMENT_SEED);
        byte[] buf = md.digest();
        SHA256.returnMessageDigest(md);
        return buf;
    }

    private Metadata() {
        this.hashCode = super.hashCode();
        this.hashes = null;
        this.topSize = 0L;
        this.topCompressedSize = 0L;
        this.topBlocksRequired = 0;
        this.topBlocksTotal = 0;
        this.topDontCompress = false;
        this.topCompatibilityMode = InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
    }

    private void addRedirectionManifest(HashMap<String, Object> dir) throws MalformedURLException {
        this.documentType = DocumentType.SIMPLE_MANIFEST;
        this.noMIME = true;
        this.manifestEntries = new HashMap();
        for (Map.Entry<String, Object> entry : dir.entrySet()) {
            Metadata target;
            String key = entry.getKey().intern();
            Object o = entry.getValue();
            if (o instanceof String) {
                FreenetURI uri = new FreenetURI((String)o);
                target = new Metadata(DocumentType.SIMPLE_REDIRECT, null, null, uri, null);
            } else if (o instanceof HashMap) {
                target = new Metadata();
                target.addRedirectionManifest(Metadata.forceMap(o));
            } else {
                throw new IllegalArgumentException("Not String nor HashMap: " + o);
            }
            this.manifestEntries.put(key, target);
        }
    }

    public static Metadata mkRedirectionManifest(HashMap<String, Object> dir) throws MalformedURLException {
        Metadata ret = new Metadata();
        ret.addRedirectionManifest(dir);
        return ret;
    }

    public static Metadata mkRedirectionManifestWithMetadata(HashMap<String, Object> dir) {
        Metadata ret = new Metadata();
        ret.addRedirectionManifestWithMetadata(dir);
        return ret;
    }

    private void addRedirectionManifestWithMetadata(HashMap<String, Object> dir) {
        this.documentType = DocumentType.SIMPLE_MANIFEST;
        this.noMIME = true;
        this.manifestEntries = new HashMap();
        for (Map.Entry<String, Object> entry : dir.entrySet()) {
            String key = entry.getKey().intern();
            if (key.indexOf(47) != -1) {
                throw new IllegalArgumentException("Slashes in simple redirect manifest filenames! (slashes denote sub-manifests): " + key);
            }
            Object o = entry.getValue();
            if (o instanceof Metadata) {
                Metadata data = (Metadata)o;
                if (data == null) {
                    throw new NullPointerException();
                }
                if (logDEBUG) {
                    Logger.debug(this, "Putting metadata for " + key);
                }
                this.manifestEntries.put(key, data);
                continue;
            }
            if (!(o instanceof HashMap)) continue;
            if (key.equals("")) {
                Logger.error(this, "Creating a subdirectory called \"\" - it will not be possible to access this through fproxy!", (Throwable)new Exception("error"));
            }
            HashMap<String, Object> hm = Metadata.forceMap(o);
            if (logDEBUG) {
                Logger.debug(this, "Making metadata map for " + key);
            }
            Metadata subMap = Metadata.mkRedirectionManifestWithMetadata(hm);
            this.manifestEntries.put(key, subMap);
            if (!logDEBUG) continue;
            Logger.debug(this, "Putting metadata map for " + key);
        }
    }

    Metadata(HashMap<String, Object> dir, String prefix) {
        this.hashCode = super.hashCode();
        this.hashes = null;
        this.documentType = DocumentType.SIMPLE_MANIFEST;
        this.noMIME = true;
        this.mimeType = null;
        this.clientMetadata = new ClientMetadata();
        this.manifestEntries = new HashMap();
        for (Map.Entry<String, Object> entry : dir.entrySet()) {
            Metadata target;
            String key = entry.getKey().intern();
            Object o = entry.getValue();
            if (o instanceof String) {
                target = new Metadata(DocumentType.ARCHIVE_INTERNAL_REDIRECT, null, null, prefix + key, new ClientMetadata(DefaultMIMETypes.guessMIMEType(key, false)));
            } else if (o instanceof HashMap) {
                target = new Metadata(Metadata.forceMap(o), prefix + key + "/");
            } else {
                throw new IllegalArgumentException("Not String nor HashMap: " + o);
            }
            this.manifestEntries.put(key, target);
        }
        this.topSize = 0L;
        this.topCompressedSize = 0L;
        this.topBlocksRequired = 0;
        this.topBlocksTotal = 0;
        this.topDontCompress = false;
        this.topCompatibilityMode = InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
    }

    public Metadata(DocumentType docType, ArchiveManager.ARCHIVE_TYPE archiveType, Compressor.COMPRESSOR_TYPE compressionCodec, String arg, ClientMetadata cm) {
        this.hashCode = super.hashCode();
        if (docType == DocumentType.ARCHIVE_INTERNAL_REDIRECT || docType == DocumentType.SYMBOLIC_SHORTLINK) {
            this.documentType = docType;
            this.archiveType = archiveType;
            this.clientMetadata = cm;
            this.compressionCodec = compressionCodec;
            if (cm != null) {
                this.setMIMEType(cm.getMIMEType());
            }
            this.targetName = arg;
            while (true) {
                if (this.targetName.isEmpty()) {
                    throw new IllegalArgumentException("Invalid target name is empty: \"" + arg + "\"");
                }
                if (this.targetName.charAt(0) == '/') {
                    this.targetName = this.targetName.substring(1);
                    Logger.error(this, "Stripped initial slash from archive internal redirect on creating metadata: \"" + arg + "\"", (Throwable)new Exception("debug"));
                    continue;
                }
                break;
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.hashes = null;
        this.topSize = 0L;
        this.topCompressedSize = 0L;
        this.topBlocksRequired = 0;
        this.topBlocksTotal = 0;
        this.topDontCompress = false;
        this.topCompatibilityMode = InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
    }

    private Metadata(DocumentType docType, String name) {
        this.hashCode = super.hashCode();
        this.noMIME = true;
        if (docType == DocumentType.ARCHIVE_METADATA_REDIRECT) {
            this.documentType = docType;
            this.targetName = name;
            while (true) {
                if (this.targetName.isEmpty()) {
                    throw new IllegalArgumentException("Invalid target name is empty: \"" + name + "\"");
                }
                if (this.targetName.charAt(0) == '/') {
                    this.targetName = this.targetName.substring(1);
                    Logger.error(this, "Stripped initial slash from archive internal redirect on creating metadata: \"" + name + "\"", (Throwable)new Exception("debug"));
                    continue;
                }
                break;
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.hashes = null;
        this.topSize = 0L;
        this.topCompressedSize = 0L;
        this.topBlocksRequired = 0;
        this.topBlocksTotal = 0;
        this.topDontCompress = false;
        this.topCompatibilityMode = InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
    }

    public Metadata(DocumentType docType, ArchiveManager.ARCHIVE_TYPE archiveType, Compressor.COMPRESSOR_TYPE compressionCodec, FreenetURI uri, ClientMetadata cm) {
        this(docType, archiveType, compressionCodec, uri, cm, 0L, 0L, 0, 0, false, InsertContext.CompatibilityMode.COMPAT_UNKNOWN, null);
    }

    public Metadata(DocumentType docType, ArchiveManager.ARCHIVE_TYPE archiveType, Compressor.COMPRESSOR_TYPE compressionCodec, FreenetURI uri, ClientMetadata cm, long origDataLength, long origCompressedDataLength, int reqBlocks, int totalBlocks, boolean topDontCompress, InsertContext.CompatibilityMode topCompatibilityMode, HashResult[] hashes) {
        assert (topCompatibilityMode != InsertContext.CompatibilityMode.COMPAT_CURRENT);
        this.hashCode = super.hashCode();
        if (hashes != null && hashes.length == 0) {
            throw new IllegalArgumentException();
        }
        this.hashes = hashes;
        if (docType == DocumentType.SIMPLE_REDIRECT || docType == DocumentType.ARCHIVE_MANIFEST) {
            this.documentType = docType;
            this.archiveType = archiveType;
            this.compressionCodec = compressionCodec;
            this.clientMetadata = cm;
            if (cm != null && !cm.isTrivial()) {
                this.setMIMEType(cm.getMIMEType());
            } else {
                this.setMIMEType("application/octet-stream");
                this.noMIME = true;
            }
            if (uri == null) {
                throw new NullPointerException();
            }
            this.simpleRedirectKey = uri;
            if (!uri.getKeyType().equals("CHK") || uri.hasMetaStrings()) {
                this.fullKeys = true;
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (origDataLength != 0L || origCompressedDataLength != 0L || reqBlocks != 0 || totalBlocks != 0 || hashes != null) {
            this.topSize = origDataLength;
            this.topCompressedSize = origCompressedDataLength;
            this.topBlocksRequired = reqBlocks;
            this.topBlocksTotal = totalBlocks;
            this.topDontCompress = topDontCompress;
            this.topCompatibilityMode = topCompatibilityMode;
            this.parsedVersion = 1;
        } else {
            this.topSize = 0L;
            this.topCompressedSize = 0L;
            this.topBlocksRequired = 0;
            this.topBlocksTotal = 0;
            this.topDontCompress = false;
            this.topCompatibilityMode = InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
            this.parsedVersion = 0;
        }
    }

    public Metadata(SplitfileAlgorithm algo, ClientCHK[] dataURIs, ClientCHK[] checkURIs, int segmentSize, int checkSegmentSize, int deductBlocksFromSegments, ClientMetadata cm, long dataLength, ArchiveManager.ARCHIVE_TYPE archiveType, Compressor.COMPRESSOR_TYPE compressionCodec, long decompressedLength, boolean isMetadata, HashResult[] hashes, byte[] hashThisLayerOnly, long origDataSize, long origCompressedDataSize, int requiredBlocks, int totalBlocks, boolean topDontCompress, InsertContext.CompatibilityMode topCompatibilityMode, byte splitfileCryptoAlgorithm, byte[] splitfileCryptoKey, boolean specifySplitfileKey, int crossSegmentBlocks) {
        assert (topCompatibilityMode != InsertContext.CompatibilityMode.COMPAT_CURRENT);
        this.hashCode = super.hashCode();
        this.hashes = hashes;
        this.hashThisLayerOnly = hashThisLayerOnly;
        if (hashThisLayerOnly != null && hashThisLayerOnly.length != 32) {
            throw new IllegalArgumentException();
        }
        if (isMetadata) {
            this.documentType = DocumentType.MULTI_LEVEL_METADATA;
        } else if (archiveType != null) {
            this.documentType = DocumentType.ARCHIVE_MANIFEST;
            this.archiveType = archiveType;
        } else {
            this.documentType = DocumentType.SIMPLE_REDIRECT;
        }
        this.splitfile = true;
        this.splitfileAlgorithm = algo;
        this.dataLength = dataLength;
        this.compressionCodec = compressionCodec;
        this.splitfileBlocks = dataURIs.length;
        this.splitfileCheckBlocks = checkURIs.length;
        this.splitfileDataKeys = dataURIs;
        assert (this.keysValid(this.splitfileDataKeys));
        this.splitfileCheckKeys = checkURIs;
        assert (this.keysValid(this.splitfileCheckKeys));
        this.clientMetadata = cm;
        this.compressionCodec = compressionCodec;
        this.decompressedLength = decompressedLength;
        if (cm != null) {
            this.setMIMEType(cm.getMIMEType());
        } else {
            this.setMIMEType("application/octet-stream");
        }
        if (topCompatibilityMode.ordinal() < InsertContext.CompatibilityMode.COMPAT_1255.ordinal()) {
            if (splitfileCryptoKey != null) {
                throw new IllegalArgumentException();
            }
            if (hashes != null) {
                throw new IllegalArgumentException();
            }
            if (deductBlocksFromSegments != 0) {
                throw new IllegalArgumentException();
            }
            origDataSize = 0L;
            origCompressedDataSize = 0L;
            requiredBlocks = 0;
            totalBlocks = 0;
            this.parsedVersion = 0;
        } else {
            if (splitfileCryptoKey == null) {
                throw new IllegalArgumentException();
            }
            this.parsedVersion = 1;
        }
        if (origDataSize != 0L) {
            this.topSize = origDataSize;
            this.topCompressedSize = origCompressedDataSize;
            this.topBlocksRequired = requiredBlocks;
            this.topBlocksTotal = totalBlocks;
            if (topCompatibilityMode.ordinal() >= InsertContext.CompatibilityMode.COMPAT_1468.ordinal()) {
                this.topDontCompress = topDontCompress;
                this.topCompatibilityMode = topCompatibilityMode;
            } else {
                this.topDontCompress = false;
                this.topCompatibilityMode = InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
            }
        } else {
            this.topSize = 0L;
            this.topCompressedSize = 0L;
            this.topBlocksRequired = 0;
            this.topBlocksTotal = 0;
            this.topDontCompress = false;
            this.topCompatibilityMode = InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
        }
        if (this.parsedVersion == 0) {
            this.splitfileParams = Fields.intsToBytes(new int[]{segmentSize, checkSegmentSize});
        } else {
            short mode;
            boolean deductBlocks = deductBlocksFromSegments != 0;
            int len = 10;
            if (crossSegmentBlocks == 0) {
                if (deductBlocks) {
                    mode = 1;
                    len += 4;
                } else {
                    mode = 0;
                }
            } else {
                mode = 2;
                len += 8;
            }
            this.splitfileParams = new byte[len];
            byte[] b = Fields.shortToBytes(mode);
            System.arraycopy(b, 0, this.splitfileParams, 0, 2);
            b = mode == 2 ? Fields.intsToBytes(new int[]{segmentSize, checkSegmentSize, deductBlocksFromSegments, crossSegmentBlocks}) : (mode == 1 ? Fields.intsToBytes(new int[]{segmentSize, checkSegmentSize, deductBlocksFromSegments}) : Fields.intsToBytes(new int[]{segmentSize, checkSegmentSize}));
            System.arraycopy(b, 0, this.splitfileParams, 2, b.length);
            this.splitfileSingleCryptoAlgorithm = splitfileCryptoAlgorithm;
            this.splitfileSingleCryptoKey = splitfileCryptoKey;
            this.specifySplitfileKey = specifySplitfileKey;
            if (splitfileCryptoKey == null) {
                throw new IllegalArgumentException("Splitfile with parsed version 1 must have a crypto key");
            }
        }
    }

    private boolean keysValid(ClientCHK[] keys) {
        for (ClientCHK key : keys) {
            if (key.getNodeCHK().getRoutingKey() != null) continue;
            return false;
        }
        return true;
    }

    private void setMIMEType(String type) {
        this.noMIME = false;
        short s = DefaultMIMETypes.byName(type);
        if (s >= 0) {
            this.compressedMIME = true;
            this.compressedMIMEValue = s;
        } else {
            this.compressedMIME = false;
        }
        this.mimeType = type;
    }

    public byte[] writeToByteArray() throws MetadataUnresolvedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            this.writeTo(dos);
        }
        catch (IOException e) {
            throw new Error("Could not write to byte array: " + e, e);
        }
        return baos.toByteArray();
    }

    public long writtenLength() throws MetadataUnresolvedException {
        CountedOutputStream cos = new CountedOutputStream(new NullOutputStream());
        try {
            this.writeTo(new DataOutputStream(cos));
        }
        catch (IOException e) {
            throw new Error("Could not write to CountedOutputStream: " + e, e);
        }
        return cos.written();
    }

    private FreenetURI readKey(DataInputStream dis) throws IOException {
        if (this.fullKeys) {
            return FreenetURI.readFullBinaryKeyWithLength(dis);
        }
        return ClientCHK.readRawBinaryKey(dis).getURI();
    }

    private void writeKey(DataOutputStream dos, FreenetURI freenetURI) throws IOException {
        if (this.fullKeys) {
            freenetURI.writeFullBinaryKeyWithLength(dos);
        } else {
            String[] meta = freenetURI.getAllMetaStrings();
            if (meta != null && meta.length > 0) {
                throw new MalformedURLException("Not a plain CHK");
            }
            BaseClientKey key = BaseClientKey.getBaseKey(freenetURI);
            if (key instanceof ClientCHK) {
                ((ClientCHK)key).writeRawBinaryKey(dos);
            } else {
                throw new IllegalArgumentException("Full keys must be enabled to write non-CHKs");
            }
        }
    }

    private void writeCHK(DataOutputStream dos, ClientCHK chk) throws IOException {
        if (this.fullKeys) {
            throw new UnsupportedOperationException("Full keys not supported on splitfiles");
        }
        chk.writeRawBinaryKey(dos);
    }

    public boolean isSimpleManifest() {
        return this.documentType == DocumentType.SIMPLE_MANIFEST;
    }

    public Metadata getDocument(String name) {
        return this.manifestEntries.get(name);
    }

    public Metadata grabDocument(String name) {
        return this.manifestEntries.remove(name);
    }

    public Metadata getDefaultDocument() {
        return this.getDocument("");
    }

    public Metadata grabDefaultDocument() {
        return this.grabDocument("");
    }

    public HashMap<String, Metadata> getDocuments() {
        HashMap<String, Metadata> docs = new HashMap<String, Metadata>();
        for (Map.Entry<String, Metadata> entry : this.manifestEntries.entrySet()) {
            String st = entry.getKey();
            if (st.length() <= 0) continue;
            docs.put(st, entry.getValue());
        }
        return docs;
    }

    public boolean isSingleFileRedirect() {
        return !this.splitfile && (this.documentType == DocumentType.SIMPLE_REDIRECT || this.documentType == DocumentType.MULTI_LEVEL_METADATA || this.documentType == DocumentType.ARCHIVE_MANIFEST);
    }

    public FreenetURI getSingleTarget() {
        return this.simpleRedirectKey;
    }

    public boolean isArchiveManifest() {
        return this.documentType == DocumentType.ARCHIVE_MANIFEST;
    }

    public boolean isArchiveMetadataRedirect() {
        return this.documentType == DocumentType.ARCHIVE_METADATA_REDIRECT;
    }

    public boolean isArchiveInternalRedirect() {
        return this.documentType == DocumentType.ARCHIVE_INTERNAL_REDIRECT;
    }

    public String getArchiveInternalName() {
        if (this.documentType != DocumentType.ARCHIVE_INTERNAL_REDIRECT && this.documentType != DocumentType.ARCHIVE_METADATA_REDIRECT) {
            throw new IllegalArgumentException();
        }
        return this.targetName;
    }

    public String getSymbolicShortlinkTargetName() {
        if (this.documentType != DocumentType.SYMBOLIC_SHORTLINK) {
            throw new IllegalArgumentException();
        }
        return this.targetName;
    }

    public ClientMetadata getClientMetadata() {
        return this.clientMetadata;
    }

    public boolean isSplitfile() {
        return this.splitfile;
    }

    public boolean isSimpleSplitfile() {
        return this.splitfile && this.documentType == DocumentType.SIMPLE_REDIRECT;
    }

    public boolean isMultiLevelMetadata() {
        return this.documentType == DocumentType.MULTI_LEVEL_METADATA;
    }

    public ArchiveManager.ARCHIVE_TYPE getArchiveType() {
        return this.archiveType;
    }

    public void setSimpleRedirect() {
        this.documentType = DocumentType.SIMPLE_REDIRECT;
    }

    public boolean isSimpleRedirect() {
        return this.documentType == DocumentType.SIMPLE_REDIRECT;
    }

    public boolean isNoMimeEnabled() {
        return this.noMIME;
    }

    public String getResolvedName() {
        return this.resolvedName;
    }

    public boolean isSymbolicShortlink() {
        return this.documentType == DocumentType.SYMBOLIC_SHORTLINK;
    }

    public void writeTo(DataOutputStream dos) throws IOException, MetadataUnresolvedException {
        boolean hasTopBlocks;
        dos.writeLong(-1129362800769939413L);
        dos.writeShort(this.parsedVersion);
        dos.writeByte(this.documentType.code);
        boolean bl = hasTopBlocks = this.topBlocksRequired != 0 || this.topBlocksTotal != 0 || this.topSize != 0L || this.topCompressedSize != 0L || this.topCompatibilityMode != InsertContext.CompatibilityMode.COMPAT_UNKNOWN;
        if (this.haveFlags()) {
            short flags = 0;
            if (this.splitfile) {
                flags = (short)(flags | 1);
            }
            if (this.dbr) {
                flags = (short)(flags | 2);
            }
            if (this.noMIME) {
                flags = (short)(flags | 4);
            }
            if (this.compressedMIME) {
                flags = (short)(flags | 8);
            }
            if (this.extraMetadata) {
                flags = (short)(flags | 0x10);
            }
            if (this.fullKeys) {
                flags = (short)(flags | 0x20);
            }
            if (this.compressionCodec != null) {
                flags = (short)(flags | 0x80);
            }
            if (this.hashes != null) {
                flags = (short)(flags | 0x200);
            }
            if (hasTopBlocks) {
                assert (this.parsedVersion >= 1);
                flags = (short)(flags | 0x100);
            }
            if (this.specifySplitfileKey) {
                flags = (short)(flags | 0x400);
            }
            if (this.hashThisLayerOnly != null) {
                flags = (short)(flags | 0x800);
            }
            dos.writeShort(flags);
            if (this.hashes != null) {
                HashResult.write(this.hashes, dos);
            }
            if (this.hashThisLayerOnly != null) {
                assert (this.hashThisLayerOnly.length == 32);
                dos.write(this.hashThisLayerOnly);
            }
        }
        if (hasTopBlocks) {
            dos.writeLong(this.topSize);
            dos.writeLong(this.topCompressedSize);
            dos.writeInt(this.topBlocksRequired);
            dos.writeInt(this.topBlocksTotal);
            dos.writeBoolean(this.topDontCompress);
            dos.writeShort(this.topCompatibilityMode.code);
        }
        if (this.documentType == DocumentType.ARCHIVE_MANIFEST) {
            short code = this.archiveType.metadataID;
            dos.writeShort(code);
        }
        if (this.splitfile) {
            if (this.parsedVersion >= 1) {
                dos.writeByte(this.splitfileSingleCryptoAlgorithm);
                if (this.specifySplitfileKey || this.hashes == null || this.hashes.length == 0 || !HashResult.contains(this.hashes, HashType.SHA256)) {
                    dos.write(this.splitfileSingleCryptoKey);
                }
            }
            dos.writeLong(this.dataLength);
        }
        if (this.compressionCodec != null) {
            dos.writeShort(this.compressionCodec.metadataID);
            dos.writeLong(this.decompressedLength);
        }
        if (!this.noMIME) {
            if (this.compressedMIME) {
                int x = this.compressedMIMEValue;
                if (this.hasCompressedMIMEParams) {
                    x |= 0x8000;
                }
                dos.writeShort((short)x);
                if (this.hasCompressedMIMEParams) {
                    dos.writeShort(this.compressedMIMEParams);
                }
            } else {
                byte[] data = this.mimeType.getBytes("UTF-8");
                if (data.length > 255) {
                    throw new Error("MIME type too long: " + data.length + " bytes: " + this.mimeType);
                }
                dos.writeByte((byte)data.length);
                dos.write(data);
            }
        }
        if (this.dbr) {
            throw new UnsupportedOperationException("No DBR support yet");
        }
        if (this.extraMetadata) {
            throw new UnsupportedOperationException("No extra metadata support yet");
        }
        if (!(this.splitfile || this.documentType != DocumentType.SIMPLE_REDIRECT && this.documentType != DocumentType.ARCHIVE_MANIFEST)) {
            this.writeKey(dos, this.simpleRedirectKey);
        } else if (this.splitfile) {
            dos.writeShort(this.splitfileAlgorithm.code);
            if (this.splitfileParams != null) {
                dos.writeInt(this.splitfileParams.length);
                dos.write(this.splitfileParams);
            } else {
                dos.writeInt(0);
            }
            dos.writeInt(this.splitfileBlocks);
            dos.writeInt(this.splitfileCheckBlocks);
            if (this.segments != null) {
                int i;
                for (i = 0; i < this.segmentCount; ++i) {
                    this.segments[i].writeKeys(dos, false);
                }
                for (i = 0; i < this.segmentCount; ++i) {
                    this.segments[i].writeKeys(dos, true);
                }
            } else if (this.splitfileSingleCryptoKey == null) {
                int i;
                for (i = 0; i < this.splitfileBlocks; ++i) {
                    this.writeCHK(dos, this.splitfileDataKeys[i]);
                }
                for (i = 0; i < this.splitfileCheckBlocks; ++i) {
                    this.writeCHK(dos, this.splitfileCheckKeys[i]);
                }
            } else {
                int i;
                for (i = 0; i < this.splitfileBlocks; ++i) {
                    dos.write(this.splitfileDataKeys[i].getRoutingKey());
                }
                for (i = 0; i < this.splitfileCheckBlocks; ++i) {
                    dos.write(this.splitfileCheckKeys[i].getRoutingKey());
                }
            }
        }
        if (this.documentType == DocumentType.SIMPLE_MANIFEST) {
            dos.writeInt(this.manifestEntries.size());
            boolean kill = false;
            LinkedList<Metadata> unresolvedMetadata = null;
            for (Map.Entry<String, Metadata> entry : this.manifestEntries.entrySet()) {
                String name = entry.getKey();
                byte[] nameData = name.getBytes("UTF-8");
                if (nameData.length > Short.MAX_VALUE) {
                    throw new IllegalArgumentException("Manifest name too long");
                }
                dos.writeShort(nameData.length);
                dos.write(nameData);
                Metadata meta = entry.getValue();
                try {
                    byte[] data = meta.writeToByteArray();
                    if (data.length > Short.MAX_VALUE) {
                        FreenetURI uri = meta.resolvedURI;
                        String n = meta.resolvedName;
                        if (uri != null) {
                            meta = new Metadata(DocumentType.SIMPLE_REDIRECT, null, null, uri, null);
                            data = meta.writeToByteArray();
                        } else if (n != null) {
                            meta = new Metadata(DocumentType.ARCHIVE_METADATA_REDIRECT, n);
                            data = meta.writeToByteArray();
                        } else {
                            kill = true;
                            if (unresolvedMetadata == null) {
                                unresolvedMetadata = new LinkedList();
                            }
                            unresolvedMetadata.addLast(meta);
                        }
                    }
                    dos.writeShort(data.length);
                    dos.write(data);
                }
                catch (MetadataUnresolvedException e) {
                    Metadata[] metas = e.mustResolve;
                    if (unresolvedMetadata == null) {
                        unresolvedMetadata = new LinkedList<Metadata>();
                    }
                    for (Metadata m : metas) {
                        unresolvedMetadata.addFirst(m);
                    }
                    kill = true;
                }
            }
            if (kill) {
                Metadata[] meta = unresolvedMetadata.toArray(new Metadata[unresolvedMetadata.size()]);
                throw new MetadataUnresolvedException(meta, "Manifest data too long and not resolved");
            }
        }
        if (this.documentType == DocumentType.ARCHIVE_INTERNAL_REDIRECT || this.documentType == DocumentType.ARCHIVE_METADATA_REDIRECT || this.documentType == DocumentType.SYMBOLIC_SHORTLINK) {
            byte[] data = this.targetName.getBytes("UTF-8");
            if (data.length > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Archive internal redirect name too long");
            }
            dos.writeShort(data.length);
            dos.write(data);
        }
    }

    public boolean haveFlags() {
        return this.documentType == DocumentType.SIMPLE_REDIRECT || this.documentType == DocumentType.MULTI_LEVEL_METADATA || this.documentType == DocumentType.ARCHIVE_MANIFEST || this.documentType == DocumentType.ARCHIVE_INTERNAL_REDIRECT || this.documentType == DocumentType.ARCHIVE_METADATA_REDIRECT || this.documentType == DocumentType.SYMBOLIC_SHORTLINK;
    }

    public SplitfileAlgorithm getSplitfileType() {
        return this.splitfileAlgorithm;
    }

    public ClientCHK[] getSplitfileDataKeys() {
        return this.splitfileDataKeys;
    }

    public ClientCHK[] getSplitfileCheckKeys() {
        return this.splitfileCheckKeys;
    }

    public boolean isCompressed() {
        return this.compressionCodec != null;
    }

    public Compressor.COMPRESSOR_TYPE getCompressionCodec() {
        return this.compressionCodec;
    }

    public long dataLength() {
        return this.dataLength;
    }

    public byte[] splitfileParams() {
        return this.splitfileParams;
    }

    public long uncompressedDataLength() {
        return this.decompressedLength;
    }

    public FreenetURI getResolvedURI() {
        return this.resolvedURI;
    }

    public void resolve(FreenetURI uri) {
        this.resolvedURI = uri;
    }

    public void resolve(String name) {
        this.resolvedName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomAccessBucket toBucket(BucketFactory bf) throws MetadataUnresolvedException, IOException {
        RandomAccessBucket randomAccessBucket;
        RandomAccessBucket b = bf.makeBucket(-1L);
        DataOutputStream dos = null;
        boolean success = false;
        try {
            dos = new DataOutputStream(b.getOutputStream());
            this.writeTo(dos);
            dos.close();
            dos = null;
            b.setReadOnly();
            success = true;
            randomAccessBucket = b;
        }
        catch (Throwable throwable) {
            Closer.close(dos);
            if (!success) {
                b.free();
            }
            throw throwable;
        }
        Closer.close(dos);
        if (!success) {
            b.free();
        }
        return randomAccessBucket;
    }

    public boolean isResolved() {
        return this.resolvedURI != null || this.resolvedName != null;
    }

    public void setArchiveManifest() {
        ArchiveManager.ARCHIVE_TYPE type;
        this.archiveType = type = ArchiveManager.ARCHIVE_TYPE.getArchiveType(this.clientMetadata.getMIMEType());
        this.clientMetadata.clear();
        this.documentType = DocumentType.ARCHIVE_MANIFEST;
    }

    public String getMIMEType() {
        if (this.clientMetadata == null) {
            return null;
        }
        return this.clientMetadata.getMIMEType();
    }

    public void clearSplitfileKeys() {
        this.splitfileDataKeys = null;
        this.splitfileCheckKeys = null;
        this.segments = null;
    }

    public int countDocuments() {
        return this.manifestEntries.size();
    }

    public String dump() {
        StringBuffer sb = new StringBuffer();
        this.dump(0, sb);
        return sb.toString();
    }

    public void dump(int indent, StringBuffer sb) {
        this.dumpline(indent, sb, "");
        this.dumpline(indent, sb, "Document type: " + (Object)((Object)this.documentType));
        this.dumpline(indent, sb, "Flags: sf=" + this.splitfile + " dbr=" + this.dbr + " noMIME=" + this.noMIME + " cmime=" + this.compressedMIME + " extra=" + this.extraMetadata + " fullkeys=" + this.fullKeys);
        if (this.archiveType != null) {
            this.dumpline(indent, sb, "Archive type: " + (Object)((Object)this.archiveType));
        }
        if (this.compressionCodec != null) {
            this.dumpline(indent, sb, "Compression codec: " + this.compressionCodec);
        }
        if (this.simpleRedirectKey != null) {
            this.dumpline(indent, sb, "Simple redirect: " + this.simpleRedirectKey);
        }
        if (this.splitfile) {
            this.dumpline(indent, sb, "Splitfile algorithm: " + (Object)((Object)this.splitfileAlgorithm));
            this.dumpline(indent, sb, "Splitfile blocks: " + this.splitfileBlocks);
            this.dumpline(indent, sb, "Splitfile blocks: " + this.splitfileCheckBlocks);
        }
        if (this.targetName != null) {
            this.dumpline(indent, sb, "Target name: " + this.targetName);
        }
        if (this.manifestEntries != null) {
            for (Map.Entry<String, Metadata> entry : this.manifestEntries.entrySet()) {
                this.dumpline(indent, sb, "Entry: " + entry.getKey() + ":");
                entry.getValue().dump(indent + 1, sb);
            }
        }
    }

    private void dumpline(int indent, StringBuffer sb, String string) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        sb.append(string);
        sb.append("\n");
    }

    public static HashMap<String, Object> forceMap(Object o) {
        return (HashMap)o;
    }

    public short getParsedVersion() {
        return this.parsedVersion;
    }

    public boolean hasTopData() {
        return this.topSize != 0L || this.topCompressedSize != 0L || this.topBlocksRequired != 0 || this.topBlocksTotal != 0;
    }

    public HashResult[] getHashes() {
        return this.hashes;
    }

    public byte[] getCustomSplitfileKey() {
        if (this.specifySplitfileKey) {
            return this.splitfileSingleCryptoKey;
        }
        return null;
    }

    public byte[] getSplitfileCryptoKey() {
        return this.splitfileSingleCryptoKey;
    }

    public byte[] getHashThisLayerOnly() {
        return this.hashThisLayerOnly;
    }

    public byte getSplitfileCryptoAlgorithm() {
        return this.splitfileSingleCryptoAlgorithm;
    }

    public InsertContext.CompatibilityMode getTopCompatibilityMode() {
        return this.topCompatibilityMode;
    }

    public boolean getTopDontCompress() {
        return this.topDontCompress;
    }

    public short getTopCompatibilityCode() {
        return this.topCompatibilityMode.code;
    }

    public InsertContext.CompatibilityMode getMinCompatMode() {
        return this.minCompatMode;
    }

    public InsertContext.CompatibilityMode getMaxCompatMode() {
        return this.maxCompatMode;
    }

    public int getCrossCheckBlocks() {
        return this.crossCheckBlocks;
    }

    public int getCheckBlocksPerSegment() {
        return this.checkBlocksPerSegment;
    }

    public int getDataBlocksPerSegment() {
        return this.blocksPerSegment;
    }

    public int getSegmentCount() {
        return this.segmentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplitFileSegmentKeys[] grabSegmentKeys() throws FetchException {
        Metadata metadata = this;
        synchronized (metadata) {
            if (this.segments == null && this.splitfileDataKeys != null && this.splitfileCheckKeys != null) {
                throw new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, "Please restart the download, need to re-parse metadata due to internal changes");
            }
            SplitFileSegmentKeys[] segs = this.segments;
            this.segments = null;
            return segs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplitFileSegmentKeys[] getSegmentKeys() throws FetchException {
        Metadata metadata = this;
        synchronized (metadata) {
            if (this.segments == null && this.splitfileDataKeys != null && this.splitfileCheckKeys != null) {
                throw new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, "Please restart the download, need to re-parse metadata due to internal changes");
            }
            return this.segments;
        }
    }

    public int getDeductBlocksFromSegments() {
        return this.deductBlocksFromSegments;
    }

    public InsertContext.CompatibilityMode guessCompatibilityMode() {
        InsertContext.CompatibilityMode mode = this.getTopCompatibilityMode();
        if (mode != InsertContext.CompatibilityMode.COMPAT_UNKNOWN) {
            return mode;
        }
        InsertContext.CompatibilityMode min = this.minCompatMode;
        InsertContext.CompatibilityMode max = this.maxCompatMode;
        if (max == InsertContext.CompatibilityMode.COMPAT_CURRENT) {
            max = InsertContext.CompatibilityMode.latest();
        }
        if (min == max) {
            return min;
        }
        if (min == InsertContext.CompatibilityMode.COMPAT_UNKNOWN && max != InsertContext.CompatibilityMode.COMPAT_UNKNOWN) {
            return max;
        }
        if (max == InsertContext.CompatibilityMode.COMPAT_UNKNOWN && min != InsertContext.CompatibilityMode.COMPAT_UNKNOWN) {
            return min;
        }
        return max;
    }

    public static boolean isValidSplitfileCryptoAlgorithm(byte cryptoAlgorithm) {
        return cryptoAlgorithm == 0 || Key.isValidCryptoAlgorithm(cryptoAlgorithm);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        try {
            SPLITKEY = "SPLITKEY".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
        try {
            CROSS_SEGMENT_SEED = "CROSS_SEGMENT_SEED".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public static class SimpleManifestComposer {
        private Metadata m = new Metadata();

        public SimpleManifestComposer() {
            this.m.documentType = DocumentType.SIMPLE_MANIFEST;
            this.m.noMIME = true;
            this.m.manifestEntries = new HashMap();
        }

        public void addItem(String name, Metadata item) {
            if (name == null || item == null) {
                throw new NullPointerException();
            }
            if (this.m == null) {
                throw new IllegalStateException("You can't call it after getMetadata()");
            }
            if (this.m.manifestEntries.containsKey(name)) {
                throw new IllegalStateException("You can't add a item twice: '" + name + "'");
            }
            this.m.manifestEntries.put(name, item);
        }

        public Metadata getMetadata() {
            Metadata result = this.m;
            this.m = null;
            return result;
        }
    }

    public static enum SplitfileAlgorithm {
        NONREDUNDANT(0),
        ONION_STANDARD(1);

        public final short code;

        private SplitfileAlgorithm(short code) {
            this.code = code;
        }

        public static SplitfileAlgorithm getByCode(short s) {
            if (s < 0 || s >= SplitfileAlgorithm.values().length) {
                throw new IllegalArgumentException("Bad splitfile code");
            }
            return SplitfileAlgorithm.values()[s];
        }
    }

    public static enum DocumentType {
        SIMPLE_REDIRECT(0),
        MULTI_LEVEL_METADATA(1),
        SIMPLE_MANIFEST(2),
        ARCHIVE_MANIFEST(3),
        ARCHIVE_INTERNAL_REDIRECT(4),
        ARCHIVE_METADATA_REDIRECT(5),
        SYMBOLIC_SHORTLINK(6);

        final byte code;

        private DocumentType(byte code) {
            this.code = code;
        }

        static DocumentType byCode(byte b) {
            if (b < 0 || b >= DocumentType.values().length) {
                throw new IllegalArgumentException();
            }
            return DocumentType.values()[b];
        }
    }
}

