/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.FetchContext;
import freenet.client.async.BaseSingleFileFetcher;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientRequester;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.USKCheckerCallback;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.ClientSSKBlock;
import freenet.node.LowLevelGetException;
import freenet.node.SendableRequestItem;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;

class USKChecker
extends BaseSingleFileFetcher {
    final USKCheckerCallback cb;
    private int dnfs;
    private long cooldownWakeupTime;
    private static volatile boolean logMINOR;

    USKChecker(USKCheckerCallback cb, ClientKey key, int maxRetries, FetchContext ctx, ClientRequester parent, boolean realTimeFlag) {
        super(key, maxRetries, ctx, parent, false, realTimeFlag);
        this.cb = cb;
        if (logMINOR) {
            Logger.minor(USKChecker.class, "Created USKChecker for " + key + " : " + this);
        }
    }

    @Override
    public void onSuccess(ClientKeyBlock block, boolean fromStore, Object token, ClientContext context) {
        this.cb.onSuccess((ClientSSKBlock)block, context);
    }

    @Override
    public void onFailure(LowLevelGetException e, SendableRequestItem token, ClientContext context) {
        boolean canRetry;
        if (logMINOR) {
            Logger.minor(this, "onFailure: " + e + " for " + this);
        }
        switch (e.code) {
            case 1: 
            case 9: {
                canRetry = false;
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                ++this.dnfs;
                canRetry = true;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                canRetry = true;
                break;
            }
            default: {
                Logger.error(this, "Unknown low-level fetch error code: " + e.code, (Throwable)new Exception("error"));
                canRetry = true;
            }
        }
        if (canRetry && this.retry(context)) {
            return;
        }
        this.unregisterAll(context);
        if (e.code == 9) {
            this.cb.onCancelled(context);
            return;
        }
        if (e.code == 1) {
            this.cb.onFatalAuthorError(context);
            return;
        }
        if (this.dnfs > 0) {
            this.cb.onDNF(context);
        } else {
            this.cb.onNetworkError(context);
        }
    }

    public String toString() {
        return "USKChecker for " + this.key.getURI() + " for " + this.cb;
    }

    @Override
    public void onFailed(KeyListenerConstructionException e, ClientContext context) {
        this.onFailure(new LowLevelGetException(3, "IMPOSSIBLE: Failed to create Bloom filters (we don't have any!)", e), null, context);
    }

    @Override
    public short getPriorityClass() {
        return this.cb.getPriority();
    }

    @Override
    protected void onEnterFiniteCooldown(ClientContext context) {
        this.cb.onEnterFiniteCooldown(context);
    }

    @Override
    protected void notFoundInStore(ClientContext context) {
        this.unregisterAll(context);
        this.cb.onDNF(context);
    }

    @Override
    protected void onBlockDecodeError(SendableRequestItem token, ClientContext context) {
        this.onFailure(new LowLevelGetException(1), token, context);
    }

    @Override
    protected ClientGetState getClientGetState() {
        return null;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

