/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptoElement;
import freenet.crypt.Util;
import freenet.support.HexUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import net.i2p.util.NativeBigInteger;

public class DSASignature
implements CryptoElement,
Serializable {
    private static final long serialVersionUID = -1L;
    private final BigInteger r;
    private final BigInteger s;
    private String toStringCached;

    public DSASignature(InputStream in) throws IOException {
        this.r = Util.readMPI(in);
        this.s = Util.readMPI(in);
        if (this.r.signum() != 1 || this.s.signum() != 1) {
            throw new IOException("Both R and S should be positive!");
        }
    }

    public DSASignature(String sig) throws NumberFormatException {
        int x = sig.indexOf(44);
        if (x <= 0) {
            throw new NumberFormatException("DSA Signatures have two values");
        }
        this.r = new NativeBigInteger(sig.substring(0, x), 16);
        this.s = new NativeBigInteger(sig.substring(x + 1), 16);
        if (this.r.signum() != 1 || this.s.signum() != 1) {
            throw new IllegalArgumentException();
        }
    }

    public static DSASignature read(InputStream in) throws IOException {
        BigInteger r = Util.readMPI(in);
        BigInteger s = Util.readMPI(in);
        return new DSASignature(r, s);
    }

    public void write(OutputStream o) throws IOException {
        Util.writeMPI(this.r, o);
        Util.writeMPI(this.s, o);
    }

    public DSASignature(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
        if (r.signum() != 1 || s.signum() != 1) {
            throw new IllegalArgumentException();
        }
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }

    @Override
    public String toLongString() {
        if (this.toStringCached == null) {
            this.toStringCached = HexUtil.biToHex(this.r) + ',' + HexUtil.biToHex(this.s);
        }
        return this.toStringCached;
    }

    public byte[] getRBytes(int length) {
        return DSASignature.getParamBytes(this.r, length);
    }

    public byte[] getSBytes(int length) {
        return DSASignature.getParamBytes(this.s, length);
    }

    private static byte[] getParamBytes(BigInteger param, int length) {
        byte[] data = param.toByteArray();
        if (data.length < length) {
            byte[] out = new byte[length];
            System.arraycopy(data, 0, out, out.length - data.length, data.length);
            return out;
        }
        if (data.length == length + 1) {
            if (data[0] == 0) {
                byte[] out = new byte[length];
                System.arraycopy(data, 1, out, 0, length);
                return out;
            }
            throw new IllegalArgumentException("Parameter longer than " + length + " bytes : " + param.bitLength());
        }
        if (data.length == length) {
            return data;
        }
        throw new IllegalArgumentException("Length is much shorter: " + data.length + " but target length = " + length);
    }
}

