/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.config.SubConfig;
import freenet.crypt.AEADCryptBucket;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeInitException;
import freenet.node.ProgramDirectory;
import freenet.pluginmanager.PluginStore;
import freenet.support.IllegalBase64Exception;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import freenet.support.io.PaddedBucket;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PluginStores {
    final Node node;
    private final ProgramDirectory pluginStoresDir;

    public PluginStores(Node node, SubConfig installConfig) throws NodeInitException {
        this.node = node;
        this.pluginStoresDir = node.setupProgramDir(installConfig, "pluginStoresDir", "plugin-data", "NodeClientCore.pluginStoresDir", "NodeClientCore.pluginStoresDir", null, null);
        File dir = this.pluginStoresDir.dir();
        if (!(dir.mkdirs() || dir.exists() && dir.isDirectory() && dir.canRead() && dir.canWrite())) {
            System.err.println("Unable to create folder for plugin data: " + this.pluginStoresDir.dir());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePluginStoreInner(String storeIdentifier, PluginStore pluginStore, boolean isEncrypted, boolean backup) throws IOException {
        Bucket bucket = this.makePluginStoreBucket(storeIdentifier, isEncrypted, backup);
        OutputStream os = bucket.getOutputStream();
        try {
            if (pluginStore != null) {
                pluginStore.exportStoreAsSFS().writeTo(os);
            }
        }
        finally {
            os.close();
        }
    }

    private File getPluginStoreFile(String storeIdentifier, boolean encrypted, boolean backup) {
        String filename = storeIdentifier;
        filename = filename + ".data";
        if (backup) {
            filename = filename + ".bak";
        }
        if (encrypted) {
            filename = filename + ".crypt";
        }
        return this.pluginStoresDir.file(filename);
    }

    private Bucket makePluginStoreBucket(String storeIdentifier, boolean isEncrypted, boolean backup) throws FileNotFoundException {
        byte[] key;
        File f = this.getPluginStoreFile(storeIdentifier, isEncrypted, backup);
        Bucket bucket = new FileBucket(f, false, true, false, false);
        if (isEncrypted && (key = this.node.getPluginStoreKey(storeIdentifier)) != null) {
            bucket = new AEADCryptBucket(bucket, key);
            bucket = new PaddedBucket(bucket);
        }
        return bucket;
    }

    private Bucket findPluginStoreBucket(String storeIdentifier, boolean isEncrypted, boolean backup) throws FileNotFoundException {
        byte[] key;
        File f = this.getPluginStoreFile(storeIdentifier, isEncrypted, backup);
        if (!f.exists()) {
            return null;
        }
        Bucket bucket = new FileBucket(f, false, false, false, false);
        if (isEncrypted && (key = this.node.getPluginStoreKey(storeIdentifier)) != null) {
            bucket = new AEADCryptBucket(bucket, key);
            bucket = new PaddedBucket(bucket, bucket.size());
        }
        return bucket;
    }

    public PluginStore loadPluginStore(String storeIdentifier) {
        boolean isEncrypted = this.node.wantEncryptedDatabase();
        PluginStore store = this.loadPluginStore(storeIdentifier, isEncrypted, false);
        if (store != null) {
            return store;
        }
        store = this.loadPluginStore(storeIdentifier, isEncrypted, true);
        if (store != null) {
            return store;
        }
        store = this.loadPluginStore(storeIdentifier, isEncrypted = !isEncrypted, false);
        if (store != null) {
            return store;
        }
        store = this.loadPluginStore(storeIdentifier, isEncrypted, true);
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginStore loadPluginStore(String storeIdentifier, boolean isEncrypted, boolean backup) {
        PluginStore pluginStore;
        block11: {
            Bucket bucket;
            try {
                bucket = this.findPluginStoreBucket(storeIdentifier, isEncrypted, backup);
                if (bucket == null) {
                    return null;
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
            InputStream is = null;
            try {
                is = bucket.getInputStream();
                SimpleFieldSet fs = SimpleFieldSet.readFrom(is, false, false, true, true);
                pluginStore = new PluginStore(fs);
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    System.err.println("Unable to load plugin data for " + storeIdentifier + " : " + e);
                    System.err.println("This could be caused by data corruption or bugs in Freenet.");
                    return null;
                }
                catch (IllegalBase64Exception e) {
                    System.err.println("Unable to load plugin data for " + storeIdentifier + " : " + e);
                    System.err.println("This could be caused by data corruption or bugs in Freenet.");
                    return null;
                }
                catch (FSParseException e) {
                    System.err.println("Unable to load plugin data for " + storeIdentifier + " : " + e);
                    System.err.println("This could be caused by data corruption or bugs in Freenet.");
                    return null;
                }
            }
            is.close();
        }
        return pluginStore;
    }

    public void writePluginStore(String storeIdentifier, PluginStore store) throws IOException {
        boolean isEncrypted = this.node.wantEncryptedDatabase();
        File backup = this.getPluginStoreFile(storeIdentifier, isEncrypted, true);
        File main = this.getPluginStoreFile(storeIdentifier, isEncrypted, false);
        if (backup.exists() && main.exists()) {
            FileUtil.secureDelete(backup);
        }
        if (main.exists() && !main.renameTo(backup)) {
            System.err.println("Unable to rename " + main + " to " + backup + " when writing pluginstore for " + storeIdentifier);
        }
        this.writePluginStoreInner(storeIdentifier, store, isEncrypted, false);
        File f = this.getPluginStoreFile(storeIdentifier, !isEncrypted, true);
        if (f.exists()) {
            FileUtil.secureDelete(f);
        }
        if ((f = this.getPluginStoreFile(storeIdentifier, !isEncrypted, false)).exists()) {
            FileUtil.secureDelete(f);
        }
    }
}

