/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.node.PrioRunnable;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.io.NativeThread;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class PooledExecutor
implements Executor {
    private final int[] runningThreads = new int[10];
    private final ArrayList<MyThread>[] waitingThreads = new ArrayList[this.runningThreads.length];
    private volatile int waitingThreadsCount;
    AtomicLong[] threadCounter = new AtomicLong[this.runningThreads.length];
    private long jobCount;
    private long jobMisses;
    private static boolean logMINOR;
    private Ticker ticker;
    static final long TIMEOUT;

    public synchronized void setTicker(Ticker ticker) {
        this.ticker = ticker;
    }

    public PooledExecutor() {
        for (int i = 0; i < this.runningThreads.length; ++i) {
            this.waitingThreads[i] = new ArrayList();
            this.threadCounter[i] = new AtomicLong();
        }
        this.waitingThreadsCount = 0;
    }

    public void start() {
        logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
    }

    @Override
    public void execute(Runnable job) {
        this.execute(job, "<noname>");
    }

    @Override
    public void execute(Runnable job, String jobName) {
        this.execute(job, jobName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Runnable runnable, String jobName, boolean fromTicker) {
        int prio = NativeThread.NORM_PRIORITY;
        if (runnable instanceof PrioRunnable) {
            prio = ((PrioRunnable)runnable).getPriority();
        }
        if (logMINOR) {
            Logger.minor(this, "Executing " + runnable + " as " + jobName + " at prio " + prio);
        }
        if (prio < NativeThread.MIN_PRIORITY) throw new IllegalArgumentException("Unreconized priority level : " + prio + '!');
        if (prio > NativeThread.MAX_PRIORITY) {
            throw new IllegalArgumentException("Unreconized priority level : " + prio + '!');
        }
        Job job = new Job(runnable, jobName);
        while (true) {
            MyThread t = null;
            boolean miss = false;
            PooledExecutor pooledExecutor = this;
            // MONITORENTER : pooledExecutor
            ++this.jobCount;
            if (!this.waitingThreads[prio - 1].isEmpty()) {
                t = this.waitingThreads[prio - 1].remove(this.waitingThreads[prio - 1].size() - 1);
                if (t != null) {
                    --this.waitingThreadsCount;
                }
                if (logMINOR) {
                    Logger.minor(this, "Reusing thread " + t);
                }
            } else {
                if (this.ticker != null && !fromTicker && NativeThread.usingNativeCode() && prio > Thread.currentThread().getPriority()) {
                    this.ticker.queueTimedJob(runnable, jobName, 0L, true, false);
                    // MONITOREXIT : pooledExecutor
                    return;
                }
                miss = true;
            }
            // MONITOREXIT : pooledExecutor
            if (miss) {
                long threadNo = this.threadCounter[prio - 1].getAndIncrement();
                t = new MyThread("Pooled thread awaiting work @" + threadNo + " for prio " + prio, job, threadNo, prio, !fromTicker);
                t.setDaemon(true);
                PooledExecutor pooledExecutor2 = this;
                // MONITORENTER : pooledExecutor2
                int n = prio - 1;
                this.runningThreads[n] = this.runningThreads[n] + 1;
                ++this.jobMisses;
                if (logMINOR) {
                    Logger.minor(this, "Jobs: " + this.jobMisses + " misses of " + this.jobCount + " starting urgently " + jobName);
                }
                // MONITOREXIT : pooledExecutor2
                t.start();
                return;
            }
            pooledExecutor = t;
            // MONITORENTER : pooledExecutor
            if (!t.alive) {
                // MONITOREXIT : pooledExecutor
                continue;
            }
            if (t.nextJob == null) {
                t.nextJob = job;
                t.notifyAll();
                // MONITOREXIT : pooledExecutor
                if (!logMINOR) return;
                pooledExecutor = this;
                // MONITORENTER : pooledExecutor
                Logger.minor(this, "Not starting: Jobs: " + this.jobMisses + " misses of " + this.jobCount + " starting urgently " + jobName);
                // MONITOREXIT : pooledExecutor
                return;
            }
            // MONITOREXIT : pooledExecutor
        }
    }

    @Override
    public synchronized int[] runningThreads() {
        int[] result = new int[this.runningThreads.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.runningThreads[i] - this.waitingThreads[i].size();
        }
        return result;
    }

    @Override
    public synchronized int[] waitingThreads() {
        int[] result = new int[this.waitingThreads.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.waitingThreads[i].size();
        }
        return result;
    }

    @Override
    public int getWaitingThreadsCount() {
        return this.waitingThreadsCount;
    }

    static {
        TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
    }

    private class MyThread
    extends NativeThread {
        final String defaultName;
        volatile boolean alive;
        Job nextJob;
        final long threadNo;
        private boolean removed;

        public MyThread(String defaultName, Job firstJob, long threadCounter, int prio, boolean dontCheckRenice) {
            super(defaultName, prio, dontCheckRenice);
            this.alive = true;
            this.removed = false;
            this.defaultName = defaultName;
            this.threadNo = threadCounter;
            this.nextJob = firstJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void realRun() {
            block9: {
                PooledExecutor pooledExecutor;
                int nativePriority = this.getNativePriority();
                try {
                    this.innerRun(nativePriority);
                    if (this.removed) break block9;
                    pooledExecutor = PooledExecutor.this;
                }
                catch (Throwable throwable) {
                    if (!this.removed) {
                        PooledExecutor pooledExecutor2 = PooledExecutor.this;
                        synchronized (pooledExecutor2) {
                            int[] nArray = PooledExecutor.this.runningThreads;
                            int n = nativePriority - 1;
                            nArray[n] = nArray[n] - 1;
                        }
                    }
                    throw throwable;
                }
                synchronized (pooledExecutor) {
                    int[] nArray = PooledExecutor.this.runningThreads;
                    int n = nativePriority - 1;
                    nArray[n] = nArray[n] - 1;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void innerRun(int nativePriority) {
            long ranJobs = 0L;
            while (true) {
                Job job;
                Object object = this;
                synchronized (object) {
                    job = this.nextJob;
                    this.nextJob = null;
                }
                if (job == null) {
                    object = PooledExecutor.this;
                    synchronized (object) {
                        PooledExecutor.this.waitingThreads[nativePriority - 1].add(this);
                        PooledExecutor.this.waitingThreadsCount++;
                    }
                    object = this;
                    synchronized (object) {
                        if (this.nextJob == null) {
                            this.setName(this.defaultName);
                            try {
                                this.wait(TIMEOUT);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        }
                    }
                    object = PooledExecutor.this;
                    synchronized (object) {
                        if (PooledExecutor.this.waitingThreads[nativePriority - 1].remove(this)) {
                            PooledExecutor.this.waitingThreadsCount--;
                        }
                        MyThread myThread = this;
                        synchronized (myThread) {
                            job = this.nextJob;
                            this.nextJob = null;
                            if (job == null) {
                                this.alive = false;
                            }
                        }
                        if (!this.alive) {
                            int[] nArray = PooledExecutor.this.runningThreads;
                            int n = nativePriority - 1;
                            nArray[n] = nArray[n] - 1;
                            if (logMINOR) {
                                Logger.minor(this, "Exiting having executed " + ranJobs + " jobs : " + this);
                            }
                            this.removed = true;
                            return;
                        }
                    }
                }
                try {
                    this.setName(job.name + "(" + this.threadNo + ")");
                    job.runnable.run();
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught " + t + " running job " + job, t);
                }
                ++ranJobs;
            }
        }
    }

    private static class Job {
        private final Runnable runnable;
        private final String name;

        Job(Runnable runnable, String name) {
            this.runnable = runnable;
            this.name = name;
        }
    }
}

