/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestSelector;
import freenet.client.async.RequestSelectionTreeNode;
import freenet.support.Logger;
import freenet.support.RandomGrabArrayItem;
import freenet.support.RandomGrabArrayItemExclusionList;
import freenet.support.RemoveRandom;
import freenet.support.RemoveRandomParent;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.tanukisoftware.wrapper.WrapperManager;

public class RandomGrabArray
implements RemoveRandom,
RequestSelectionTreeNode {
    private static volatile boolean logMINOR;
    private Block[] blocks = new Block[]{new Block()};
    private int index;
    private static final int MIN_SIZE = 32;
    private static final int BLOCK_SIZE = 1024;
    private final int hashCode;
    private RemoveRandomParent parent;
    protected ClientRequestSelector root;
    private long wakeupTime;
    static final int MAX_EXCLUDED = 10;

    public RandomGrabArray(RemoveRandomParent parent, ClientRequestSelector root) {
        this.blocks[0].reqs = new RandomGrabArrayItem[32];
        this.index = 0;
        this.hashCode = super.hashCode();
        this.parent = parent;
        this.root = root;
    }

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RandomGrabArrayItem req, ClientContext context) {
        if (context != null && req.getWakeupTime(context, System.currentTimeMillis()) < 0L) {
            if (logMINOR) {
                Logger.minor(this, "Is finished already: " + req);
            }
            return;
        }
        req.setParentGrabArray(this);
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            if (context != null) {
                this.clearWakeupTime(context);
            }
            int x = 0;
            if (this.blocks.length == 1 && this.index < 1024) {
                for (int i = 0; i < this.index; ++i) {
                    if (this.blocks[0].reqs[i] != req) continue;
                    return;
                }
                if (this.index >= this.blocks[0].reqs.length) {
                    this.blocks[0].reqs = Arrays.copyOf(this.blocks[0].reqs, Math.min(1024, this.blocks[0].reqs.length * 2));
                }
                this.blocks[0].reqs[this.index++] = req;
                if (logMINOR) {
                    Logger.minor(this, "Added " + req + " before index " + this.index);
                }
                return;
            }
            int targetBlock = this.index / 1024;
            for (int i = 0; i < this.blocks.length; ++i) {
                Block block = this.blocks[i];
                if (i != this.blocks.length - 1 && block.reqs.length != 1024) {
                    Logger.error(this, "Block " + i + " of " + this.blocks.length + " is wrong size: " + block.reqs.length + " should be " + 1024);
                }
                for (int j = 0; j < block.reqs.length && x < this.index; ++x, ++j) {
                    if (block.reqs[j] == req) {
                        if (logMINOR) {
                            Logger.minor(this, "Already contains " + req + " : " + this + " size now " + this.index);
                        }
                        return;
                    }
                    if (block.reqs[j] != null) continue;
                    Logger.error(this, "reqs[" + i + "." + j + "] = null on " + this);
                }
            }
            if (this.blocks.length <= targetBlock) {
                if (logMINOR) {
                    Logger.minor(this, "Adding blocks on " + this);
                }
                Block[] newBlocks = Arrays.copyOf(this.blocks, targetBlock + 1);
                for (int i = this.blocks.length; i < newBlocks.length; ++i) {
                    newBlocks[i] = new Block();
                    newBlocks[i].reqs = new RandomGrabArrayItem[1024];
                }
                this.blocks = newBlocks;
            }
            Block target = this.blocks[targetBlock];
            target.reqs[this.index++ % 1024] = req;
            if (logMINOR) {
                Logger.minor(this, "Added: " + req + " to " + this + " size now " + this.index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveRandom.RemoveRandomReturn removeRandom(RandomGrabArrayItemExclusionList excluding, ClientContext context, long now) {
        if (logMINOR) {
            Logger.minor(this, "removeRandom() on " + this + " index=" + this.index);
        }
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            if (this.index == 0) {
                if (logMINOR) {
                    Logger.minor(this, "All null on " + this);
                }
                return null;
            }
            if (this.index < 10) {
                return this.removeRandomExhaustiveSearch(excluding, context, now);
            }
            RandomGrabArrayItem ret = this.removeRandomLimited(excluding, context, now);
            if (ret != null) {
                return new RemoveRandom.RemoveRandomReturn(ret);
            }
            if (this.index == 0) {
                if (logMINOR) {
                    Logger.minor(this, "All null on " + this);
                }
                return null;
            }
            return this.removeRandomExhaustiveSearch(excluding, context, now);
        }
    }

    private RandomGrabArrayItem removeRandomLimited(RandomGrabArrayItemExclusionList excluding, ClientContext context, long now) {
        int newBlockCount;
        RandomGrabArrayItem oret;
        RandomGrabArrayItem ret;
        int blockNo;
        int i;
        block13: {
            int excluded = 0;
            while (true) {
                i = context.fastWeakRandom.nextInt(this.index);
                blockNo = i / 1024;
                ret = this.blocks[blockNo].reqs[i % 1024];
                if (ret == null) {
                    Logger.error(this, "reqs[" + i + "] = null");
                    this.remove(blockNo, i);
                    continue;
                }
                if (ret.getWakeupTime(context, now) > 0L) {
                    if (++excluded <= 10) continue;
                    return null;
                }
                oret = ret;
                long itemWakeTime = ret.getWakeupTime(context, now);
                if (itemWakeTime == -1L) {
                    if (logMINOR) {
                        Logger.minor(this, "Not returning because cancelled: " + ret);
                    }
                    ret = null;
                    oret.setParentGrabArray(null);
                }
                if (itemWakeTime == 0L) {
                    itemWakeTime = excluding.exclude(ret, context, now);
                }
                if (ret == null || itemWakeTime <= 0L) break block13;
                if (++excluded > 10) break;
            }
            return null;
        }
        if (ret != null) {
            if (logMINOR) {
                Logger.minor(this, "Returning (cannot remove): " + ret + " of " + this.index);
            }
            return ret;
        }
        do {
            this.remove(blockNo, i);
            oret = this.blocks[blockNo].reqs[i % 1024];
        } while (this.index > i && oret == null);
        if (this.blocks.length == 1 && this.index < this.blocks[0].reqs.length / 4 && this.blocks[0].reqs.length > 32) {
            this.blocks[0].reqs = Arrays.copyOf(this.blocks[0].reqs, Math.max(this.index * 2, 32));
        } else if (this.blocks.length > 1 && (newBlockCount = (this.index + 512) / 1024 + 1) < this.blocks.length) {
            if (logMINOR) {
                Logger.minor(this, "Shrinking blocks on " + this);
            }
            this.blocks = Arrays.copyOf(this.blocks, newBlockCount);
        }
        return ret;
    }

    private RemoveRandom.RemoveRandomReturn removeRandomExhaustiveSearch(RandomGrabArrayItemExclusionList excluding, ClientContext context, long now) {
        if (logMINOR) {
            Logger.minor(this, "Doing exhaustive search and compaction on " + this);
        }
        long wakeupTime = Long.MAX_VALUE;
        RandomGrabArrayItem ret = null;
        int random = -1;
        while (true) {
            RandomGrabArrayItem[] reqsReading = this.blocks[0].reqs;
            RandomGrabArrayItem[] reqsWriting = this.blocks[0].reqs;
            int blockNumReading = 0;
            int blockNumWriting = 0;
            int offset = -1;
            int writeOffset = -1;
            int exclude = 0;
            int valid = 0;
            int validIndex = -1;
            int target = 0;
            RandomGrabArrayItem chosenItem = null;
            RandomGrabArrayItem validItem = null;
            for (int i = 0; i < this.index; ++i) {
                RandomGrabArrayItem item;
                if (++offset == 1024) {
                    offset = 0;
                    reqsReading = this.blocks[++blockNumReading].reqs;
                }
                if ((item = reqsReading[offset]) == null) {
                    if (!logMINOR) continue;
                    Logger.minor(this, "Found null item at offset " + offset + " i=" + i + " block = " + blockNumReading + " on " + this);
                    continue;
                }
                boolean excludeItem = false;
                long excludeTime = item.getWakeupTime(context, now);
                if (excludeTime > 0L) {
                    excludeItem = true;
                    if (wakeupTime > excludeTime) {
                        wakeupTime = excludeTime;
                    }
                } else {
                    long itemWakeTime = item.getWakeupTime(context, now);
                    if (itemWakeTime == -1L) {
                        if (logMINOR) {
                            Logger.minor(this, "Removing " + item + " on " + this);
                        }
                        reqsReading[offset] = null;
                        item.setParentGrabArray(null);
                        continue;
                    }
                    if (itemWakeTime > 0L) {
                        if (itemWakeTime < wakeupTime) {
                            wakeupTime = itemWakeTime;
                        }
                        excludeItem = true;
                    }
                    if (!excludeItem && (itemWakeTime = excluding.exclude(item, context, now)) > 0L) {
                        if (itemWakeTime < wakeupTime) {
                            wakeupTime = itemWakeTime;
                        }
                        excludeItem = true;
                    }
                }
                if (++writeOffset == 1024) {
                    writeOffset = 0;
                    reqsWriting = this.blocks[++blockNumWriting].reqs;
                }
                if (i != target) {
                    reqsReading[offset] = null;
                    reqsWriting[writeOffset] = item;
                }
                ++target;
                if (excludeItem) {
                    ++exclude;
                    continue;
                }
                if (valid == random) {
                    chosenItem = item;
                }
                if (validIndex == -1) {
                    validIndex = target - 1;
                    validItem = item;
                }
                ++valid;
            }
            if (this.index != target) {
                this.index = target;
            }
            if (chosenItem != null) {
                ret = chosenItem;
                if (logMINOR) {
                    Logger.minor(this, "Chosen random item " + ret + " out of " + valid + " total " + this.index);
                }
                return new RemoveRandom.RemoveRandomReturn(ret);
            }
            if (valid == 0 && exclude == 0) {
                if (logMINOR) {
                    Logger.minor(this, "No valid or excluded items total " + this.index);
                }
                return null;
            }
            if (valid == 0) {
                if (logMINOR) {
                    Logger.minor(this, "No valid items, " + exclude + " excluded items total " + this.index);
                }
                this.reduceWakeupTime(wakeupTime, context);
                return new RemoveRandom.RemoveRandomReturn(wakeupTime);
            }
            if (valid == 1) {
                ret = validItem;
                if (logMINOR) {
                    Logger.minor(this, "No valid or excluded items apart from " + ret + " total " + this.index);
                }
                return new RemoveRandom.RemoveRandomReturn(ret);
            }
            random = context.fastWeakRandom.nextInt(valid);
            if (!logMINOR) continue;
            Logger.minor(this, "Looping to choose valid item " + random + " of " + valid + " (excluded " + exclude + ")");
        }
    }

    private void remove(int blockNo, int i) {
        --this.index;
        int endBlock = this.index / 1024;
        if (this.blocks.length == 1 || blockNo == endBlock) {
            RandomGrabArrayItem[] items = this.blocks[blockNo].reqs;
            int idx = this.index % 1024;
            items[i % 1024] = items[idx];
            items[idx] = null;
        } else {
            RandomGrabArrayItem[] toItems = this.blocks[blockNo].reqs;
            RandomGrabArrayItem[] endItems = this.blocks[endBlock].reqs;
            toItems[i % 1024] = endItems[this.index % 1024];
            endItems[this.index % 1024] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(RandomGrabArrayItem it, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Removing " + it + " from " + this);
        }
        boolean matched = false;
        boolean empty = false;
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            if (this.blocks.length == 1) {
                Block block = this.blocks[0];
                for (int i = 0; i < this.index; ++i) {
                    if (block.reqs[i] != it) continue;
                    block.reqs[i] = block.reqs[--this.index];
                    block.reqs[this.index] = null;
                    matched = true;
                    break;
                }
                if (this.index == 0) {
                    empty = true;
                }
            } else {
                int x = 0;
                block4: for (int i = 0; i < this.blocks.length; ++i) {
                    Block block = this.blocks[i];
                    for (int j = 0; j < block.reqs.length && x < this.index; ++x, ++j) {
                        if (block.reqs[j] != it) continue;
                        int pullFrom = --this.index;
                        int idx = pullFrom % 1024;
                        int endBlock = pullFrom / 1024;
                        if (i == endBlock) {
                            block.reqs[j] = block.reqs[idx];
                            block.reqs[idx] = null;
                        } else {
                            Block fromBlock = this.blocks[endBlock];
                            block.reqs[j] = fromBlock.reqs[idx];
                            fromBlock.reqs[idx] = null;
                        }
                        matched = true;
                        continue block4;
                    }
                }
                if (this.index == 0) {
                    empty = true;
                }
            }
        }
        RandomGrabArray oldArray = it.getParentGrabArray();
        if (oldArray == this) {
            it.setParentGrabArray(null);
        } else if (oldArray != null) {
            Logger.error(this, "Removing item " + it + " from " + this + " but RGA is " + it.getParentGrabArray(), (Throwable)new Exception("debug"));
        }
        if (!matched) {
            if (logMINOR) {
                Logger.minor(this, "Not found: " + it + " on " + this);
            }
            return;
        }
        if (empty && this.parent != null) {
            this.parent.maybeRemove(this, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            return this.index == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RandomGrabArrayItem item) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            if (this.blocks.length == 1) {
                Block block = this.blocks[0];
                for (int i = 0; i < this.index; ++i) {
                    if (block.reqs[i] != item) continue;
                    return true;
                }
            } else {
                int x = 0;
                for (int i = 0; i < this.blocks.length; ++i) {
                    Block block = this.blocks[i];
                    for (int j = 0; j < block.reqs.length && x < this.index; ++x, ++j) {
                        if (block.reqs[i] != item) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            return this.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RandomGrabArrayItem get(int idx) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            int blockNo = idx / 1024;
            RandomGrabArrayItem item = this.blocks[blockNo].reqs[idx % 1024];
            return item;
        }
    }

    public void moveElementsTo(RandomGrabArray existingGrabber, boolean canCommit) {
        WrapperManager.signalStarting((int)((int)TimeUnit.MINUTES.toMillis(5L)));
        for (Block block : this.blocks) {
            for (int j = 0; j < block.reqs.length; ++j) {
                RandomGrabArrayItem item = block.reqs[j];
                if (item == null) continue;
                item.setParentGrabArray(null);
                existingGrabber.add(item, null);
                block.reqs[j] = null;
            }
            System.out.println("Moved block in RGA " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParent(RemoveRandomParent newParent) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            this.parent = newParent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestSelectionTreeNode getParentGrabArray() {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            return this.parent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getWakeupTime(ClientContext context, long now) {
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            if (this.wakeupTime < now) {
                this.wakeupTime = 0L;
            }
            return this.wakeupTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reduceWakeupTime(long wakeupTime, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "reduceCooldownTime(" + (wakeupTime - System.currentTimeMillis()) + ") on " + this);
        }
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            if (this.wakeupTime > wakeupTime) {
                this.wakeupTime = wakeupTime;
                if (this.parent != null) {
                    this.parent.reduceWakeupTime(wakeupTime, context);
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWakeupTime(ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "clearCooldownTime() on " + this);
        }
        ClientRequestSelector clientRequestSelector = this.root;
        synchronized (clientRequestSelector) {
            this.wakeupTime = 0L;
            if (this.parent != null) {
                this.parent.clearWakeupTime(context);
            }
        }
    }

    static {
        Logger.registerClass(RandomGrabArray.class);
    }

    private static class Block {
        RandomGrabArrayItem[] reqs;

        private Block() {
        }
    }
}

