/*
 * Decompiled with CFR 0.152.
 */
package plugins.JSTUN.de.javawi.jstun.attribute;

import java.util.logging.Logger;
import plugins.JSTUN.de.javawi.jstun.attribute.ChangeRequest;
import plugins.JSTUN.de.javawi.jstun.attribute.ChangedAddress;
import plugins.JSTUN.de.javawi.jstun.attribute.Dummy;
import plugins.JSTUN.de.javawi.jstun.attribute.ErrorCode;
import plugins.JSTUN.de.javawi.jstun.attribute.MappedAddress;
import plugins.JSTUN.de.javawi.jstun.attribute.MessageAttributeInterface;
import plugins.JSTUN.de.javawi.jstun.attribute.MessageAttributeParsingException;
import plugins.JSTUN.de.javawi.jstun.attribute.MessageIntegrity;
import plugins.JSTUN.de.javawi.jstun.attribute.Password;
import plugins.JSTUN.de.javawi.jstun.attribute.ReflectedFrom;
import plugins.JSTUN.de.javawi.jstun.attribute.ResponseAddress;
import plugins.JSTUN.de.javawi.jstun.attribute.SourceAddress;
import plugins.JSTUN.de.javawi.jstun.attribute.UnknownAttribute;
import plugins.JSTUN.de.javawi.jstun.attribute.Username;
import plugins.JSTUN.de.javawi.jstun.util.Utility;
import plugins.JSTUN.de.javawi.jstun.util.UtilityException;

public abstract class MessageAttribute
implements MessageAttributeInterface {
    private static Logger logger = Logger.getLogger("de.javawi.stun.util.MessageAttribute");
    MessageAttributeInterface.MessageAttributeType type;
    int length;

    public MessageAttribute() {
    }

    public MessageAttribute(MessageAttributeInterface.MessageAttributeType type) {
        this.setType(type);
    }

    public void setType(MessageAttributeInterface.MessageAttributeType type) {
        this.type = type;
    }

    public MessageAttributeInterface.MessageAttributeType getType() {
        return this.type;
    }

    public static int typeToInteger(MessageAttributeInterface.MessageAttributeType type) {
        if (type == MessageAttributeInterface.MessageAttributeType.MappedAddress) {
            return 1;
        }
        if (type == MessageAttributeInterface.MessageAttributeType.ResponseAddress) {
            return 2;
        }
        if (type == MessageAttributeInterface.MessageAttributeType.ChangeRequest) {
            return 3;
        }
        if (type == MessageAttributeInterface.MessageAttributeType.SourceAddress) {
            return 4;
        }
        if (type == MessageAttributeInterface.MessageAttributeType.ChangedAddress) {
            return 5;
        }
        if (type == MessageAttributeInterface.MessageAttributeType.Username) {
            return 6;
        }
        if (type == MessageAttributeInterface.MessageAttributeType.Password) {
            return 7;
        }
        if (type == MessageAttributeInterface.MessageAttributeType.MessageIntegrity) {
            return 8;
        }
        if (type == MessageAttributeInterface.MessageAttributeType.ErrorCode) {
            return 9;
        }
        if (type == MessageAttributeInterface.MessageAttributeType.UnknownAttribute) {
            return 10;
        }
        if (type == MessageAttributeInterface.MessageAttributeType.ReflectedFrom) {
            return 11;
        }
        if (type == MessageAttributeInterface.MessageAttributeType.Dummy) {
            return 0;
        }
        return -1;
    }

    public static MessageAttributeInterface.MessageAttributeType intToType(long type) {
        if (type == 1L) {
            return MessageAttributeInterface.MessageAttributeType.MappedAddress;
        }
        if (type == 2L) {
            return MessageAttributeInterface.MessageAttributeType.ResponseAddress;
        }
        if (type == 3L) {
            return MessageAttributeInterface.MessageAttributeType.ChangeRequest;
        }
        if (type == 4L) {
            return MessageAttributeInterface.MessageAttributeType.SourceAddress;
        }
        if (type == 5L) {
            return MessageAttributeInterface.MessageAttributeType.ChangedAddress;
        }
        if (type == 6L) {
            return MessageAttributeInterface.MessageAttributeType.Username;
        }
        if (type == 7L) {
            return MessageAttributeInterface.MessageAttributeType.Password;
        }
        if (type == 8L) {
            return MessageAttributeInterface.MessageAttributeType.MessageIntegrity;
        }
        if (type == 9L) {
            return MessageAttributeInterface.MessageAttributeType.ErrorCode;
        }
        if (type == 10L) {
            return MessageAttributeInterface.MessageAttributeType.UnknownAttribute;
        }
        if (type == 11L) {
            return MessageAttributeInterface.MessageAttributeType.ReflectedFrom;
        }
        if (type == 0L) {
            return MessageAttributeInterface.MessageAttributeType.Dummy;
        }
        return MessageAttributeInterface.MessageAttributeType.Dummy;
    }

    public abstract byte[] getBytes() throws UtilityException;

    public int getLength() throws UtilityException {
        int length = this.getBytes().length;
        return length;
    }

    public static MessageAttribute parseCommonHeader(byte[] data) throws MessageAttributeParsingException {
        try {
            MessageAttribute ma;
            byte[] typeArray = new byte[2];
            System.arraycopy(data, 0, typeArray, 0, 2);
            int type = Utility.TwoBytesToInteger(typeArray);
            byte[] lengthArray = new byte[2];
            System.arraycopy(data, 2, lengthArray, 0, 2);
            int lengthValue = Utility.TwoBytesToInteger(lengthArray);
            byte[] valueArray = new byte[lengthValue];
            System.arraycopy(data, 4, valueArray, 0, lengthValue);
            switch (type) {
                case 1: {
                    ma = MappedAddress.parse(valueArray);
                    break;
                }
                case 2: {
                    ma = ResponseAddress.parse(valueArray);
                    break;
                }
                case 3: {
                    ma = ChangeRequest.parse(valueArray);
                    break;
                }
                case 4: {
                    ma = SourceAddress.parse(valueArray);
                    break;
                }
                case 5: {
                    ma = ChangedAddress.parse(valueArray);
                    break;
                }
                case 6: {
                    ma = Username.parse(valueArray);
                    break;
                }
                case 7: {
                    ma = Password.parse(valueArray);
                    break;
                }
                case 8: {
                    ma = MessageIntegrity.parse(valueArray);
                    break;
                }
                case 9: {
                    ma = ErrorCode.parse(valueArray);
                    break;
                }
                case 10: {
                    ma = UnknownAttribute.parse(valueArray);
                    break;
                }
                case 11: {
                    ma = ReflectedFrom.parse(valueArray);
                    break;
                }
                default: {
                    logger.config("MessageAttribute with type " + type + " unkown" + '.');
                    ma = Dummy.parse(valueArray);
                }
            }
            return ma;
        }
        catch (UtilityException ue) {
            throw new MessageAttributeParsingException("Parsing Error");
        }
    }
}

