/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.ext.Db4oIOException;
import com.db4o.internal.fileheader.FileHeader1;
import com.db4o.io.IoAdapter;

public class CachedIoAdapter
extends IoAdapter {
    private Page _head;
    private Page _tail;
    private long _position;
    private int _pageSize;
    private int _pageCount;
    private long _fileLength;
    private long _filePointer;
    private IoAdapter _io;
    private boolean _readOnly;
    private static int DEFAULT_PAGE_SIZE = 1024;
    private static int DEFAULT_PAGE_COUNT = 64;

    public CachedIoAdapter(IoAdapter ioAdapter) {
        this(ioAdapter, DEFAULT_PAGE_SIZE, DEFAULT_PAGE_COUNT);
    }

    public CachedIoAdapter(IoAdapter ioAdapter, int pageSize, int pageCount) {
        this._io = ioAdapter;
        this._pageSize = pageSize;
        this._pageCount = pageCount;
    }

    public CachedIoAdapter(String path, boolean lockFile, long initialLength, boolean readOnly, IoAdapter io, int pageSize, int pageCount) throws Db4oIOException {
        this._readOnly = readOnly;
        this._pageSize = pageSize;
        this._pageCount = pageCount;
        this.initCache();
        this.initIOAdaptor(path, lockFile, initialLength, readOnly, io);
        this._position = initialLength;
        this._filePointer = initialLength;
        this._fileLength = this._io.getLength();
    }

    @Override
    public IoAdapter open(String path, boolean lockFile, long initialLength, boolean readOnly) throws Db4oIOException {
        return new CachedIoAdapter(path, lockFile, initialLength, readOnly, this._io, this._pageSize, this._pageCount);
    }

    @Override
    public void delete(String path) {
        this._io.delete(path);
    }

    @Override
    public boolean exists(String path) {
        return this._io.exists(path);
    }

    private void initIOAdaptor(String path, boolean lockFile, long initialLength, boolean readOnly, IoAdapter io) throws Db4oIOException {
        this._io = io.open(path, lockFile, initialLength, readOnly);
    }

    private void initCache() {
        this._head = new Page(this._pageSize);
        this._head._prev = null;
        Page page = this._head;
        Page next = this._head;
        for (int i = 0; i < this._pageCount - 1; ++i) {
            page._next = next = new Page(this._pageSize);
            next._prev = page;
            page = next;
        }
        this._tail = next;
    }

    @Override
    public int read(byte[] buffer, int length) throws Db4oIOException {
        long startAddress = this._position;
        int bytesToRead = length;
        int totalRead = 0;
        while (bytesToRead > 0) {
            Page page = this.getPage(startAddress, true);
            int readBytes = page.read(buffer, totalRead, startAddress, bytesToRead);
            this.movePageToHead(page);
            if (readBytes <= 0) break;
            bytesToRead -= readBytes;
            startAddress += (long)readBytes;
            totalRead += readBytes;
        }
        this._position = startAddress;
        return totalRead == 0 ? -1 : totalRead;
    }

    @Override
    public void write(byte[] buffer, int length) throws Db4oIOException {
        long endAddress;
        this.validateReadOnly();
        long startAddress = this._position;
        Page page = null;
        int bytesToWrite = length;
        int bufferOffset = 0;
        while (bytesToWrite > 0) {
            boolean loadFromDisk = bytesToWrite < this._pageSize || startAddress % (long)this._pageSize != 0L;
            page = this.getPage(startAddress, loadFromDisk);
            page.ensureEndAddress(this.getLength());
            int writtenBytes = page.write(buffer, bufferOffset, startAddress, bytesToWrite);
            if (this.containsHeaderBlock(page)) {
                this.flushPage(page);
            }
            this.movePageToHead(page);
            bytesToWrite -= writtenBytes;
            startAddress += (long)writtenBytes;
            bufferOffset += writtenBytes;
        }
        this._position = endAddress = startAddress;
        this._fileLength = Math.max(endAddress, this._fileLength);
    }

    private void validateReadOnly() {
        if (this._readOnly) {
            throw new Db4oIOException();
        }
    }

    @Override
    public void sync() throws Db4oIOException {
        this.validateReadOnly();
        this.flushAllPages();
        this._io.sync();
    }

    @Override
    public long getLength() throws Db4oIOException {
        return this._fileLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Db4oIOException {
        try {
            this.flushAllPages();
        }
        finally {
            this._io.close();
        }
    }

    @Override
    public IoAdapter delegatedIoAdapter() {
        return this._io.delegatedIoAdapter();
    }

    private Page getPage(long startAddress, boolean loadFromDisk) throws Db4oIOException {
        Page page = this.getPageFromCache(startAddress);
        if (page != null) {
            if (this.containsHeaderBlock(page)) {
                this.getPageFromDisk(page, startAddress);
            }
            page.ensureEndAddress(this._fileLength);
            return page;
        }
        page = this.getFreePageFromCache();
        if (loadFromDisk) {
            this.getPageFromDisk(page, startAddress);
        } else {
            this.resetPageAddress(page, startAddress);
        }
        return page;
    }

    private boolean containsHeaderBlock(Page page) {
        return page.startAddress() <= (long)FileHeader1.HEADER_LENGTH;
    }

    private void resetPageAddress(Page page, long startAddress) {
        page.startAddress(startAddress);
        page.endAddress(startAddress + (long)this._pageSize);
    }

    private Page getFreePageFromCache() throws Db4oIOException {
        if (!this._tail.isFree()) {
            this.flushPage(this._tail);
        }
        return this._tail;
    }

    private Page getPageFromCache(long pos) throws Db4oIOException {
        Page page = this._head;
        while (page != null) {
            if (page.contains(pos)) {
                return page;
            }
            page = page._next;
        }
        return null;
    }

    private void flushAllPages() throws Db4oIOException {
        Page node = this._head;
        while (node != null) {
            this.flushPage(node);
            node = node._next;
        }
    }

    private void flushPage(Page page) throws Db4oIOException {
        if (!page._dirty) {
            return;
        }
        this.ioSeek(page.startAddress());
        this.writePageToDisk(page);
    }

    private void getPageFromDisk(Page page, long pos) throws Db4oIOException {
        long startAddress = pos - pos % (long)this._pageSize;
        page.startAddress(startAddress);
        this.ioSeek(page._startAddress);
        int count = this.ioRead(page);
        if (count > 0) {
            page.endAddress(startAddress + (long)count);
        } else {
            page.endAddress(startAddress);
        }
    }

    private int ioRead(Page page) throws Db4oIOException {
        int count = this._io.read(page._buffer);
        if (count > 0) {
            this._filePointer = page._startAddress + (long)count;
        }
        return count;
    }

    private void movePageToHead(Page page) {
        if (page == this._head) {
            return;
        }
        if (page == this._tail) {
            Page tempTail = this._tail._prev;
            tempTail._next = null;
            this._tail._next = this._head;
            this._tail._prev = null;
            this._head._prev = page;
            this._head = this._tail;
            this._tail = tempTail;
        } else {
            page._prev._next = page._next;
            page._next._prev = page._prev;
            page._next = this._head;
            this._head._prev = page;
            page._prev = null;
            this._head = page;
        }
    }

    private void writePageToDisk(Page page) throws Db4oIOException {
        try {
            this._io.write(page._buffer, page.size());
            this._filePointer = page.endAddress();
            page._dirty = false;
        }
        catch (Db4oIOException e) {
            this._readOnly = true;
            throw e;
        }
    }

    @Override
    public void seek(long pos) throws Db4oIOException {
        this._position = pos;
    }

    private void ioSeek(long pos) throws Db4oIOException {
        if (this._filePointer != pos) {
            this._io.seek(pos);
            this._filePointer = pos;
        }
    }

    private static class Page {
        byte[] _buffer;
        long _startAddress = -1L;
        long _endAddress;
        final int _bufferSize;
        boolean _dirty;
        Page _prev;
        Page _next;
        private byte[] zeroBytes;

        public Page(int size) {
            this._bufferSize = size;
            this._buffer = new byte[this._bufferSize];
        }

        void ensureEndAddress(long fileLength) {
            long bufferEndAddress = this._startAddress + (long)this._bufferSize;
            if (this._endAddress < bufferEndAddress && fileLength > this._endAddress) {
                long newEndAddress = Math.min(fileLength, bufferEndAddress);
                if (this.zeroBytes == null) {
                    this.zeroBytes = new byte[this._bufferSize];
                }
                System.arraycopy(this.zeroBytes, 0, this._buffer, (int)(this._endAddress - this._startAddress), (int)(newEndAddress - this._endAddress));
                this._endAddress = newEndAddress;
            }
        }

        long endAddress() {
            return this._endAddress;
        }

        void startAddress(long address) {
            this._startAddress = address;
        }

        long startAddress() {
            return this._startAddress;
        }

        void endAddress(long address) {
            this._endAddress = address;
        }

        int size() {
            return (int)(this._endAddress - this._startAddress);
        }

        int read(byte[] out, int outOffset, long startAddress, int length) {
            int bufferOffset = (int)(startAddress - this._startAddress);
            int pageAvailbeDataSize = (int)(this._endAddress - startAddress);
            int readBytes = Math.min(pageAvailbeDataSize, length);
            if (readBytes <= 0) {
                return -1;
            }
            System.arraycopy(this._buffer, bufferOffset, out, outOffset, readBytes);
            return readBytes;
        }

        int write(byte[] data, int dataOffset, long startAddress, int length) {
            int bufferOffset = (int)(startAddress - this._startAddress);
            int pageAvailabeBufferSize = this._bufferSize - bufferOffset;
            int writtenBytes = Math.min(pageAvailabeBufferSize, length);
            System.arraycopy(data, dataOffset, this._buffer, bufferOffset, writtenBytes);
            long endAddress = startAddress + (long)writtenBytes;
            if (endAddress > this._endAddress) {
                this._endAddress = endAddress;
            }
            this._dirty = true;
            return writtenBytes;
        }

        boolean contains(long address) {
            return this._startAddress != -1L && address >= this._startAddress && address < this._startAddress + (long)this._bufferSize;
        }

        boolean isFree() {
            return this._startAddress == -1L;
        }
    }
}

