/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.index.xml;

import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.HighLevelSimpleClient;
import freenet.keys.FreenetURI;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.FileBucket;
import java.io.File;
import java.net.MalformedURLException;

public class Util {
    static volatile boolean logMINOR;
    static volatile boolean logDEBUG;

    public static Bucket fetchBucket(String uri, HighLevelSimpleClient hlsc) throws FetchException, MalformedURLException {
        FetchResult res;
        File file = new File(uri);
        if (file.exists() && file.canRead()) {
            return new FileBucket(file, true, false, false, false, false);
        }
        if (hlsc == null) {
            throw new NullPointerException("No client or file " + uri + " found");
        }
        if (logMINOR) {
            Logger.minor(Util.class, (String)("Fetching " + uri));
        }
        FreenetURI u = new FreenetURI(uri);
        while (true) {
            try {
                res = hlsc.fetch(u);
            }
            catch (FetchException e) {
                if (e.newURI != null) {
                    u = e.newURI;
                    continue;
                }
                throw e;
            }
            break;
        }
        return res.asBucket();
    }

    public static boolean isValid(String uri) {
        File file = new File(uri);
        if (!file.exists() || !file.canRead()) {
            try {
                FreenetURI u = new FreenetURI(uri);
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return true;
    }

    static {
        Logger.registerClass(Util.class);
    }
}

