/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.io.serial;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.UUID;
import plugins.Library.io.ObjectStreamReader;
import plugins.Library.io.ObjectStreamWriter;
import plugins.Library.io.serial.Archiver;
import plugins.Library.io.serial.LiveArchiver;
import plugins.Library.io.serial.Serialiser;
import plugins.Library.util.exec.SimpleProgress;
import plugins.Library.util.exec.TaskAbortException;

public class FileArchiver<T>
implements Archiver<T>,
LiveArchiver<T, SimpleProgress> {
    private static boolean testmode = false;
    protected final boolean random;
    protected final String prefix;
    protected final String suffix;
    protected final String extension;
    protected final File parentDir;
    protected final ObjectStreamReader reader;
    protected final ObjectStreamWriter writer;

    public static void setTestMode() {
        System.out.println("FileArchiver will now randomly pause 5-10s for each task, to simulate network speeds");
        testmode = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void randomWait(SimpleProgress p) {
        int t = (int)(Math.random() * 5.0 + 5.0);
        p.addPartKnown(t, true);
        for (int i = 0; i < t; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            finally {
                p.addPartDone();
            }
        }
    }

    public <S extends ObjectStreamWriter & ObjectStreamReader> FileArchiver(S rw, String pre, String suf, String ext, File parent) {
        this((ObjectStreamReader)rw, rw, pre, suf, ext, parent);
    }

    public <S extends ObjectStreamWriter & ObjectStreamReader> FileArchiver(S rw, boolean rnd, String ext, String prefix, String suffix, File parent) {
        this(rw, rw, rnd, ext, prefix, suffix, parent);
    }

    public FileArchiver(ObjectStreamReader r, ObjectStreamWriter w, String pre, String suf, String ext, File parent) {
        this.reader = r;
        this.writer = w;
        this.prefix = pre == null ? "" : pre;
        this.suffix = suf == null ? "" : suf;
        this.extension = ext == null ? "" : ext;
        this.random = false;
        this.parentDir = parent;
    }

    public FileArchiver(ObjectStreamReader r, ObjectStreamWriter w, boolean rnd, String ext, String prefix, String suffix, File parent) {
        this.reader = r;
        this.writer = w;
        this.suffix = suffix;
        this.prefix = prefix;
        this.extension = ext == null ? "" : ext;
        this.random = rnd;
        this.parentDir = parent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected File getFile(Object meta) {
        if (meta instanceof File) {
            return (File)meta;
        }
        String main = "";
        String part = "";
        if (meta instanceof String) {
            main = (String)meta;
            return new File(this.parentDir, this.prefix + main + this.suffix + part + this.extension);
        } else if (meta instanceof Object[]) {
            Object[] arr = (Object[])meta;
            if (arr.length <= 0 || !(arr[0] instanceof String)) throw new IllegalArgumentException("FileArchiver does not support such metadata: " + Arrays.deepToString(arr));
            main = (String)arr[0];
            if (arr.length <= 1) return new File(this.parentDir, this.prefix + main + this.suffix + part + this.extension);
            StringBuilder str = new StringBuilder(arr[1].toString());
            for (int i = 2; i < arr.length; ++i) {
                str.append('.').append(arr[i].toString());
            }
            part = str.toString();
            return new File(this.parentDir, this.prefix + main + this.suffix + part + this.extension);
        } else {
            if (meta == null) return new File(this.parentDir, this.prefix + main + this.suffix + part + this.extension);
            throw new IllegalArgumentException("FileArchiver does not support such metadata: " + meta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pull(Serialiser.PullTask<T> t) throws TaskAbortException {
        File file = this.getFile(t.meta);
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                FileLock lock = is.getChannel().lock(0L, Long.MAX_VALUE, true);
                try {
                    t.data = this.reader.readObject(is);
                }
                finally {
                    lock.release();
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException f) {}
            }
        }
        catch (IOException e) {
            throw new TaskAbortException("FileArchiver could not complete pull on " + file, e, true);
        }
        catch (RuntimeException e) {
            throw new TaskAbortException("FileArchiver could not complete pull on " + file, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(Serialiser.PushTask<T> t) throws TaskAbortException {
        if (this.random) {
            t.meta = UUID.randomUUID().toString();
        }
        File file = this.getFile(t.meta);
        try {
            FileOutputStream os = new FileOutputStream(file);
            try {
                FileLock lock = os.getChannel().lock();
                try {
                    this.writer.writeObject(t.data, os);
                }
                finally {
                    lock.release();
                }
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException f) {}
            }
        }
        catch (IOException e) {
            throw new TaskAbortException("FileArchiver could not complete push on " + file, e, true);
        }
        catch (RuntimeException e) {
            throw new TaskAbortException("FileArchiver could not complete push on " + file, e);
        }
    }

    @Override
    public void pullLive(Serialiser.PullTask<T> t, SimpleProgress p) throws TaskAbortException {
        try {
            this.pull(t);
            if (testmode) {
                FileArchiver.randomWait(p);
            } else {
                p.addPartKnown(0, true);
            }
        }
        catch (TaskAbortException e) {
            p.abort(e);
        }
    }

    @Override
    public void pushLive(Serialiser.PushTask<T> t, SimpleProgress p) throws TaskAbortException {
        try {
            this.push(t);
            if (testmode) {
                FileArchiver.randomWait(p);
            } else {
                p.addPartKnown(0, true);
            }
        }
        catch (TaskAbortException e) {
            p.abort(e);
        }
    }
}

