/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.search;

import freenet.support.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import plugins.Library.index.TermEntry;
import plugins.Library.index.TermIndexEntry;
import plugins.Library.index.TermPageEntry;
import plugins.Library.index.TermTermEntry;
import plugins.Library.util.exec.Execution;
import plugins.Library.util.exec.TaskAbortException;

public class ResultSet
implements Set<TermEntry>,
Runnable {
    private ResultOperation resultOperation;
    private boolean done = false;
    private Set<TermEntry>[] subresults;
    private RuntimeException exception;
    private HashMap<TermEntry, TermEntry> internal;
    private final String subject;
    private final boolean ignoreTAEs;

    ResultSet(String subject, ResultOperation resultOperation, List<Execution<Set<TermEntry>>> subRequests, boolean ignoreTAEs) throws TaskAbortException {
        if (resultOperation == ResultOperation.SINGLE && subRequests.size() != 1) {
            throw new IllegalArgumentException(subRequests.size() + " requests supplied with SINGLE operation");
        }
        if (resultOperation == ResultOperation.REMOVE && subRequests.size() != 2) {
            throw new IllegalArgumentException("Negative operations can only have 2 parameters");
        }
        if ((resultOperation == ResultOperation.PHRASE || resultOperation == ResultOperation.INTERSECTION || resultOperation == ResultOperation.UNION || resultOperation == ResultOperation.DIFFERENTINDEXES) && subRequests.size() < 2) {
            throw new IllegalArgumentException(resultOperation.toString() + " operations need more than one term");
        }
        this.subject = subject;
        this.internal = new HashMap();
        this.resultOperation = resultOperation;
        this.ignoreTAEs = ignoreTAEs;
        this.subresults = this.getResultSets(subRequests, ignoreTAEs);
    }

    @Override
    public synchronized void run() {
        if (this.done) {
            throw new IllegalStateException("This ResultSet has already run and is finalised.");
        }
        try {
            switch (this.resultOperation) {
                case SINGLE: {
                    this.addAllToEmptyInternal(this.subresults[0]);
                    break;
                }
                case DIFFERENTINDEXES: 
                case UNION: {
                    this.unite(this.subresults);
                    break;
                }
                case INTERSECTION: {
                    this.intersect(this.subresults);
                    break;
                }
                case REMOVE: {
                    this.exclude(this.subresults[0], this.subresults[1]);
                    break;
                }
                case PHRASE: {
                    this.phrase(this.subresults);
                }
            }
        }
        catch (RuntimeException e) {
            this.exception = e;
            throw e;
        }
        this.subresults = null;
        this.done = true;
    }

    private ResultSet(String subject, Collection<? extends TermEntry> copy, boolean ignoreTAEs) {
        this.subject = subject;
        this.internal = new HashMap();
        this.ignoreTAEs = ignoreTAEs;
        this.addAllToEmptyInternal(copy);
    }

    @Override
    public int size() {
        return this.internal.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internal.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.internal.containsKey(o);
    }

    @Override
    public Iterator<TermEntry> iterator() {
        if (this.exception != null) {
            throw new RuntimeException("RuntimeException thrown in ResultSet thread", this.exception);
        }
        return new ResultIterator(this.internal.keySet().iterator());
    }

    @Override
    public Object[] toArray() {
        return this.internal.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.internal.keySet().toArray(a);
    }

    @Override
    public boolean add(TermEntry e) {
        throw new UnsupportedOperationException("Set is unmodifiable.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Set is unmodifiable.");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.internal.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends TermEntry> c) {
        throw new UnsupportedOperationException("Set is unmodifiable.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Set is unmodifiable.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Set is unmodifiable.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Set is unmodifiable.");
    }

    private void addInternal(TermEntry entry) {
        this.internal.put(entry, entry);
    }

    private void addAllToEmptyInternal(Collection<? extends TermEntry> result) {
        for (TermEntry termEntry : result) {
            TermEntry entry = this.convertEntry(termEntry);
            this.addInternal(entry);
        }
    }

    private void exclude(Collection<? extends TermEntry> add, Collection<? extends TermEntry> subtract) {
        for (TermEntry termEntry : add) {
            if (this.getIgnoreSubject(termEntry, subtract) != null) continue;
            this.addInternal(termEntry);
        }
    }

    private void unite(Collection<? extends TermEntry> ... collections) {
        for (Collection<? extends TermEntry> c : collections) {
            if (c == null) {
                Logger.error((Object)this, (String)"the result was null");
                continue;
            }
            for (TermEntry termEntry : c) {
                TermEntry entry = this.convertEntry(termEntry);
                if (this.contains(entry)) {
                    this.addInternal(this.mergeEntries(this.internal.get(entry), entry));
                    continue;
                }
                this.addInternal(entry);
            }
        }
    }

    private void intersect(Collection<? extends TermEntry> ... collections) {
        Collection<? extends TermEntry> firstCollection = collections[0];
        for (TermEntry termEntry : firstCollection) {
            Collection<? extends TermEntry> collection;
            TermEntry termEntry2;
            int i;
            float combinedrelevance = termEntry.rel;
            for (i = 1; i < collections.length && (termEntry2 = this.getIgnoreSubject(termEntry, collection = collections[i])) != null; ++i) {
                combinedrelevance += termEntry2.rel;
            }
            if (i != collections.length) continue;
            TermEntry newEntry = this.convertEntry(termEntry, combinedrelevance / (float)collections.length);
            this.addInternal(newEntry);
        }
    }

    private void phrase(Collection<? extends TermEntry> ... collections) {
        Collection<? extends TermEntry> firstCollection = collections[0];
        for (TermEntry termEntry : firstCollection) {
            TermPageEntry termPageEntry;
            if (!(termEntry instanceof TermPageEntry) || !(termPageEntry = (TermPageEntry)termEntry).hasPositions()) continue;
            HashMap<Integer, String> positions = new HashMap<Integer, String>(termPageEntry.positionsMap());
            for (int i = 1; positions != null && i < collections.length && positions.size() > 0; ++i) {
                Collection<? extends TermEntry> collection = collections[i];
                if (collection == null) continue;
                TermPageEntry termPageEntry1 = (TermPageEntry)this.getIgnoreSubject(termPageEntry, collection);
                if (termPageEntry1 == null || !termPageEntry1.hasPositions()) {
                    positions = null;
                    continue;
                }
                Iterator it = positions.keySet().iterator();
                while (it.hasNext()) {
                    int posi = (Integer)it.next();
                    if (!termPageEntry1.hasPosition(posi + i)) {
                        it.remove();
                        continue;
                    }
                    Logger.minor((Object)this, (String)(termPageEntry.page + "[" + positions.keySet() + "] is followed by " + termPageEntry1.page + "[" + termPageEntry1.positions() + "] +" + i));
                }
            }
            if (positions == null || positions.size() <= 0) continue;
            this.addInternal(new TermPageEntry(this.subject, termPageEntry.rel, termPageEntry.page, termPageEntry.title, positions));
        }
    }

    private TermEntry convertEntry(TermEntry termEntry) {
        return this.convertEntry(termEntry, termEntry.rel);
    }

    private TermEntry convertEntry(TermEntry termEntry, float rel) {
        TermEntry entry;
        if (termEntry instanceof TermTermEntry) {
            entry = new TermTermEntry(this.subject, rel, ((TermTermEntry)termEntry).term);
        } else if (termEntry instanceof TermPageEntry) {
            entry = new TermPageEntry(this.subject, rel, ((TermPageEntry)termEntry).page, ((TermPageEntry)termEntry).title, ((TermPageEntry)termEntry).positionsMap());
        } else if (termEntry instanceof TermIndexEntry) {
            entry = new TermIndexEntry(this.subject, rel, ((TermIndexEntry)termEntry).index);
        } else {
            throw new UnsupportedOperationException("The TermEntry type " + termEntry.getClass().getName() + " is not currently supported in ResultSet");
        }
        return entry;
    }

    private TermEntry mergeEntries(TermEntry ... entries) {
        for (int i = 1; i < entries.length; ++i) {
            if (entries[0].equalsTarget(entries[i])) continue;
            throw new IllegalArgumentException("entries were not equal : " + entries[0].toString() + " & " + entries[i].toString());
        }
        TermEntry combination = entries[0];
        if (combination instanceof TermIndexEntry) {
            combination = new TermIndexEntry(this.subject, entries[0].rel, ((TermIndexEntry)combination).index);
        } else if (combination instanceof TermPageEntry) {
            combination = new TermPageEntry(this.subject, entries[0].rel, ((TermPageEntry)combination).page, ((TermPageEntry)combination).title, ((TermPageEntry)combination).positionsMap());
        } else if (combination instanceof TermTermEntry) {
            combination = new TermTermEntry(this.subject, entries[0].rel, ((TermTermEntry)combination).term);
        } else {
            throw new IllegalArgumentException("Unknown type : " + combination.getClass().toString());
        }
        for (int i = 1; i < entries.length; ++i) {
            TermEntry termEntry = entries[i];
            combination = this.combine(combination, termEntry);
        }
        return combination;
    }

    private TermEntry combine(TermEntry entry1, TermEntry entry2) {
        if (!entry1.equalsTarget(entry2)) {
            throw new IllegalArgumentException("Combine can only be performed on equal TermEntrys");
        }
        float newRel = entry1.rel / (float)(entry2.rel == 0.0f ? 1 : 2) + entry2.rel / (float)(entry1.rel == 0.0f ? 1 : 2);
        if (entry1 instanceof TermPageEntry) {
            TermPageEntry pageentry1 = (TermPageEntry)entry1;
            TermPageEntry pageentry2 = (TermPageEntry)entry2;
            HashMap<Integer, String> newPos = null;
            if (!pageentry1.hasPositions() && pageentry2.hasPositions()) {
                newPos = new HashMap<Integer, String>(pageentry2.positionsMap());
            } else if (pageentry1.hasPositions()) {
                newPos = new HashMap<Integer, String>(pageentry1.positionsMap());
                if (pageentry2.hasPositions()) {
                    newPos.putAll(pageentry2.positionsMap());
                }
            }
            return new TermPageEntry(pageentry1.subj, newRel, pageentry1.page, pageentry1.title != null ? pageentry1.title : pageentry2.title, newPos);
        }
        if (entry1 instanceof TermIndexEntry) {
            TermIndexEntry castEntry = (TermIndexEntry)entry1;
            return new TermIndexEntry(castEntry.subj, newRel, castEntry.index);
        }
        if (entry1 instanceof TermTermEntry) {
            TermTermEntry castEntry = (TermTermEntry)entry1;
            return new TermTermEntry(castEntry.subj, newRel, castEntry.term);
        }
        throw new UnsupportedOperationException("This type of TermEntry is not yet supported in the combine code : " + entry1.getClass().getName());
    }

    private Set<TermEntry>[] getResultSets(List<Execution<Set<TermEntry>>> subRequests, boolean ignoreTAEs) throws TaskAbortException {
        Set[] sets = new Set[subRequests.size()];
        int x = 0;
        for (int i = 0; i < subRequests.size(); ++i) {
            if (subRequests.get(i) == null) {
                if (this.resultOperation == ResultOperation.PHRASE) {
                    sets[x++] = null;
                    continue;
                }
                throw new NullPointerException("Nulls not allowed in subRequests for operations other than phrase.");
            }
            try {
                sets[x++] = subRequests.get(i).getResult();
                continue;
            }
            catch (TaskAbortException e) {
                if (ignoreTAEs) continue;
                throw e;
            }
        }
        if (x != subRequests.size()) {
            Set[] newSets = new Set[x];
            System.arraycopy(sets, 0, newSets, 0, newSets.length);
            sets = newSets;
        }
        return sets;
    }

    private TermEntry getIgnoreSubject(TermEntry entry, Collection<? extends TermEntry> collection) {
        TermEntry result = null;
        for (TermEntry termEntry : collection) {
            if (!entry.equalsTarget(termEntry)) continue;
            result = termEntry;
            break;
        }
        return result;
    }

    public String toString() {
        return this.internal.keySet().toString();
    }

    public boolean isDone() {
        if (this.exception != null) {
            throw new RuntimeException("RuntimeException thrown in ResultSet thread", this.exception);
        }
        return this.done;
    }

    class ResultIterator
    implements Iterator<TermEntry> {
        Iterator<TermEntry> internal;

        private ResultIterator(Iterator<TermEntry> iterator) {
            this.internal = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.internal.hasNext();
        }

        @Override
        public TermEntry next() {
            return this.internal.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removal not allowed.");
        }
    }

    public static enum ResultOperation {
        INTERSECTION,
        UNION,
        REMOVE,
        PHRASE,
        SINGLE,
        DIFFERENTINDEXES;

    }
}

