/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.ui;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.node.NodeClientCore;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.api.HTTPRequest;
import java.io.IOException;
import java.net.URI;
import plugins.Library.Library;
import plugins.Library.ui.L10nString;
import plugins.Library.ui.MainPage;

public class MainPageToadlet
extends Toadlet {
    private NodeClientCore core;
    private final Library library;
    private final PluginRespirator pr;

    public MainPageToadlet(HighLevelSimpleClient client, Library library, NodeClientCore core, PluginRespirator pr) {
        super(client);
        this.core = core;
        this.library = library;
        this.pr = pr;
    }

    public boolean allowPOSTWithoutPassword() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMethodGET(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Library.class.getClassLoader());
        try {
            String title = L10nString.getString("title") + " (" + Library.plugName + ")";
            MainPage page = MainPage.processGetRequest(request);
            if (page == null) {
                page = new MainPage(this.library, this.pr);
            } else {
                String query = page.getQuery();
                if (query != null && query.length() > 0) {
                    title = query + " - " + L10nString.getString("title") + " (" + Library.plugName + ")";
                }
            }
            PageNode p = ctx.getPageMaker().getPageNode(title, ctx);
            p.headNode.addChild("link", new String[]{"rel", "href", "type"}, new String[]{"stylesheet", this.path() + "static/style.css", "text/css"});
            HTMLNode pageNode = p.outer;
            HTMLNode contentNode = p.content;
            MultiValueTable headers = new MultiValueTable();
            page.writeContent(contentNode, (MultiValueTable<String, String>)headers);
            this.writeHTMLReply(ctx, 200, "OK", headers, pageNode.generate());
        }
        catch (RuntimeException e) {
            Logger.error((Object)((Object)this), (String)"Runtime Exception writing main page", (Throwable)e);
            PageNode p = ctx.getPageMaker().getPageNode(Library.plugName, ctx);
            p.headNode.addChild("link", new String[]{"rel", "href", "type"}, new String[]{"stylesheet", this.path() + "static/style.css", "text/css"});
            HTMLNode pageNode = p.outer;
            HTMLNode contentNode = p.content;
            MainPage errorpage = new MainPage(e, this.library, this.pr);
            MultiValueTable headers = new MultiValueTable();
            errorpage.writeContent(contentNode, (MultiValueTable<String, String>)headers);
            this.writeHTMLReply(ctx, 200, "OK", headers, pageNode.generate());
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(Library.class.getClassLoader());
        boolean hasFormPassword = ctx.hasFormPassword(request);
        try {
            PageNode p = ctx.getPageMaker().getPageNode(Library.plugName, ctx);
            p.headNode.addChild("link", new String[]{"rel", "href", "type"}, new String[]{"stylesheet", this.path() + "static/style.css", "text/css"});
            HTMLNode pageNode = p.outer;
            HTMLNode contentNode = p.content;
            MainPage page = MainPage.processPostRequest(request, contentNode, hasFormPassword, ctx.isAllowedFullAccess(), this.library, this.pr);
            if (page == null) {
                page = new MainPage(this.library, this.pr);
            }
            MultiValueTable headers = new MultiValueTable();
            page.writeContent(contentNode, (MultiValueTable<String, String>)headers);
            this.writeHTMLReply(ctx, 200, "OK", headers, pageNode.generate());
        }
        catch (RuntimeException e) {
            Logger.error((Object)((Object)this), (String)"Runtime Exception writing main page", (Throwable)e);
            PageNode p = ctx.getPageMaker().getPageNode(Library.plugName, ctx);
            p.headNode.addChild("link", new String[]{"rel", "href", "type"}, new String[]{"stylesheet", this.path() + "static/style.css", "text/css"});
            HTMLNode pageNode = p.outer;
            HTMLNode contentNode = p.content;
            MainPage errorpage = new MainPage(e, this.library, this.pr);
            MultiValueTable headers = new MultiValueTable();
            errorpage.writeContent(contentNode, (MultiValueTable<String, String>)headers);
            this.writeHTMLReply(ctx, 200, "OK", headers, pageNode.generate());
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    public String path() {
        return MainPage.path();
    }

    public String name() {
        return "WelcomeToadlet.searchFreenet";
    }

    public String menu() {
        return "FProxyToadlet.categoryBrowsing";
    }
}

