/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Integers {
    private Integers() {
    }

    public static Iterable<Integer> allocateEvenly(final int total, final int num) {
        if (total < 0) {
            throw new IllegalArgumentException("Total must be non-negative.");
        }
        if (num <= 0) {
            throw new IllegalArgumentException("Count must be positive.");
        }
        return new Iterable<Integer>(){
            final int k;
            final int r;
            final double step;
            {
                this.k = total / num;
                this.r = total % num;
                this.step = (double)num / (double)this.r;
            }

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    double d;
                    int i;
                    {
                        this.d = step / 2.0;
                        this.i = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i < num;
                    }

                    @Override
                    public Integer next() {
                        if (this.i >= num) {
                            throw new NoSuchElementException();
                        }
                        if ((int)this.d == this.i++) {
                            this.d += step;
                            return k + 1;
                        }
                        return k;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public String toString() {
                char[] xs = new char[num];
                int j = 0;
                for (Integer ii : this) {
                    xs[j++] = ii == this.k ? 32 : 43;
                }
                return total + "/" + num + ": " + this.k + "+[" + new String(xs) + "]";
            }
        };
    }
}

