/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util;

import java.util.Map;

public final class Maps {
    private Maps() {
    }

    public static <K, V> Map.Entry<K, V> $(K k, V v) {
        return new BaseEntry<K, V>(k, v);
    }

    public static <K, V> Map.Entry<K, V> $$(K k, V v) {
        return new ImmutableEntry<K, V>(k, v);
    }

    public static <K, V> Map.Entry<K, V> $K(K k, V v) {
        return new KeyEntry<K, V>(k, v);
    }

    public static <K, V> Map<K, V> of(Class<? extends Map> mapcl, Map.Entry<K, V> ... items) {
        try {
            Map map = mapcl.newInstance();
            for (Map.Entry<K, V> en : items) {
                map.put(en.getKey(), en.getValue());
            }
            return map;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate map class", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access map class", e);
        }
    }

    public static class KeyEntry<K, V>
    extends BaseEntry<K, V> {
        public KeyEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof KeyEntry)) {
                return false;
            }
            KeyEntry en = (KeyEntry)o;
            return this.key == null && en.key == null || this.key.equals(en.key);
        }

        @Override
        public int hashCode() {
            return this.key == null ? 0 : 1 + this.key.hashCode();
        }
    }

    public static class ImmutableEntry<K, V>
    extends BaseEntry<K, V> {
        public ImmutableEntry(K k, V v) {
            super(k, v);
        }

        @Override
        public V setValue(V n) {
            throw new UnsupportedOperationException("ImmutableEntry: cannot modify value after creation");
        }
    }

    public static class BaseEntry<K, V>
    implements Map.Entry<K, V> {
        public final K key;
        protected V val;

        public BaseEntry(K k, V v) {
            this.key = k;
            this.val = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.val;
        }

        @Override
        public V setValue(V n) {
            V o = this.val;
            this.val = n;
            return o;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry en = (Map.Entry)o;
            return (this.key == null ? en.getKey() == null : this.key.equals(en.getKey())) && (this.val == null ? en.getValue() == null : this.val.equals(en.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.val == null ? 0 : this.val.hashCode());
        }
    }
}

