/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;

public class SortedArraySet<E>
extends AbstractSet<E>
implements Set<E>,
SortedSet<E> {
    protected final E[] bkarr;
    protected final Comparator<? super E> comparator;
    final int li;
    final int ri;

    public SortedArraySet(E[] arr) {
        this(arr, null, false);
    }

    public SortedArraySet(E[] arr, Comparator<? super E> cmp, boolean sorted) {
        this(arr, 0, arr.length, cmp);
        if (!sorted) {
            Arrays.sort(this.bkarr, SortedArraySet.noDuplicateComparator(cmp));
        } else {
            Comparator<E> dcmp = SortedArraySet.noDuplicateComparator(cmp);
            int i = 0;
            int j = 1;
            while (j < arr.length) {
                if (dcmp.compare(arr[i], arr[j]) > 0) {
                    throw new IllegalArgumentException("Array is not sorted");
                }
                i = j++;
            }
        }
    }

    protected SortedArraySet(E[] arr, int l, int r, Comparator<? super E> cmp) {
        assert (0 <= l && l <= r && r <= arr.length);
        this.bkarr = arr;
        this.li = l;
        this.ri = r;
        this.comparator = cmp;
    }

    public static <E> Comparator<? super E> noDuplicateComparator(final Comparator<? super E> cmp) {
        if (cmp == null) {
            return new Comparator<E>(){

                @Override
                public int compare(E e1, E e2) {
                    int d = ((Comparable)e1).compareTo(e2);
                    if (d == 0) {
                        throw new IllegalArgumentException("A set cannot have two duplicate elements");
                    }
                    return d;
                }
            };
        }
        return new Comparator<E>(){

            @Override
            public int compare(E e1, E e2) {
                int d = cmp.compare(e1, e2);
                if (d == 0) {
                    throw new IllegalArgumentException("A set cannot have two duplicate elements");
                }
                return d;
            }
        };
    }

    @Override
    public int size() {
        return this.ri - this.li;
    }

    @Override
    public boolean isEmpty() {
        return this.ri == this.li;
    }

    @Override
    public boolean contains(Object o) {
        return Arrays.binarySearch(this.bkarr, this.li, this.ri, o, this.comparator) > 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int i;
            {
                this.i = SortedArraySet.this.li;
            }

            @Override
            public boolean hasNext() {
                return this.i < SortedArraySet.this.ri;
            }

            @Override
            public E next() {
                return SortedArraySet.this.bkarr[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException("This set is immutable");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("This set is immutable");
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            throw new UnsupportedOperationException("This set is immutable");
        }
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public E first() {
        return this.bkarr[this.li];
    }

    @Override
    public E last() {
        return this.bkarr[this.ri - 1];
    }

    @Override
    public SortedSet<E> headSet(E to) {
        int d = Arrays.binarySearch(this.bkarr, this.li, this.ri, to, this.comparator);
        if (d < 0) {
            d ^= 0xFFFFFFFF;
        }
        if (d < this.li || this.ri < d) {
            throw new IllegalArgumentException("Argument not in this subset's range");
        }
        return new SortedArraySet<E>(this.bkarr, this.li, d, this.comparator);
    }

    @Override
    public SortedSet<E> tailSet(E fr) {
        int d = Arrays.binarySearch(this.bkarr, this.li, this.ri, fr, this.comparator);
        if (d < 0) {
            d ^= 0xFFFFFFFF;
        }
        if (d < this.li || this.ri < d) {
            throw new IllegalArgumentException("Argument not in this subset's range");
        }
        return new SortedArraySet<E>(this.bkarr, d, this.ri, this.comparator);
    }

    @Override
    public SortedSet<E> subSet(E fr, E to) {
        return this.tailSet(fr).headSet(to);
    }
}

