/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.constructor.Tuple;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConstructor {
    protected final Map<String, Construct> yamlConstructors = new HashMap<String, Construct>();
    private Composer composer;
    private final Map<Node, Object> constructedObjects = new HashMap<Node, Object>();
    private final Set<Node> recursiveObjects = new HashSet<Node>();
    private final Stack<Tuple<Node, Object>> toBeConstructedAt2ndStep = new Stack();
    private final LinkedList<Tuple<Map<Object, Object>, Tuple<Object, Object>>> maps2fill = new LinkedList();
    private final LinkedList<Tuple<Set<Object>, Object>> sets2fill = new LinkedList();
    protected Class<? extends Object> rootType = Object.class;

    public void setComposer(Composer composer) {
        this.composer = composer;
    }

    public boolean checkData() {
        return this.composer.checkNode();
    }

    public Object getData() {
        this.composer.checkNode();
        Node node = this.composer.getNode();
        node.setType(this.rootType);
        return this.constructDocument(node);
    }

    public Object getSingleData() {
        Node node = this.composer.getSingleNode();
        if (node != null) {
            node.setType(this.rootType);
            return this.constructDocument(node);
        }
        return null;
    }

    private Object constructDocument(Node node) {
        Object data = this.constructObject(node);
        while (!this.toBeConstructedAt2ndStep.isEmpty()) {
            Tuple<Node, Object> toBeProcessed = this.toBeConstructedAt2ndStep.pop();
            this.callPostCreate(toBeProcessed._1(), toBeProcessed._2());
        }
        if (!this.maps2fill.isEmpty()) {
            for (Tuple tuple : this.maps2fill) {
                Tuple key_value = (Tuple)tuple._2();
                ((Map)tuple._1()).put(key_value._1(), key_value._2());
            }
            this.maps2fill.clear();
        }
        if (!this.sets2fill.isEmpty()) {
            for (Tuple tuple : this.sets2fill) {
                ((Set)tuple._1()).add(tuple._2());
            }
            this.sets2fill.clear();
        }
        this.constructedObjects.clear();
        this.recursiveObjects.clear();
        this.toBeConstructedAt2ndStep.clear();
        return data;
    }

    protected Object constructObject(Node node) {
        if (this.constructedObjects.containsKey(node)) {
            return this.constructedObjects.get(node);
        }
        if (this.recursiveObjects.contains(node)) {
            throw new ConstructorException(null, null, "found unconstructable recursive node", node.getStartMark());
        }
        this.recursiveObjects.add(node);
        Object data = this.callConstructor(node);
        if (node.isTwoStepsConstruction()) {
            this.toBeConstructedAt2ndStep.push(new Tuple<Node, Object>(node, data));
        }
        this.constructedObjects.put(node, data);
        this.recursiveObjects.remove(node);
        return data;
    }

    protected Object callConstructor(Node node) {
        return this.getConstructor(node).construct(node);
    }

    protected void callPostCreate(Node node, Object object) {
        this.getConstructor(node).construct2ndStep(node, object);
    }

    private Construct getConstructor(Node node) {
        Construct constructor = this.yamlConstructors.get(node.getTag());
        if (constructor == null) {
            return this.yamlConstructors.get(null);
        }
        return constructor;
    }

    protected Object constructScalar(ScalarNode node) {
        return node.getValue();
    }

    protected List<Object> createDefaultList(int initSize) {
        return new LinkedList<Object>();
    }

    protected List<? extends Object> constructSequence(SequenceNode node) {
        List<Object> result = this.createDefaultList(node.getValue().size());
        this.constructSequenceStep2(node, result);
        return result;
    }

    protected void constructSequenceStep2(SequenceNode node, List<Object> list) {
        Iterator i$ = node.getValue().iterator();
        while (i$.hasNext()) {
            Node child = (Node)i$.next();
            list.add(this.constructObject(child));
        }
    }

    protected Map<Object, Object> createDefaultMap() {
        return new LinkedHashMap<Object, Object>();
    }

    protected Set<Object> createDefaultSet() {
        return new LinkedHashSet<Object>();
    }

    protected Set<Object> constructSet(MappingNode node) {
        Set<Object> set = this.createDefaultSet();
        this.constructSet2ndStep(node, set);
        return set;
    }

    protected Map<Object, Object> constructMapping(MappingNode node) {
        Map<Object, Object> mapping = this.createDefaultMap();
        this.constructMapping2ndStep(node, mapping);
        return mapping;
    }

    protected void constructMapping2ndStep(MappingNode node, Map<Object, Object> mapping) {
        Object nodeValue = node.getValue();
        Iterator i$ = nodeValue.iterator();
        while (i$.hasNext()) {
            Node[] tuple = (Node[])i$.next();
            Node keyNode = tuple[0];
            Node valueNode = tuple[1];
            Object key = this.constructObject(keyNode);
            if (key != null) {
                try {
                    key.hashCode();
                }
                catch (Exception e) {
                    throw new ConstructorException("while constructing a mapping", node.getStartMark(), "found unacceptable key " + key, tuple[0].getStartMark(), e);
                }
            }
            Object value = this.constructObject(valueNode);
            if (keyNode.isTwoStepsConstruction()) {
                this.maps2fill.addFirst(new Tuple<Map<Object, Object>, Tuple<Object, Object>>(mapping, new Tuple<Object, Object>(key, value)));
                continue;
            }
            mapping.put(key, value);
        }
    }

    protected void constructSet2ndStep(MappingNode node, Set<Object> set) {
        Object nodeValue = node.getValue();
        Iterator i$ = nodeValue.iterator();
        while (i$.hasNext()) {
            Node[] tuple = (Node[])i$.next();
            Node keyNode = tuple[0];
            Object key = this.constructObject(keyNode);
            if (key != null) {
                try {
                    key.hashCode();
                }
                catch (Exception e) {
                    throw new ConstructorException("while constructing a Set", node.getStartMark(), "found unacceptable key " + key, tuple[0].getStartMark(), e);
                }
            }
            if (keyNode.isTwoStepsConstruction()) {
                this.sets2fill.addFirst(new Tuple<Set<Object>, Object>(set, key));
                continue;
            }
            set.add(key);
        }
    }
}

