/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library;

import freenet.l10n.BaseL10n;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginFCP;
import freenet.pluginmanager.FredPluginHTTP;
import freenet.pluginmanager.FredPluginL10n;
import freenet.pluginmanager.FredPluginRealVersioned;
import freenet.pluginmanager.FredPluginThreadless;
import freenet.pluginmanager.FredPluginVersioned;
import freenet.pluginmanager.PluginReplySender;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import freenet.support.api.HTTPRequest;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import plugins.Library.Library;
import plugins.Library.SpiderIndexUploader;
import plugins.Library.Version;
import plugins.Library.search.Search;
import plugins.Library.ui.WebInterface;
import plugins.Library.util.concurrent.Executors;

public class Main
implements FredPlugin,
FredPluginVersioned,
FredPluginHTTP,
FredPluginRealVersioned,
FredPluginThreadless,
FredPluginL10n,
FredPluginFCP {
    private static PluginRespirator pr;
    private Library library;
    private WebInterface webinterface;
    private SpiderIndexUploader uploader;
    static volatile boolean logMINOR;
    static volatile boolean logDEBUG;

    public static PluginRespirator getPluginRespirator() {
        return pr;
    }

    public void setLanguage(BaseL10n.LANGUAGE lang) {
    }

    public String getVersion() {
        Main main = this;
        return main.library.getVersion() + " " + Version.vcsRevision();
    }

    public long getRealVersion() {
        Main main = this;
        return main.library.getVersion();
    }

    public String handleHTTPGet(HTTPRequest request) {
        try {
            Class<?> tester = Class.forName("plugins.Library.Tester");
            Method method = tester.getMethod("runTest", Library.class, String.class);
            try {
                return (String)method.invoke(null, this.library, request.getParam("plugins.Library.Tester"));
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (ClassNotFoundException e) {
            return "<p>To use Library, go to <b>Browsing -&gt; Search Freenet</b> in the main menu in FProxy.</p><p>This page is only where the test suite would be, if it had been compiled in (give -Dtester= to ant).</p>";
        }
        catch (Throwable t) {
            Throwable th = t;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            th.printStackTrace(new PrintStream(bytes));
            return "<pre>" + bytes + "</pre>";
        }
    }

    public String handleHTTPPost(HTTPRequest request) {
        return null;
    }

    public void runPlugin(PluginRespirator pr) {
        Main.pr = pr;
        Executor exec = pr.getNode().executor;
        this.library = Library.init(pr);
        Search.setup(this.library, exec);
        Executors.setDefaultExecutor((java.util.concurrent.Executor)exec);
        this.webinterface = new WebInterface(this.library, pr);
        this.webinterface.load();
        this.uploader = new SpiderIndexUploader(pr);
        this.uploader.start();
    }

    public void terminate() {
        this.webinterface.unload();
    }

    public String getString(String key) {
        return key;
    }

    private static String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static String MD5(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] b = text.getBytes("UTF-8");
            md.update(b, 0, b.length);
            byte[] md5hash = md.digest();
            return Main.convertToHex(md5hash);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void handle(PluginReplySender replysender, SimpleFieldSet params, Bucket data, int accesstype) {
        if ("pushBuffer".equals(params.get("command"))) {
            this.uploader.handlePushBuffer(params, data);
        } else if ("getSpiderURI".equals(params.get("command"))) {
            this.uploader.handleGetSpiderURI(replysender);
        } else {
            Logger.error((Object)this, (String)("Unknown command : \"" + params.get("command")));
        }
    }

    static {
        Logger.registerClass(Main.class);
    }
}

